/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.taucher2003.t2003_utils.tjda.connect;

import com.gitlab.taucher2003.t2003_utils.tjda.commands.SlashCommandManager;
import com.gitlab.taucher2003.t2003_utils.tjda.connect.InteractionsListener;
import com.gitlab.taucher2003.t2003_utils.tjda.page.PaginationManager;
import net.dv8tion.jda.api.exceptions.InvalidTokenException;
import net.dv8tion.jda.api.sharding.DefaultShardManagerBuilder;
import net.dv8tion.jda.api.sharding.ShardManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardManagerConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShardManagerConnector.class);
    private final DefaultShardManagerBuilder builder;
    private SlashCommandManager slashCommandManager;
    private PaginationManager paginationManager;

    public ShardManagerConnector(DefaultShardManagerBuilder builder) {
        this.builder = builder;
    }

    public ShardManagerConnector withSlashCommandManager(SlashCommandManager slashCommandManager) {
        this.slashCommandManager = slashCommandManager;
        return this;
    }

    public ShardManagerConnector withPaginationManager() {
        return this.withPaginationManager(new PaginationManager());
    }

    public ShardManagerConnector withPaginationManager(PaginationManager paginationManager) {
        this.paginationManager = paginationManager;
        return this;
    }

    public ShardManager build() throws InterruptedException {
        return this.build(true);
    }

    public ShardManager build(boolean login) throws InterruptedException {
        if (this.slashCommandManager != null) {
            this.builder.addEventListeners(new Object[]{new InteractionsListener(this.slashCommandManager)});
        }
        if (this.paginationManager != null) {
            this.builder.addEventListeners(new Object[]{this.paginationManager});
        }
        int count = 1;
        while (true) {
            try {
                return this.builder.build(login);
            }
            catch (InvalidTokenException e) {
                throw e;
            }
            catch (Exception e) {
                long delay = (long)Math.min(30, count++) * 1000L;
                LOGGER.error("Failed to login ShardManager.", (Throwable)e);
                LOGGER.info("Retrying in {}ms", (Object)delay);
                Thread.sleep(delay);
                Thread.onSpinWait();
                continue;
            }
            break;
        }
    }
}

