/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.taucher2003.t2003_utils.tjda.commands;

import com.gitlab.taucher2003.t2003_utils.tjda.commands.Command;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.Permissible;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.SlashCommandManagerHook;
import com.gitlab.taucher2003.t2003_utils.tjda.theme.Theme;
import com.gitlab.taucher2003.t2003_utils.tjda.theme.ThemeProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.interactions.commands.CommandAutoCompleteInteraction;
import net.dv8tion.jda.api.interactions.commands.CommandInteraction;
import net.dv8tion.jda.api.sharding.ShardManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlashCommandManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlashCommandManager.class);
    private final ThemeProvider themeProvider;
    private final SlashCommandManagerHook hook;
    private final Collection<Command> commands = new ArrayList<Command>();

    public SlashCommandManager(Theme theme) {
        this(() -> theme);
    }

    public SlashCommandManager(ThemeProvider themeProvider) {
        this(themeProvider, new SlashCommandManagerHook(){});
    }

    public SlashCommandManager(ThemeProvider themeProvider, SlashCommandManagerHook hook) {
        this.themeProvider = themeProvider;
        this.hook = hook;
    }

    public void updateCommands(ShardManager shardManager) {
        shardManager.getGuildCache().forEach(this::updateCommands);
    }

    public void upsertCommands(ShardManager shardManager) {
        shardManager.getGuildCache().forEach(this::upsertCommands);
    }

    public void updateCommands(Guild guild) {
        if (!this.hook.useSlashCommands(guild)) {
            LOGGER.info("Deleting commands for {}/{} due to {} hook", new Object[]{guild.getName(), guild.getId(), this.hook.getClass().getCanonicalName()});
            guild.updateCommands().queue();
            return;
        }
        LOGGER.info("Updating commands for {}/{}", (Object)guild.getName(), (Object)guild.getId());
        guild.updateCommands().addCommands((Collection)this.commands.stream().map(command -> command.asJdaObject(this.hook.getLocalizationFunction())).collect(Collectors.toList())).queue(commandList -> LOGGER.info("Updated {} commands for {}/{}", new Object[]{commandList.size(), guild.getName(), guild.getId()}), throwable -> LOGGER.error("Failed to update commands for {}/{}", new Object[]{guild.getName(), guild.getId(), throwable}));
    }

    public void upsertCommands(Guild guild) {
        if (!this.hook.useSlashCommands(guild)) {
            LOGGER.info("Commands for {}/{} are disabled with {} hook, skipping upsert", new Object[]{guild.getName(), guild.getId(), this.hook.getClass().getCanonicalName()});
            return;
        }
        LOGGER.info("Upserting commands for {}/{}", (Object)guild.getName(), (Object)guild.getId());
        this.commands.stream().map(command -> command.asJdaObject(this.hook.getLocalizationFunction())).map(arg_0 -> ((Guild)guild).upsertCommand(arg_0)).forEach(action -> action.queue(ignored -> LOGGER.info("Upserted command {} for {}/{}", new Object[]{ignored.getName(), guild.getName(), guild.getId()}), throwable -> LOGGER.error("Failed to upsert command for {}/{}", new Object[]{guild.getName(), guild.getId(), throwable})));
    }

    public Optional<Command> getCommandByName(String name) {
        return this.commands.stream().filter(command -> command.name().equalsIgnoreCase(name)).findFirst();
    }

    public Theme getTheme() {
        return (Theme)this.themeProvider.get();
    }

    public ThemeProvider getThemeProvider() {
        return this.themeProvider;
    }

    public boolean registerCommand(Command command) {
        return this.commands.add(command);
    }

    public boolean unregisterCommand(Command command) {
        return this.commands.remove(command);
    }

    public void unregisterAllCommands() {
        this.commands.clear();
    }

    public void dispatch(CommandInteraction event) {
        Permissible.PermissibleContext permissibleContext = new Permissible.PermissibleContext(event.getGuild(), event.getMember(), event.getUser());
        Optional<Command> commandOpt = this.getCommandByName(event.getName());
        if (commandOpt.isEmpty()) {
            LOGGER.warn("Received interaction for unknown command '{}'", (Object)event.getFullCommandName());
            return;
        }
        Command command = commandOpt.get();
        command.doExecuteRouting(event, this.getTheme(), permissibleContext, this::buildPermissible, this.hook);
    }

    public void autocomplete(CommandAutoCompleteInteraction event) {
        Permissible.PermissibleContext permissibleContext = new Permissible.PermissibleContext(event.getGuild(), event.getMember(), event.getUser());
        Optional<Command> commandOpt = this.getCommandByName(event.getName());
        if (commandOpt.isEmpty()) {
            LOGGER.warn("Received autocomplete for unknown command '{}'", (Object)event.getFullCommandName());
            return;
        }
        Command command = commandOpt.get();
        command.doAutocompleteRouting(event, permissibleContext, this::buildPermissible);
    }

    private Permissible buildPermissible(Permissible base) {
        return base.and(this.hook.getGlobalPermissible()).or(this.hook.getBypassPermissible());
    }
}

