/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.taucher2003.t2003_utils.tjda.commands;

import com.gitlab.taucher2003.t2003_utils.common.i18n.Localizer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import net.dv8tion.jda.api.interactions.commands.localization.LocalizationFunction;
import org.jetbrains.annotations.NotNull;

public class PrefixedLocalizationFunction
implements LocalizationFunction {
    private final Localizer localizer;
    private final String keyPrefix;

    public PrefixedLocalizationFunction(Localizer localizer) {
        this.localizer = localizer;
        this.keyPrefix = null;
    }

    public PrefixedLocalizationFunction(Localizer localizer, String keyPrefix) {
        this.localizer = localizer;
        this.keyPrefix = keyPrefix;
    }

    @NotNull
    public Map<DiscordLocale, String> apply(@NotNull String localizationKey) {
        String effectiveKey = this.keyPrefix == null ? localizationKey : this.keyPrefix + "." + localizationKey;
        HashMap<DiscordLocale, String> map = new HashMap<DiscordLocale, String>();
        for (DiscordLocale discordLocale : DiscordLocale.values()) {
            String localeTag = discordLocale.getLocale();
            Locale locale = Locale.forLanguageTag(localeTag);
            map.put(discordLocale, this.localizer.localize(effectiveKey, locale));
        }
        map.remove(DiscordLocale.UNKNOWN);
        return map;
    }
}

