/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.taucher2003.t2003_utils.tjda.commands;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;

@FunctionalInterface
public interface Permissible {
    public static final Permissible UNRESTRICTED = context -> true;
    public static final Permissible ADMINISTRATOR_ONLY = new Permissible(){

        @Override
        public List<Permission> defaultMemberPermissions() {
            return List.of(Permission.ADMINISTRATOR);
        }

        @Override
        public boolean permitted(PermissibleContext context) {
            return context.getMember().map(m -> m.hasPermission(new Permission[]{Permission.ADMINISTRATOR})).orElse(false);
        }
    };

    public boolean permitted(PermissibleContext var1);

    default public List<Permission> defaultMemberPermissions() {
        return Collections.emptyList();
    }

    default public Permissible or(Permissible permissible) {
        return context -> this.permitted(context) || permissible.permitted(context);
    }

    default public Permissible and(Permissible permissible) {
        return context -> this.permitted(context) && permissible.permitted(context);
    }

    public static class PermissibleContext
    implements ISnowflake {
        private final Guild guild;
        private final Member member;
        private final User user;

        public PermissibleContext(Guild guild, Member member, User user) {
            this.guild = guild;
            this.member = member;
            this.user = user;
        }

        public Optional<Guild> getGuild() {
            return Optional.ofNullable(this.guild);
        }

        public Optional<Member> getMember() {
            return Optional.ofNullable(this.member);
        }

        public User getUser() {
            return this.user;
        }

        public long getIdLong() {
            return this.user.getIdLong();
        }
    }
}

