/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.taucher2003.t2003_utils.tjda.commands;

import com.gitlab.taucher2003.t2003_utils.tjda.commands.Permissible;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.Routable;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.SlashCommandManagerHook;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.build.meta.SubCommandGroupMetaBuilder;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.build.meta.SubCommandableMeta;
import com.gitlab.taucher2003.t2003_utils.tjda.theme.Theme;
import java.util.Collections;
import java.util.function.Function;
import net.dv8tion.jda.api.interactions.callbacks.IReplyCallback;
import net.dv8tion.jda.api.interactions.commands.CommandAutoCompleteInteraction;
import net.dv8tion.jda.api.interactions.commands.CommandInteraction;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandGroup
implements Routable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandGroup.class);
    private final SubCommandableMeta<SubcommandGroupData> meta;

    public CommandGroup(SubCommandableMeta<SubcommandGroupData> meta) {
        this.meta = meta;
    }

    public SubcommandGroupData asJdaObject() {
        SubcommandGroupData data = new SubcommandGroupData(this.meta.getName(), this.meta.getDescription());
        this.meta.getConfigurator().accept(data);
        return data;
    }

    @Override
    public String name() {
        return this.meta.getName();
    }

    public SubCommandableMeta<SubcommandGroupData> meta() {
        return this.meta;
    }

    @Override
    public void doExecuteRouting(CommandInteraction event, Theme theme, Permissible.PermissibleContext permissibleContext, Function<Permissible, Permissible> permissibleCreator, SlashCommandManagerHook hook) {
        String[] path = event.getFullCommandName().split(" ");
        this.meta.getSubCommands().stream().filter(subCommand -> subCommand.name().equals(path[2])).findFirst().ifPresentOrElse(subCommand -> {
            Permissible innerPermissible = (Permissible)permissibleCreator.apply(subCommand.meta().getPermissible());
            if (!innerPermissible.permitted(permissibleContext)) {
                hook.handleUnpermitted((IReplyCallback)event, theme);
                return;
            }
            subCommand.execute(event, theme, permissibleContext);
        }, () -> LOGGER.warn("Received interaction for unknown sub-command '{}'", (Object)event.getFullCommandName()));
    }

    @Override
    public void doAutocompleteRouting(CommandAutoCompleteInteraction event, Permissible.PermissibleContext permissibleContext, Function<Permissible, Permissible> permissibleCreator) {
        String[] path = event.getFullCommandName().split(" ");
        this.meta.getSubCommands().stream().filter(subCommand -> subCommand.name().equals(path[2])).findFirst().ifPresentOrElse(subCommand -> {
            Permissible innerPermissible = (Permissible)permissibleCreator.apply(subCommand.meta().getPermissible());
            if (!innerPermissible.permitted(permissibleContext)) {
                event.replyChoices(Collections.emptyList()).queue();
                return;
            }
            subCommand.autocomplete(event, permissibleContext);
        }, () -> LOGGER.warn("Received autocomplete for unknown sub-command '{}'", (Object)event.getFullCommandName()));
    }

    public static SubCommandGroupMetaBuilder createMeta(String name, String description) {
        return new SubCommandGroupMetaBuilder(name, description);
    }
}

