/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.taucher2003.t2003_utils.tjda.commands;

import com.gitlab.taucher2003.t2003_utils.tjda.commands.CommandArgument;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.CommandMixin;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.Permissible;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.Routable;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.SlashCommandManagerHook;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.SubCommand;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.build.meta.CommandMetaBuilder;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.build.meta.RootCommandMetaBuilder;
import com.gitlab.taucher2003.t2003_utils.tjda.commands.build.meta.SubCommandGroupableMeta;
import com.gitlab.taucher2003.t2003_utils.tjda.theme.Theme;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import net.dv8tion.jda.api.interactions.callbacks.IReplyCallback;
import net.dv8tion.jda.api.interactions.commands.CommandAutoCompleteInteraction;
import net.dv8tion.jda.api.interactions.commands.CommandInteraction;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.localization.LocalizationFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Command
implements Routable,
CommandMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger(Command.class);
    private final SubCommandGroupableMeta meta;

    @Deprecated
    protected Command(String name, String description) {
        this(name, description, Permissible.UNRESTRICTED);
    }

    @Deprecated
    protected Command(String name, String description, Permissible permissible) {
        this(name, description, new CommandArgument[0], permissible);
    }

    @Deprecated
    protected Command(String name, String description, CommandArgument[] arguments) {
        this(name, description, arguments, Permissible.UNRESTRICTED);
    }

    @Deprecated
    protected Command(String name, String description, CommandArgument[] arguments, Permissible permissible) {
        this(Command.createMeta(name, description).setArguments(Arrays.asList(arguments)).setPermissible(permissible).build());
    }

    @Deprecated
    protected Command(String name, String description, SubCommand[] subCommands) {
        this(name, description, subCommands, Permissible.UNRESTRICTED);
    }

    @Deprecated
    protected Command(String name, String description, SubCommand[] subCommands, Permissible permissible) {
        this(Command.createMeta(name, description).setSubCommands(Arrays.asList(subCommands)).setPermissible(permissible).build());
    }

    protected Command(SubCommandGroupableMeta meta) {
        this.meta = meta;
    }

    public CommandData asJdaObject(LocalizationFunction localizationFunction) {
        SlashCommandData data = Commands.slash((String)this.meta.getName(), (String)this.meta.getDescription());
        this.meta.getConfigurator().accept(data);
        if (localizationFunction != null) {
            data.setLocalizationFunction(localizationFunction);
        }
        return data;
    }

    @Override
    public String name() {
        return this.meta.getName();
    }

    public SubCommandGroupableMeta meta() {
        return this.meta;
    }

    public abstract void execute(CommandInteraction var1, Theme var2, Permissible.PermissibleContext var3);

    public void autocomplete(CommandAutoCompleteInteraction event, Permissible.PermissibleContext permissibleContext) {
    }

    @Override
    public void doExecuteRouting(CommandInteraction event, Theme theme, Permissible.PermissibleContext permissibleContext, Function<Permissible, Permissible> permissibleCreator, SlashCommandManagerHook hook) {
        Permissible permissible = permissibleCreator.apply(this.meta.getPermissible());
        if (!permissible.permitted(permissibleContext)) {
            hook.handleUnpermitted((IReplyCallback)event, theme);
            return;
        }
        String[] path = event.getFullCommandName().split(" ");
        if (path.length == 1) {
            this.execute(event, theme, permissibleContext);
            return;
        }
        if (path.length == 2) {
            this.meta.getSubCommands().stream().filter(command -> command.name().equals(path[1])).findFirst().ifPresentOrElse(command -> {
                Permissible innerPermissible = (Permissible)permissibleCreator.apply(command.meta().getPermissible());
                if (!innerPermissible.permitted(permissibleContext)) {
                    hook.handleUnpermitted((IReplyCallback)event, theme);
                    return;
                }
                command.execute(event, theme, permissibleContext);
            }, () -> LOGGER.warn("Received interaction for unknown sub-command '{}'", (Object)event.getFullCommandName()));
            return;
        }
        this.meta.getCommandGroups().stream().filter(group -> group.name().equals(path[1])).findFirst().ifPresentOrElse(group -> {
            Permissible innerPermissible = (Permissible)permissibleCreator.apply(group.meta().getPermissible());
            if (!innerPermissible.permitted(permissibleContext)) {
                hook.handleUnpermitted((IReplyCallback)event, theme);
                return;
            }
            group.doExecuteRouting(event, theme, permissibleContext, permissibleCreator, hook);
        }, () -> LOGGER.warn("Received interaction for unknown sub-group '{}'", (Object)event.getFullCommandName()));
    }

    @Override
    public void doAutocompleteRouting(CommandAutoCompleteInteraction event, Permissible.PermissibleContext permissibleContext, Function<Permissible, Permissible> permissibleCreator) {
        Permissible permissible = permissibleCreator.apply(this.meta.getPermissible());
        if (!permissible.permitted(permissibleContext)) {
            event.replyChoices(Collections.emptyList()).queue();
            return;
        }
        String[] path = event.getFullCommandName().split(" ");
        if (path.length == 1) {
            this.autocomplete(event, permissibleContext);
            return;
        }
        if (path.length == 2) {
            this.meta.getSubCommands().stream().filter(command -> command.name().equals(path[1])).findFirst().ifPresentOrElse(command -> {
                Permissible innerPermissible = (Permissible)permissibleCreator.apply(command.meta().getPermissible());
                if (!innerPermissible.permitted(permissibleContext)) {
                    event.replyChoices(Collections.emptyList()).queue();
                    return;
                }
                command.autocomplete(event, permissibleContext);
            }, () -> LOGGER.warn("Received autocomplete for unknown sub-command '{}'", (Object)event.getFullCommandName()));
            return;
        }
        this.meta.getCommandGroups().stream().filter(group -> group.name().equals(path[1])).findFirst().ifPresentOrElse(group -> {
            Permissible innerPermissible = (Permissible)permissibleCreator.apply(group.meta().getPermissible());
            if (!innerPermissible.permitted(permissibleContext)) {
                event.replyChoices(Collections.emptyList()).queue();
                return;
            }
            group.doAutocompleteRouting(event, permissibleContext, permissibleCreator);
        }, () -> LOGGER.warn("Received autocomplete for unknown sub-group '{}'", (Object)event.getFullCommandName()));
    }

    public static RootCommandMetaBuilder createMeta(String name, String description) {
        return new CommandMetaBuilder(name, description);
    }
}

