/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.ui.components;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.content.ContextCompat;
import com.zynksoftware.documentscanner.R;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencv.core.Point;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u001eJ\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0014J)\u0010#\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%\u00a2\u0006\u0002\u0010'R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/zynksoftware/documentscanner/ui/components/ScanCanvasView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "border", "Landroid/graphics/Paint;", "handlerClear", "Landroid/os/Handler;", "paint", "pointer1", "Landroid/view/View;", "pointer2", "pointer3", "pointer4", "previewHeight", "", "Ljava/lang/Float;", "previewWidth", "runnable", "Ljava/lang/Runnable;", "shouldAnimate", "", "clearPointersPosition", "", "clearShape", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "showShape", "points", "", "Lorg/opencv/core/Point;", "(FF[Lorg/opencv/core/Point;)V", "Companion", "DocumentScanner_release"})
public final class ScanCanvasView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Paint paint;
    @NotNull
    private Paint border;
    @NotNull
    private final Handler handlerClear;
    private boolean shouldAnimate;
    @NotNull
    private View pointer1;
    @NotNull
    private View pointer2;
    @NotNull
    private View pointer3;
    @NotNull
    private View pointer4;
    @Nullable
    private Float previewWidth;
    @Nullable
    private Float previewHeight;
    @NotNull
    private final Runnable runnable;
    @NotNull
    public Map<Integer, View> _$_findViewCache;
    private static final long CLEAR_SHAPE_DELAY_IN_MILLIS = 600L;
    private static final long POINTER_ANIMATION_DURATION = 300L;

    public ScanCanvasView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.paint = new Paint();
        this.border = new Paint();
        this.handlerClear = new Handler(Looper.getMainLooper());
        this.shouldAnimate = true;
        this.pointer1 = new View(this.getContext());
        this.pointer2 = new View(this.getContext());
        this.pointer3 = new View(this.getContext());
        this.pointer4 = new View(this.getContext());
        this.paint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.zdc_white_transparent));
        this.border.setColor(ContextCompat.getColor((Context)this.getContext(), (int)17170443));
        this.border.setStrokeWidth(this.getContext().getResources().getDimension(R.dimen.zdc_polygon_line_stroke_width));
        this.border.setStyle(Paint.Style.STROKE);
        this.border.setAntiAlias(true);
        this.paint.setAntiAlias(true);
        this.pointer1.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.pointer2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.pointer3.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.pointer4.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.clearPointersPosition();
        this.addView(this.pointer1);
        this.addView(this.pointer2);
        this.addView(this.pointer3);
        this.addView(this.pointer4);
        this.runnable = () -> ScanCanvasView.runnable$lambda-7(this);
        this._$_findViewCache = new LinkedHashMap();
    }

    public ScanCanvasView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.paint = new Paint();
        this.border = new Paint();
        this.handlerClear = new Handler(Looper.getMainLooper());
        this.shouldAnimate = true;
        this.pointer1 = new View(this.getContext());
        this.pointer2 = new View(this.getContext());
        this.pointer3 = new View(this.getContext());
        this.pointer4 = new View(this.getContext());
        this.paint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.zdc_white_transparent));
        this.border.setColor(ContextCompat.getColor((Context)this.getContext(), (int)17170443));
        this.border.setStrokeWidth(this.getContext().getResources().getDimension(R.dimen.zdc_polygon_line_stroke_width));
        this.border.setStyle(Paint.Style.STROKE);
        this.border.setAntiAlias(true);
        this.paint.setAntiAlias(true);
        this.pointer1.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.pointer2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.pointer3.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.pointer4.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.clearPointersPosition();
        this.addView(this.pointer1);
        this.addView(this.pointer2);
        this.addView(this.pointer3);
        this.addView(this.pointer4);
        this.runnable = () -> ScanCanvasView.runnable$lambda-7(this);
        this._$_findViewCache = new LinkedHashMap();
    }

    public ScanCanvasView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.paint = new Paint();
        this.border = new Paint();
        this.handlerClear = new Handler(Looper.getMainLooper());
        this.shouldAnimate = true;
        this.pointer1 = new View(this.getContext());
        this.pointer2 = new View(this.getContext());
        this.pointer3 = new View(this.getContext());
        this.pointer4 = new View(this.getContext());
        this.paint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.zdc_white_transparent));
        this.border.setColor(ContextCompat.getColor((Context)this.getContext(), (int)17170443));
        this.border.setStrokeWidth(this.getContext().getResources().getDimension(R.dimen.zdc_polygon_line_stroke_width));
        this.border.setStyle(Paint.Style.STROKE);
        this.border.setAntiAlias(true);
        this.paint.setAntiAlias(true);
        this.pointer1.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.pointer2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.pointer3.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.pointer4.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.clearPointersPosition();
        this.addView(this.pointer1);
        this.addView(this.pointer2);
        this.addView(this.pointer3);
        this.addView(this.pointer4);
        this.runnable = () -> ScanCanvasView.runnable$lambda-7(this);
        this._$_findViewCache = new LinkedHashMap();
    }

    private final void clearPointersPosition() {
        this.pointer1.setX(0.0f);
        this.pointer1.setY(0.0f);
        this.pointer2.setX(0.0f);
        this.pointer2.setY(0.0f);
        this.pointer3.setX(0.0f);
        this.pointer3.setY(0.0f);
        this.pointer4.setX(0.0f);
        this.pointer4.setY(0.0f);
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.dispatchDraw(canvas);
        Float f = this.previewWidth;
        if (f != null) {
            float previewWidth = ((Number)f).floatValue();
            boolean bl = false;
            Float f2 = this.previewHeight;
            if (f2 != null) {
                float previewHeight = ((Number)f2).floatValue();
                boolean bl2 = false;
                canvas.scale((float)this.getWidth() / previewWidth, (float)this.getHeight() / previewHeight);
            }
        }
        canvas.drawLine(this.pointer1.getX(), this.pointer1.getY(), this.pointer4.getX(), this.pointer4.getY(), this.border);
        canvas.drawLine(this.pointer1.getX(), this.pointer1.getY(), this.pointer2.getX(), this.pointer2.getY(), this.border);
        canvas.drawLine(this.pointer3.getX(), this.pointer3.getY(), this.pointer4.getX(), this.pointer4.getY(), this.border);
        canvas.drawLine(this.pointer2.getX(), this.pointer2.getY(), this.pointer3.getX(), this.pointer3.getY(), this.border);
        Path path = new Path();
        path.moveTo(this.pointer1.getX(), this.pointer1.getY());
        path.lineTo(this.pointer2.getX(), this.pointer2.getY());
        path.lineTo(this.pointer3.getX(), this.pointer3.getY());
        path.lineTo(this.pointer4.getX(), this.pointer4.getY());
        path.close();
        Path it = path;
        boolean bl = false;
        canvas.drawPath(it, this.paint);
    }

    public final void showShape(float previewWidth, float previewHeight, @NotNull Point[] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        this.previewWidth = Float.valueOf(previewWidth);
        this.previewHeight = Float.valueOf(previewHeight);
        float pointer1x = previewWidth - (float)points[0].y;
        float pointer1y = (float)points[0].x;
        float pointer2x = previewWidth - (float)points[1].y;
        float pointer2y = (float)points[1].x;
        float pointer3x = previewWidth - (float)points[2].y;
        float pointer3y = (float)points[2].x;
        float pointer4x = previewWidth - (float)points[3].y;
        float pointer4y = (float)points[3].x;
        if (this.pointer1.getX() == 0.0f && this.pointer1.getY() == 0.0f) {
            this.pointer1.setX(pointer1x);
            this.pointer1.setY(pointer1y);
            this.pointer2.setX(pointer2x);
            this.pointer2.setY(pointer2y);
            this.pointer3.setX(pointer3x);
            this.pointer3.setY(pointer3y);
            this.pointer4.setX(pointer4x);
            this.pointer4.setY(pointer4y);
        } else if (this.shouldAnimate) {
            this.shouldAnimate = false;
            this.pointer1.animate().translationX(pointer1x).translationY(pointer1y).setDuration(300L).withEndAction(() -> ScanCanvasView.showShape$lambda-3(this)).start();
            this.pointer2.animate().translationX(pointer2x).translationY(pointer2y).setDuration(300L).withEndAction(() -> ScanCanvasView.showShape$lambda-4(this)).start();
            this.pointer3.animate().translationX(pointer3x).translationY(pointer3y).setDuration(300L).withEndAction(() -> ScanCanvasView.showShape$lambda-5(this)).start();
            this.pointer4.animate().translationX(pointer4x).translationY(pointer4y).setDuration(300L).withEndAction(() -> ScanCanvasView.showShape$lambda-6(this)).start();
        }
        this.handlerClear.removeCallbacks(this.runnable);
        this.invalidate();
    }

    public final void clearShape() {
        this.handlerClear.postDelayed(this.runnable, 600L);
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 == null) {
                view = null;
            } else {
                map.put(id2, view2);
                view = view2;
            }
        }
        return view;
    }

    private static final void showShape$lambda-3(ScanCanvasView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.shouldAnimate = true;
    }

    private static final void showShape$lambda-4(ScanCanvasView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.shouldAnimate = true;
    }

    private static final void showShape$lambda-5(ScanCanvasView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.shouldAnimate = true;
    }

    private static final void showShape$lambda-6(ScanCanvasView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.shouldAnimate = true;
    }

    private static final void runnable$lambda-7(ScanCanvasView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.pointer1.clearAnimation();
        this$0.pointer2.clearAnimation();
        this$0.pointer3.clearAnimation();
        this$0.pointer4.clearAnimation();
        this$0.clearPointersPosition();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/zynksoftware/documentscanner/ui/components/ScanCanvasView$Companion;", "", "()V", "CLEAR_SHAPE_DELAY_IN_MILLIS", "", "POINTER_ANIMATION_DURATION", "DocumentScanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

