/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.common.utils;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/zynksoftware/documentscanner/common/utils/FileUriUtils;", "", "()V", "getDataColumn", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getFilePath", "getImageExtension", "uriImage", "getPathFromLocalUri", "getPathFromRemoteUri", "getRealPath", "isDownloadsDocument", "", "isExternalStorageDocument", "isGooglePhotosUri", "isMediaDocument", "DocumentScanner_release"})
public final class FileUriUtils {
    @NotNull
    public static final FileUriUtils INSTANCE = new FileUriUtils();

    private FileUriUtils() {
    }

    @Nullable
    public final String getRealPath(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String path = this.getPathFromLocalUri(context, uri);
        if (path == null) {
            path = this.getPathFromRemoteUri(context, uri);
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    private final String getPathFromLocalUri(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (this.isExternalStorageDocument(uri)) {
                String path;
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
                Object object = docId;
                Regex regex = new Regex(":");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl2 = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                String[] split = stringArray;
                String type = split[0];
                String string = StringsKt.equals((String)"primary", (String)type, (boolean)true) ? (split.length > 1 ? Environment.getExternalStorageDirectory().toString() + '/' + split[1] : Intrinsics.stringPlus((String)Environment.getExternalStorageDirectory().toString(), (Object)"/")) : (new File(path = Intrinsics.stringPlus((String)"storage/", (Object)StringsKt.replace$default((String)docId, (String)":", (String)"/", (boolean)false, (int)4, null))).exists() ? path : Intrinsics.stringPlus((String)"/storage/sdcard/", (Object)split[1]));
                return string;
            }
            if (this.isDownloadsDocument(uri)) {
                String fileName = this.getFilePath(context, uri);
                if (fileName != null) {
                    return Environment.getExternalStorageDirectory().toString() + "/Download/" + fileName;
                }
                String id2 = DocumentsContract.getDocumentId((Uri)uri);
                Uri uri2 = Uri.parse((String)"content://downloads/public_downloads");
                Long thisCollection$iv = Long.valueOf(id2);
                Intrinsics.checkNotNullExpressionValue((Object)thisCollection$iv, (String)"valueOf(id)");
                Uri path = ContentUris.withAppendedId((Uri)uri2, (long)((Number)thisCollection$iv).longValue());
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"withAppendedId(\n        \u2026eOf(id)\n                )");
                Uri contentUri = path;
                return this.getDataColumn(context, contentUri, null, null);
            }
            if (this.isMediaDocument(uri)) {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
                Object contentUri = docId;
                Regex path = new Regex(":");
                int thisCollection$iv = 0;
                contentUri = path.split((CharSequence)contentUri, thisCollection$iv);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl3 = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv2 = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv2.toArray(new String[0]);
                Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                String[] split = stringArray;
                String type = split[0];
                Uri contentUri2 = null;
                if (Intrinsics.areEqual((Object)"image", (Object)type)) {
                    contentUri2 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if (Intrinsics.areEqual((Object)"video", (Object)type)) {
                    contentUri2 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if (Intrinsics.areEqual((Object)"audio", (Object)type)) {
                    contentUri2 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                String selection = "_id=?";
                String[] stringArray2 = new String[]{split[1]};
                String[] selectionArgs = stringArray2;
                return this.getDataColumn(context, contentUri2, selection, selectionArgs);
            }
        } else {
            String string = uri.getScheme();
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.equals((String)"content", (String)string, (boolean)true)) {
                return this.isGooglePhotosUri(uri) ? uri.getLastPathSegment() : this.getDataColumn(context, uri, null, null);
            }
            String string2 = uri.getScheme();
            Intrinsics.checkNotNull((Object)string2);
            if (StringsKt.equals((String)"file", (String)string2, (boolean)true)) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor;
        block7: {
            Cursor cursor2;
            String string;
            cursor = null;
            String column = "_data";
            String[] stringArray = new String[]{column};
            String[] projection = stringArray;
            try {
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri2 = uri;
                Intrinsics.checkNotNull((Object)uri2);
                cursor = contentResolver.query(uri2, projection, selection, selectionArgs, null);
                if (cursor == null || !cursor.moveToFirst()) break block7;
                int index = cursor.getColumnIndexOrThrow(column);
                string = cursor.getString(index);
                cursor2 = cursor;
            }
            catch (Exception exception) {
                Cursor cursor3 = cursor;
                if (cursor3 != null) {
                    cursor3.close();
                }
                catch (Throwable throwable) {
                    Cursor cursor4 = cursor;
                    if (cursor4 != null) {
                        cursor4.close();
                    }
                    throw throwable;
                }
            }
            cursor2.close();
            return string;
        }
        Cursor cursor5 = cursor;
        if (cursor5 != null) {
            cursor5.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFilePath(Context context, Uri uri) {
        Cursor cursor;
        block4: {
            Cursor cursor2;
            String string;
            cursor = null;
            String[] stringArray = new String[]{"_display_name"};
            String[] projection = stringArray;
            try {
                cursor = context.getContentResolver().query(uri, projection, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) break block4;
                int index = cursor.getColumnIndexOrThrow("_display_name");
                string = cursor.getString(index);
                cursor2 = cursor;
            }
            catch (Throwable throwable) {
                Cursor cursor3 = cursor;
                if (cursor3 != null) {
                    cursor3.close();
                }
                throw throwable;
            }
            cursor2.close();
            return string;
        }
        Cursor cursor4 = cursor;
        if (cursor4 != null) {
            cursor4.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final String getPathFromRemoteUri(Context context, Uri uri) {
        String string;
        boolean success;
        File file;
        block25: {
            Object extension22222222222;
            OutputStream outputStream;
            InputStream inputStream;
            block24: {
                file = null;
                inputStream = null;
                outputStream = null;
                success = false;
                extension22222222222 = this.getImageExtension(uri);
                inputStream = context.getContentResolver().openInputStream(uri);
                File storageDir = context.getCacheDir();
                if (!storageDir.exists()) {
                    storageDir.mkdirs();
                }
                file = new File(storageDir, Intrinsics.stringPlus((String)"remotePicture", (Object)extension22222222222));
                file.createNewFile();
                outputStream = new FileOutputStream(file);
                if (inputStream == null) break block24;
                ByteStreamsKt.copyTo((InputStream)inputStream, (OutputStream)outputStream, (int)4096);
                success = true;
            }
            try {
                Object object = extension22222222222 = inputStream;
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            catch (IOException extension22222222222) {
                // empty catch block
            }
            try {
                extension22222222222 = outputStream;
                ((OutputStream)extension22222222222).close();
            }
            catch (IOException ignored22222222222) {
                success = false;
            }
            break block25;
            catch (IOException ignored22222222222) {
                try {
                    InputStream inputStream2 = ignored22222222222 = inputStream;
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (IOException ignored22222222222) {
                    // empty catch block
                }
                try {
                    OutputStream outputStream2 = outputStream;
                    if (outputStream2 != null) {
                        outputStream2.close();
                    }
                }
                catch (IOException ignored3) {
                    success = false;
                }
                catch (Throwable throwable) {
                    try {
                        InputStream storageDir;
                        InputStream inputStream3 = storageDir = inputStream;
                        if (inputStream3 != null) {
                            inputStream3.close();
                        }
                    }
                    catch (IOException storageDir) {
                        // empty catch block
                    }
                    try {
                        OutputStream outputStream3 = outputStream;
                        if (outputStream3 != null) {
                            outputStream3.close();
                        }
                    }
                    catch (IOException ignored4) {
                        success = false;
                    }
                    throw throwable;
                }
            }
        }
        if (success) {
            File file2 = file;
            Intrinsics.checkNotNull(file2);
            string = file2.getPath();
        } else {
            string = null;
        }
        return string;
    }

    private final String getImageExtension(Uri uriImage) {
        String extension = null;
        try {
            String imagePath = uriImage.getPath();
            if (imagePath != null && StringsKt.lastIndexOf$default((CharSequence)imagePath, (String)".", (int)0, (boolean)false, (int)6, null) != -1) {
                String string = imagePath.substring(StringsKt.lastIndexOf$default((CharSequence)imagePath, (String)".", (int)0, (boolean)false, (int)6, null) + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                extension = string;
            }
        }
        catch (Exception e) {
            extension = null;
        }
        if (extension == null || ((CharSequence)extension).length() == 0) {
            extension = "jpg";
        }
        return Intrinsics.stringPlus((String)".", (Object)extension);
    }

    private final boolean isExternalStorageDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    private final boolean isDownloadsDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    private final boolean isMediaDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    private final boolean isGooglePhotosUri(Uri uri) {
        return Intrinsics.areEqual((Object)"com.google.android.apps.photos.content", (Object)uri.getAuthority());
    }
}

