/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.common.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opencv.core.Point;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J!\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/zynksoftware/documentscanner/common/utils/MathUtils;", "", "()V", "angle", "", "p1", "Lorg/opencv/core/Point;", "p2", "p0", "getDistance", "getMaxCosine", "maxCosine", "approxPoints", "", "(D[Lorg/opencv/core/Point;)D", "DocumentScanner_release"})
public final class MathUtils {
    @NotNull
    public static final MathUtils INSTANCE;

    private final double angle(Point p1, Point p2, Point p0) {
        double dx1 = p1.x - p0.x;
        double dy1 = p1.y - p0.y;
        double dx2 = p2.x - p0.x;
        double dy2 = p2.y - p0.y;
        double d = (dx1 * dx1 + dy1 * dy1) * (dx2 * dx2 + dy2 * dy2) + 1.0E-10;
        boolean bl = false;
        return (dx1 * dx2 + dy1 * dy2) / Math.sqrt(d);
    }

    public final double getDistance(@NotNull Point p1, @NotNull Point p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        double d = dx * dx + dy * dy;
        boolean bl = false;
        return Math.sqrt(d);
    }

    /*
     * WARNING - void declaration
     */
    public final double getMaxCosine(double maxCosine, @NotNull Point[] approxPoints) {
        Intrinsics.checkNotNullParameter((Object)approxPoints, (String)"approxPoints");
        double newMaxCosine = maxCosine;
        int n = 2;
        int n2 = 4;
        while (n <= n2) {
            void i;
            double d = this.angle(approxPoints[i % 4], approxPoints[i - 2], approxPoints[i - true]);
            boolean bl = false;
            double cosine = Math.abs(d);
            boolean bl2 = false;
            newMaxCosine = Math.max(cosine, newMaxCosine);
            ++i;
        }
        return newMaxCosine;
    }

    private MathUtils() {
    }

    static {
        MathUtils mathUtils;
        INSTANCE = mathUtils = new MathUtils();
    }
}

