/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.common.extensions;

import androidx.camera.core.ImageProxy;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u00a8\u0006\u0003"}, d2={"yuvToRgba", "Lorg/opencv/core/Mat;", "Landroidx/camera/core/ImageProxy;", "DocumentScanner_release"})
public final class ImageProxyExtensionsKt {
    @NotNull
    public static final Mat yuvToRgba(@NotNull ImageProxy $this$yuvToRgba) {
        Intrinsics.checkNotNullParameter((Object)$this$yuvToRgba, (String)"$this$yuvToRgba");
        Mat rgbaMat = new Mat();
        if ($this$yuvToRgba.getFormat() == 35 && $this$yuvToRgba.getPlanes().length == 3) {
            ImageProxy.PlaneProxy planeProxy = $this$yuvToRgba.getPlanes()[1];
            Intrinsics.checkNotNullExpressionValue((Object)planeProxy, (String)"planes[1]");
            int chromaPixelStride = planeProxy.getPixelStride();
            if (chromaPixelStride == 2) {
                ImageProxy.PlaneProxy planeProxy2 = $this$yuvToRgba.getPlanes()[0];
                Intrinsics.checkNotNullExpressionValue((Object)planeProxy2, (String)"planes[0]");
                ByteBuffer byteBuffer = planeProxy2.getBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"planes[0].buffer");
                ByteBuffer yPlane = byteBuffer;
                ImageProxy.PlaneProxy planeProxy3 = $this$yuvToRgba.getPlanes()[1];
                Intrinsics.checkNotNullExpressionValue((Object)planeProxy3, (String)"planes[1]");
                ByteBuffer byteBuffer2 = planeProxy3.getBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"planes[1].buffer");
                ByteBuffer uvPlane1 = byteBuffer2;
                ImageProxy.PlaneProxy planeProxy4 = $this$yuvToRgba.getPlanes()[2];
                Intrinsics.checkNotNullExpressionValue((Object)planeProxy4, (String)"planes[2]");
                ByteBuffer byteBuffer3 = planeProxy4.getBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"planes[2].buffer");
                ByteBuffer uvPlane2 = byteBuffer3;
                Mat yMat = new Mat($this$yuvToRgba.getHeight(), $this$yuvToRgba.getWidth(), CvType.CV_8UC1, yPlane);
                Mat uvMat1 = new Mat($this$yuvToRgba.getHeight() / 2, $this$yuvToRgba.getWidth() / 2, CvType.CV_8UC2, uvPlane1);
                Mat uvMat2 = new Mat($this$yuvToRgba.getHeight() / 2, $this$yuvToRgba.getWidth() / 2, CvType.CV_8UC2, uvPlane2);
                long addrDiff = uvMat2.dataAddr() - uvMat1.dataAddr();
                if (addrDiff > 0L) {
                    Imgproc.cvtColorTwoPlane((Mat)yMat, (Mat)uvMat1, (Mat)rgbaMat, (int)94);
                } else {
                    Imgproc.cvtColorTwoPlane((Mat)yMat, (Mat)uvMat2, (Mat)rgbaMat, (int)96);
                }
            } else {
                byte[] yuvBytes = new byte[$this$yuvToRgba.getWidth() * ($this$yuvToRgba.getHeight() + $this$yuvToRgba.getHeight() / 2)];
                ImageProxy.PlaneProxy planeProxy5 = $this$yuvToRgba.getPlanes()[0];
                Intrinsics.checkNotNullExpressionValue((Object)planeProxy5, (String)"planes[0]");
                ByteBuffer byteBuffer = planeProxy5.getBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"planes[0].buffer");
                ByteBuffer yPlane = byteBuffer;
                ImageProxy.PlaneProxy planeProxy6 = $this$yuvToRgba.getPlanes()[1];
                Intrinsics.checkNotNullExpressionValue((Object)planeProxy6, (String)"planes[1]");
                ByteBuffer byteBuffer4 = planeProxy6.getBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer4, (String)"planes[1].buffer");
                ByteBuffer uPlane = byteBuffer4;
                ImageProxy.PlaneProxy planeProxy7 = $this$yuvToRgba.getPlanes()[2];
                Intrinsics.checkNotNullExpressionValue((Object)planeProxy7, (String)"planes[2]");
                ByteBuffer byteBuffer5 = planeProxy7.getBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer5, (String)"planes[2].buffer");
                ByteBuffer vPlane = byteBuffer5;
                yPlane.get(yuvBytes, 0, $this$yuvToRgba.getWidth() * $this$yuvToRgba.getHeight());
                ImageProxy.PlaneProxy planeProxy8 = $this$yuvToRgba.getPlanes()[1];
                Intrinsics.checkNotNullExpressionValue((Object)planeProxy8, (String)"planes[1]");
                int chromaRowStride = planeProxy8.getRowStride();
                int chromaRowPadding = chromaRowStride - $this$yuvToRgba.getWidth() / 2;
                int offset = $this$yuvToRgba.getWidth() * $this$yuvToRgba.getHeight();
                if (chromaRowPadding == 0) {
                    uPlane.get(yuvBytes, offset, $this$yuvToRgba.getWidth() * $this$yuvToRgba.getHeight() / 4);
                    vPlane.get(yuvBytes, offset += $this$yuvToRgba.getWidth() * $this$yuvToRgba.getHeight() / 4, $this$yuvToRgba.getWidth() * $this$yuvToRgba.getHeight() / 4);
                } else {
                    int i;
                    int n = 0;
                    int n2 = $this$yuvToRgba.getHeight() / 2;
                    while (n < n2) {
                        uPlane.get(yuvBytes, offset, $this$yuvToRgba.getWidth() / 2);
                        offset += $this$yuvToRgba.getWidth() / 2;
                        if (i < $this$yuvToRgba.getHeight() / 2 - 1) {
                            uPlane.position(uPlane.position() + chromaRowPadding);
                        }
                        ++i;
                    }
                    n2 = $this$yuvToRgba.getHeight() / 2;
                    for (i = 0; i < n2; ++i) {
                        vPlane.get(yuvBytes, offset, $this$yuvToRgba.getWidth() / 2);
                        offset += $this$yuvToRgba.getWidth() / 2;
                        if (i >= $this$yuvToRgba.getHeight() / 2 - 1) continue;
                        vPlane.position(vPlane.position() + chromaRowPadding);
                    }
                }
                Mat yuvMat = new Mat($this$yuvToRgba.getHeight() + $this$yuvToRgba.getHeight() / 2, $this$yuvToRgba.getWidth(), CvType.CV_8UC1);
                yuvMat.put(0, 0, yuvBytes);
                Imgproc.cvtColor((Mat)yuvMat, (Mat)rgbaMat, (int)93, (int)4);
            }
        }
        return rgbaMat;
    }
}

