/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.manager;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import id.zelory.compressor.UtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\tR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/zynksoftware/documentscanner/manager/SessionManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "preferences", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "format", "", "getImageQuality", "", "getImageSize", "", "getImageType", "setImageQuality", "", "quality", "setImageSize", "size", "setImageType", "type", "Companion", "DocumentScanner_release"})
public final class SessionManager {
    private final SharedPreferences preferences;
    private static final String IMAGE_SIZE_KEY = "IMAGE_SIZE_KEY";
    private static final String IMAGE_QUALITY_KEY = "IMAGE_QUALITY_KEY";
    private static final String IMAGE_TYPE_KEY = "IMAGE_TYPE_KEY";
    private static final String DEFAULT_IMAGE_TYPE = "jpg";
    public static final Companion Companion = new Companion(null);

    public final long getImageSize() {
        return this.preferences.getLong(IMAGE_SIZE_KEY, -1L);
    }

    public final void setImageSize(long size) {
        this.preferences.edit().putLong(IMAGE_SIZE_KEY, size).apply();
    }

    public final int getImageQuality() {
        return this.preferences.getInt(IMAGE_QUALITY_KEY, 100);
    }

    public final void setImageQuality(int quality) {
        this.preferences.edit().putInt(IMAGE_QUALITY_KEY, quality).apply();
    }

    @NotNull
    public final Bitmap.CompressFormat getImageType() {
        String string = this.preferences.getString(IMAGE_TYPE_KEY, DEFAULT_IMAGE_TYPE);
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"preferences.getString(IM\u2026EY, DEFAULT_IMAGE_TYPE)!!");
        return this.compressFormat(string);
    }

    public final void setImageType(@NotNull Bitmap.CompressFormat type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.preferences.edit().putString(IMAGE_TYPE_KEY, UtilKt.extension((Bitmap.CompressFormat)type)).apply();
    }

    private final Bitmap.CompressFormat compressFormat(String format) {
        Bitmap.CompressFormat compressFormat;
        String string = format;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        switch (string3) {
            case "png": {
                compressFormat = Bitmap.CompressFormat.PNG;
                break;
            }
            case "webp": {
                compressFormat = Bitmap.CompressFormat.WEBP;
                break;
            }
            default: {
                compressFormat = Bitmap.CompressFormat.JPEG;
            }
        }
        return compressFormat;
    }

    public SessionManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.preferences = context.getSharedPreferences("ZDC_Shared_Preferences", 0);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/zynksoftware/documentscanner/manager/SessionManager$Companion;", "", "()V", "DEFAULT_IMAGE_TYPE", "", "IMAGE_QUALITY_KEY", "IMAGE_SIZE_KEY", "IMAGE_TYPE_KEY", "DocumentScanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

