/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.common.utils;

import com.zynksoftware.documentscanner.common.utils.MathUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u000fH\u0002J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u0014\u0010\u0016\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/zynksoftware/documentscanner/common/utils/ImageDetectionProperties;", "", "previewWidth", "", "previewHeight", "topLeftPoint", "Lorg/opencv/core/Point;", "bottomLeftPoint", "bottomRightPoint", "topRightPoint", "resultWidth", "", "resultHeight", "(DDLorg/opencv/core/Point;Lorg/opencv/core/Point;Lorg/opencv/core/Point;Lorg/opencv/core/Point;II)V", "isBottomEdgeTouching", "", "()Z", "isEdgeTouching", "isLeftEdgeDistorted", "isLeftEdgeTouching", "isRightEdgeDistorted", "isRightEdgeTouching", "isTopEdgeTouching", "getMaxCosine", "approx", "Lorg/opencv/core/MatOfPoint2f;", "isAngleNotCorrect", "isDetectedAreaBelowLimits", "isNotValidImage", "Companion", "DocumentScanner_release"})
public final class ImageDetectionProperties {
    private final double previewWidth;
    private final double previewHeight;
    private final Point topLeftPoint;
    private final Point bottomLeftPoint;
    private final Point bottomRightPoint;
    private final Point topRightPoint;
    private final int resultWidth;
    private final int resultHeight;
    private static final double SMALLEST_ANGLE_COS = 0.172;
    public static final Companion Companion = new Companion(null);

    public final boolean isNotValidImage(@NotNull MatOfPoint2f approx) {
        Intrinsics.checkNotNullParameter((Object)approx, (String)"approx");
        return this.isEdgeTouching() || this.isAngleNotCorrect(approx) || this.isDetectedAreaBelowLimits();
    }

    private final boolean isAngleNotCorrect(MatOfPoint2f approx) {
        return this.getMaxCosine(approx) || this.isLeftEdgeDistorted() || this.isRightEdgeDistorted();
    }

    private final boolean isRightEdgeDistorted() {
        double d = this.topRightPoint.y - this.bottomRightPoint.y;
        boolean bl = false;
        return Math.abs(d) > (double)100;
    }

    private final boolean isLeftEdgeDistorted() {
        double d = this.topLeftPoint.y - this.bottomLeftPoint.y;
        boolean bl = false;
        return Math.abs(d) > (double)100;
    }

    private final boolean getMaxCosine(MatOfPoint2f approx) {
        double maxCosine = 0.0;
        Point[] approxPoints = approx.toArray();
        Intrinsics.checkNotNullExpressionValue((Object)approxPoints, (String)"approxPoints");
        maxCosine = MathUtils.INSTANCE.getMaxCosine(maxCosine, approxPoints);
        return maxCosine >= 0.172;
    }

    private final boolean isEdgeTouching() {
        return this.isTopEdgeTouching() || this.isBottomEdgeTouching() || this.isLeftEdgeTouching() || this.isRightEdgeTouching();
    }

    private final boolean isBottomEdgeTouching() {
        return this.bottomLeftPoint.x >= this.previewHeight - (double)10 || this.bottomRightPoint.x >= this.previewHeight - (double)10;
    }

    private final boolean isTopEdgeTouching() {
        return this.topLeftPoint.x <= (double)10 || this.topRightPoint.x <= (double)10;
    }

    private final boolean isRightEdgeTouching() {
        return this.topRightPoint.y >= this.previewWidth - (double)10 || this.bottomRightPoint.y >= this.previewWidth - (double)10;
    }

    private final boolean isLeftEdgeTouching() {
        return this.topLeftPoint.y <= (double)10 || this.bottomLeftPoint.y <= (double)10;
    }

    private final boolean isDetectedAreaBelowLimits() {
        return !(this.previewWidth / this.previewHeight >= 1.0 && (double)this.resultWidth / (double)this.resultHeight >= 0.9 && (double)this.resultHeight >= 0.7 * this.previewHeight || this.previewHeight / this.previewWidth >= 1.0 && (double)this.resultHeight / (double)this.resultWidth >= 0.9 && (double)this.resultWidth >= 0.7 * this.previewWidth);
    }

    public ImageDetectionProperties(double previewWidth, double previewHeight, @NotNull Point topLeftPoint, @NotNull Point bottomLeftPoint, @NotNull Point bottomRightPoint, @NotNull Point topRightPoint, int resultWidth, int resultHeight) {
        Intrinsics.checkNotNullParameter((Object)topLeftPoint, (String)"topLeftPoint");
        Intrinsics.checkNotNullParameter((Object)bottomLeftPoint, (String)"bottomLeftPoint");
        Intrinsics.checkNotNullParameter((Object)bottomRightPoint, (String)"bottomRightPoint");
        Intrinsics.checkNotNullParameter((Object)topRightPoint, (String)"topRightPoint");
        this.previewWidth = previewWidth;
        this.previewHeight = previewHeight;
        this.topLeftPoint = topLeftPoint;
        this.bottomLeftPoint = bottomLeftPoint;
        this.bottomRightPoint = bottomRightPoint;
        this.topRightPoint = topRightPoint;
        this.resultWidth = resultWidth;
        this.resultHeight = resultHeight;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/zynksoftware/documentscanner/common/utils/ImageDetectionProperties$Companion;", "", "()V", "SMALLEST_ANGLE_COS", "", "DocumentScanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

