/*
 * Decompiled with CFR 0.152.
 */
package az.plainpie;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import az.plainpie.R;
import az.plainpie.annotation.ColorInt;

public class PieView
extends View {
    private RelativeLayout baseLayout;
    private TextView mPercentageTextView = null;
    private int mPercentageSize;
    private int mInnerCirclePadding;
    private Paint mPercentageFill;
    private Paint mBackgroundFill;
    private Paint mCenterFill;
    private RectF mRect;
    private RectF mRectCent;
    private float mPercentage = 0.0f;
    private float mMaxPercentage = 100.0f;
    private float mAngle = 0.0f;

    public PieView(Context context) {
        super(context);
        this.mPercentage = 0.0f;
        this.mAngle = 0.0f;
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.baseLayout = new RelativeLayout(context);
        this.baseLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mPercentageTextView = new TextView(context);
        int roundedPercentage = (int)(this.mPercentage * this.mMaxPercentage);
        this.mPercentageTextView.setText((CharSequence)(Integer.toString(roundedPercentage) + "%"));
        this.baseLayout.addView((View)this.mPercentageTextView);
        this.mPercentageSize = 50;
        this.mPercentageTextView.setTextSize((float)this.mPercentageSize);
        this.init();
    }

    public PieView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupWidgetWithParams(context, attrs, 0);
        this.init();
    }

    public PieView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setupWidgetWithParams(context, attrs, defStyle);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupWidgetWithParams(Context context, AttributeSet attrs, int defStyle) {
        this.mPercentageTextView = new TextView(context);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PieView, 0, 0);
        try {
            this.mPercentage = a.getFloat(R.styleable.PieView_percentage, 0.0f) / this.mMaxPercentage;
            this.mAngle = 360.0f * this.mPercentage;
            this.mPercentageSize = a.getInteger(R.styleable.PieView_percentage_size, 0);
            this.mInnerCirclePadding = a.getInteger(R.styleable.PieView_inner_pie_padding, 0);
            this.mPercentageTextView.setText((CharSequence)a.getString(R.styleable.PieView_inner_text));
            this.mPercentageTextView.setVisibility(a.getBoolean(R.styleable.PieView_inner_text_visibility, true) ? 0 : 4);
        }
        finally {
            a.recycle();
        }
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.baseLayout = new RelativeLayout(context);
        this.baseLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        if (this.mPercentageTextView.getText().toString().trim().equals("")) {
            int roundedPercentage = (int)(this.mPercentage * this.mMaxPercentage);
            this.mPercentageTextView.setText((CharSequence)(Integer.toString(roundedPercentage) + "%"));
        }
        this.mPercentageTextView.setTextSize((float)this.mPercentageSize);
        this.baseLayout.addView((View)this.mPercentageTextView);
    }

    private void init() {
        this.mPercentageTextView.setTextColor(this.getContext().getResources().getColor(R.color.percentageTextColor));
        this.mPercentageFill = new Paint();
        this.mPercentageFill.setColor(this.getContext().getResources().getColor(R.color.percentageFillColor));
        this.mPercentageFill.setAntiAlias(true);
        this.mPercentageFill.setStyle(Paint.Style.FILL);
        this.mBackgroundFill = new Paint();
        this.mBackgroundFill.setColor(this.getContext().getResources().getColor(R.color.percentageUnfilledColor));
        this.mBackgroundFill.setAntiAlias(true);
        this.mBackgroundFill.setStyle(Paint.Style.FILL);
        this.mCenterFill = new Paint();
        this.mCenterFill.setColor(this.getContext().getResources().getColor(R.color.percentageTextBackground));
        this.mCenterFill.setAntiAlias(true);
        this.mCenterFill.setStyle(Paint.Style.FILL);
        this.mRect = new RectF();
        this.mRectCent = new RectF();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int left = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        int top = 0;
        this.mRect.set((float)left, (float)top, (float)(left + width), (float)(top + width));
        this.mRectCent.set((float)(left + this.mInnerCirclePadding), (float)(top + this.mInnerCirclePadding), (float)(left - this.mInnerCirclePadding + width), (float)(top - this.mInnerCirclePadding + width));
        canvas.drawArc(this.mRect, -90.0f, 360.0f, true, this.mBackgroundFill);
        if (this.mPercentage != 0.0f) {
            canvas.drawArc(this.mRect, -90.0f, this.mAngle, true, this.mPercentageFill);
            canvas.drawArc(this.mRectCent, -90.0f, 360.0f, true, this.mCenterFill);
        }
        this.mPercentageTextView.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        this.mPercentageTextView.layout(left, top, left + width, top + height);
        this.mPercentageTextView.setGravity(17);
        this.baseLayout.draw(canvas);
    }

    public float getPieAngle() {
        return this.mAngle;
    }

    public void setPieAngle(float arcAngle) {
        this.mAngle = arcAngle;
    }

    public void setInnerTextVisibility(int visibility) {
        this.mPercentageTextView.setVisibility(visibility);
        this.invalidate();
    }

    public void setInnerText(String text) {
        this.mPercentageTextView.setText((CharSequence)text);
        this.invalidate();
    }

    public void setPieInnerPadding(int padding) {
        this.mInnerCirclePadding = padding;
        this.invalidate();
    }

    public int getPieInnerPadding() {
        return this.mInnerCirclePadding;
    }

    public float getPercentage() {
        return this.mPercentage * this.mMaxPercentage;
    }

    public void setPercentage(float percentage) {
        this.mPercentage = percentage / this.mMaxPercentage;
        int roundedPercentage = (int)percentage;
        this.mPercentageTextView.setText((CharSequence)(Integer.toString(roundedPercentage) + "%"));
        this.mAngle = 360.0f * this.mPercentage;
        this.invalidate();
    }

    public void setPercentageTextSize(float size) {
        this.mPercentageTextView.setTextSize(size);
        this.invalidate();
    }

    public void setInnerBackgroundColor(@ColorInt int color2) {
        this.mCenterFill.setColor(color2);
    }

    public void setPercentageBackgroundColor(@ColorInt int color2) {
        this.mPercentageFill.setColor(color2);
    }

    public void setMainBackgroundColor(@ColorInt int color2) {
        this.mBackgroundFill.setColor(color2);
    }

    public void setTextColor(@ColorInt int color2) {
        this.mPercentageTextView.setTextColor(color2);
    }

    public void setMaxPercentage(float mMaxPercentage) {
        this.mMaxPercentage = mMaxPercentage;
    }
}

