/*
 * Decompiled with CFR 0.152.
 */
package com.zp.z_file.listener;

import com.zp.z_file.common.ZFileType;
import com.zp.z_file.type.AudioType;
import com.zp.z_file.type.ImageType;
import com.zp.z_file.type.OtherType;
import com.zp.z_file.type.PdfType;
import com.zp.z_file.type.PptType;
import com.zp.z_file.type.TxtType;
import com.zp.z_file.type.VideoType;
import com.zp.z_file.type.WordType;
import com.zp.z_file.type.XlsType;
import com.zp.z_file.type.ZipType;
import com.zp.z_file.util.ZFileHelp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/zp/z_file/listener/ZFileTypeListener;", "", "()V", "getFileType", "Lcom/zp/z_file/common/ZFileType;", "filePath", "", "z_file_release"})
public class ZFileTypeListener {
    @NotNull
    public ZFileType getFileType(@NotNull String filePath) {
        ZFileType zFileType;
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        switch (ZFileHelp.getFileTypeBySuffix(filePath)) {
            case "jpg": 
            case "gif": 
            case "png": 
            case "jpeg": {
                zFileType = new ImageType();
                break;
            }
            case "aac": 
            case "wav": 
            case "mp3": {
                zFileType = new AudioType();
                break;
            }
            case "mp4": 
            case "3gp": {
                zFileType = new VideoType();
                break;
            }
            case "txt": 
            case "xml": 
            case "json": {
                zFileType = new TxtType();
                break;
            }
            case "zip": {
                zFileType = new ZipType();
                break;
            }
            case "docx": {
                zFileType = new WordType();
                break;
            }
            case "xlsx": {
                zFileType = new XlsType();
                break;
            }
            case "pptx": {
                zFileType = new PptType();
                break;
            }
            case "pdf": {
                zFileType = new PdfType();
                break;
            }
            default: {
                zFileType = new OtherType();
            }
        }
        return zFileType;
    }
}

