/*
 * Decompiled with CFR 0.152.
 */
package com.socks.library;

import android.text.TextUtils;
import com.socks.library.klog.BaseLog;
import com.socks.library.klog.FileLog;
import com.socks.library.klog.JsonLog;
import com.socks.library.klog.XmlLog;
import java.io.File;

public class KLog {
    public static final String DEFAULT_MESSAGE = "execute";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String NULL_TIPS = "Log with null object";
    public static final String PARAM = "Param";
    public static final String NULL = "null";
    public static final String TAG_DEFAULT = "KLog";
    public static final String SUFFIX = ".java";
    public static final int JSON_INDENT = 4;
    public static final int V = 1;
    public static final int D = 2;
    public static final int I = 3;
    public static final int W = 4;
    public static final int E = 5;
    public static final int A = 6;
    public static final int JSON = 7;
    public static final int XML = 8;
    private static boolean IS_SHOW_LOG = true;
    private static final int STACK_TRACE_INDEX = 5;

    public static void init(boolean isShowLog) {
        IS_SHOW_LOG = isShowLog;
    }

    public static void v() {
        KLog.printLog(1, null, DEFAULT_MESSAGE);
    }

    public static void v(Object msg) {
        KLog.printLog(1, null, msg);
    }

    public static void v(String tag, Object ... objects) {
        KLog.printLog(1, tag, objects);
    }

    public static void d() {
        KLog.printLog(2, null, DEFAULT_MESSAGE);
    }

    public static void d(Object msg) {
        KLog.printLog(2, null, msg);
    }

    public static void d(String tag, Object ... objects) {
        KLog.printLog(2, tag, objects);
    }

    public static void i() {
        KLog.printLog(3, null, DEFAULT_MESSAGE);
    }

    public static void i(Object msg) {
        KLog.printLog(3, null, msg);
    }

    public static void i(String tag, Object ... objects) {
        KLog.printLog(3, tag, objects);
    }

    public static void w() {
        KLog.printLog(4, null, DEFAULT_MESSAGE);
    }

    public static void w(Object msg) {
        KLog.printLog(4, null, msg);
    }

    public static void w(String tag, Object ... objects) {
        KLog.printLog(4, tag, objects);
    }

    public static void e() {
        KLog.printLog(5, null, DEFAULT_MESSAGE);
    }

    public static void e(Object msg) {
        KLog.printLog(5, null, msg);
    }

    public static void e(String tag, Object ... objects) {
        KLog.printLog(5, tag, objects);
    }

    public static void a() {
        KLog.printLog(6, null, DEFAULT_MESSAGE);
    }

    public static void a(Object msg) {
        KLog.printLog(6, null, msg);
    }

    public static void a(String tag, Object ... objects) {
        KLog.printLog(6, tag, objects);
    }

    public static void json(String jsonFormat) {
        KLog.printLog(7, null, jsonFormat);
    }

    public static void json(String tag, String jsonFormat) {
        KLog.printLog(7, tag, jsonFormat);
    }

    public static void xml(String xml) {
        KLog.printLog(8, null, xml);
    }

    public static void xml(String tag, String xml) {
        KLog.printLog(8, tag, xml);
    }

    public static void file(File targetDirectory, Object msg) {
        KLog.printFile(null, targetDirectory, null, msg);
    }

    public static void file(String tag, File targetDirectory, Object msg) {
        KLog.printFile(tag, targetDirectory, null, msg);
    }

    public static void file(String tag, File targetDirectory, String fileName, Object msg) {
        KLog.printFile(tag, targetDirectory, fileName, msg);
    }

    private static void printLog(int type, String tagStr, Object ... objects) {
        if (!IS_SHOW_LOG) {
            return;
        }
        String[] contents = KLog.wrapperContent(tagStr, objects);
        String tag = contents[0];
        String msg = contents[1];
        String headString = contents[2];
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                BaseLog.printDefault(type, tag, headString + msg);
                break;
            }
            case 7: {
                JsonLog.printJson(tag, msg, headString);
                break;
            }
            case 8: {
                XmlLog.printXml(tag, msg, headString);
            }
        }
    }

    private static void printFile(String tagStr, File targetDirectory, String fileName, Object objectMsg) {
        if (!IS_SHOW_LOG) {
            return;
        }
        String[] contents = KLog.wrapperContent(tagStr, objectMsg);
        String tag = contents[0];
        String msg = contents[1];
        String headString = contents[2];
        FileLog.printFile(tag, targetDirectory, fileName, headString, msg);
    }

    private static String[] wrapperContent(String tagStr, Object ... objects) {
        String tag;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement targetElement = stackTrace[5];
        String className = targetElement.getClassName();
        String[] classNameInfo = className.split("\\.");
        if (classNameInfo.length > 0) {
            className = classNameInfo[classNameInfo.length - 1] + SUFFIX;
        }
        String methodName = targetElement.getMethodName();
        int lineNumber = targetElement.getLineNumber();
        if (lineNumber < 0) {
            lineNumber = 0;
        }
        String methodNameShort = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        String string = tag = tagStr == null ? className : tagStr;
        if (TextUtils.isEmpty((CharSequence)tag)) {
            tag = TAG_DEFAULT;
        }
        String msg = objects == null ? NULL_TIPS : KLog.getObjectsString(objects);
        String headString = "[ (" + className + ":" + lineNumber + ")#" + methodNameShort + " ] ";
        return new String[]{tag, msg, headString};
    }

    private static String getObjectsString(Object ... objects) {
        if (objects.length > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n");
            for (int i = 0; i < objects.length; ++i) {
                Object object = objects[i];
                if (object == null) {
                    stringBuilder.append(PARAM).append("[").append(i).append("]").append(" = ").append(NULL).append("\n");
                    continue;
                }
                stringBuilder.append(PARAM).append("[").append(i).append("]").append(" = ").append(object.toString()).append("\n");
            }
            return stringBuilder.toString();
        }
        Object object = objects[0];
        return object == null ? NULL : object.toString();
    }
}

