/*
 * Decompiled with CFR 0.152.
 */
package com.socks.library.klog;

import android.util.Log;
import com.socks.library.KLog;
import com.socks.library.Util;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlLog {
    public static void printXml(String tag, String xml, String headString) {
        String[] lines;
        if (xml != null) {
            xml = XmlLog.formatXML(xml);
            xml = headString + "\n" + xml;
        } else {
            xml = headString + "Log with null object";
        }
        Util.printLine(tag, true);
        for (String line : lines = xml.split(KLog.LINE_SEPARATOR)) {
            if (Util.isEmpty(line)) continue;
            Log.d((String)tag, (String)("\u2551 " + line));
        }
        Util.printLine(tag, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatXML(String inputXML) {
        XMLWriter writer = null;
        String requestXML = null;
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read((Reader)new StringReader(inputXML));
            StringWriter stringWriter = new StringWriter();
            OutputFormat format = new OutputFormat(" ", true);
            writer = new XMLWriter((Writer)stringWriter, format);
            writer.write(document);
            writer.flush();
            requestXML = stringWriter.getBuffer().toString();
        }
        catch (IOException e) {
            String string = inputXML;
            return string;
        }
        catch (DocumentException e) {
            String string = inputXML;
            return string;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    return inputXML;
                }
            }
        }
        return requestXML;
    }
}

