/*
 * Decompiled with CFR 0.152.
 */
package com.socks.library;

import android.text.TextUtils;
import android.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KLog {
    private static boolean IS_SHOW_LOG = true;
    private static final String DEFAULT_MESSAGE = "execute";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int JSON_INDENT = 4;
    private static final int V = 1;
    private static final int D = 2;
    private static final int I = 3;
    private static final int W = 4;
    private static final int E = 5;
    private static final int A = 6;
    private static final int JSON = 7;

    public static void init(boolean isShowLog) {
        IS_SHOW_LOG = isShowLog;
    }

    public static void v() {
        KLog.printLog(1, null, DEFAULT_MESSAGE);
    }

    public static void v(String msg) {
        KLog.printLog(1, null, msg);
    }

    public static void v(String tag, String msg) {
        KLog.printLog(1, tag, msg);
    }

    public static void d() {
        KLog.printLog(2, null, DEFAULT_MESSAGE);
    }

    public static void d(String msg) {
        KLog.printLog(2, null, msg);
    }

    public static void d(String tag, String msg) {
        KLog.printLog(2, tag, msg);
    }

    public static void i() {
        KLog.printLog(3, null, DEFAULT_MESSAGE);
    }

    public static void i(String msg) {
        KLog.printLog(3, null, msg);
    }

    public static void i(String tag, String msg) {
        KLog.printLog(3, tag, msg);
    }

    public static void w() {
        KLog.printLog(4, null, DEFAULT_MESSAGE);
    }

    public static void w(String msg) {
        KLog.printLog(4, null, msg);
    }

    public static void w(String tag, String msg) {
        KLog.printLog(4, tag, msg);
    }

    public static void e() {
        KLog.printLog(5, null, DEFAULT_MESSAGE);
    }

    public static void e(String msg) {
        KLog.printLog(5, null, msg);
    }

    public static void e(String tag, String msg) {
        KLog.printLog(5, tag, msg);
    }

    public static void a() {
        KLog.printLog(6, null, DEFAULT_MESSAGE);
    }

    public static void a(String msg) {
        KLog.printLog(6, null, msg);
    }

    public static void a(String tag, String msg) {
        KLog.printLog(6, tag, msg);
    }

    public static void json(String jsonFormat) {
        KLog.printLog(7, null, jsonFormat);
    }

    public static void json(String tag, String jsonFormat) {
        KLog.printLog(7, tag, jsonFormat);
    }

    private static void printLog(int type, String tagStr, String msg) {
        if (!IS_SHOW_LOG) {
            return;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int index = 4;
        String className = stackTrace[index].getFileName();
        String methodName = stackTrace[index].getMethodName();
        int lineNumber = stackTrace[index].getLineNumber();
        String tag = tagStr == null ? className : tagStr;
        methodName = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ (").append(className).append(":").append(lineNumber).append(")#").append(methodName).append(" ] ");
        if (msg != null && type != 7) {
            stringBuilder.append(msg);
        }
        String logStr = stringBuilder.toString();
        switch (type) {
            case 1: {
                Log.v((String)tag, (String)logStr);
                break;
            }
            case 2: {
                Log.d((String)tag, (String)logStr);
                break;
            }
            case 3: {
                Log.i((String)tag, (String)logStr);
                break;
            }
            case 4: {
                Log.w((String)tag, (String)logStr);
                break;
            }
            case 5: {
                Log.e((String)tag, (String)logStr);
                break;
            }
            case 6: {
                Log.wtf((String)tag, (String)logStr);
                break;
            }
            case 7: {
                if (TextUtils.isEmpty((CharSequence)msg)) {
                    Log.d((String)tag, (String)"Empty or Null json content");
                    return;
                }
                String message = null;
                try {
                    if (msg.startsWith("{")) {
                        JSONObject jsonObject = new JSONObject(msg);
                        message = jsonObject.toString(4);
                    } else if (msg.startsWith("[")) {
                        JSONArray jsonArray = new JSONArray(msg);
                        message = jsonArray.toString(4);
                    }
                }
                catch (JSONException e) {
                    KLog.e(tag, e.getCause().getMessage() + "\n" + msg);
                    return;
                }
                KLog.printLine(tag, true);
                message = logStr + LINE_SEPARATOR + message;
                String[] lines = message.split(LINE_SEPARATOR);
                StringBuilder jsonContent = new StringBuilder();
                for (String line : lines) {
                    jsonContent.append("\u2551 ").append(line).append(LINE_SEPARATOR);
                }
                Log.d((String)tag, (String)jsonContent.toString());
                KLog.printLine(tag, false);
            }
        }
    }

    private static void printLine(String tag, boolean isTop) {
        if (isTop) {
            Log.d((String)tag, (String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        } else {
            Log.d((String)tag, (String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        }
    }
}

