/*
 * Decompiled with CFR 0.152.
 */
package com.zerobranch.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.GestureDetectorCompat;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;
import com.zerobranch.layout.R;

public class SwipeLayout
extends FrameLayout {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int HORIZONTAL = 3;
    private static final int CLOSE_POSITION = 0;
    private static final int NO_POSITION = -1;
    private static final int DEFAULT_AUTO_OPEN_SPEED = 1000;
    private int currentDirection;
    private boolean isTogether;
    private boolean isEnabledSwipe;
    private boolean isContinuousSwipe;
    private boolean isFreeDragAfterOpen;
    private boolean isFreeHorizontalDrag;
    private int rightDragViewPadding;
    private int leftDragViewPadding;
    private double autoOpenSpeed;
    private boolean disallowIntercept;
    private int currentDraggingState = 0;
    private ViewDragHelper dragHelper;
    private GestureDetectorCompat gestureDetector;
    private int draggingViewLeft;
    private int horizontalWidth;
    private boolean isLeftOpen = false;
    private boolean isRightOpen = false;
    private int staticRightViewId;
    private int staticLeftViewId;
    private int draggedViewId;
    private View draggedView;
    private View staticRightView;
    private View staticLeftView;
    private SwipeActionsListener actionsListener;
    private GestureDetector.OnGestureListener gestureDetectorCallBack = new GestureDetector.SimpleOnGestureListener(){

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (SwipeLayout.this.getParent() != null) {
                SwipeLayout.this.getParent().requestDisallowInterceptTouchEvent(true);
            }
            return false;
        }
    };
    private final ViewDragHelper.Callback dragHelperCallback = new ViewDragHelper.Callback(){

        public void onViewDragStateChanged(int state) {
            if (state == SwipeLayout.this.currentDraggingState) {
                return;
            }
            if (SwipeLayout.this.isIdleAfterMoving(state)) {
                SwipeLayout.this.updateState();
            }
            SwipeLayout.this.currentDraggingState = state;
        }

        public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
            SwipeLayout.this.draggingViewLeft = left;
            if (SwipeLayout.this.isTogether) {
                if (SwipeLayout.this.currentDirection == 1) {
                    SwipeLayout.this.staticRightView.offsetLeftAndRight(dx);
                } else if (SwipeLayout.this.currentDirection == 2) {
                    SwipeLayout.this.staticLeftView.offsetLeftAndRight(dx);
                } else if (SwipeLayout.this.currentDirection == 3) {
                    SwipeLayout.this.staticLeftView.offsetLeftAndRight(dx);
                    SwipeLayout.this.staticRightView.offsetLeftAndRight(dx);
                }
            }
        }

        public int getViewHorizontalDragRange(@NonNull View child) {
            return SwipeLayout.this.horizontalWidth;
        }

        public boolean tryCaptureView(@NonNull View view, int pointerId) {
            return view.getId() == SwipeLayout.this.draggedView.getId();
        }

        public int clampViewPositionHorizontal(@NonNull View child, int left, int dx) {
            if (!SwipeLayout.this.isEnabledSwipe) {
                return 0;
            }
            switch (SwipeLayout.this.currentDirection) {
                case 1: {
                    return SwipeLayout.this.clampLeftViewPosition(left);
                }
                case 2: {
                    return SwipeLayout.this.clampRightViewPosition(left);
                }
                case 3: {
                    return SwipeLayout.this.clampHorizontalViewPosition(left, dx);
                }
            }
            return 0;
        }

        public void onViewReleased(@NonNull View releasedChild, float xVel, float yVel) {
            int finalXDraggingView = 0;
            if (SwipeLayout.this.currentDirection == 1) {
                finalXDraggingView = SwipeLayout.this.getFinalXLeftDirection(xVel);
            } else if (SwipeLayout.this.currentDirection == 2) {
                finalXDraggingView = SwipeLayout.this.getFinalXRightDirection(xVel);
            } else if (SwipeLayout.this.currentDirection == 3 && (finalXDraggingView = SwipeLayout.this.getFinalXHorizontalDirection(xVel)) == -1) {
                finalXDraggingView = SwipeLayout.this.getPreviousPosition();
            }
            if (SwipeLayout.this.dragHelper.settleCapturedViewAt(finalXDraggingView, SwipeLayout.this.draggedView.getTop())) {
                ViewCompat.postInvalidateOnAnimation((View)SwipeLayout.this);
            }
        }
    };

    public SwipeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.SwipeLayout);
        this.currentDirection = typedArray.getInteger(R.styleable.SwipeLayout_swipeDirection, 1);
        this.isFreeDragAfterOpen = typedArray.getBoolean(R.styleable.SwipeLayout_isFreeDragAfterOpen, false);
        this.isFreeHorizontalDrag = typedArray.getBoolean(R.styleable.SwipeLayout_isFreeHorizontalDrag, false);
        this.isContinuousSwipe = typedArray.getBoolean(R.styleable.SwipeLayout_isContinuousSwipe, false);
        this.isTogether = typedArray.getBoolean(R.styleable.SwipeLayout_isTogether, false);
        this.isEnabledSwipe = typedArray.getBoolean(R.styleable.SwipeLayout_isEnabledSwipe, true);
        this.staticLeftViewId = typedArray.getResourceId(R.styleable.SwipeLayout_leftItem, 0);
        this.staticRightViewId = typedArray.getResourceId(R.styleable.SwipeLayout_rightItem, 0);
        this.draggedViewId = typedArray.getResourceId(R.styleable.SwipeLayout_draggedItem, 0);
        this.autoOpenSpeed = typedArray.getInt(R.styleable.SwipeLayout_autoMovingSensitivity, 1000);
        this.rightDragViewPadding = (int)typedArray.getDimension(R.styleable.SwipeLayout_rightDragViewPadding, 0.0f);
        this.leftDragViewPadding = (int)typedArray.getDimension(R.styleable.SwipeLayout_leftDragViewPadding, 0.0f);
        this.parametersAdjustment();
        typedArray.recycle();
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        this.horizontalWidth = w;
        super.onSizeChanged(w, h, oldW, oldH);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.disallowIntercept && this.isViewGroup(this.draggedView)) {
            View neededScrollView = this.getNeededTouchView(event, (ViewGroup)this.draggedView);
            Point touchPoint = new Point((int)event.getX(), (int)event.getY());
            if (neededScrollView != null && this.isViewTouchTarget(neededScrollView, touchPoint)) {
                return false;
            }
        }
        return this.isSwipeViewTarget(event) && this.dragHelper.shouldInterceptTouchEvent(event);
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
        this.disallowIntercept = disallowIntercept;
    }

    protected void onFinishInflate() {
        if (this.draggedViewId != 0) {
            this.draggedView = this.findViewById(this.draggedViewId);
        }
        if (this.staticLeftViewId != 0) {
            this.staticLeftView = this.findViewById(this.staticLeftViewId);
        }
        if (this.staticRightViewId != 0) {
            this.staticRightView = this.findViewById(this.staticRightViewId);
        }
        if (this.draggedView == null) {
            throw new RuntimeException("'draggedItem' must be specified");
        }
        if (this.isTogether && this.currentDirection == 1 && this.staticRightView == null) {
            throw new RuntimeException("If 'isTogether = true' 'rightItem' must be specified");
        }
        if (this.isTogether && this.currentDirection == 2 && this.staticLeftView == null) {
            throw new RuntimeException("If 'isTogether = true' 'leftItem' must be specified");
        }
        if (this.currentDirection == 1 && !this.isContinuousSwipe && this.staticRightView == null) {
            throw new RuntimeException("Must be specified 'rightItem' or flag isContinuousSwipe = true");
        }
        if (this.currentDirection == 2 && !this.isContinuousSwipe && this.staticLeftView == null) {
            throw new RuntimeException("Must be specified 'leftItem' or flag isContinuousSwipe = true");
        }
        if (this.currentDirection == 3 && (this.staticRightView == null || this.staticLeftView == null)) {
            throw new RuntimeException("'leftItem' and 'rightItem' must be specified");
        }
        this.dragHelper = ViewDragHelper.create((ViewGroup)this, (float)1.0f, (ViewDragHelper.Callback)this.dragHelperCallback);
        this.gestureDetector = new GestureDetectorCompat(this.getContext(), this.gestureDetectorCallBack);
        this.setupPost();
        super.onFinishInflate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isSwipeViewTarget(event) || this.isMoving()) {
            this.gestureDetector.onTouchEvent(event);
            this.dragHelper.processTouchEvent(event);
            return true;
        }
        return super.onTouchEvent(event);
    }

    public void computeScroll() {
        if (this.dragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public boolean isEnabledSwipe() {
        return this.isEnabledSwipe;
    }

    public void setEnabledSwipe(boolean enabledSwipe) {
        this.isEnabledSwipe = enabledSwipe;
    }

    public void openRight(boolean animated) {
        if (animated) {
            this.openRight();
        } else if (this.isDragIdle(this.currentDraggingState) && (this.currentDirection == 1 && !this.isEmptyRightView() || this.currentDirection == 3) && !this.isRightOpen) {
            if (this.isTogether) {
                this.staticRightView.offsetLeftAndRight(-1 * (this.isLeftOpen ? this.getRightViewWidth() * 2 : this.getRightViewWidth()));
            }
            this.draggedView.offsetLeftAndRight(-1 * (this.isLeftOpen ? this.getRightViewWidth() * 2 : this.getRightViewWidth()));
            this.draggingViewLeft -= this.isLeftOpen ? this.getRightViewWidth() * 2 : this.getRightViewWidth();
            this.updateState();
        }
    }

    public void openRightCompletely(boolean animated) {
        if (animated) {
            this.openRightCompletely();
        } else if (this.isDragIdle(this.currentDraggingState) && this.currentDirection == 1) {
            if (this.isTogether) {
                this.staticRightView.offsetLeftAndRight(-this.horizontalWidth);
            }
            this.draggedView.offsetLeftAndRight(-this.horizontalWidth);
            this.draggingViewLeft -= this.horizontalWidth;
            this.updateState();
        }
    }

    public void openLeft(boolean animated) {
        if (animated) {
            this.openLeft();
        } else if (this.isDragIdle(this.currentDraggingState) && (this.currentDirection == 2 && !this.isEmptyLeftView() || this.currentDirection == 3) && !this.isLeftOpen) {
            if (this.isTogether) {
                this.staticLeftView.offsetLeftAndRight(this.isRightOpen ? this.getLeftViewWidth() * 2 : this.getLeftViewWidth());
            }
            this.draggedView.offsetLeftAndRight(this.isRightOpen ? this.getLeftViewWidth() * 2 : this.getLeftViewWidth());
            this.draggingViewLeft += this.isRightOpen ? this.getLeftViewWidth() * 2 : this.getLeftViewWidth();
            this.updateState();
        }
    }

    public void openLeftCompletely(boolean animated) {
        if (animated) {
            this.openRightCompletely();
        } else if (this.isDragIdle(this.currentDraggingState) && this.currentDirection == 2) {
            if (this.isTogether) {
                this.staticRightView.offsetLeftAndRight(this.horizontalWidth);
            }
            this.draggedView.offsetLeftAndRight(this.horizontalWidth);
            this.draggingViewLeft += this.horizontalWidth;
            this.updateState();
        }
    }

    public void close(boolean animated) {
        if (animated) {
            this.close();
        } else {
            if (this.isTogether) {
                if (this.staticLeftView != null && this.currentDirection == 2) {
                    this.staticLeftView.layout(0, this.staticLeftView.getTop(), this.staticLeftView.getWidth(), this.staticLeftView.getBottom());
                } else if (this.staticRightView != null && this.currentDirection == 1) {
                    this.staticRightView.layout(this.horizontalWidth - this.staticRightView.getWidth(), this.staticRightView.getTop(), this.horizontalWidth, this.staticRightView.getBottom());
                } else if (this.currentDirection == 3 && this.staticRightView != null && this.staticLeftView != null) {
                    this.staticLeftView.layout(0, this.staticLeftView.getTop(), this.staticLeftView.getWidth(), this.staticLeftView.getBottom());
                    this.staticRightView.layout(this.horizontalWidth - this.staticRightView.getWidth(), this.staticRightView.getTop(), this.horizontalWidth, this.staticRightView.getBottom());
                }
            }
            this.draggedView.layout(0, this.draggedView.getTop(), this.draggedView.getWidth(), this.draggedView.getBottom());
            this.draggingViewLeft = 0;
            this.updateState();
        }
    }

    public void openLeft() {
        if (this.isDragIdle(this.currentDraggingState) && (this.currentDirection == 2 && !this.isEmptyLeftView() || this.currentDirection == 3)) {
            this.moveTo(this.getLeftViewWidth());
        }
    }

    public void openRight() {
        if (this.isDragIdle(this.currentDraggingState) && (this.currentDirection == 1 && !this.isEmptyRightView() || this.currentDirection == 3)) {
            this.moveTo(-this.getRightViewWidth());
        }
    }

    public void openLeftCompletely() {
        if (this.isDragIdle(this.currentDraggingState) && this.currentDirection == 2) {
            this.moveTo(this.horizontalWidth);
        }
    }

    public void openRightCompletely() {
        if (this.isDragIdle(this.currentDraggingState) && this.currentDirection == 1) {
            this.moveTo(-this.horizontalWidth);
        }
    }

    public void close() {
        this.moveTo(0);
    }

    public boolean isMoving() {
        return this.currentDraggingState == 1 || this.currentDraggingState == 2;
    }

    public boolean isClosed() {
        return this.draggingViewLeft == 0;
    }

    public int getCurrentDirection() {
        return this.currentDirection;
    }

    public SwipeLayout setCurrentDirection(int currentDirection) {
        this.currentDirection = currentDirection;
        return this;
    }

    public boolean isTogether() {
        return this.isTogether;
    }

    public SwipeLayout setTogether(boolean together) {
        this.isTogether = together;
        return this;
    }

    public boolean isContinuousSwipe() {
        return this.isContinuousSwipe;
    }

    public SwipeLayout setContinuousSwipe(boolean continuousSwipe) {
        this.isContinuousSwipe = continuousSwipe;
        this.parametersAdjustment();
        return this;
    }

    public boolean isFreeDragAfterOpen() {
        return this.isFreeDragAfterOpen;
    }

    public SwipeLayout setFreeDragAfterOpen(boolean freeDragAfterOpen) {
        this.isFreeDragAfterOpen = freeDragAfterOpen;
        this.parametersAdjustment();
        return this;
    }

    public boolean isFreeHorizontalDrag() {
        return this.isFreeHorizontalDrag;
    }

    public SwipeLayout setFreeHorizontalDrag(boolean freeHorizontalDrag) {
        this.isFreeHorizontalDrag = freeHorizontalDrag;
        return this;
    }

    public boolean isRightOpen() {
        return this.isRightOpen;
    }

    public boolean isLeftOpen() {
        return this.isLeftOpen;
    }

    public SwipeLayout setOnActionsListener(@Nullable SwipeActionsListener actionsListener) {
        this.actionsListener = actionsListener;
        return this;
    }

    public int getRightDragViewPadding() {
        return this.rightDragViewPadding;
    }

    public SwipeLayout setRightDragViewPadding(int minRightDragViewPadding) {
        this.rightDragViewPadding = minRightDragViewPadding;
        this.parametersAdjustment();
        return this;
    }

    public int getLeftDragViewPadding() {
        return this.leftDragViewPadding;
    }

    public SwipeLayout setLeftDragViewPadding(int minLeftDragViewPadding) {
        this.leftDragViewPadding = minLeftDragViewPadding;
        this.parametersAdjustment();
        return this;
    }

    public void enableTouchForViewGroup(@NonNull ViewGroup viewGroup) {
        viewGroup.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                SwipeLayout.this.requestDisallowInterceptTouchEvent(true);
                return false;
            }
        });
    }

    private void updateState() {
        if (this.isClosed()) {
            this.isLeftOpen = false;
            this.isRightOpen = false;
            if (this.actionsListener != null) {
                this.actionsListener.onClose();
            }
        } else if (this.isLeftOpenCompletely() || this.isLeftViewOpen()) {
            this.isLeftOpen = true;
            this.isRightOpen = false;
            if (this.actionsListener != null) {
                this.actionsListener.onOpen(2, this.isLeftOpenCompletely());
            }
        } else if (this.isRightOpenCompletely() || this.isRightViewOpen()) {
            this.isLeftOpen = false;
            this.isRightOpen = true;
            if (this.actionsListener != null) {
                this.actionsListener.onOpen(1, this.isRightOpenCompletely());
            }
        }
    }

    private int clampLeftViewPosition(int left) {
        if (this.isContinuousSwipe && this.isEmptyRightView()) {
            if (this.isFreeHorizontalDrag) {
                return left > this.horizontalWidth ? 0 : Math.max(left, -this.horizontalWidth);
            }
            return left > 0 ? 0 : Math.max(left, -this.horizontalWidth);
        }
        if (this.isFreeDragAfterOpen) {
            if (this.isFreeHorizontalDrag) {
                return left > this.horizontalWidth ? 0 : Math.max(left, this.leftDragViewPadding - this.horizontalWidth);
            }
            return left > 0 ? 0 : Math.max(left, this.leftDragViewPadding - this.horizontalWidth);
        }
        if (this.isFreeHorizontalDrag) {
            return left > this.horizontalWidth ? 0 : Math.max(left, -this.getRightViewWidth());
        }
        return left > 0 ? 0 : Math.max(left, -this.getRightViewWidth());
    }

    private int clampRightViewPosition(int left) {
        if (this.isContinuousSwipe && this.isEmptyLeftView()) {
            if (this.isFreeHorizontalDrag) {
                return left < -this.horizontalWidth ? -this.horizontalWidth : Math.min(left, this.horizontalWidth);
            }
            return left < 0 ? 0 : Math.min(left, this.horizontalWidth);
        }
        if (this.isFreeDragAfterOpen) {
            if (this.isFreeHorizontalDrag) {
                return left < -this.horizontalWidth ? -this.horizontalWidth : Math.min(left, this.horizontalWidth - this.rightDragViewPadding);
            }
            return left < 0 ? 0 : Math.min(left, this.horizontalWidth - this.rightDragViewPadding);
        }
        if (this.isFreeHorizontalDrag) {
            return left < -this.horizontalWidth ? -this.horizontalWidth : Math.min(left, this.getLeftViewWidth());
        }
        return left < 0 ? 0 : Math.min(left, this.getLeftViewWidth());
    }

    private int clampHorizontalViewPosition(int left, int dx) {
        if (!this.isFreeHorizontalDrag && this.isLeftOpen && dx < 0) {
            return Math.max(left, 0);
        }
        if (!this.isFreeHorizontalDrag && this.isRightOpen && dx > 0) {
            return Math.min(left, 0);
        }
        if (!this.isFreeDragAfterOpen && left > 0) {
            return Math.min(left, this.getLeftViewWidth());
        }
        if (!this.isFreeDragAfterOpen && left < 0) {
            return Math.max(left, -this.getRightViewWidth());
        }
        return left < 0 ? Math.max(left, this.leftDragViewPadding - this.horizontalWidth) : Math.min(left, this.horizontalWidth - this.rightDragViewPadding);
    }

    private int getPreviousPosition() {
        if (this.isLeftOpen) {
            return this.getLeftViewWidth();
        }
        if (this.isRightOpen) {
            return -this.getRightViewWidth();
        }
        return 0;
    }

    private int getFinalXLeftDirection(float xVel) {
        if (this.isContinuousSwipe) {
            if (this.isEmptyRightView()) {
                if (this.draggingViewLeft < 0 && Math.abs(this.draggingViewLeft) > this.horizontalWidth / 2 || (double)xVel < -this.autoOpenSpeed) {
                    return -this.horizontalWidth;
                }
                return 0;
            }
            if (this.isContinuousSwipeToLeft(xVel)) {
                return -this.horizontalWidth;
            }
        }
        boolean settleToOpen = (double)xVel > this.autoOpenSpeed ? false : ((double)xVel < -this.autoOpenSpeed ? true : (this.draggingViewLeft < 0 && Math.abs(this.draggingViewLeft) > this.getRightViewWidth() / 2 ? true : (this.draggingViewLeft < 0 && Math.abs(this.draggingViewLeft) < this.getRightViewWidth() / 2 ? false : false)));
        return settleToOpen ? -this.getRightViewWidth() : 0;
    }

    private int getFinalXRightDirection(float xVel) {
        if (this.isContinuousSwipe) {
            if (this.isEmptyLeftView()) {
                if (this.draggingViewLeft > 0 && Math.abs(this.draggingViewLeft) > this.horizontalWidth / 2 || (double)xVel > this.autoOpenSpeed) {
                    return this.horizontalWidth;
                }
                return 0;
            }
            if (this.isContinuousSwipeToRight(xVel)) {
                return this.horizontalWidth;
            }
        }
        boolean settleToOpen = (double)xVel > this.autoOpenSpeed ? true : ((double)xVel < -this.autoOpenSpeed ? false : (this.draggingViewLeft > 0 && Math.abs(this.draggingViewLeft) > this.getLeftViewWidth() / 2 ? true : (this.draggingViewLeft > 0 && Math.abs(this.draggingViewLeft) < this.getLeftViewWidth() / 2 ? false : false)));
        return settleToOpen ? this.getLeftViewWidth() : 0;
    }

    private int getFinalXHorizontalDirection(float xVel) {
        if (this.isSwipeToOpenLeft(xVel)) {
            return this.getLeftViewWidth();
        }
        if (this.isSwipeToOpenRight(xVel)) {
            return -this.getRightViewWidth();
        }
        if (this.isSwipeToClose(xVel)) {
            return 0;
        }
        return -1;
    }

    private boolean isContinuousSwipeToRight(float xVel) {
        return (double)xVel > this.autoOpenSpeed && Math.abs(this.draggingViewLeft) > this.getLeftViewWidth() || this.draggingViewLeft > 0 && Math.abs(this.draggingViewLeft) > this.horizontalWidth / 2;
    }

    private boolean isContinuousSwipeToLeft(float xVel) {
        return (double)xVel < -this.autoOpenSpeed && Math.abs(this.draggingViewLeft) > this.getRightViewWidth() || this.draggingViewLeft < 0 && Math.abs(this.draggingViewLeft) > this.horizontalWidth / 2;
    }

    private boolean isSwipeToOpenRight(float xVel) {
        if (xVel > 0.0f) {
            return false;
        }
        return this.draggingViewLeft < 0 && (double)xVel < -this.autoOpenSpeed || this.draggingViewLeft < 0 && Math.abs(this.draggingViewLeft) > this.getRightViewWidth() / 2;
    }

    private boolean isSwipeToOpenLeft(float xVel) {
        if (xVel < 0.0f) {
            return false;
        }
        return this.draggingViewLeft > 0 && (double)xVel > this.autoOpenSpeed || this.draggingViewLeft > 0 && Math.abs(this.draggingViewLeft) > this.getLeftViewWidth() / 2;
    }

    private boolean isSwipeToClose(float xVel) {
        return this.draggingViewLeft >= 0 && (double)xVel < -this.autoOpenSpeed || this.draggingViewLeft <= 0 && (double)xVel > this.autoOpenSpeed || this.draggingViewLeft >= 0 && Math.abs(this.draggingViewLeft) < this.getLeftViewWidth() / 2 || this.draggingViewLeft <= 0 && Math.abs(this.draggingViewLeft) < this.getRightViewWidth() / 2;
    }

    private void setupPost() {
        if (this.isTogether) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    if (SwipeLayout.this.currentDirection == 1) {
                        SwipeLayout.this.staticRightView.setX((float)SwipeLayout.this.horizontalWidth);
                    } else if (SwipeLayout.this.currentDirection == 2) {
                        SwipeLayout.this.staticLeftView.setX((float)(-SwipeLayout.this.staticLeftView.getWidth()));
                    } else if (SwipeLayout.this.currentDirection == 3) {
                        SwipeLayout.this.staticRightView.setX((float)SwipeLayout.this.horizontalWidth);
                        SwipeLayout.this.staticLeftView.setX((float)(-SwipeLayout.this.staticLeftView.getWidth()));
                    }
                }
            });
        }
    }

    private boolean isViewTouchTarget(View view, Point point) {
        return point.y >= view.getTop() && point.y < view.getBottom() && point.x >= view.getLeft() && point.y < view.getRight();
    }

    private View getNeededTouchView(MotionEvent event, ViewGroup rootView) {
        if (rootView.onInterceptTouchEvent(event)) {
            return rootView;
        }
        int count = rootView.getChildCount();
        for (int i = 0; i < count; ++i) {
            View neededScrollView;
            View view = rootView.getChildAt(i);
            if (!this.isViewGroup(view) || (neededScrollView = this.getNeededTouchView(event, (ViewGroup)view)) == null) continue;
            return neededScrollView;
        }
        return null;
    }

    private boolean isViewGroup(View view) {
        return view instanceof ViewGroup;
    }

    private boolean isSwipeViewTarget(MotionEvent event) {
        int[] swipeViewLocation = new int[2];
        this.draggedView.getLocationOnScreen(swipeViewLocation);
        int upperLimit = swipeViewLocation[1] + this.draggedView.getMeasuredHeight();
        int lowerLimit = swipeViewLocation[1];
        int y = (int)event.getRawY();
        return y > lowerLimit && y < upperLimit;
    }

    private boolean isIdleAfterMoving(int state) {
        return (this.currentDraggingState == 1 || this.currentDraggingState == 2) && state == 0;
    }

    private boolean isDragIdle(int state) {
        return state == 0;
    }

    private boolean isRightViewOpen() {
        return this.staticRightView != null && this.draggingViewLeft == -this.getRightViewWidth();
    }

    private boolean isLeftViewOpen() {
        return this.staticLeftView != null && this.draggingViewLeft == this.getLeftViewWidth();
    }

    private boolean isRightOpenCompletely() {
        return this.draggingViewLeft == -this.horizontalWidth;
    }

    private boolean isLeftOpenCompletely() {
        return this.draggingViewLeft == this.horizontalWidth;
    }

    private int getLeftViewWidth() {
        return this.staticLeftView.getWidth();
    }

    private int getRightViewWidth() {
        return this.staticRightView.getWidth();
    }

    private boolean isEmptyLeftView() {
        return this.staticLeftView == null;
    }

    private boolean isEmptyRightView() {
        return this.staticRightView == null;
    }

    private void parametersAdjustment() {
        if (this.isContinuousSwipe && this.currentDirection != 3) {
            this.isFreeDragAfterOpen = true;
        }
        if (this.currentDirection == 3) {
            this.rightDragViewPadding = 0;
            this.leftDragViewPadding = 0;
        }
    }

    private void moveTo(int x) {
        this.dragHelper.smoothSlideViewTo(this.draggedView, x, this.draggedView.getTop());
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public static interface SwipeActionsListener {
        public void onOpen(int var1, boolean var2);

        public void onClose();
    }
}

