/*
 * Decompiled with CFR 0.152.
 */
package com.github.zawadz88.materialpopupmenu.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.github.zawadz88.materialpopupmenu.MaterialPopupMenu;
import com.github.zawadz88.materialpopupmenu.R;
import com.github.zawadz88.materialpopupmenu.ViewBoundCallback;
import com.github.zawadz88.materialpopupmenu.internal.SectionedRecyclerViewAdapter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0004\u001c\u001d\u001e\u001fB!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0014J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0014J \u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0014J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\fH\u0014J\u0018\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0014J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0014R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter;", "Lcom/github/zawadz88/materialpopupmenu/internal/SectionedRecyclerViewAdapter;", "Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter$SectionHeaderViewHolder;", "Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter$AbstractItemViewHolder;", "sections", "", "Lcom/github/zawadz88/materialpopupmenu/MaterialPopupMenu$PopupMenuSection;", "dismissPopupCallback", "Lkotlin/Function0;", "", "(Ljava/util/List;Lkotlin/jvm/functions/Function0;)V", "sectionCount", "", "getSectionCount", "()I", "getItemCountForSection", "section", "getSectionItemViewType", "position", "onBindItemViewHolder", "holder", "onBindSectionHeaderViewHolder", "sectionPosition", "onCreateItemViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onCreateSectionHeaderViewHolder", "AbstractItemViewHolder", "CustomItemViewHolder", "ItemViewHolder", "SectionHeaderViewHolder", "material-popup-menu_release"})
@SuppressLint(value={"RestrictedApi"})
public final class PopupMenuAdapter
extends SectionedRecyclerViewAdapter<SectionHeaderViewHolder, AbstractItemViewHolder> {
    private final List<MaterialPopupMenu.PopupMenuSection> sections;
    private final Function0<Unit> dismissPopupCallback;

    @Override
    protected int getItemCountForSection(int section) {
        return this.sections.get(section).getItems().size();
    }

    @Override
    protected int getSectionCount() {
        return this.sections.size();
    }

    @Override
    @NotNull
    protected SectionHeaderViewHolder onCreateSectionHeaderViewHolder(@NotNull ViewGroup parent, int viewType) {
        View v;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        View view = v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.mpm_popup_menu_section_header, parent, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"v");
        return new SectionHeaderViewHolder(view);
    }

    @Override
    protected int getSectionItemViewType(int section, int position) {
        MaterialPopupMenu.AbstractPopupMenuItem popupMenuItem = this.sections.get(section).getItems().get(position);
        return popupMenuItem instanceof MaterialPopupMenu.PopupMenuCustomItem ? ((MaterialPopupMenu.PopupMenuCustomItem)popupMenuItem).getLayoutResId() : super.getSectionItemViewType(section, position);
    }

    @Override
    @NotNull
    protected AbstractItemViewHolder onCreateItemViewHolder(@NotNull ViewGroup parent, int viewType) {
        AbstractItemViewHolder abstractItemViewHolder;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        if (viewType == -2) {
            View v;
            View view = v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.mpm_popup_menu_item, parent, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"v");
            abstractItemViewHolder = new ItemViewHolder(view, this.dismissPopupCallback);
        } else {
            View v;
            View view = v = LayoutInflater.from((Context)parent.getContext()).inflate(viewType, parent, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"v");
            abstractItemViewHolder = new CustomItemViewHolder(view, this.dismissPopupCallback);
        }
        return abstractItemViewHolder;
    }

    @Override
    protected void onBindSectionHeaderViewHolder(@NotNull SectionHeaderViewHolder holder, int sectionPosition) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        CharSequence title = this.sections.get(sectionPosition).getTitle();
        if (title != null) {
            holder.getLabel().setVisibility(0);
            holder.getLabel().setText(title);
        } else {
            holder.getLabel().setVisibility(8);
        }
        holder.getSeparator().setVisibility(sectionPosition == 0 ? 8 : 0);
    }

    @Override
    protected void onBindItemViewHolder(@NotNull AbstractItemViewHolder holder, int section, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        MaterialPopupMenu.AbstractPopupMenuItem popupMenuItem = this.sections.get(section).getItems().get(position);
        holder.bindItem(popupMenuItem);
        holder.itemView.setOnClickListener(new View.OnClickListener(this, popupMenuItem){
            final /* synthetic */ PopupMenuAdapter this$0;
            final /* synthetic */ MaterialPopupMenu.AbstractPopupMenuItem $popupMenuItem;

            public final void onClick(View it) {
                this.$popupMenuItem.getCallback().invoke();
                if (this.$popupMenuItem.getDismissOnSelect()) {
                    PopupMenuAdapter.access$getDismissPopupCallback$p(this.this$0).invoke();
                }
            }
            {
                this.this$0 = popupMenuAdapter;
                this.$popupMenuItem = abstractPopupMenuItem;
            }
        });
    }

    public PopupMenuAdapter(@NotNull List<MaterialPopupMenu.PopupMenuSection> sections, @NotNull Function0<Unit> dismissPopupCallback) {
        Intrinsics.checkParameterIsNotNull(sections, (String)"sections");
        Intrinsics.checkParameterIsNotNull(dismissPopupCallback, (String)"dismissPopupCallback");
        this.sections = sections;
        this.dismissPopupCallback = dismissPopupCallback;
        this.setHasStableIds(false);
    }

    public static final /* synthetic */ Function0 access$getDismissPopupCallback$p(PopupMenuAdapter $this) {
        return $this.dismissPopupCallback;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0017R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter$AbstractItemViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "dismissPopupCallback", "Lkotlin/Function0;", "", "(Landroid/view/View;Lkotlin/jvm/functions/Function0;)V", "bindItem", "popupMenuItem", "Lcom/github/zawadz88/materialpopupmenu/MaterialPopupMenu$AbstractPopupMenuItem;", "material-popup-menu_release"})
    public static abstract class AbstractItemViewHolder
    extends RecyclerView.ViewHolder {
        private final Function0<Unit> dismissPopupCallback;

        @CallSuper
        public void bindItem(@NotNull MaterialPopupMenu.AbstractPopupMenuItem popupMenuItem) {
            Intrinsics.checkParameterIsNotNull((Object)popupMenuItem, (String)"popupMenuItem");
            popupMenuItem.getViewBoundCallback().setDismissPopupAction$material_popup_menu_release(this.dismissPopupCallback);
            ViewBoundCallback viewBoundCallback2 = popupMenuItem.getViewBoundCallback();
            View view = this.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
            viewBoundCallback2.invoke(view);
        }

        public AbstractItemViewHolder(@NotNull View itemView, @NotNull Function0<Unit> dismissPopupCallback) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            Intrinsics.checkParameterIsNotNull(dismissPopupCallback, (String)"dismissPopupCallback");
            super(itemView);
            this.dismissPopupCallback = dismissPopupCallback;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter$ItemViewHolder;", "Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter$AbstractItemViewHolder;", "itemView", "Landroid/view/View;", "dismissPopupCallback", "Lkotlin/Function0;", "", "(Landroid/view/View;Lkotlin/jvm/functions/Function0;)V", "icon", "Landroidx/appcompat/widget/AppCompatImageView;", "label", "Landroid/widget/TextView;", "nestedIcon", "bindItem", "popupMenuItem", "Lcom/github/zawadz88/materialpopupmenu/MaterialPopupMenu$AbstractPopupMenuItem;", "material-popup-menu_release"})
    public static final class ItemViewHolder
    extends AbstractItemViewHolder {
        private TextView label;
        private AppCompatImageView icon;
        private AppCompatImageView nestedIcon;

        @Override
        public void bindItem(@NotNull MaterialPopupMenu.AbstractPopupMenuItem popupMenuItem) {
            Intrinsics.checkParameterIsNotNull((Object)popupMenuItem, (String)"popupMenuItem");
            MaterialPopupMenu.PopupMenuItem castedPopupMenuItem = (MaterialPopupMenu.PopupMenuItem)popupMenuItem;
            if (castedPopupMenuItem.getLabel() != null) {
                this.label.setText(castedPopupMenuItem.getLabel());
            } else {
                this.label.setText(castedPopupMenuItem.getLabelRes());
            }
            if (castedPopupMenuItem.getIcon() != 0 || castedPopupMenuItem.getIconDrawable() != null) {
                AppCompatImageView appCompatImageView;
                AppCompatImageView $receiver = appCompatImageView = this.icon;
                boolean bl = false;
                $receiver.setVisibility(0);
                $receiver.setImageResource(castedPopupMenuItem.getIcon());
                Drawable drawable = castedPopupMenuItem.getIconDrawable();
                if (drawable != null) {
                    Drawable drawable2;
                    Drawable it = drawable2 = drawable;
                    boolean bl2 = false;
                    $receiver.setImageDrawable(it);
                }
                if (castedPopupMenuItem.getIconColor() != 0) {
                    $receiver.setSupportImageTintList(ColorStateList.valueOf((int)castedPopupMenuItem.getIconColor()));
                }
            } else {
                this.icon.setVisibility(8);
            }
            if (castedPopupMenuItem.getLabelColor() != 0) {
                this.label.setTextColor(castedPopupMenuItem.getLabelColor());
            }
            this.nestedIcon.setVisibility(castedPopupMenuItem.getHasNestedItems() ? 0 : 8);
            super.bindItem(popupMenuItem);
        }

        public ItemViewHolder(@NotNull View itemView, @NotNull Function0<Unit> dismissPopupCallback) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            Intrinsics.checkParameterIsNotNull(dismissPopupCallback, (String)"dismissPopupCallback");
            super(itemView, dismissPopupCallback);
            View view = itemView.findViewById(R.id.mpm_popup_menu_item_label);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView.findViewById(R.\u2026pm_popup_menu_item_label)");
            this.label = (TextView)view;
            View view2 = itemView.findViewById(R.id.mpm_popup_menu_item_icon);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView.findViewById(R.\u2026mpm_popup_menu_item_icon)");
            this.icon = (AppCompatImageView)view2;
            View view3 = itemView.findViewById(R.id.mpm_popup_menu_item_nested_icon);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"itemView.findViewById(R.\u2026up_menu_item_nested_icon)");
            this.nestedIcon = (AppCompatImageView)view3;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter$CustomItemViewHolder;", "Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter$AbstractItemViewHolder;", "itemView", "Landroid/view/View;", "dismissPopupCallback", "Lkotlin/Function0;", "", "(Landroid/view/View;Lkotlin/jvm/functions/Function0;)V", "material-popup-menu_release"})
    public static final class CustomItemViewHolder
    extends AbstractItemViewHolder {
        public CustomItemViewHolder(@NotNull View itemView, @NotNull Function0<Unit> dismissPopupCallback) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            Intrinsics.checkParameterIsNotNull(dismissPopupCallback, (String)"dismissPopupCallback");
            super(itemView, dismissPopupCallback);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004\u00a8\u0006\u000f"}, d2={"Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter$SectionHeaderViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "label", "Landroid/widget/TextView;", "getLabel", "()Landroid/widget/TextView;", "setLabel", "(Landroid/widget/TextView;)V", "separator", "getSeparator", "()Landroid/view/View;", "setSeparator", "material-popup-menu_release"})
    public static final class SectionHeaderViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private TextView label;
        @NotNull
        private View separator;

        @NotNull
        public final TextView getLabel() {
            return this.label;
        }

        public final void setLabel(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
            this.label = textView;
        }

        @NotNull
        public final View getSeparator() {
            return this.separator;
        }

        public final void setSeparator(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"<set-?>");
            this.separator = view;
        }

        public SectionHeaderViewHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.mpm_popup_menu_section_header_label);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView.findViewById(R.\u2026enu_section_header_label)");
            this.label = (TextView)view;
            View view2 = itemView.findViewById(R.id.mpm_popup_menu_section_separator);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView.findViewById(R.\u2026p_menu_section_separator)");
            this.separator = view2;
        }
    }
}

