/*
 * Decompiled with CFR 0.152.
 */
package com.github.zagum.switchicon;

import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Region;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.FloatRange;
import androidx.appcompat.widget.AppCompatImageView;
import com.github.zagum.switchicon.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 C2\u00020\u0001:\u0002CDB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001cH\u0002J\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020&H\u0002J\u0010\u0010,\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/H\u0014J\b\u00100\u001a\u00020/H\u0014J(\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0007H\u0014J\b\u00106\u001a\u00020&H\u0002J\u0010\u00107\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\u001a\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020!2\b\b\u0002\u0010:\u001a\u00020!H\u0007J\u0012\u0010;\u001a\u00020&2\b\b\u0002\u0010:\u001a\u00020!H\u0007J\u0010\u0010<\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\b\u0010=\u001a\u00020&H\u0002J\u0010\u0010>\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\u0010\u0010?\u001a\u00020&2\u0006\u0010@\u001a\u00020\u0007H\u0002J\u0010\u0010A\u001a\u00020&2\u0006\u0010B\u001a\u00020\u0007H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001c8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00020\u001c8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/github/zagum/switchicon/SwitchIconView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "animationDuration", "", "clipPath", "Landroid/graphics/Path;", "colorEvaluator", "Landroid/animation/ArgbEvaluator;", "colorFilter", "Landroid/graphics/PorterDuffColorFilter;", "dashEnd", "Landroid/graphics/Point;", "dashLengthXProjection", "dashLengthYProjection", "dashPaint", "Landroid/graphics/Paint;", "dashStart", "dashThickness", "dashXStart", "dashYStart", "disabledStateAlpha", "", "disabledStateColor", "fraction", "iconTintColor", "<set-?>", "", "isIconEnabled", "()Z", "noDash", "animateToFraction", "", "toFraction", "drawDash", "canvas", "Landroid/graphics/Canvas;", "initDashCoordinates", "onDraw", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onSizeChanged", "width", "height", "oldWidth", "oldHeight", "postInvalidateOnAnimationCompat", "setFraction", "setIconEnabled", "enabled", "animate", "switchState", "updateAlpha", "updateClipPath", "updateColor", "updateImageAlpha", "alpha", "updateImageColor", "color", "Companion", "SwitchIconSavedState", "switchicon_release"})
public final class SwitchIconView
extends AppCompatImageView {
    @FloatRange(from=0.0, to=1.0)
    private float fraction;
    private int dashThickness;
    private int dashLengthXProjection;
    private int dashLengthYProjection;
    private PorterDuffColorFilter colorFilter;
    @FloatRange(from=0.0, to=1.0)
    private final float disabledStateAlpha;
    private final long animationDuration;
    private final int dashXStart;
    private final int dashYStart;
    private final int iconTintColor;
    private final int disabledStateColor;
    private final boolean noDash;
    private final ArgbEvaluator colorEvaluator;
    private final Path clipPath;
    private final Point dashStart;
    private final Point dashEnd;
    private final Paint dashPaint;
    private boolean isIconEnabled;
    private static final int DEFAULT_ANIMATION_DURATION = 300;
    private static final float DASH_THICKNESS_PART = 0.083333336f;
    private static final float DEFAULT_DISABLED_ALPHA = 0.5f;
    private static final float SIN_45;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    public final boolean isIconEnabled() {
        return this.isIconEnabled;
    }

    @JvmOverloads
    public final void setIconEnabled(boolean enabled, boolean animate) {
        if (this.isIconEnabled == enabled) {
            return;
        }
        this.switchState(animate);
    }

    @JvmOverloads
    public static /* synthetic */ void setIconEnabled$default(SwitchIconView switchIconView, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = true;
        }
        switchIconView.setIconEnabled(bl, bl2);
    }

    @JvmOverloads
    public final void setIconEnabled(boolean enabled) {
        SwitchIconView.setIconEnabled$default(this, enabled, false, 2, null);
    }

    @JvmOverloads
    public final void switchState(boolean animate) {
        float newFraction = this.isIconEnabled ? 1.0f : 0.0f;
        boolean bl = this.isIconEnabled = !this.isIconEnabled;
        if (animate) {
            this.animateToFraction(newFraction);
        } else {
            this.setFraction(newFraction);
            this.invalidate();
        }
    }

    @JvmOverloads
    public static /* synthetic */ void switchState$default(SwitchIconView switchIconView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        switchIconView.switchState(bl);
    }

    @JvmOverloads
    public final void switchState() {
        SwitchIconView.switchState$default(this, false, 1, null);
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState;
        Parcelable parcelable = superState = super.onSaveInstanceState();
        Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"superState");
        SwitchIconSavedState savedState = new SwitchIconSavedState(parcelable);
        savedState.setIconEnabled(this.isIconEnabled);
        return (Parcelable)savedState;
    }

    protected void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (!(state instanceof SwitchIconSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        super.onRestoreInstanceState(((SwitchIconSavedState)state).getSuperState());
        this.isIconEnabled = ((SwitchIconSavedState)state).getIconEnabled();
        this.setFraction(this.isIconEnabled ? 0.0f : 1.0f);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.dashLengthXProjection = width - this.getPaddingLeft() - this.getPaddingRight();
        this.dashLengthYProjection = height - this.getPaddingTop() - this.getPaddingBottom();
        this.dashThickness = (int)(0.083333336f * (float)(this.dashLengthXProjection + this.dashLengthYProjection) / 2.0f);
        this.dashPaint.setStrokeWidth((float)this.dashThickness);
        this.initDashCoordinates();
        this.updateClipPath();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (!this.noDash) {
            this.drawDash(canvas);
            if (Build.VERSION.SDK_INT >= 26) {
                canvas.clipOutPath(this.clipPath);
            } else {
                canvas.clipPath(this.clipPath, Region.Op.XOR);
            }
        }
        super.onDraw(canvas);
    }

    private final void animateToFraction(float toFraction) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.fraction, toFraction});
        boolean bl = false;
        boolean bl2 = false;
        ValueAnimator $this$apply = valueAnimator;
        boolean bl3 = false;
        $this$apply.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ SwitchIconView this$0;
            {
                this.this$0 = switchIconView;
            }

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                SwitchIconView.access$setFraction(this.this$0, ((Float)object).floatValue());
            }
        });
        $this$apply.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        $this$apply.setDuration(this.animationDuration);
        $this$apply.start();
    }

    private final void setFraction(float fraction) {
        this.fraction = fraction;
        this.updateColor(fraction);
        this.updateAlpha(fraction);
        this.updateClipPath();
        this.postInvalidateOnAnimationCompat();
    }

    private final void initDashCoordinates() {
        float delta1 = 1.5f * SIN_45 * (float)this.dashThickness;
        float delta2 = 0.5f * SIN_45 * (float)this.dashThickness;
        this.dashStart.x = (int)((float)this.dashXStart + delta2);
        this.dashStart.y = this.dashYStart + (int)delta1;
        this.dashEnd.x = (int)((float)(this.dashXStart + this.dashLengthXProjection) - delta1);
        this.dashEnd.y = (int)((float)(this.dashYStart + this.dashLengthYProjection) - delta2);
    }

    private final void updateClipPath() {
        float delta = (float)this.dashThickness / SIN_45;
        Path path = this.clipPath;
        boolean bl = false;
        boolean bl2 = false;
        Path $this$apply = path;
        boolean bl3 = false;
        $this$apply.reset();
        $this$apply.moveTo((float)this.dashXStart, (float)this.dashYStart + delta);
        $this$apply.lineTo((float)this.dashXStart + delta, (float)this.dashYStart);
        $this$apply.lineTo((float)this.dashXStart + (float)this.dashLengthXProjection * this.fraction, (float)this.dashYStart + (float)this.dashLengthYProjection * this.fraction - delta);
        $this$apply.lineTo((float)this.dashXStart + (float)this.dashLengthXProjection * this.fraction - delta, (float)this.dashYStart + (float)this.dashLengthYProjection * this.fraction);
    }

    private final void drawDash(Canvas canvas) {
        float x = this.fraction * (float)(this.dashEnd.x - this.dashStart.x) + (float)this.dashStart.x;
        float y = this.fraction * (float)(this.dashEnd.y - this.dashStart.y) + (float)this.dashStart.y;
        canvas.drawLine((float)this.dashStart.x, (float)this.dashStart.y, x, y, this.dashPaint);
    }

    private final void updateColor(float fraction) {
        if (this.iconTintColor != this.disabledStateColor) {
            Object object = this.colorEvaluator.evaluate(fraction, (Object)this.iconTintColor, (Object)this.disabledStateColor);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
            }
            int color = (Integer)object;
            this.updateImageColor(color);
            this.dashPaint.setColor(color);
        }
    }

    private final void updateAlpha(float fraction) {
        int alpha = (int)((this.disabledStateAlpha + (1.0f - fraction) * (1.0f - this.disabledStateAlpha)) * (float)255);
        this.updateImageAlpha(alpha);
        this.dashPaint.setAlpha(alpha);
    }

    private final void updateImageColor(int color) {
        this.colorFilter = new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN);
        this.setColorFilter((ColorFilter)this.colorFilter);
    }

    private final void updateImageAlpha(int alpha) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setImageAlpha(alpha);
        } else {
            this.setAlpha(alpha);
        }
    }

    private final void postInvalidateOnAnimationCompat() {
        long fakeFrameTime = 10L;
        if (Build.VERSION.SDK_INT > 15) {
            this.postInvalidateOnAnimation();
        } else {
            this.postInvalidateDelayed(fakeFrameTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public SwitchIconView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.colorEvaluator = new ArgbEvaluator();
        this.clipPath = new Path();
        this.dashStart = new Point();
        this.dashEnd = new Point();
        Paint paint2 = new Paint(1);
        SwitchIconView switchIconView = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint2;
        boolean bl3 = false;
        $this$apply.setStyle(Paint.Style.STROKE);
        switchIconView.dashPaint = paint = paint2;
        this.setLayerType(1, null);
        paint2 = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SwitchIconView, 0, 0);
        bl = false;
        bl2 = false;
        $this$apply = paint2;
        boolean bl4 = false;
        try {
            this.iconTintColor = $this$apply.getColor(R.styleable.SwitchIconView_si_tint_color, -16777216);
            this.animationDuration = $this$apply.getInteger(R.styleable.SwitchIconView_si_animation_duration, 300);
            this.disabledStateAlpha = $this$apply.getFloat(R.styleable.SwitchIconView_si_disabled_alpha, 0.5f);
            this.disabledStateColor = $this$apply.getColor(R.styleable.SwitchIconView_si_disabled_color, this.iconTintColor);
            this.isIconEnabled = $this$apply.getBoolean(R.styleable.SwitchIconView_si_enabled, true);
            this.noDash = $this$apply.getBoolean(R.styleable.SwitchIconView_si_no_dash, false);
        }
        finally {
            $this$apply.recycle();
        }
        if (this.disabledStateAlpha < 0.0f || this.disabledStateAlpha > 1.0f) {
            throw (Throwable)new IllegalArgumentException("Wrong value for si_disabled_alpha [" + this.disabledStateAlpha + "]. " + "Must be value from range [0, 1]");
        }
        this.colorFilter = new PorterDuffColorFilter(this.iconTintColor, PorterDuff.Mode.SRC_IN);
        this.setColorFilter((ColorFilter)this.colorFilter);
        this.dashXStart = this.getPaddingLeft();
        this.dashYStart = this.getPaddingTop();
        this.dashPaint.setColor(this.iconTintColor);
        this.initDashCoordinates();
        this.setFraction(this.isIconEnabled ? 0.0f : 1.0f);
    }

    @JvmOverloads
    public /* synthetic */ SwitchIconView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public SwitchIconView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SwitchIconView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        SIN_45 = (float)Math.sin(Math.toRadians(45.0));
    }

    public static final /* synthetic */ void access$setFraction(SwitchIconView $this, float fraction) {
        $this.setFraction(fraction);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/github/zagum/switchicon/SwitchIconView$SwitchIconSavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "(Landroid/os/Parcelable;)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "iconEnabled", "", "getIconEnabled", "()Z", "setIconEnabled", "(Z)V", "writeToParcel", "", "out", "flags", "", "Companion", "switchicon_release"})
    public static final class SwitchIconSavedState
    extends View.BaseSavedState {
        private boolean iconEnabled;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<SwitchIconSavedState> CREATOR;
        public static final Companion Companion;

        public final boolean getIconEnabled() {
            return this.iconEnabled;
        }

        public final void setIconEnabled(boolean bl) {
            this.iconEnabled = bl;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            super.writeToParcel(out, flags);
            out.writeInt(this.iconEnabled ? 1 : 0);
        }

        public SwitchIconSavedState(@NotNull Parcelable superState) {
            Intrinsics.checkParameterIsNotNull((Object)superState, (String)"superState");
            super(superState);
        }

        private SwitchIconSavedState(Parcel parcel) {
            super(parcel);
            int enabled = parcel.readInt();
            this.iconEnabled = enabled == 1;
        }

        static {
            Companion = new Companion(null);
            CREATOR = (Parcelable.Creator)new Parcelable.Creator<SwitchIconSavedState>(){

                @NotNull
                public SwitchIconSavedState createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
                    return new SwitchIconSavedState(parcel, null);
                }

                @NotNull
                public SwitchIconSavedState[] newArray(int size) {
                    return new SwitchIconSavedState[size];
                }
            };
        }

        public /* synthetic */ SwitchIconSavedState(Parcel parcel, DefaultConstructorMarker $constructor_marker) {
            this(parcel);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/zagum/switchicon/SwitchIconView$SwitchIconSavedState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/github/zagum/switchicon/SwitchIconView$SwitchIconSavedState;", "switchicon_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/zagum/switchicon/SwitchIconView$Companion;", "", "()V", "DASH_THICKNESS_PART", "", "DEFAULT_ANIMATION_DURATION", "", "DEFAULT_DISABLED_ALPHA", "SIN_45", "switchicon_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

