/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuweiguocn.library.greendao;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.StandardDatabase;
import org.greenrobot.greendao.internal.DaoConfig;

public final class MigrationHelper {
    public static boolean DEBUG = false;
    private static String TAG = "MigrationHelper";

    public static void migrate(SQLiteDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        StandardDatabase database = new StandardDatabase(db);
        if (DEBUG) {
            Log.d((String)TAG, (String)("\u3010Database Version\u3011" + db.getVersion()));
            Log.d((String)TAG, (String)"\u3010Generate temp table\u3011start");
        }
        MigrationHelper.generateTempTables((Database)database, daoClasses);
        if (DEBUG) {
            Log.d((String)TAG, (String)"\u3010Generate temp table\u3011complete");
        }
        MigrationHelper.dropAllTables((Database)database, true, daoClasses);
        MigrationHelper.createAllTables((Database)database, false, daoClasses);
        if (DEBUG) {
            Log.d((String)TAG, (String)"\u3010Restore data\u3011start");
        }
        MigrationHelper.restoreData((Database)database, daoClasses);
        if (DEBUG) {
            Log.d((String)TAG, (String)"\u3010Restore data\u3011complete");
        }
    }

    private static void generateTempTables(Database db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        for (int i = 0; i < daoClasses.length; ++i) {
            String tempTableName = null;
            try {
                DaoConfig daoConfig = new DaoConfig(db, daoClasses[i]);
                String tableName = daoConfig.tablename;
                tempTableName = daoConfig.tablename.concat("_TEMP");
                StringBuilder dropTableStringBuilder = new StringBuilder();
                dropTableStringBuilder.append("DROP TABLE IF EXISTS ").append(tempTableName).append(";");
                db.execSQL(dropTableStringBuilder.toString());
                StringBuilder insertTableStringBuilder = new StringBuilder();
                insertTableStringBuilder.append("CREATE TEMPORARY TABLE ").append(tempTableName);
                insertTableStringBuilder.append(" AS SELECT * FROM ").append(tableName).append(";");
                db.execSQL(insertTableStringBuilder.toString());
                if (!DEBUG) continue;
                Log.d((String)TAG, (String)("\u3010Table\u3011" + tableName + "\n ---Columns-->" + MigrationHelper.getColumnsStr(daoConfig)));
                Log.d((String)TAG, (String)("\u3010Generate temp table\u3011" + tempTableName));
                continue;
            }
            catch (SQLException e) {
                Log.e((String)TAG, (String)("\u3010Failed to generate temp table\u3011" + tempTableName), (Throwable)e);
            }
        }
    }

    private static String getColumnsStr(DaoConfig daoConfig) {
        if (daoConfig == null) {
            return "no columns";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < daoConfig.allColumns.length; ++i) {
            builder.append(daoConfig.allColumns[i]);
            builder.append(",");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private static void dropAllTables(Database db, boolean ifExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        MigrationHelper.reflectMethod(db, "dropTable", ifExists, daoClasses);
        if (DEBUG) {
            Log.d((String)TAG, (String)"\u3010Drop all table\u3011");
        }
    }

    private static void createAllTables(Database db, boolean ifNotExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        MigrationHelper.reflectMethod(db, "createTable", ifNotExists, daoClasses);
        if (DEBUG) {
            Log.d((String)TAG, (String)"\u3010Create all table\u3011");
        }
    }

    private static void reflectMethod(Database db, String methodName, boolean isExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        if (daoClasses.length < 1) {
            return;
        }
        try {
            for (Class<AbstractDao<?, ?>> clazz : daoClasses) {
                Method method = clazz.getDeclaredMethod(methodName, Database.class, Boolean.TYPE);
                method.invoke(null, db, isExists);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static void restoreData(Database db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        for (int i = 0; i < daoClasses.length; ++i) {
            String tempTableName = null;
            try {
                DaoConfig daoConfig = new DaoConfig(db, daoClasses[i]);
                String tableName = daoConfig.tablename;
                tempTableName = daoConfig.tablename.concat("_TEMP");
                List<String> columns = MigrationHelper.getColumns(db, tempTableName);
                ArrayList<String> properties = new ArrayList<String>(columns.size());
                for (int j = 0; j < daoConfig.properties.length; ++j) {
                    String columnName = daoConfig.properties[j].columnName;
                    if (!columns.contains(columnName)) continue;
                    properties.add(columnName);
                }
                if (properties.size() > 0) {
                    String columnSQL = TextUtils.join((CharSequence)",", properties);
                    StringBuilder insertTableStringBuilder = new StringBuilder();
                    insertTableStringBuilder.append("INSERT INTO ").append(tableName).append(" (");
                    insertTableStringBuilder.append(columnSQL);
                    insertTableStringBuilder.append(") SELECT ");
                    insertTableStringBuilder.append(columnSQL);
                    insertTableStringBuilder.append(" FROM ").append(tempTableName).append(";");
                    db.execSQL(insertTableStringBuilder.toString());
                    if (DEBUG) {
                        Log.d((String)TAG, (String)("\u3010Restore data\u3011 to " + tableName));
                    }
                }
                StringBuilder dropTableStringBuilder = new StringBuilder();
                dropTableStringBuilder.append("DROP TABLE ").append(tempTableName);
                db.execSQL(dropTableStringBuilder.toString());
                if (!DEBUG) continue;
                Log.d((String)TAG, (String)("\u3010Drop temp table\u3011" + tempTableName));
                continue;
            }
            catch (SQLException e) {
                Log.e((String)TAG, (String)("\u3010Failed to restore data from temp table (probably new table)\u3011" + tempTableName), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getColumns(Database db, String tableName) {
        List<String> columns;
        block9: {
            columns = null;
            Cursor cursor = null;
            try {
                cursor = db.rawQuery("SELECT * FROM " + tableName + " limit 0", null);
                if (null != cursor && cursor.getColumnCount() > 0) {
                    columns = Arrays.asList(cursor.getColumnNames());
                }
                if (cursor == null) break block9;
            }
            catch (Exception e) {
                block10: {
                    try {
                        e.printStackTrace();
                        if (cursor == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (cursor != null) {
                            cursor.close();
                        }
                        if (null == columns) {
                            columns = new ArrayList<String>();
                        }
                        throw throwable;
                    }
                    cursor.close();
                }
                if (null == columns) {
                    columns = new ArrayList();
                }
            }
            cursor.close();
        }
        if (null == columns) {
            columns = new ArrayList();
        }
        return columns;
    }
}

