/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuweiguocn.library.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.internal.DaoConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class MigrationHelper {
    public static boolean DEBUG = false;
    private static String TAG = "MigrationHelper";

    public static void migrate(SQLiteDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        MigrationHelper.generateTempTables(db, daoClasses);
        MigrationHelper.dropAllTables(db, true, daoClasses);
        MigrationHelper.createAllTables(db, false, daoClasses);
        MigrationHelper.restoreData(db, daoClasses);
    }

    private static void generateTempTables(SQLiteDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        for (int i = 0; i < daoClasses.length; ++i) {
            DaoConfig daoConfig = new DaoConfig(db, daoClasses[i]);
            String tableName = daoConfig.tablename;
            String tempTableName = daoConfig.tablename.concat("_TEMP");
            StringBuilder insertTableStringBuilder = new StringBuilder();
            insertTableStringBuilder.append("CREATE TEMPORARY TABLE ").append(tempTableName);
            insertTableStringBuilder.append(" AS SELECT * FROM ").append(tableName).append(";");
            db.execSQL(insertTableStringBuilder.toString());
            if (!DEBUG) continue;
            Log.d((String)TAG, (String)("the table " + tableName + " columns are " + MigrationHelper.getColumnsStr(daoConfig)));
            Log.d((String)TAG, (String)("generate temp table " + tempTableName));
        }
    }

    private static String getColumnsStr(DaoConfig daoConfig) {
        if (daoConfig == null) {
            return "no columns";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < daoConfig.allColumns.length; ++i) {
            builder.append(daoConfig.allColumns[i]);
            builder.append(",");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private static void dropAllTables(SQLiteDatabase db, boolean ifExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        MigrationHelper.reflectMethod(db, "dropTable", ifExists, daoClasses);
        if (DEBUG) {
            Log.d((String)TAG, (String)"drop all table");
        }
    }

    private static void createAllTables(SQLiteDatabase db, boolean ifNotExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        MigrationHelper.reflectMethod(db, "createTable", ifNotExists, daoClasses);
        if (DEBUG) {
            Log.d((String)TAG, (String)"create all table");
        }
    }

    private static void reflectMethod(SQLiteDatabase db, String methodName, boolean isExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        if (daoClasses.length < 1) {
            return;
        }
        try {
            for (Class<AbstractDao<?, ?>> clazz : daoClasses) {
                Method method = clazz.getDeclaredMethod(methodName, SQLiteDatabase.class, Boolean.TYPE);
                method.invoke(null, db, isExists);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static void restoreData(SQLiteDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        for (int i = 0; i < daoClasses.length; ++i) {
            DaoConfig daoConfig = new DaoConfig(db, daoClasses[i]);
            String tableName = daoConfig.tablename;
            String tempTableName = daoConfig.tablename.concat("_TEMP");
            List<String> columns = MigrationHelper.getColumns(db, tempTableName);
            ArrayList<String> properties = new ArrayList<String>(columns.size());
            for (int j = 0; j < daoConfig.properties.length; ++j) {
                String columnName = daoConfig.properties[j].columnName;
                if (!columns.contains(columnName)) continue;
                properties.add(columnName);
            }
            if (properties.size() > 0) {
                String columnSQL = TextUtils.join((CharSequence)",", properties);
                StringBuilder insertTableStringBuilder = new StringBuilder();
                insertTableStringBuilder.append("INSERT INTO ").append(tableName).append(" (");
                insertTableStringBuilder.append(columnSQL);
                insertTableStringBuilder.append(") SELECT ");
                insertTableStringBuilder.append(columnSQL);
                insertTableStringBuilder.append(" FROM ").append(tempTableName).append(";");
                db.execSQL(insertTableStringBuilder.toString());
                if (DEBUG) {
                    Log.d((String)TAG, (String)("restore data to " + tableName));
                    Log.d((String)TAG, (String)("the table " + tableName + " columns are " + MigrationHelper.getColumnsStr(daoConfig)));
                }
            }
            StringBuilder dropTableStringBuilder = new StringBuilder();
            dropTableStringBuilder.append("DROP TABLE ").append(tempTableName);
            db.execSQL(dropTableStringBuilder.toString());
            if (!DEBUG) continue;
            Log.d((String)TAG, (String)("drop temp table " + tempTableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getColumns(SQLiteDatabase db, String tableName) {
        List<String> columns;
        block9: {
            columns = null;
            Cursor cursor = null;
            try {
                cursor = db.rawQuery("SELECT * FROM " + tableName + " limit 0", null);
                if (null != cursor && cursor.getColumnCount() > 0) {
                    columns = Arrays.asList(cursor.getColumnNames());
                }
                if (cursor == null) break block9;
            }
            catch (Exception e) {
                block10: {
                    try {
                        e.printStackTrace();
                        if (cursor == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (cursor != null) {
                            cursor.close();
                        }
                        if (null == columns) {
                            columns = new ArrayList<String>();
                        }
                        throw throwable;
                    }
                    cursor.close();
                }
                if (null == columns) {
                    columns = new ArrayList();
                }
            }
            cursor.close();
        }
        if (null == columns) {
            columns = new ArrayList();
        }
        return columns;
    }
}

