/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuweiguocn.library.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.internal.DaoConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class MigrationHelper {
    public static void migrate(SQLiteDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        MigrationHelper.generateTempTables(db, daoClasses);
        MigrationHelper.dropAllTables(db, true, daoClasses);
        MigrationHelper.createAllTables(db, false, daoClasses);
        MigrationHelper.restoreData(db, daoClasses);
    }

    private static void generateTempTables(SQLiteDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        for (int i = 0; i < daoClasses.length; ++i) {
            DaoConfig daoConfig = new DaoConfig(db, daoClasses[i]);
            String tableName = daoConfig.tablename;
            String tempTableName = daoConfig.tablename.concat("_TEMP");
            StringBuilder insertTableStringBuilder = new StringBuilder();
            insertTableStringBuilder.append("CREATE TEMPORARY TABLE ").append(tempTableName);
            insertTableStringBuilder.append(" AS SELECT * FROM ").append(tableName).append(";");
            db.execSQL(insertTableStringBuilder.toString());
        }
    }

    private static void dropAllTables(SQLiteDatabase db, boolean ifExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        MigrationHelper.reflectMethod(db, "dropTable", ifExists, daoClasses);
    }

    private static void createAllTables(SQLiteDatabase db, boolean ifNotExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        MigrationHelper.reflectMethod(db, "createTable", ifNotExists, daoClasses);
    }

    private static void reflectMethod(SQLiteDatabase db, String methodName, boolean isExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        if (daoClasses.length < 1) {
            return;
        }
        try {
            for (Class<AbstractDao<?, ?>> clazz : daoClasses) {
                Method method = clazz.getDeclaredMethod(methodName, SQLiteDatabase.class, Boolean.TYPE);
                method.invoke(null, db, isExists);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static void restoreData(SQLiteDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        for (int i = 0; i < daoClasses.length; ++i) {
            DaoConfig daoConfig = new DaoConfig(db, daoClasses[i]);
            String tableName = daoConfig.tablename;
            String tempTableName = daoConfig.tablename.concat("_TEMP");
            List<String> columns = MigrationHelper.getColumns(db, tempTableName);
            ArrayList<String> properties = new ArrayList<String>(columns.size());
            for (int j = 0; j < daoConfig.properties.length; ++j) {
                String columnName = daoConfig.properties[j].columnName;
                if (!columns.contains(columnName)) continue;
                properties.add(columnName);
            }
            if (properties.size() > 0) {
                String columnSQL = TextUtils.join((CharSequence)",", properties);
                StringBuilder insertTableStringBuilder = new StringBuilder();
                insertTableStringBuilder.append("INSERT INTO ").append(tableName).append(" (");
                insertTableStringBuilder.append(columnSQL);
                insertTableStringBuilder.append(") SELECT ");
                insertTableStringBuilder.append(columnSQL);
                insertTableStringBuilder.append(" FROM ").append(tempTableName).append(";");
                db.execSQL(insertTableStringBuilder.toString());
            }
            StringBuilder dropTableStringBuilder = new StringBuilder();
            dropTableStringBuilder.append("DROP TABLE ").append(tempTableName);
            db.execSQL(dropTableStringBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getColumns(SQLiteDatabase db, String tableName) {
        List<String> columns;
        block9: {
            columns = null;
            Cursor cursor = null;
            try {
                cursor = db.rawQuery("SELECT * FROM " + tableName + " limit 0", null);
                if (null != cursor && cursor.getColumnCount() > 0) {
                    columns = Arrays.asList(cursor.getColumnNames());
                }
                if (cursor == null) break block9;
            }
            catch (Exception e) {
                block10: {
                    try {
                        e.printStackTrace();
                        if (cursor == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (cursor != null) {
                            cursor.close();
                        }
                        if (null == columns) {
                            columns = new ArrayList<String>();
                        }
                        throw throwable;
                    }
                    cursor.close();
                }
                if (null == columns) {
                    columns = new ArrayList();
                }
            }
            cursor.close();
        }
        if (null == columns) {
            columns = new ArrayList();
        }
        return columns;
    }
}

