/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuweiguocn.library.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.internal.DaoConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class MigrationHelper {
    private static final String CONVERSION_CLASS_NOT_FOUND_EXCEPTION = "MIGRATION HELPER - CLASS DOESN'T MATCH WITH THE CURRENT PARAMETERS";
    private static MigrationHelper instance;

    public static MigrationHelper getInstance() {
        if (instance == null) {
            instance = new MigrationHelper();
        }
        return instance;
    }

    public void migrate(SQLiteDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        this.generateTempTables(db, daoClasses);
        this.dropAllTables(db, true, daoClasses);
        this.createAllTables(db, false, daoClasses);
        this.restoreData(db, daoClasses);
    }

    private void generateTempTables(SQLiteDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        for (int i = 0; i < daoClasses.length; ++i) {
            DaoConfig daoConfig = new DaoConfig(db, daoClasses[i]);
            String divider = "";
            String tableName = daoConfig.tablename;
            String tempTableName = daoConfig.tablename.concat("_TEMP");
            ArrayList<String> properties = new ArrayList<String>();
            StringBuilder createTableStringBuilder = new StringBuilder();
            createTableStringBuilder.append("CREATE TABLE ").append(tempTableName).append(" (");
            for (int j = 0; j < daoConfig.properties.length; ++j) {
                String columnName = daoConfig.properties[j].columnName;
                if (!MigrationHelper.getColumns(db, tableName).contains(columnName)) continue;
                properties.add(columnName);
                String type = null;
                try {
                    type = this.getTypeByClass(daoConfig.properties[j].type);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                createTableStringBuilder.append(divider).append(columnName).append(" ").append(type);
                if (daoConfig.properties[j].primaryKey) {
                    createTableStringBuilder.append(" PRIMARY KEY");
                }
                divider = ",";
            }
            createTableStringBuilder.append(");");
            if (createTableStringBuilder.toString().contains(" ();")) continue;
            db.execSQL(createTableStringBuilder.toString());
            StringBuilder insertTableStringBuilder = new StringBuilder();
            insertTableStringBuilder.append("INSERT INTO ").append(tempTableName).append(" (");
            insertTableStringBuilder.append(TextUtils.join((CharSequence)",", properties));
            insertTableStringBuilder.append(") SELECT ");
            insertTableStringBuilder.append(TextUtils.join((CharSequence)",", properties));
            insertTableStringBuilder.append(" FROM ").append(tableName).append(";");
            db.execSQL(insertTableStringBuilder.toString());
        }
    }

    private void dropAllTables(SQLiteDatabase db, boolean ifExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        for (int i = 0; i < daoClasses.length; ++i) {
            DaoConfig daoConfig = new DaoConfig(db, daoClasses[i]);
            String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"" + daoConfig.tablename + "\"";
            db.execSQL(sql);
        }
    }

    private void createAllTables(SQLiteDatabase db, boolean ifNotExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        for (int i = 0; i < daoClasses.length; ++i) {
            DaoConfig daoConfig = new DaoConfig(db, daoClasses[i]);
            String divider = "";
            String tableName = daoConfig.tablename;
            ArrayList<String> properties = new ArrayList<String>();
            StringBuilder createTableStringBuilder = new StringBuilder();
            String constraint = ifNotExists ? "IF NOT EXISTS " : "";
            createTableStringBuilder.append("CREATE TABLE ").append(constraint).append(tableName).append(" (");
            for (int j = 0; j < daoConfig.properties.length; ++j) {
                String columnName = daoConfig.properties[j].columnName;
                properties.add(columnName);
                String type = null;
                try {
                    type = this.getTypeByClass(daoConfig.properties[j].type);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                createTableStringBuilder.append(divider).append(columnName).append(" ").append(type);
                if (daoConfig.properties[j].primaryKey) {
                    createTableStringBuilder.append(" PRIMARY KEY");
                }
                divider = ",";
            }
            createTableStringBuilder.append(");");
            db.execSQL(createTableStringBuilder.toString());
        }
    }

    private void restoreData(SQLiteDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        for (int i = 0; i < daoClasses.length; ++i) {
            DaoConfig daoConfig = new DaoConfig(db, daoClasses[i]);
            String tableName = daoConfig.tablename;
            String tempTableName = daoConfig.tablename.concat("_TEMP");
            ArrayList<String> properties = new ArrayList<String>();
            for (int j = 0; j < daoConfig.properties.length; ++j) {
                String columnName = daoConfig.properties[j].columnName;
                if (!MigrationHelper.getColumns(db, tempTableName).contains(columnName)) continue;
                properties.add(columnName);
            }
            StringBuilder insertTableStringBuilder = new StringBuilder();
            insertTableStringBuilder.append("INSERT INTO ").append(tableName).append(" (");
            insertTableStringBuilder.append(TextUtils.join((CharSequence)",", properties));
            insertTableStringBuilder.append(") SELECT ");
            insertTableStringBuilder.append(TextUtils.join((CharSequence)",", properties));
            insertTableStringBuilder.append(" FROM ").append(tempTableName).append(";");
            StringBuilder dropTableStringBuilder = new StringBuilder();
            dropTableStringBuilder.append("DROP TABLE ").append(tempTableName);
            if (insertTableStringBuilder.toString().contains("()")) continue;
            db.execSQL(insertTableStringBuilder.toString());
            db.execSQL(dropTableStringBuilder.toString());
        }
    }

    private String getTypeByClass(Class<?> type) throws Exception {
        if (type.equals(String.class)) {
            return "TEXT";
        }
        if (type.equals(Long.class) || type.equals(Integer.class) || type.equals(Long.TYPE) || type.equals(Date.class)) {
            return "INTEGER";
        }
        if (type.equals(Boolean.class)) {
            return "BOOLEAN";
        }
        Exception exception = new Exception(CONVERSION_CLASS_NOT_FOUND_EXCEPTION.concat(" - Class: ").concat(type.toString()));
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getColumns(SQLiteDatabase db, String tableName) {
        ArrayList<String> columns = new ArrayList<String>();
        try (Cursor cursor = null;){
            cursor = db.rawQuery("SELECT * FROM " + tableName + " limit 1", null);
            if (cursor != null) {
                columns = new ArrayList<String>(Arrays.asList(cursor.getColumnNames()));
            }
        }
        return columns;
    }
}

