/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.WindowManager;
import com.budiyev.android.codescanner.AutoFocusMode;
import com.budiyev.android.codescanner.CodeScannerException;
import com.budiyev.android.codescanner.ErrorCallback;
import com.google.zxing.client.android.camera.CameraConfigurationUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class Utils {
    private static final float SQUARE_RATIO = 0.75f;
    private static final float PORTRAIT_WIDTH_RATIO = 0.75f;
    private static final float PORTRAIT_HEIGHT_RATIO = 0.75f;
    private static final float LANDSCAPE_WIDTH_RATIO = 1.4f;
    private static final float LANDSCAPE_HEIGHT_RATIO = 0.625f;
    private static final float MAX_DISTORTION = 0.5f;
    private static final int MIN_PREVIEW_PIXELS = 442368;

    private Utils() {
    }

    public static void optimizeParameters(@NonNull Camera.Parameters parameters) {
        CameraConfigurationUtils.setBestPreviewFPS((Camera.Parameters)parameters);
        CameraConfigurationUtils.setBarcodeSceneMode((Camera.Parameters)parameters);
        CameraConfigurationUtils.setVideoStabilization((Camera.Parameters)parameters);
        parameters.setPreviewFormat(17);
    }

    @NonNull
    public static Point findSuitablePreviewSize(@NonNull Camera.Parameters parameters, int frameWidth, int frameHeight) {
        Camera.Size defaultSize;
        List sizes = parameters.getSupportedPreviewSizes();
        if (sizes != null && !sizes.isEmpty()) {
            Collections.sort(sizes, new CameraSizeComparator());
            float frameRatio = (float)frameWidth / (float)frameHeight;
            for (Camera.Size size : sizes) {
                int width = size.width;
                int height = size.height;
                if (width * height < 442368 || !(Math.abs(frameRatio - (float)width / (float)height) <= 0.5f)) continue;
                return new Point(width, height);
            }
        }
        if ((defaultSize = parameters.getPreviewSize()) == null) {
            throw new CodeScannerException("Unable to configure camera preview size");
        }
        return new Point(defaultSize.width, defaultSize.height);
    }

    public static boolean disableAutoFocus(@NonNull Camera.Parameters parameters) {
        List focusModes = parameters.getSupportedFocusModes();
        if (focusModes == null || focusModes.isEmpty()) {
            return false;
        }
        String focusMode = parameters.getFocusMode();
        if (focusModes.contains("fixed")) {
            if ("fixed".equals(focusMode)) {
                return false;
            }
            parameters.setFocusMode("fixed");
            return true;
        }
        if (focusModes.contains("auto")) {
            if ("auto".equals(focusMode)) {
                return false;
            }
            parameters.setFocusMode("auto");
            return true;
        }
        return false;
    }

    public static boolean setAutoFocusMode(@NonNull Camera.Parameters parameters, AutoFocusMode autoFocusMode) {
        List focusModes = parameters.getSupportedFocusModes();
        if (focusModes == null || focusModes.isEmpty()) {
            return false;
        }
        if (autoFocusMode == AutoFocusMode.CONTINUOUS) {
            if ("continuous-picture".equals(parameters.getFocusMode())) {
                return false;
            }
            if (focusModes.contains("continuous-picture")) {
                parameters.setFocusMode("continuous-picture");
                return true;
            }
        }
        if ("auto".equals(parameters.getFocusMode())) {
            return false;
        }
        if (focusModes.contains("auto")) {
            parameters.setFocusMode("auto");
            return true;
        }
        return false;
    }

    public static boolean setFlashMode(@NonNull Camera.Parameters parameters, @NonNull String flashMode) {
        if (flashMode.equals(parameters.getFlashMode())) {
            return false;
        }
        List flashModes = parameters.getSupportedFlashModes();
        if (flashModes != null && flashModes.contains(flashMode)) {
            parameters.setFlashMode(flashMode);
            return true;
        }
        return false;
    }

    public static int getDisplayOrientation(@NonNull Context context, @NonNull Camera.CameraInfo cameraInfo) {
        int degrees;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager == null) {
            throw new CodeScannerException("Unable to access window manager");
        }
        int rotation = windowManager.getDefaultDisplay().getRotation();
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
                break;
            }
            default: {
                if (rotation % 90 == 0) {
                    degrees = (360 + rotation) % 360;
                    break;
                }
                throw new CodeScannerException("Invalid display rotation");
            }
        }
        return ((cameraInfo.facing == 1 ? 180 : 360) + cameraInfo.orientation - degrees) % 360;
    }

    public static boolean isPortrait(int orientation) {
        return orientation == 90 || orientation == 270;
    }

    public static boolean isLaidOut(@NonNull View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            return view.isLaidOut();
        }
        return view.getWidth() > 0 && view.getHeight() > 0;
    }

    @NonNull
    public static Point getFrameSize(int imageWidth, int imageHeight, int frameWidth, int frameHeight) {
        int imageRatioHeight;
        if (imageWidth == frameWidth && imageHeight == frameHeight) {
            return new Point(frameWidth, frameHeight);
        }
        int imageDivisor = Utils.greatestCommonDivisor(imageWidth, imageHeight);
        int imageRatioWidth = imageWidth / imageDivisor;
        int resultWidth = imageRatioWidth * frameHeight / (imageRatioHeight = imageHeight / imageDivisor);
        if (resultWidth < frameWidth) {
            return new Point(frameWidth, imageRatioHeight * frameWidth / imageRatioWidth);
        }
        return new Point(resultWidth, frameHeight);
    }

    @NonNull
    public static Rect getFrameRect(boolean squareFrame, int width, int height) {
        int frameHeight;
        int frameWidth;
        if (squareFrame) {
            frameHeight = frameWidth = Math.round((float)Math.min(width, height) * 0.75f);
        } else if (width >= height) {
            frameHeight = Math.round((float)height * 0.625f);
            frameWidth = Math.round(1.4f * (float)frameHeight);
        } else {
            frameWidth = Math.round((float)width * 0.75f);
            frameHeight = Math.round(0.75f * (float)frameWidth);
        }
        int left = (width - frameWidth) / 2;
        int top = (height - frameHeight) / 2;
        return new Rect(left, top, left + frameWidth, top + frameHeight);
    }

    @NonNull
    public static Rect getImageFrameRect(boolean squareFrame, int imageWidth, int imageHeight, int frameWidth, int frameHeight) {
        Point frameSize = Utils.getFrameSize(imageWidth, imageHeight, frameWidth, frameHeight);
        int wDiff = (frameSize.x - frameWidth) / 2;
        int hDiff = (frameSize.y - frameHeight) / 2;
        Rect frameRect = Utils.getFrameRect(squareFrame, frameWidth, frameHeight);
        frameRect.left += wDiff;
        frameRect.top += hDiff;
        frameRect.right += wDiff;
        frameRect.bottom += hDiff;
        float wRatio = (float)imageWidth / (float)frameSize.x;
        float hRatio = (float)imageHeight / (float)frameSize.y;
        frameRect.left = Math.round((float)frameRect.left * wRatio);
        frameRect.top = Math.round((float)frameRect.top * hRatio);
        frameRect.right = Math.round((float)frameRect.right * wRatio);
        frameRect.bottom = Math.round((float)frameRect.bottom * hRatio);
        return frameRect;
    }

    public static byte[] rotateNV21(byte[] yuv, int width, int height, int rotation) {
        if (rotation == 0 || rotation == 360) {
            return yuv;
        }
        if (rotation % 90 != 0 || rotation < 0 || rotation > 270) {
            throw new IllegalArgumentException("0 <= rotation < 360, rotation % 90 == 0");
        }
        byte[] output = new byte[yuv.length];
        int frameSize = width * height;
        boolean swap = rotation % 180 != 0;
        boolean flipX = rotation % 270 != 0;
        boolean flipY = rotation >= 180;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int yIn = j * width + i;
                int uIn = frameSize + (j >> 1) * width + (i & 0xFFFFFFFE);
                int vIn = uIn + 1;
                int wOut = swap ? height : width;
                int hOut = swap ? width : height;
                int iSwapped = swap ? j : i;
                int jSwapped = swap ? i : j;
                int iOut = flipX ? wOut - iSwapped - 1 : iSwapped;
                int jOut = flipY ? hOut - jSwapped - 1 : jSwapped;
                int yOut = jOut * wOut + iOut;
                int uOut = frameSize + (jOut >> 1) * wOut + (iOut & 0xFFFFFFFE);
                int vOut = uOut + 1;
                output[yOut] = (byte)(0xFF & yuv[yIn]);
                output[uOut] = (byte)(0xFF & yuv[uIn]);
                output[vOut] = (byte)(0xFF & yuv[vIn]);
            }
        }
        return output;
    }

    private static int greatestCommonDivisor(int a, int b) {
        while (a > 0 && b > 0) {
            if (a > b) {
                a %= b;
                continue;
            }
            b %= a;
        }
        return a + b;
    }

    private static final class CameraSizeComparator
    implements Comparator<Camera.Size> {
        private CameraSizeComparator() {
        }

        @Override
        public int compare(@NonNull Camera.Size a, @NonNull Camera.Size b) {
            int bPixels = b.height * b.width;
            int aPixels = a.height * a.width;
            if (bPixels < aPixels) {
                return -1;
            }
            if (bPixels > aPixels) {
                return 1;
            }
            return 0;
        }
    }

    public static final class SuppressErrorCallback
    implements ErrorCallback {
        @Override
        public void onError(@NonNull Exception error) {
        }
    }
}

