/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.github.yulichang.adapter.AdapterHelper;
import com.github.yulichang.toolkit.TableHelper;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class LogicInfoUtils
implements Constants {
    private static final Map<Class<?>, Map<String, String>> LOGIC_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, String>> LOGIC_CACHE_NO_AND = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, String>> LOGIC_CACHE_INVERT = new ConcurrentHashMap();

    public static String getLogicInfo(Integer tableIndex, Class<?> clazz, boolean hasAlias, String alias) {
        Map absent = LOGIC_CACHE.computeIfAbsent(clazz, k -> new ConcurrentHashMap());
        return absent.computeIfAbsent(hasAlias ? alias : alias + tableIndex, key -> LogicInfoUtils.getLogicStr(key, clazz, true, false));
    }

    public static String getLogicInfoApt(Class<?> clazz, String alias) {
        Map absent = LOGIC_CACHE.computeIfAbsent(clazz, k -> new ConcurrentHashMap());
        return absent.computeIfAbsent(alias, key -> LogicInfoUtils.getLogicStr(key, clazz, true, false));
    }

    public static String getLogicInfoNoAnd(Integer tableIndex, Class<?> clazz, boolean hasAlias, String alias) {
        Map absent = LOGIC_CACHE_NO_AND.computeIfAbsent(clazz, k -> new ConcurrentHashMap());
        return absent.computeIfAbsent(hasAlias ? alias : alias + tableIndex, key -> LogicInfoUtils.getLogicStr(key, clazz, false, false));
    }

    public static String getLogicInfoInvert(Integer tableIndex, Class<?> clazz, boolean hasAlias, String alias) {
        Map absent = LOGIC_CACHE_INVERT.computeIfAbsent(clazz, k -> new ConcurrentHashMap());
        return absent.computeIfAbsent(hasAlias ? alias : alias + tableIndex, key -> LogicInfoUtils.getLogicStr(key, clazz, false, true));
    }

    private static String getLogicStr(String prefix, Class<?> clazz, boolean and, boolean invert) {
        String logicStr;
        TableInfo tableInfo = TableHelper.getAssert(clazz);
        TableFieldInfo logicField = AdapterHelper.getAdapter().mpjGetLogicField(tableInfo);
        if (AdapterHelper.getAdapter().mpjHasLogic(tableInfo) && Objects.nonNull(logicField)) {
            String notDeleteValue = logicField.getLogicNotDeleteValue();
            String deleteValue = logicField.getLogicDeleteValue();
            logicStr = "null".equalsIgnoreCase(notDeleteValue) ? (and ? " AND " : "") + prefix + "." + logicField.getColumn() + (invert ? " IS NOT NULL" : " IS NULL") : (and ? " AND " : "") + prefix + "." + logicField.getColumn() + "=" + String.format(logicField.isCharSequence() ? "'%s'" : "%s", invert ? deleteValue : notDeleteValue);
        } else {
            logicStr = "";
        }
        return logicStr;
    }
}

