/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.extension.apt;

import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.extension.apt.AptAbstractWrapper;
import com.github.yulichang.extension.apt.interfaces.Query;
import com.github.yulichang.extension.apt.interfaces.QueryLabel;
import com.github.yulichang.extension.apt.matedata.BaseColumn;
import com.github.yulichang.extension.apt.matedata.Column;
import com.github.yulichang.extension.apt.toolkit.AptWrapperUtils;
import com.github.yulichang.extension.apt.toolkit.AptWrappers;
import com.github.yulichang.toolkit.LambdaUtils;
import com.github.yulichang.toolkit.StrUtils;
import com.github.yulichang.toolkit.TableMap;
import com.github.yulichang.toolkit.support.ColumnCache;
import com.github.yulichang.wrapper.enums.IfExistsSqlKeyWordEnum;
import com.github.yulichang.wrapper.interfaces.Chain;
import com.github.yulichang.wrapper.interfaces.MBiPredicate;
import com.github.yulichang.wrapper.interfaces.MFunction;
import com.github.yulichang.wrapper.interfaces.SelectWrapper;
import com.github.yulichang.wrapper.resultmap.Label;
import com.github.yulichang.wrapper.segments.AptConsumer;
import com.github.yulichang.wrapper.segments.Select;
import com.github.yulichang.wrapper.segments.SelectApt;
import com.github.yulichang.wrapper.segments.SelectCache;
import com.github.yulichang.wrapper.segments.SelectSub;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;

public class AptQueryWrapper<T>
extends AptAbstractWrapper<T, AptQueryWrapper<T>>
implements Query<AptQueryWrapper<T>>,
QueryLabel<AptQueryWrapper<T>>,
Chain<T>,
SelectWrapper<T, AptQueryWrapper<T>> {
    private SharedString sqlSelect = new SharedString();
    private boolean selectDistinct = false;
    private final List<Select> selectColumns = new ArrayList<Select>();
    private final List<Label<?>> resultMapMybatisLabel = new ArrayList();
    private SharedString unionSql;
    private AtomicInteger wrapperIndex;
    private Map<String, Wrapper<?>> wrapperMap;

    public AptQueryWrapper(BaseColumn<T> baseColumn) {
        super(baseColumn);
    }

    public AptQueryWrapper(BaseColumn<T> baseColumn, T entity) {
        super(baseColumn, entity);
    }

    protected AptQueryWrapper(T entity, BaseColumn<T> baseColumn, SharedString sqlSelect, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString paramAlias, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst, TableMap aptIndex, Integer index, String keyWord, Class<?> joinClass, String tableName, MBiPredicate<Object, IfExistsSqlKeyWordEnum> IfExists) {
        super(baseColumn);
        super.setEntity(entity);
        super.setEntityClass(baseColumn.getColumnClass());
        this.baseColumn = baseColumn;
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.sqlSelect = sqlSelect;
        this.paramAlias = paramAlias;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
        if (aptIndex != null) {
            this.aptIndex = aptIndex;
        }
        this.index = index;
        this.keyWord = keyWord;
        this.joinClass = joinClass;
        this.tableName = tableName;
        this.ifExists = IfExists;
    }

    public AptQueryWrapper<T> distinct() {
        this.selectDistinct = true;
        return (AptQueryWrapper)this.typedThis;
    }

    @Override
    public List<Select> getSelectColum() {
        return this.selectColumns;
    }

    @Override
    public void addLabel(Label<?> label, boolean isCollection) {
        if (isCollection) {
            this.resultMapCollection = true;
        }
        this.resultMap = true;
        this.resultMapMybatisLabel.add(label);
    }

    @Override
    public AptQueryWrapper<T> getChildren() {
        return (AptQueryWrapper)this.typedThis;
    }

    @Override
    public final AptQueryWrapper<T> select(Column ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            for (Column s : columns) {
                Map<String, SelectCache> cacheMap = ColumnCache.getMapField(s.getClazz());
                SelectCache cache = cacheMap.get(s.getProperty());
                this.getSelectColum().add(new SelectApt(cache, s));
            }
        }
        return (AptQueryWrapper)this.typedThis;
    }

    @Override
    public final <E> AptQueryWrapper<T> selectAll(BaseColumn<E> baseColumn, Column ... exclude) {
        return (AptQueryWrapper)Query.super.selectAll(baseColumn, exclude);
    }

    @Override
    public AptQueryWrapper<T> selectAll() {
        Assert.notNull(this.getEntityClass(), (String)"\u4f7f\u7528 AptWrappers.query(clazz) \u6216\u8005 new JoinAptQueryWrapper<>(BaseColum)", (Object[])new Object[0]);
        return (AptQueryWrapper)this.selectAll(this.getBaseColumn());
    }

    @Override
    public AptQueryWrapper<T> selectFunc(String sql, MFunction<AptConsumer> column, String alias) {
        AptConsumer apply = column.apply(new AptConsumer());
        String formatSql = ArrayUtils.isEmpty((Object[])apply.getValues()) ? sql : this.formatSqlMaybeWithParam(sql, apply.getValues());
        this.getSelectColum().add(new SelectApt(apply.getColumns(), () -> formatSql, alias));
        return (AptQueryWrapper)this.typedThis;
    }

    public <E, F> AptQueryWrapper<T> selectSub(BaseColumn<E> baseColumn, Consumer<AptQueryWrapper<E>> consumer, SFunction<F, ?> alias) {
        return this.selectSub(baseColumn, consumer, LambdaUtils.getName(alias));
    }

    public <E, F> AptQueryWrapper<T> selectSub(BaseColumn<E> baseColumn, Consumer<AptQueryWrapper<E>> consumer, String alias) {
        AptQueryWrapper wrapper = new AptQueryWrapper<E>(null, baseColumn, SharedString.emptyString(), this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), new SharedString(this.paramAlias.getStringValue()), SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString(), null, null, null, null, null, this.ifExists){};
        wrapper.aptIndex.setParent(this.aptIndex);
        if (null == baseColumn.getAlias()) {
            wrapper.alias = ConfigProperties.subQueryAlias;
            wrapper.aptIndex.setRootAlias(ConfigProperties.subQueryAlias);
        }
        wrapper.subTableAlias = ConfigProperties.subQueryAlias;
        consumer.accept(wrapper);
        this.addCustomWrapper(wrapper);
        this.selectColumns.add(new SelectSub(() -> AptWrapperUtils.buildSubSqlByWrapper(baseColumn.getColumnClass(), wrapper, alias), this.hasAlias, this.alias, alias));
        return (AptQueryWrapper)this.typedThis;
    }

    public <U> AptQueryWrapper<T> union(BaseColumn<U> baseColumn, Consumer<AptQueryWrapper<U>> consumer) {
        AptQueryWrapper<U> unionWrapper = AptWrappers.query(baseColumn);
        this.addCustomWrapper(unionWrapper);
        consumer.accept(unionWrapper);
        String sb = " UNION " + AptWrapperUtils.buildUnionSqlByWrapper(baseColumn.getColumnClass(), unionWrapper);
        if (Objects.isNull(this.unionSql)) {
            this.unionSql = SharedString.emptyString();
        }
        this.unionSql.setStringValue(this.unionSql.getStringValue() + sb);
        return (AptQueryWrapper)this.typedThis;
    }

    public <U> AptQueryWrapper<T> unionAll(BaseColumn<U> baseColumn, Consumer<AptQueryWrapper<U>> consumer) {
        AptQueryWrapper<U> unionWrapper = AptWrappers.query(baseColumn);
        this.addCustomWrapper(unionWrapper);
        consumer.accept(unionWrapper);
        String sb = " UNION ALL " + AptWrapperUtils.buildUnionSqlByWrapper(baseColumn.getColumnClass(), unionWrapper);
        if (Objects.isNull(this.unionSql)) {
            this.unionSql = SharedString.emptyString();
        }
        this.unionSql.setStringValue(this.unionSql.getStringValue() + sb);
        return (AptQueryWrapper)this.typedThis;
    }

    private void addCustomWrapper(AptQueryWrapper<?> wrapper) {
        if (Objects.isNull(this.wrapperIndex)) {
            this.wrapperIndex = new AtomicInteger(0);
        }
        int index = this.wrapperIndex.incrementAndGet();
        if (Objects.isNull(this.wrapperMap)) {
            this.wrapperMap = new HashMap();
        }
        String key = "ew" + index;
        wrapper.setParamAlias(wrapper.getParamAlias() + ".wrapperMap." + key);
        this.wrapperMap.put(key, wrapper);
    }

    @Override
    public String getSqlSelect() {
        if (StrUtils.isBlank(this.sqlSelect.getStringValue()) && CollectionUtils.isNotEmpty(this.selectColumns)) {
            String s = this.selectColumns.stream().map(i -> {
                if (i.isStr()) {
                    return i.getColumn();
                }
                if (i.isFunc()) {
                    return String.format(i.getFunc().getSql(), Arrays.stream(i.getColumns()).map(c -> this.aptIndex.get(c.getRoot()) + "." + i.getColumn()).toArray()) + " AS " + i.getAlias();
                }
                String prefix = null == i.getTableAlias() && null != i.getBaseColumn() ? this.aptIndex.get(i.getBaseColumn()) : i.getTableAlias();
                String col = prefix + "." + i.getColumn();
                return i.isHasAlias() ? col + " AS " + i.getAlias() : col;
            }).collect(Collectors.joining(","));
            this.sqlSelect.setStringValue(s);
        }
        return this.sqlSelect.getStringValue();
    }

    @Override
    public String getUnionSql() {
        return Optional.ofNullable(this.unionSql).map(SharedString::getStringValue).orElse("");
    }

    public boolean getSelectDistinct() {
        return this.selectDistinct;
    }

    @Override
    protected AptQueryWrapper<T> instance() {
        return this.instance(this.index, (String)null, (Class)null, (String)null);
    }

    @Override
    protected AptQueryWrapper<T> instanceEmpty() {
        return new AptQueryWrapper(this.getBaseColumn());
    }

    @Override
    protected AptQueryWrapper<T> instance(Integer index, String keyWord, Class<?> joinClass, String tableName) {
        return new AptQueryWrapper(this.getEntity(), this.baseColumn, null, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), this.paramAlias, SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString(), this.aptIndex, index, keyWord, joinClass, tableName, this.ifExists);
    }

    @Override
    public void clear() {
        super.clear();
        this.selectDistinct = false;
        this.sqlSelect.toNull();
        this.selectColumns.clear();
        this.wrapperIndex = new AtomicInteger(0);
        if (Objects.nonNull(this.wrapperMap)) {
            this.wrapperMap.clear();
        }
        if (Objects.nonNull(this.unionSql)) {
            this.unionSql.toEmpty();
        }
        this.resultMapMybatisLabel.clear();
        this.ifExists = ConfigProperties.ifExists;
    }

    @Override
    @Generated
    public List<Select> getSelectColumns() {
        return this.selectColumns;
    }

    @Override
    @Generated
    public List<Label<?>> getResultMapMybatisLabel() {
        return this.resultMapMybatisLabel;
    }

    @Generated
    public Map<String, Wrapper<?>> getWrapperMap() {
        return this.wrapperMap;
    }
}

