/*
 * Decompiled with CFR 0.152.
 */
package com.chaoliu.spanlite;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.RequiresApi;
import android.support.annotation.StyleRes;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.text.style.DynamicDrawableSpan;
import android.view.View;
import com.chaoliu.spanlite.Util;

public class SpanBuilder {
    private SpannableStringBuilder spanBuilder;
    private String content;

    private SpanBuilder() {
    }

    private SpanBuilder(String content) {
        this.content = content;
        this.spanBuilder = new SpannableStringBuilder((CharSequence)content);
    }

    public static SpanBuilder Builder(String content) {
        return new SpanBuilder(content);
    }

    public SpanBuilder drawBlurMaskFilter(float radius, BlurMaskFilter.Blur style) {
        Util.setSpanExEx(this.spanBuilder, Util.drawBlurMaskFilter(radius, style));
        return this;
    }

    public SpanBuilder drawImage(Context context, @DrawableRes int drawableRes) {
        Util.setSpanExEx(this.spanBuilder, Util.drawImageSpan(context, drawableRes));
        return this;
    }

    public SpanBuilder drawImage(Drawable drawable, int verticalAlignment) {
        Util.setSpanExEx(this.spanBuilder, Util.drawImageSpan(drawable, verticalAlignment));
        return this;
    }

    public SpanBuilder drawImageDrawable(Context context, @DrawableRes int drawableRes) {
        Util.setSpanExEx(this.spanBuilder, Util.drawImageDrawableSpan(context, drawableRes));
        return this;
    }

    public SpanBuilder drawImageWidthHeight(Context context, @DrawableRes int drawableRes, int width, int height) {
        Util.setSpanExEx(this.spanBuilder, Util.drawImageSpanWidthHeight(context, drawableRes, width, height));
        return this;
    }

    public SpanBuilder drawDynamicDrawable(DynamicDrawableSpan dynamicDrawableSpan) {
        Util.setSpanExEx(this.spanBuilder, dynamicDrawableSpan);
        return this;
    }

    public SpanBuilder drawUnderline() {
        Util.setSpanExEx(this.spanBuilder, Util.drawUnderlineSpan());
        return this;
    }

    public SpanBuilder drawStrikethrough() {
        Util.setSpanExEx(this.spanBuilder, Util.drawStrikethroughSpan());
        return this;
    }

    public SpanBuilder drawTypeFaceBoldItalic() {
        Util.setSpanExEx(this.spanBuilder, Util.drawTypeFaceBoldItalic());
        return this;
    }

    public SpanBuilder drawTypeFaceBold() {
        Util.setSpanExEx(this.spanBuilder, Util.drawTypeFaceBold());
        return this;
    }

    public SpanBuilder drawTypeFaceItalic() {
        Util.setSpanExEx(this.spanBuilder, Util.drawTypeFaceItalic());
        return this;
    }

    public SpanBuilder drawTypeFaceNormal() {
        Util.setSpanExEx(this.spanBuilder, Util.drawTypeFaceNormal());
        return this;
    }

    public SpanBuilder drawTextSizeAbsolute(int size) {
        Util.setSpanExEx(this.spanBuilder, Util.drawTextSizeAbsolute(size));
        return this;
    }

    public SpanBuilder drawTextSizeRelative(int size) {
        Util.setSpanExEx(this.spanBuilder, Util.drawTextSizeRelative(size));
        return this;
    }

    public SpanBuilder drawScaleX(float proportion) {
        Util.setSpanExEx(this.spanBuilder, Util.drawScaleXSpan(proportion));
        return this;
    }

    public SpanBuilder drawSuperscript() {
        Util.setSpanExEx(this.spanBuilder, Util.drawSuperscriptSpan());
        return this;
    }

    public SpanBuilder drawSubscript() {
        Util.setSpanExEx(this.spanBuilder, Util.drawSubscriptSpan());
        return this;
    }

    @RequiresApi(api=28)
    public SpanBuilder drawTypeface(Typeface typeface) {
        Util.setSpanExEx(this.spanBuilder, Util.drawTypefaceSpan(typeface));
        return this;
    }

    public SpanBuilder drawTypeface(String typeface) {
        Util.setSpanExEx(this.spanBuilder, Util.drawTypefaceSpan(typeface));
        return this;
    }

    public SpanBuilder drawURL(String url) {
        Util.setSpanExEx(this.spanBuilder, Util.drawURLSpan(url));
        return this;
    }

    public SpanBuilder drawTextAppearance(Context context, @StyleRes int style) {
        Util.setSpanExEx(this.spanBuilder, Util.drawTextAppearanceSpan(context, style));
        return this;
    }

    public SpanBuilder drawTextColor(int color) {
        Util.setSpanExEx(this.spanBuilder, Util.drawTextColorSpan(color));
        return this;
    }

    public SpanBuilder drawTextBackgroundColor(int color) {
        Util.setSpanExEx(this.spanBuilder, Util.drawTextBackgroundColorSpan(color));
        return this;
    }

    public SpanBuilder drawTextColor(String colorString) {
        Util.setSpanExEx(this.spanBuilder, Util.drawTextColorSpan(colorString));
        return this;
    }

    public SpanBuilder drawTextBackgroundColor(String colorString) {
        Util.setSpanExEx(this.spanBuilder, Util.drawTextBackgroundColorSpan(colorString));
        return this;
    }

    public SpanBuilder setOnClick(final Listerner listerner) {
        Util.setSpanExEx(this.spanBuilder, new ClickableSpan(){

            public void onClick(View widget) {
                if (listerner != null) {
                    listerner.onClick(widget);
                }
            }

            public void updateDrawState(TextPaint ds) {
                ds.setColor(ds.linkColor);
                ds.setUnderlineText(false);
                if (listerner != null) {
                    listerner.updateDrawState(ds);
                }
            }
        });
        return this;
    }

    public SpannableStringBuilder build() {
        return this.spanBuilder;
    }

    public static abstract class Listerner {
        public abstract void onClick(View var1);

        public void updateDrawState(TextPaint ds) {
        }
    }
}

