/*
 * Decompiled with CFR 0.152.
 */
package com.yhao.floatwindow;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.yhao.floatwindow.IFloatWindow;
import com.yhao.floatwindow.IFloatWindowImpl;
import com.yhao.floatwindow.PermissionListener;
import com.yhao.floatwindow.Util;
import com.yhao.floatwindow.ViewStateListener;
import java.util.HashMap;
import java.util.Map;

public class FloatWindow {
    private static final String mDefaultTag = "default_float_window_tag";
    private static Map<String, IFloatWindow> mFloatWindowMap;
    private static B mBuilder;

    private FloatWindow() {
    }

    public static IFloatWindow get() {
        return FloatWindow.get(mDefaultTag);
    }

    public static IFloatWindow get(@NonNull String tag) {
        return mFloatWindowMap == null ? null : mFloatWindowMap.get(tag);
    }

    @MainThread
    public static B with(@NonNull Context applicationContext) {
        mBuilder = new B(applicationContext);
        return mBuilder;
    }

    public static void destroy() {
        FloatWindow.destroy(mDefaultTag);
    }

    public static void destroy(String tag) {
        if (mFloatWindowMap == null || !mFloatWindowMap.containsKey(tag)) {
            return;
        }
        mFloatWindowMap.get(tag).dismiss();
        mFloatWindowMap.remove(tag);
    }

    static {
        mBuilder = null;
    }

    public static class B {
        Context mApplicationContext;
        View mView;
        private int mLayoutId;
        int mWidth = -2;
        int mHeight = -2;
        int gravity = 0x800033;
        int xOffset;
        int yOffset;
        boolean mShow = true;
        Class[] mActivities;
        int mMoveType = 3;
        int mSlideLeftMargin;
        int mSlideRightMargin;
        long mDuration = 300L;
        TimeInterpolator mInterpolator;
        private String mTag = "default_float_window_tag";
        boolean mDesktopShow;
        PermissionListener mPermissionListener;
        ViewStateListener mViewStateListener;

        private B() {
        }

        B(Context applicationContext) {
            this.mApplicationContext = applicationContext;
        }

        public B setView(@NonNull View view) {
            this.mView = view;
            return this;
        }

        public B setView(@LayoutRes int layoutId) {
            this.mLayoutId = layoutId;
            return this;
        }

        public B setWidth(int width) {
            this.mWidth = width;
            return this;
        }

        public B setHeight(int height) {
            this.mHeight = height;
            return this;
        }

        public B setWidth(int screenType, float ratio) {
            this.mWidth = (int)((float)(screenType == 0 ? Util.getScreenWidth(this.mApplicationContext) : Util.getScreenHeight(this.mApplicationContext)) * ratio);
            return this;
        }

        public B setHeight(int screenType, float ratio) {
            this.mHeight = (int)((float)(screenType == 0 ? Util.getScreenWidth(this.mApplicationContext) : Util.getScreenHeight(this.mApplicationContext)) * ratio);
            return this;
        }

        public B setX(int x) {
            this.xOffset = x;
            return this;
        }

        public B setY(int y) {
            this.yOffset = y;
            return this;
        }

        public B setX(int screenType, float ratio) {
            this.xOffset = (int)((float)(screenType == 0 ? Util.getScreenWidth(this.mApplicationContext) : Util.getScreenHeight(this.mApplicationContext)) * ratio);
            return this;
        }

        public B setY(int screenType, float ratio) {
            this.yOffset = (int)((float)(screenType == 0 ? Util.getScreenWidth(this.mApplicationContext) : Util.getScreenHeight(this.mApplicationContext)) * ratio);
            return this;
        }

        public B setFilter(boolean show, Class ... activities) {
            this.mShow = show;
            this.mActivities = activities;
            return this;
        }

        public B setMoveType(int moveType) {
            return this.setMoveType(moveType, 0, 0);
        }

        public B setMoveType(int moveType, int slideLeftMargin, int slideRightMargin) {
            this.mMoveType = moveType;
            this.mSlideLeftMargin = slideLeftMargin;
            this.mSlideRightMargin = slideRightMargin;
            return this;
        }

        public B setMoveStyle(long duration, @Nullable TimeInterpolator interpolator) {
            this.mDuration = duration;
            this.mInterpolator = interpolator;
            return this;
        }

        public B setTag(@NonNull String tag) {
            this.mTag = tag;
            return this;
        }

        public B setDesktopShow(boolean show) {
            this.mDesktopShow = show;
            return this;
        }

        public B setPermissionListener(PermissionListener listener) {
            this.mPermissionListener = listener;
            return this;
        }

        public B setViewStateListener(ViewStateListener listener) {
            this.mViewStateListener = listener;
            return this;
        }

        public void build() {
            if (mFloatWindowMap == null) {
                mFloatWindowMap = new HashMap();
            }
            if (mFloatWindowMap.containsKey(this.mTag)) {
                throw new IllegalArgumentException("FloatWindow of this tag has been added, Please set a new tag for the new FloatWindow");
            }
            if (this.mView == null && this.mLayoutId == 0) {
                throw new IllegalArgumentException("View has not been set!");
            }
            if (this.mView == null) {
                this.mView = Util.inflate(this.mApplicationContext, this.mLayoutId);
            }
            IFloatWindowImpl floatWindowImpl = new IFloatWindowImpl(this);
            mFloatWindowMap.put(this.mTag, floatWindowImpl);
        }
    }
}

