/*
 * Decompiled with CFR 0.152.
 */
package com.gh.net_lib.http;

import com.gh.net_lib.api.BaseApi;
import com.gh.net_lib.exception.RetryWhenNetworkException;
import com.gh.net_lib.listener.BaseHttpOnNextListener;
import com.gh.net_lib.subscribers.ProgressSubscriber;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class HttpManager {
    private static volatile HttpManager INSTANCE;
    private Map<String, String> headersMap;
    private List<Interceptor> interceptorList;

    private HttpManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<HttpManager> clazz = HttpManager.class;
        synchronized (HttpManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new HttpManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public HttpManager setHeaders(Map<String, String> headers) {
        this.headersMap = headers;
        return this;
    }

    public HttpManager setInterceptorList(List<Interceptor> interceptorList) {
        this.interceptorList = interceptorList;
        return this;
    }

    public void doHttpDeal(BaseApi baseApi) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout((long)baseApi.getConnectionTime(), TimeUnit.SECONDS);
        if (this.headersMap != null) {
            builder.addInterceptor(chain -> {
                Set<Map.Entry<String, String>> set = this.headersMap.entrySet();
                Iterator<Map.Entry<String, String>> i = set.iterator();
                Request.Builder xmlHttpRequest = chain.request().newBuilder();
                while (i.hasNext()) {
                    Map.Entry<String, String> entry1 = i.next();
                    xmlHttpRequest.addHeader(entry1.getKey(), entry1.getValue());
                }
                Request request = xmlHttpRequest.build();
                return chain.proceed(request);
            });
        }
        if (this.interceptorList != null && this.interceptorList.size() > 0) {
            for (Interceptor in : this.interceptorList) {
                builder.addInterceptor(in);
            }
        }
        Retrofit retrofit = new Retrofit.Builder().client(builder.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl(baseApi.getBaseUrl()).build();
        ProgressSubscriber subscriber = new ProgressSubscriber(baseApi);
        Flowable observable = baseApi.getObservable(retrofit).retryWhen((Function)new RetryWhenNetworkException(baseApi.getRetryCount(), baseApi.getRetryDelay(), baseApi.getRetryIncreaseDelay())).subscribeOn(Schedulers.io()).unsubscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).map((Function)baseApi);
        SoftReference<BaseHttpOnNextListener> httpOnNextListener = baseApi.getListener();
        if (httpOnNextListener != null && httpOnNextListener.get() != null) {
            httpOnNextListener.get().onNext(observable);
        }
        observable.subscribe(subscriber);
    }
}

