/*
 * Decompiled with CFR 0.152.
 */
package com.gh.net_lib.exception;

import io.reactivex.Flowable;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.reactivestreams.Publisher;

public class RetryWhenNetworkException
implements Function<Flowable<? extends Throwable>, Flowable<?>> {
    private int count = 3;
    private long delay = 3000L;
    private long increaseDelay = 3000L;

    public RetryWhenNetworkException() {
    }

    public RetryWhenNetworkException(int count, long delay) {
        this.count = count;
        this.delay = delay;
    }

    public RetryWhenNetworkException(int count, long delay, long increaseDelay) {
        this.count = count;
        this.delay = delay;
        this.increaseDelay = increaseDelay;
    }

    public Flowable<?> apply(Flowable<? extends Throwable> input) {
        return input.zipWith((Publisher)Flowable.range((int)1, (int)(this.count + 1)), (BiFunction)new BiFunction<Throwable, Integer, Wrapper>(){

            public Wrapper apply(Throwable throwable, Integer integer) throws Exception {
                return new Wrapper(throwable, integer);
            }
        }).flatMap(new Function<Wrapper, Publisher<?>>(){

            public Publisher<?> apply(Wrapper wrapper) throws Exception {
                if ((wrapper.throwable instanceof ConnectException || wrapper.throwable instanceof SocketTimeoutException || wrapper.throwable instanceof TimeoutException) && wrapper.index < RetryWhenNetworkException.this.count + 1) {
                    return Flowable.timer((long)(RetryWhenNetworkException.this.delay + (long)(wrapper.index - 1) * RetryWhenNetworkException.this.increaseDelay), (TimeUnit)TimeUnit.MILLISECONDS);
                }
                return Flowable.error((Throwable)wrapper.throwable);
            }
        });
    }

    private class Wrapper {
        private int index;
        private Throwable throwable;

        public Wrapper(Throwable throwable, int index) {
            this.index = index;
            this.throwable = throwable;
        }
    }
}

