/*
 * Decompiled with CFR 0.152.
 */
package com.yesterselga.countrypicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.fragment.app.DialogFragment;
import com.yesterselga.countrypicker.Country;
import com.yesterselga.countrypicker.CountryAdapter;
import com.yesterselga.countrypicker.CountryPickerListener;
import com.yesterselga.countrypicker.R;
import com.yesterselga.countrypicker.Theme;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CountryPicker
extends DialogFragment {
    EditText searchEditText;
    ListView countryListView;
    CountryAdapter adapter;
    List<Country> countriesList = new ArrayList<Country>();
    List<Country> selectedCountriesList = new ArrayList<Country>();
    CountryPickerListener listener;
    Context context;
    private static Theme pickerTheme;

    public static CountryPicker newInstance(String dialogTitle, Theme theme) {
        CountryPicker picker = new CountryPicker();
        Bundle bundle = new Bundle();
        bundle.putString("dialogTitle", dialogTitle);
        pickerTheme = theme;
        picker.setArguments(bundle);
        return picker;
    }

    public CountryPicker() {
        this.setCountriesList(Country.getAllCountries());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.country_picker, (ViewGroup)null);
        Bundle args = this.getArguments();
        if (args != null) {
            String dialogTitle = args.getString("dialogTitle");
            this.getDialog().setTitle((CharSequence)dialogTitle);
            int width = this.getResources().getDimensionPixelSize(R.dimen.cp_dialog_width);
            int height = this.getResources().getDimensionPixelSize(R.dimen.cp_dialog_height);
            this.getDialog().getWindow().setLayout(width, height);
        }
        if (pickerTheme.equals((Object)Theme.DARK)) {
            view = inflater.inflate(R.layout.country_picker_dark, (ViewGroup)null);
        }
        this.searchEditText = (EditText)view.findViewById(R.id.country_code_picker_search);
        this.countryListView = (ListView)view.findViewById(R.id.country_code_picker_listview);
        this.selectedCountriesList = new ArrayList<Country>(this.countriesList.size());
        this.selectedCountriesList.addAll(this.countriesList);
        this.adapter = new CountryAdapter((Context)this.getActivity(), this.selectedCountriesList, pickerTheme);
        this.countryListView.setAdapter((ListAdapter)this.adapter);
        this.countryListView.setOnItemClickListener((parent, view1, position, id2) -> {
            if (this.listener != null) {
                Country country = this.selectedCountriesList.get(position);
                this.listener.onSelectCountry(country.getName(), country.getCode(), country.getDialCode(), country.getFlag());
            }
        });
        this.searchEditText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                CountryPicker.this.search(s.toString());
            }
        });
        return view;
    }

    public void setListener(CountryPickerListener listener) {
        this.listener = listener;
    }

    @SuppressLint(value={"DefaultLocale"})
    private void search(String text) {
        this.selectedCountriesList.clear();
        for (Country country : this.countriesList) {
            if (!country.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase())) continue;
            this.selectedCountriesList.add(country);
        }
        this.adapter.notifyDataSetChanged();
    }

    public void setCountriesList(List<Country> newCountries) {
        this.countriesList.clear();
        this.countriesList.addAll(newCountries);
    }
}

