/*
 * Decompiled with CFR 0.152.
 */
package com.yesterselga.countrypicker;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.yesterselga.countrypicker.Country;
import com.yesterselga.countrypicker.R;
import com.yesterselga.countrypicker.Theme;
import java.util.List;

public class CountryAdapter
extends BaseAdapter {
    private Context mContext;
    List<Country> countries;
    LayoutInflater inflater;
    Theme theme;

    public CountryAdapter(Context context, List<Country> countries, Theme theme) {
        this.mContext = context;
        this.countries = countries;
        this.theme = theme;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public int getCount() {
        return this.countries.size();
    }

    public Object getItem(int arg0) {
        return null;
    }

    public long getItemId(int arg0) {
        return 0L;
    }

    public View getView(int position, View view, ViewGroup parent) {
        Country country = this.countries.get(position);
        if (view == null) {
            view = this.theme.equals((Object)Theme.DARK) ? this.inflater.inflate(R.layout.row_dark, (ViewGroup)null) : this.inflater.inflate(R.layout.row, (ViewGroup)null);
        }
        Cell cell = Cell.from(view);
        cell.textView.setText((CharSequence)country.getName());
        country.loadFlagByCode(this.mContext);
        if (country.getFlag() != -1) {
            cell.imageView.setImageResource(country.getFlag());
        }
        return view;
    }

    static class Cell {
        public TextView textView;
        public ImageView imageView;

        Cell() {
        }

        static Cell from(View view) {
            if (view == null) {
                return null;
            }
            if (view.getTag() == null) {
                Cell cell = new Cell();
                cell.textView = (TextView)view.findViewById(R.id.row_title);
                cell.imageView = (ImageView)view.findViewById(R.id.row_icon);
                view.setTag((Object)cell);
                return cell;
            }
            return (Cell)view.getTag();
        }
    }
}

