/*
 * Decompiled with CFR 0.152.
 */
package com.yarolegovich.lovelydialog;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import com.yarolegovich.lovelydialog.AbsLovelyDialog;
import com.yarolegovich.lovelydialog.R;
import com.yarolegovich.lovelydialog.ViewConfigurator;

public class LovelyTextInputDialog
extends AbsLovelyDialog<LovelyTextInputDialog> {
    private static final String KEY_HAS_ERROR = "key_has_error";
    private static final String KEY_TYPED_TEXT = "key_typed_text";
    private EditText inputField;
    private TextView errorMessage;
    private TextView confirmButton = (TextView)this.findView(R.id.ld_btn_confirm);
    private TextView negativeButton = (TextView)this.findView(R.id.ld_btn_negative);
    private TextFilter filter;

    public LovelyTextInputDialog(Context context) {
        super(context);
        this.inputField = (EditText)this.findView(R.id.ld_text_input);
        this.errorMessage = (TextView)this.findView(R.id.ld_error_message);
        this.inputField.addTextChangedListener((TextWatcher)new HideErrorOnTextChanged());
    }

    public LovelyTextInputDialog(Context context, int theme) {
        super(context, theme);
        this.inputField = (EditText)this.findView(R.id.ld_text_input);
        this.errorMessage = (TextView)this.findView(R.id.ld_error_message);
        this.inputField.addTextChangedListener((TextWatcher)new HideErrorOnTextChanged());
    }

    public LovelyTextInputDialog configureEditText(@NonNull ViewConfigurator<EditText> viewConfigurator) {
        viewConfigurator.configureView(this.inputField);
        return this;
    }

    public LovelyTextInputDialog setConfirmButton(@StringRes int text, OnTextInputConfirmListener listener) {
        return this.setConfirmButton(this.string(text), listener);
    }

    public LovelyTextInputDialog setConfirmButton(String text, OnTextInputConfirmListener listener) {
        this.confirmButton.setText((CharSequence)text);
        this.confirmButton.setOnClickListener((View.OnClickListener)new TextInputListener(listener));
        return this;
    }

    public LovelyTextInputDialog setConfirmButtonColor(int color) {
        this.confirmButton.setTextColor(color);
        return this;
    }

    public LovelyTextInputDialog setNegativeButton(@StringRes int text, View.OnClickListener listener) {
        return this.setNegativeButton(this.string(text), listener);
    }

    public LovelyTextInputDialog setNegativeButton(String text, View.OnClickListener listener) {
        this.negativeButton.setVisibility(0);
        this.negativeButton.setText((CharSequence)text);
        this.negativeButton.setOnClickListener((View.OnClickListener)new AbsLovelyDialog.ClickListenerDecorator(listener, true));
        return this;
    }

    public LovelyTextInputDialog setNegativeButtonColor(int color) {
        this.negativeButton.setTextColor(color);
        return this;
    }

    public LovelyTextInputDialog setInputFilter(@StringRes int errorMessage, TextFilter filter) {
        return this.setInputFilter(this.string(errorMessage), filter);
    }

    public LovelyTextInputDialog setInputFilter(String errorMessage, TextFilter filter) {
        this.filter = filter;
        this.errorMessage.setText((CharSequence)errorMessage);
        return this;
    }

    public LovelyTextInputDialog setErrorMessageColor(int color) {
        this.errorMessage.setTextColor(color);
        return this;
    }

    public LovelyTextInputDialog setInputType(int inputType) {
        this.inputField.setInputType(inputType);
        return this;
    }

    public LovelyTextInputDialog addTextWatcher(TextWatcher textWatcher) {
        this.inputField.addTextChangedListener(textWatcher);
        return this;
    }

    public LovelyTextInputDialog setInitialInput(@StringRes int text) {
        return this.setInitialInput(this.string(text));
    }

    public LovelyTextInputDialog setInitialInput(String text) {
        this.inputField.setText((CharSequence)text);
        return this;
    }

    public LovelyTextInputDialog setHint(@StringRes int hint) {
        return this.setHint(this.string(hint));
    }

    public LovelyTextInputDialog setHint(String text) {
        this.inputField.setHint((CharSequence)text);
        return this;
    }

    private void setError() {
        this.errorMessage.setVisibility(0);
    }

    private void hideError() {
        this.errorMessage.setVisibility(8);
    }

    @Override
    void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(KEY_HAS_ERROR, this.errorMessage.getVisibility() == 0);
        outState.putString(KEY_TYPED_TEXT, this.inputField.getText().toString());
    }

    @Override
    void restoreState(Bundle savedState) {
        super.restoreState(savedState);
        if (savedState.getBoolean(KEY_HAS_ERROR, false)) {
            this.setError();
        }
        this.inputField.setText((CharSequence)savedState.getString(KEY_TYPED_TEXT));
    }

    @Override
    protected int getLayout() {
        return R.layout.dialog_text_input;
    }

    public static interface TextFilter {
        public boolean check(String var1);
    }

    public static interface OnTextInputConfirmListener {
        public void onTextInputConfirmed(String var1);
    }

    private class HideErrorOnTextChanged
    implements TextWatcher {
        private HideErrorOnTextChanged() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            LovelyTextInputDialog.this.hideError();
        }

        public void afterTextChanged(Editable s) {
        }
    }

    private class TextInputListener
    implements View.OnClickListener {
        private OnTextInputConfirmListener wrapped;

        private TextInputListener(OnTextInputConfirmListener wrapped) {
            this.wrapped = wrapped;
        }

        public void onClick(View v) {
            String text = LovelyTextInputDialog.this.inputField.getText().toString();
            if (LovelyTextInputDialog.this.filter != null) {
                boolean isWrongInput;
                boolean bl = isWrongInput = !LovelyTextInputDialog.this.filter.check(text);
                if (isWrongInput) {
                    LovelyTextInputDialog.this.setError();
                    return;
                }
            }
            if (this.wrapped != null) {
                this.wrapped.onTextInputConfirmed(text);
            }
            LovelyTextInputDialog.this.dismiss();
        }
    }
}

