/*
 * Decompiled with CFR 0.152.
 */
package com.yarolegovich.lovelydialog;

import android.app.Dialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import androidx.annotation.StringRes;
import com.yarolegovich.lovelydialog.AbsLovelyDialog;
import com.yarolegovich.lovelydialog.R;

public class LovelyInfoDialog
extends AbsLovelyDialog<LovelyInfoDialog> {
    private static final String STORAGE = "ld_dont_show";
    private static final String KEY_DONT_SHOW_AGAIN = "key_dont_show_again";
    private CheckBox cbDontShowAgain = (CheckBox)this.findView(R.id.ld_cb_dont_show_again);
    private Button confirmButton = (Button)this.findView(R.id.ld_btn_confirm);
    private int infoDialogId;

    public LovelyInfoDialog(Context context) {
        super(context);
        this.confirmButton.setOnClickListener((View.OnClickListener)new AbsLovelyDialog.ClickListenerDecorator(null, true));
        this.infoDialogId = -1;
    }

    public LovelyInfoDialog(Context context, int theme) {
        super(context, theme);
        this.confirmButton.setOnClickListener((View.OnClickListener)new AbsLovelyDialog.ClickListenerDecorator(null, true));
        this.infoDialogId = -1;
    }

    public LovelyInfoDialog setNotShowAgainOptionEnabled(int dialogId) {
        this.infoDialogId = dialogId;
        this.cbDontShowAgain.setVisibility(0);
        this.confirmButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean notShow = LovelyInfoDialog.this.cbDontShowAgain.isChecked();
                LovelyInfoDialog.storage(LovelyInfoDialog.this.getContext()).edit().putBoolean(String.valueOf(LovelyInfoDialog.this.infoDialogId), notShow).apply();
                LovelyInfoDialog.this.dismiss();
            }
        });
        return this;
    }

    public LovelyInfoDialog setNotShowAgainOptionChecked(boolean defaultChecked) {
        this.cbDontShowAgain.setChecked(defaultChecked);
        return this;
    }

    public LovelyInfoDialog setConfirmButtonText(@StringRes int text) {
        return this.setConfirmButtonText(this.string(text));
    }

    public LovelyInfoDialog setConfirmButtonText(String text) {
        this.confirmButton.setText((CharSequence)text);
        return this;
    }

    public LovelyInfoDialog setConfirmButtonColor(int color) {
        this.confirmButton.setTextColor(color);
        return this;
    }

    @Override
    public Dialog show() {
        boolean shouldShowDialog;
        if (this.infoDialogId == -1) {
            return super.show();
        }
        boolean bl = shouldShowDialog = !LovelyInfoDialog.storage(this.getContext()).getBoolean(String.valueOf(this.infoDialogId), false);
        if (shouldShowDialog) {
            return super.show();
        }
        return super.create();
    }

    @Override
    void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(KEY_DONT_SHOW_AGAIN, this.cbDontShowAgain.isChecked());
    }

    @Override
    void restoreState(Bundle savedState) {
        super.restoreState(savedState);
        this.cbDontShowAgain.setChecked(savedState.getBoolean(KEY_DONT_SHOW_AGAIN));
    }

    @Override
    protected int getLayout() {
        return R.layout.dialog_info;
    }

    public static void reset(Context context, int dialogId) {
        LovelyInfoDialog.storage(context).edit().putBoolean(String.valueOf(dialogId), false).apply();
    }

    private static SharedPreferences storage(Context context) {
        return context.getSharedPreferences(STORAGE, 0);
    }
}

