/*
 * Decompiled with CFR 0.152.
 */
package com.xycoding.richtext.typeface;

import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.style.CharacterStyle;
import android.text.style.TypefaceSpan;
import com.xycoding.richtext.typeface.IStyleSpan;

public class FontTypefaceSpan
extends TypefaceSpan
implements IStyleSpan {
    private final Typeface mTypeface;

    public FontTypefaceSpan(Typeface typeface) {
        super("");
        this.mTypeface = typeface;
    }

    public void updateDrawState(TextPaint ds) {
        FontTypefaceSpan.apply((Paint)ds, this.mTypeface);
    }

    public void updateMeasureState(TextPaint paint) {
        FontTypefaceSpan.apply((Paint)paint, this.mTypeface);
    }

    private static void apply(Paint paint, Typeface typeface) {
        Typeface tf;
        Typeface old = paint.getTypeface();
        int oldStyle = old == null ? 0 : old.getStyle();
        int fake = oldStyle & ~(tf = Typeface.create((Typeface)typeface, (int)oldStyle)).getStyle();
        if ((fake & 1) != 0) {
            paint.setFakeBoldText(true);
        }
        if ((fake & 2) != 0) {
            paint.setTextSkewX(-0.25f);
        }
        paint.setTypeface(tf);
    }

    public CharacterStyle getStyleSpan() {
        return new FontTypefaceSpan(this.mTypeface);
    }
}

