/*
 * Decompiled with CFR 0.152.
 */
package com.xycoding.richtext.typeface;

import android.text.Spannable;
import android.text.TextPaint;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.view.View;
import android.widget.TextView;
import com.xycoding.richtext.typeface.IStyleSpan;

public class ClickSpan
extends ClickableSpan
implements IStyleSpan {
    private static final int BACK_GROUND_PRESSED_DURATION = 50;
    private OnClickListener mClickListener;
    protected int mNormalTextColor;
    protected int mPressedTextColor;
    protected int mPressedBackgroundColor;
    protected View mClickView;
    protected int mClickStart;
    protected int mClickEnd;
    protected Spannable mCachedSpannable;
    protected CharacterStyle[] mCachedStyles;
    protected ForegroundColorSpan mForegroundColorSpan;
    protected BackgroundColorSpan mBackgroundColorSpan;

    public ClickSpan(int normalTextColor, int pressedTextColor, int pressedBackgroundColor, OnClickListener listener) {
        this.mNormalTextColor = normalTextColor;
        this.mPressedTextColor = pressedTextColor;
        this.mPressedBackgroundColor = pressedBackgroundColor;
        this.mClickListener = listener;
        this.mForegroundColorSpan = new ForegroundColorSpan(this.mPressedTextColor);
        this.mBackgroundColorSpan = new BackgroundColorSpan(this.mPressedBackgroundColor);
    }

    public void onClick(View widget) {
        this.mClickView = widget;
    }

    public CharacterStyle getStyleSpan() {
        return new ClickSpan(this.mNormalTextColor, this.mPressedTextColor, this.mPressedBackgroundColor, this.mClickListener);
    }

    public void updateDrawState(TextPaint paint) {
        paint.setColor(this.mNormalTextColor);
        paint.setUnderlineText(false);
    }

    public void onClick(TextView textView, String pressedText, float rawX, float rawY, Spannable spannable, int start, int end) {
        this.mCachedSpannable = spannable;
        this.mClickStart = start;
        this.mClickEnd = end;
        this.mCachedStyles = (CharacterStyle[])spannable.getSpans(start, end, CharacterStyle.class);
        if (this.mCachedStyles != null) {
            for (CharacterStyle style : this.mCachedStyles) {
                if (style instanceof TypefaceSpan) continue;
                spannable.removeSpan((Object)style);
            }
        }
        spannable.setSpan((Object)this.mBackgroundColorSpan, start, end, 33);
        spannable.setSpan((Object)this.mForegroundColorSpan, start, end, 33);
        if (this.mClickListener != null) {
            this.mClickListener.onClick(textView, pressedText, rawX, rawY);
        }
        textView.postDelayed(new Runnable(){

            @Override
            public void run() {
                ClickSpan.this.clearBackgroundColor();
            }
        }, 50L);
    }

    public void clearBackgroundColor() {
        if (this.mCachedSpannable != null) {
            this.mCachedSpannable.removeSpan((Object)this.mBackgroundColorSpan);
            this.mCachedSpannable.removeSpan((Object)this.mForegroundColorSpan);
            if (this.mCachedStyles != null) {
                for (CharacterStyle style : this.mCachedStyles) {
                    if (style instanceof TypefaceSpan) continue;
                    this.mCachedSpannable.setSpan((Object)style, this.mClickStart, this.mClickEnd, 33);
                }
            }
        }
        if (this.mClickView != null) {
            this.mClickView.invalidate();
        }
    }

    public void setNormalTextColor(int color) {
        this.mNormalTextColor = color;
    }

    public void setPressedTextColor(int color) {
        this.mPressedTextColor = color;
    }

    public void setPressedBackgroundColor(int color) {
        this.mPressedBackgroundColor = color;
    }

    public int getNormalTextColor() {
        return this.mNormalTextColor;
    }

    public int getPressedTextColor() {
        return this.mPressedTextColor;
    }

    public int getPressedBackgroundColor() {
        return this.mPressedBackgroundColor;
    }

    public static interface OnClickListener {
        public void onClick(TextView var1, CharSequence var2, float var3, float var4);
    }
}

