/*
 * Decompiled with CFR 0.152.
 */
package com.xycoding.richtext;

import android.text.SpannableStringBuilder;
import android.text.Spanned;
import com.xycoding.richtext.TagBlock;
import com.xycoding.richtext.style.BaseTagStyle;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class TagParser
extends DefaultHandler {
    private final Parser mParser = new Parser();
    private final ArrayList<BaseTagStyle> mBaseTagStyles = new ArrayList();
    private SpannableStringBuilder mSpannableStringBuilder;

    TagParser() {
    }

    Spanned parse(String tagString) {
        this.mSpannableStringBuilder = new SpannableStringBuilder();
        try {
            this.mParser.setContentHandler((ContentHandler)this);
            this.mParser.parse(new InputSource(new StringReader(tagString)));
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
        return this.mSpannableStringBuilder;
    }

    void addTypefaceStyle(BaseTagStyle listener) {
        this.mBaseTagStyles.add(listener);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int attributesLength = attributes.getLength();
        HashMap<String, String> attributesMap = new HashMap<String, String>(attributesLength);
        for (int i = 0; i < attributesLength; ++i) {
            attributesMap.put(attributes.getLocalName(i), attributes.getValue(i));
        }
        TagBlock block = new TagBlock(localName, attributesMap);
        for (BaseTagStyle style : this.mBaseTagStyles) {
            if (!style.match(localName)) continue;
            style.start(block, this.mSpannableStringBuilder);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        for (BaseTagStyle style : this.mBaseTagStyles) {
            if (!style.match(localName)) continue;
            style.end(localName, this.mSpannableStringBuilder);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuilder stringBuilder = new StringBuilder();
        this.mSpannableStringBuilder.append((CharSequence)stringBuilder.append(ch, start, length));
    }
}

