package nobox

import java.util.Arrays
import scala.reflect.ClassTag
import scala.collection.mutable.ArrayBuilder

final class WithFilterShort private[nobox](self: ofShort, f: Short => Boolean){
  
  def map[A](g: Short => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => mapInt(g.asInstanceOf[Short => Int])
      case ClassTag.Long => mapLong(g.asInstanceOf[Short => Long])
      case ClassTag.Float => mapFloat(g.asInstanceOf[Short => Float])
      case ClassTag.Double => mapDouble(g.asInstanceOf[Short => Double])
      case ClassTag.Byte => mapByte(g.asInstanceOf[Short => Byte])
      case ClassTag.Char => mapChar(g.asInstanceOf[Short => Char])
      case ClassTag.Short => mapShort(g.asInstanceOf[Short => Short])
      case ClassTag.Boolean => mapBoolean(g.asInstanceOf[Short => Boolean])
      case _ => self.filter(f).map(g) // TODO
    }).asInstanceOf[Array[A]]
  }


  def flatMap[A](g: Short => Array[A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => flatMapInt(g.asInstanceOf[Short => Array[Int]])
      case ClassTag.Long => flatMapLong(g.asInstanceOf[Short => Array[Long]])
      case ClassTag.Float => flatMapFloat(g.asInstanceOf[Short => Array[Float]])
      case ClassTag.Double => flatMapDouble(g.asInstanceOf[Short => Array[Double]])
      case ClassTag.Byte => flatMapByte(g.asInstanceOf[Short => Array[Byte]])
      case ClassTag.Char => flatMapChar(g.asInstanceOf[Short => Array[Char]])
      case ClassTag.Short => flatMapShort(g.asInstanceOf[Short => Array[Short]])
      case ClassTag.Boolean => flatMapBoolean(g.asInstanceOf[Short => Array[Boolean]])
      case _ => self.filter(f).flatMap(g) // TODO
    }).asInstanceOf[Array[A]]
  }


  def foreach[U](g: Short => U): Unit = {
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        g(self.self(i))
      }
      i += 1
    }
  }


  def withFilter(g: Short => Boolean): WithFilterShort =
    new WithFilterShort(self, {a => f(a) && g(a)})


  def mapInt(g: Short => Int): Array[Int] = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapLong(g: Short => Long): Array[Long] = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapFloat(g: Short => Float): Array[Float] = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapDouble(g: Short => Double): Array[Double] = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapByte(g: Short => Byte): Array[Byte] = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapChar(g: Short => Char): Array[Char] = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapShort(g: Short => Short): Array[Short] = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapBoolean(g: Short => Boolean): Array[Boolean] = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def flatMapInt(g: Short => Array[Int]): Array[Int] = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapLong(g: Short => Array[Long]): Array[Long] = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapFloat(g: Short => Array[Float]): Array[Float] = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapDouble(g: Short => Array[Double]): Array[Double] = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapByte(g: Short => Array[Byte]): Array[Byte] = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapChar(g: Short => Array[Char]): Array[Char] = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapShort(g: Short => Array[Short]): Array[Short] = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapBoolean(g: Short => Array[Boolean]): Array[Boolean] = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }

}

final class ofShort (val self: Array[Short]) extends AnyVal {

  
  def sum: Int = {
    var i, n = 0
    while(i < self.length){
      n += self(i)
      i += 1
    }
    n
  }





  def product: Int = {
    var i = 0
    var n = 1
    while(i < self.length){
      n *= self(i)
      i += 1
    }
    n
  }



  def productLong: Long = {
    var i = 0
    var n: Long = 1L
    while(i < self.length){
      n *= self(i)
      i += 1
    }
    n
  }



  def productDouble: Double = {
    var i = 0
    var n: Double = 1.0
    while(i < self.length){
      n *= self(i)
      i += 1
    }
    n
  }



  def sorted: ofShort = {
    val array = self.clone
    Arrays.sort(array)
    new ofShort(array)
  }



  def max: Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var n = self(0)
      while(i < self.length){
        val x = self(i)
        if(n < x){
          n = x
        }
        i += 1
      }
      Some(n)
    }
  }

  def min: Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var n = self(0)
      while(i < self.length){
        val x = self(i)
        if(n > x){
          n = x
        }
        i += 1
      }
      Some(n)
    }
  }

  def minmax: Option[(Short, Short)] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var _min, _max = self(0)
      while(i < self.length){
        val x = self(i)
        if(_min > x){
          _min = x
        }else if(_max < x){
          _max = x
        }
        i += 1
      }
      Some((_min, _max))
    }
  }



  
  def mapInt(f: Short => Int): ofInt = {
    val array = new Array[Int](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofInt(array)
  }


  def mapLong(f: Short => Long): ofLong = {
    val array = new Array[Long](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofLong(array)
  }


  def mapFloat(f: Short => Float): ofFloat = {
    val array = new Array[Float](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def mapDouble(f: Short => Double): ofDouble = {
    val array = new Array[Double](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def mapByte(f: Short => Byte): ofByte = {
    val array = new Array[Byte](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofByte(array)
  }


  def mapChar(f: Short => Char): ofChar = {
    val array = new Array[Char](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofChar(array)
  }


  def mapShort(f: Short => Short): ofShort = {
    val array = new Array[Short](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofShort(array)
  }


  def mapBoolean(f: Short => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def mapRef[Y <: AnyRef :reflect.ClassTag](f: Short => Y): ofRef[Y] = {
    val array = new Array[Y](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def reverseMapInt(f: Short => Int): ofInt = {
    val len = self.length
    val array = new Array[Int](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofInt(array)
  }


  def reverseMapLong(f: Short => Long): ofLong = {
    val len = self.length
    val array = new Array[Long](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofLong(array)
  }


  def reverseMapFloat(f: Short => Float): ofFloat = {
    val len = self.length
    val array = new Array[Float](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def reverseMapDouble(f: Short => Double): ofDouble = {
    val len = self.length
    val array = new Array[Double](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def reverseMapByte(f: Short => Byte): ofByte = {
    val len = self.length
    val array = new Array[Byte](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofByte(array)
  }


  def reverseMapChar(f: Short => Char): ofChar = {
    val len = self.length
    val array = new Array[Char](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofChar(array)
  }


  def reverseMapShort(f: Short => Short): ofShort = {
    val len = self.length
    val array = new Array[Short](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofShort(array)
  }


  def reverseMapBoolean(f: Short => Boolean): ofBoolean = {
    val len = self.length
    val array = new Array[Boolean](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def reverseMapRef[Y <: AnyRef :reflect.ClassTag](f: Short => Y): ofRef[Y] = {
    val len = self.length
    val array = new Array[Y](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def flatMapInt(f: Short => Array[Int]): ofInt = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofInt(builder.result)
  }


  def flatMapLong(f: Short => Array[Long]): ofLong = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofLong(builder.result)
  }


  def flatMapFloat(f: Short => Array[Float]): ofFloat = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofFloat(builder.result)
  }


  def flatMapDouble(f: Short => Array[Double]): ofDouble = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofDouble(builder.result)
  }


  def flatMapByte(f: Short => Array[Byte]): ofByte = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofByte(builder.result)
  }


  def flatMapChar(f: Short => Array[Char]): ofChar = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofChar(builder.result)
  }


  def flatMapShort(f: Short => Array[Short]): ofShort = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofShort(builder.result)
  }


  def flatMapBoolean(f: Short => Array[Boolean]): ofBoolean = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofBoolean(builder.result)
  }


  def flatMapRef[Y <: AnyRef :reflect.ClassTag](f: Short => Array[Y]): ofRef[Y] = {
    val builder = new ArrayBuilder.ofRef[Y]()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofRef[Y](builder.result)
  }



  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectInt(f: PartialFunction[Short, Int]): ofInt = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofInt(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectLong(f: PartialFunction[Short, Long]): ofLong = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofLong(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectFloat(f: PartialFunction[Short, Float]): ofFloat = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofFloat(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectDouble(f: PartialFunction[Short, Double]): ofDouble = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofDouble(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectByte(f: PartialFunction[Short, Byte]): ofByte = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofByte(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectChar(f: PartialFunction[Short, Char]): ofChar = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofChar(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectShort(f: PartialFunction[Short, Short]): ofShort = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofShort(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectBoolean(f: PartialFunction[Short, Boolean]): ofBoolean = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofBoolean(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectRef[Y <: AnyRef :reflect.ClassTag](f: PartialFunction[Short, Y]): ofRef[Y] = {
    val builder = new ArrayBuilder.ofRef[Y]()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofRef[Y](builder.result)
  }



  def collectFirstInt(f: PartialFunction[Short, Int]): Option[Int] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstLong(f: PartialFunction[Short, Long]): Option[Long] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstFloat(f: PartialFunction[Short, Float]): Option[Float] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstDouble(f: PartialFunction[Short, Double]): Option[Double] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstByte(f: PartialFunction[Short, Byte]): Option[Byte] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstChar(f: PartialFunction[Short, Char]): Option[Char] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstShort(f: PartialFunction[Short, Short]): Option[Short] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstBoolean(f: PartialFunction[Short, Boolean]): Option[Boolean] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstRef[Y <: AnyRef :reflect.ClassTag](f: PartialFunction[Short, Y]): Option[Y] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }



  def foldLeftInt(z: Int)(f: (Int, Short) => Int): Int = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftLong(z: Long)(f: (Long, Short) => Long): Long = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftFloat(z: Float)(f: (Float, Short) => Float): Float = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftDouble(z: Double)(f: (Double, Short) => Double): Double = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftByte(z: Byte)(f: (Byte, Short) => Byte): Byte = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftChar(z: Char)(f: (Char, Short) => Char): Char = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftShort(z: Short)(f: (Short, Short) => Short): Short = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftBoolean(z: Boolean)(f: (Boolean, Short) => Boolean): Boolean = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftRef[Y](z: Y)(f: (Y, Short) => Y): Y = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }



  def foldRightInt(z: Int)(f: (Short, Int) => Int): Int = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightLong(z: Long)(f: (Short, Long) => Long): Long = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightFloat(z: Float)(f: (Short, Float) => Float): Float = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightDouble(z: Double)(f: (Short, Double) => Double): Double = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightByte(z: Byte)(f: (Short, Byte) => Byte): Byte = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightChar(z: Char)(f: (Short, Char) => Char): Char = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightShort(z: Short)(f: (Short, Short) => Short): Short = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightBoolean(z: Boolean)(f: (Short, Boolean) => Boolean): Boolean = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightRef[Y](z: Y)(f: (Short, Y) => Y): Y = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }



  def scanLeftInt(z: Int)(f: (Int, Short) => Int): ofInt = {
    val array = new Array[Int](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofInt(array)
  }


  def scanLeftLong(z: Long)(f: (Long, Short) => Long): ofLong = {
    val array = new Array[Long](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofLong(array)
  }


  def scanLeftFloat(z: Float)(f: (Float, Short) => Float): ofFloat = {
    val array = new Array[Float](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def scanLeftDouble(z: Double)(f: (Double, Short) => Double): ofDouble = {
    val array = new Array[Double](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def scanLeftByte(z: Byte)(f: (Byte, Short) => Byte): ofByte = {
    val array = new Array[Byte](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofByte(array)
  }


  def scanLeftChar(z: Char)(f: (Char, Short) => Char): ofChar = {
    val array = new Array[Char](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofChar(array)
  }


  def scanLeftShort(z: Short)(f: (Short, Short) => Short): ofShort = {
    val array = new Array[Short](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofShort(array)
  }


  def scanLeftBoolean(z: Boolean)(f: (Boolean, Short) => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def scanLeftRef[Y <: AnyRef :reflect.ClassTag](z: Y)(f: (Y, Short) => Y): ofRef[Y] = {
    val array = new Array[Y](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def scanRightInt(z: Int)(f: (Short, Int) => Int): ofInt = {
    val array = new Array[Int](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofInt(array)
  }


  def scanRightLong(z: Long)(f: (Short, Long) => Long): ofLong = {
    val array = new Array[Long](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofLong(array)
  }


  def scanRightFloat(z: Float)(f: (Short, Float) => Float): ofFloat = {
    val array = new Array[Float](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofFloat(array)
  }


  def scanRightDouble(z: Double)(f: (Short, Double) => Double): ofDouble = {
    val array = new Array[Double](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofDouble(array)
  }


  def scanRightByte(z: Byte)(f: (Short, Byte) => Byte): ofByte = {
    val array = new Array[Byte](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofByte(array)
  }


  def scanRightChar(z: Char)(f: (Short, Char) => Char): ofChar = {
    val array = new Array[Char](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofChar(array)
  }


  def scanRightShort(z: Short)(f: (Short, Short) => Short): ofShort = {
    val array = new Array[Short](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofShort(array)
  }


  def scanRightBoolean(z: Boolean)(f: (Short, Boolean) => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofBoolean(array)
  }


  def scanRightRef[Y <: AnyRef :reflect.ClassTag](z: Y)(f: (Short, Y) => Y): ofRef[Y] = {
    val array = new Array[Y](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofRef[Y](array)
  }



  def foldMapLeft1Int(z: Short => Int)(f: (Int, Short) => Int): Option[Int] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Long(z: Short => Long)(f: (Long, Short) => Long): Option[Long] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Float(z: Short => Float)(f: (Float, Short) => Float): Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Double(z: Short => Double)(f: (Double, Short) => Double): Option[Double] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Byte(z: Short => Byte)(f: (Byte, Short) => Byte): Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Char(z: Short => Char)(f: (Char, Short) => Char): Option[Char] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Short(z: Short => Short)(f: (Short, Short) => Short): Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Boolean(z: Short => Boolean)(f: (Boolean, Short) => Boolean): Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Ref[Y](z: Short => Y)(f: (Y, Short) => Y): Option[Y] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }



  def foldMapRight1Int(z: Short => Int)(f: (Short, Int) => Int): Option[Int] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Long(z: Short => Long)(f: (Short, Long) => Long): Option[Long] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Float(z: Short => Float)(f: (Short, Float) => Float): Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Double(z: Short => Double)(f: (Short, Double) => Double): Option[Double] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Byte(z: Short => Byte)(f: (Short, Byte) => Byte): Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Char(z: Short => Char)(f: (Short, Char) => Char): Option[Char] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Short(z: Short => Short)(f: (Short, Short) => Short): Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Boolean(z: Short => Boolean)(f: (Short, Boolean) => Boolean): Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Ref[Y](z: Short => Y)(f: (Short, Y) => Y): Option[Y] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }



  def map[A](f: Short => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => mapInt(f.asInstanceOf[Short => Int]).self
      case ClassTag.Long => mapLong(f.asInstanceOf[Short => Long]).self
      case ClassTag.Float => mapFloat(f.asInstanceOf[Short => Float]).self
      case ClassTag.Double => mapDouble(f.asInstanceOf[Short => Double]).self
      case ClassTag.Byte => mapByte(f.asInstanceOf[Short => Byte]).self
      case ClassTag.Char => mapChar(f.asInstanceOf[Short => Char]).self
      case ClassTag.Short => mapShort(f.asInstanceOf[Short => Short]).self
      case ClassTag.Boolean => mapBoolean(f.asInstanceOf[Short => Boolean]).self
      case _ => self.map(f)
    }).asInstanceOf[Array[A]]
  }



  def reverseMap[A](f: Short => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => reverseMapInt(f.asInstanceOf[Short => Int]).self
      case ClassTag.Long => reverseMapLong(f.asInstanceOf[Short => Long]).self
      case ClassTag.Float => reverseMapFloat(f.asInstanceOf[Short => Float]).self
      case ClassTag.Double => reverseMapDouble(f.asInstanceOf[Short => Double]).self
      case ClassTag.Byte => reverseMapByte(f.asInstanceOf[Short => Byte]).self
      case ClassTag.Char => reverseMapChar(f.asInstanceOf[Short => Char]).self
      case ClassTag.Short => reverseMapShort(f.asInstanceOf[Short => Short]).self
      case ClassTag.Boolean => reverseMapBoolean(f.asInstanceOf[Short => Boolean]).self
      case _ => self.reverseMap(f)
    }).asInstanceOf[Array[A]]
  }



  def flatMap[A](f: Short => Array[A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => flatMapInt(f.asInstanceOf[Short => Array[Int]]).self
      case ClassTag.Long => flatMapLong(f.asInstanceOf[Short => Array[Long]]).self
      case ClassTag.Float => flatMapFloat(f.asInstanceOf[Short => Array[Float]]).self
      case ClassTag.Double => flatMapDouble(f.asInstanceOf[Short => Array[Double]]).self
      case ClassTag.Byte => flatMapByte(f.asInstanceOf[Short => Array[Byte]]).self
      case ClassTag.Char => flatMapChar(f.asInstanceOf[Short => Array[Char]]).self
      case ClassTag.Short => flatMapShort(f.asInstanceOf[Short => Array[Short]]).self
      case ClassTag.Boolean => flatMapBoolean(f.asInstanceOf[Short => Array[Boolean]]).self
      case _ => self.flatMap(x => f(x))
    }).asInstanceOf[Array[A]]
  }



  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collect[A](f: PartialFunction[Short, A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => collectInt(f.asInstanceOf[PartialFunction[Short, Int]]).self
      case ClassTag.Long => collectLong(f.asInstanceOf[PartialFunction[Short, Long]]).self
      case ClassTag.Float => collectFloat(f.asInstanceOf[PartialFunction[Short, Float]]).self
      case ClassTag.Double => collectDouble(f.asInstanceOf[PartialFunction[Short, Double]]).self
      case ClassTag.Byte => collectByte(f.asInstanceOf[PartialFunction[Short, Byte]]).self
      case ClassTag.Char => collectChar(f.asInstanceOf[PartialFunction[Short, Char]]).self
      case ClassTag.Short => collectShort(f.asInstanceOf[PartialFunction[Short, Short]]).self
      case ClassTag.Boolean => collectBoolean(f.asInstanceOf[PartialFunction[Short, Boolean]]).self
      case _ => self.collect(f)
    }).asInstanceOf[Array[A]]
  }



  def collectFirst[A](f: PartialFunction[Short, A])(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => collectFirstInt(f.asInstanceOf[PartialFunction[Short, Int]])
      case ClassTag.Long => collectFirstLong(f.asInstanceOf[PartialFunction[Short, Long]])
      case ClassTag.Float => collectFirstFloat(f.asInstanceOf[PartialFunction[Short, Float]])
      case ClassTag.Double => collectFirstDouble(f.asInstanceOf[PartialFunction[Short, Double]])
      case ClassTag.Byte => collectFirstByte(f.asInstanceOf[PartialFunction[Short, Byte]])
      case ClassTag.Char => collectFirstChar(f.asInstanceOf[PartialFunction[Short, Char]])
      case ClassTag.Short => collectFirstShort(f.asInstanceOf[PartialFunction[Short, Short]])
      case ClassTag.Boolean => collectFirstBoolean(f.asInstanceOf[PartialFunction[Short, Boolean]])
      case _ => self.collectFirst(f)
    }).asInstanceOf[Option[A]]
  }



  def foldLeft[A](z: A)(f: (A, Short) => A)(implicit A: ClassTag[A]): A = {
    (A match {
      case ClassTag.Int => foldLeftInt(z.asInstanceOf[Int])(f.asInstanceOf[(Int, Short) => Int])
      case ClassTag.Long => foldLeftLong(z.asInstanceOf[Long])(f.asInstanceOf[(Long, Short) => Long])
      case ClassTag.Float => foldLeftFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Float, Short) => Float])
      case ClassTag.Double => foldLeftDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Double, Short) => Double])
      case ClassTag.Byte => foldLeftByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Byte, Short) => Byte])
      case ClassTag.Char => foldLeftChar(z.asInstanceOf[Char])(f.asInstanceOf[(Char, Short) => Char])
      case ClassTag.Short => foldLeftShort(z.asInstanceOf[Short])(f.asInstanceOf[(Short, Short) => Short])
      case ClassTag.Boolean => foldLeftBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Boolean, Short) => Boolean])
      case _ => self.foldLeft(z)(f)
    }).asInstanceOf[A]
  }



  def foldRight[A](z: A)(f: (Short, A) => A)(implicit A: ClassTag[A]): A = {
    (A match {
      case ClassTag.Int => foldRightInt(z.asInstanceOf[Int])(f.asInstanceOf[(Short, Int) => Int])
      case ClassTag.Long => foldRightLong(z.asInstanceOf[Long])(f.asInstanceOf[(Short, Long) => Long])
      case ClassTag.Float => foldRightFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Short, Float) => Float])
      case ClassTag.Double => foldRightDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Short, Double) => Double])
      case ClassTag.Byte => foldRightByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Short, Byte) => Byte])
      case ClassTag.Char => foldRightChar(z.asInstanceOf[Char])(f.asInstanceOf[(Short, Char) => Char])
      case ClassTag.Short => foldRightShort(z.asInstanceOf[Short])(f.asInstanceOf[(Short, Short) => Short])
      case ClassTag.Boolean => foldRightBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Short, Boolean) => Boolean])
      case _ => self.foldRight(z)(f)
    }).asInstanceOf[A]
  }



  def scanLeft[A](z: A)(f: (A, Short) => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => scanLeftInt(z.asInstanceOf[Int])(f.asInstanceOf[(Int, Short) => Int]).self
      case ClassTag.Long => scanLeftLong(z.asInstanceOf[Long])(f.asInstanceOf[(Long, Short) => Long]).self
      case ClassTag.Float => scanLeftFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Float, Short) => Float]).self
      case ClassTag.Double => scanLeftDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Double, Short) => Double]).self
      case ClassTag.Byte => scanLeftByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Byte, Short) => Byte]).self
      case ClassTag.Char => scanLeftChar(z.asInstanceOf[Char])(f.asInstanceOf[(Char, Short) => Char]).self
      case ClassTag.Short => scanLeftShort(z.asInstanceOf[Short])(f.asInstanceOf[(Short, Short) => Short]).self
      case ClassTag.Boolean => scanLeftBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Boolean, Short) => Boolean]).self
      case _ => self.scanLeft(z)(f)
    }).asInstanceOf[Array[A]]
  }



  def scanRight[A](z: A)(f: (Short, A) => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => scanRightInt(z.asInstanceOf[Int])(f.asInstanceOf[(Short, Int) => Int]).self
      case ClassTag.Long => scanRightLong(z.asInstanceOf[Long])(f.asInstanceOf[(Short, Long) => Long]).self
      case ClassTag.Float => scanRightFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Short, Float) => Float]).self
      case ClassTag.Double => scanRightDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Short, Double) => Double]).self
      case ClassTag.Byte => scanRightByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Short, Byte) => Byte]).self
      case ClassTag.Char => scanRightChar(z.asInstanceOf[Char])(f.asInstanceOf[(Short, Char) => Char]).self
      case ClassTag.Short => scanRightShort(z.asInstanceOf[Short])(f.asInstanceOf[(Short, Short) => Short]).self
      case ClassTag.Boolean => scanRightBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Short, Boolean) => Boolean]).self
      case _ => self.scanRight(z)(f)
    }).asInstanceOf[Array[A]]
  }



  def foldMapLeft1[A](z: Short => A)(f: (A, Short) => A)(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => foldMapLeft1Int(z.asInstanceOf[Short => Int])(f.asInstanceOf[(Int, Short) => Int])
      case ClassTag.Long => foldMapLeft1Long(z.asInstanceOf[Short => Long])(f.asInstanceOf[(Long, Short) => Long])
      case ClassTag.Float => foldMapLeft1Float(z.asInstanceOf[Short => Float])(f.asInstanceOf[(Float, Short) => Float])
      case ClassTag.Double => foldMapLeft1Double(z.asInstanceOf[Short => Double])(f.asInstanceOf[(Double, Short) => Double])
      case ClassTag.Byte => foldMapLeft1Byte(z.asInstanceOf[Short => Byte])(f.asInstanceOf[(Byte, Short) => Byte])
      case ClassTag.Char => foldMapLeft1Char(z.asInstanceOf[Short => Char])(f.asInstanceOf[(Char, Short) => Char])
      case ClassTag.Short => foldMapLeft1Short(z.asInstanceOf[Short => Short])(f.asInstanceOf[(Short, Short) => Short])
      case ClassTag.Boolean => foldMapLeft1Boolean(z.asInstanceOf[Short => Boolean])(f.asInstanceOf[(Boolean, Short) => Boolean])
      case _ => foldMapLeft1Ref(z)(f)
    }).asInstanceOf[Option[A]]
  }



  def foldMapRight1[A](z: Short => A)(f: (Short, A) => A)(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => foldMapRight1Int(z.asInstanceOf[Short => Int])(f.asInstanceOf[(Short, Int) => Int])
      case ClassTag.Long => foldMapRight1Long(z.asInstanceOf[Short => Long])(f.asInstanceOf[(Short, Long) => Long])
      case ClassTag.Float => foldMapRight1Float(z.asInstanceOf[Short => Float])(f.asInstanceOf[(Short, Float) => Float])
      case ClassTag.Double => foldMapRight1Double(z.asInstanceOf[Short => Double])(f.asInstanceOf[(Short, Double) => Double])
      case ClassTag.Byte => foldMapRight1Byte(z.asInstanceOf[Short => Byte])(f.asInstanceOf[(Short, Byte) => Byte])
      case ClassTag.Char => foldMapRight1Char(z.asInstanceOf[Short => Char])(f.asInstanceOf[(Short, Char) => Char])
      case ClassTag.Short => foldMapRight1Short(z.asInstanceOf[Short => Short])(f.asInstanceOf[(Short, Short) => Short])
      case ClassTag.Boolean => foldMapRight1Boolean(z.asInstanceOf[Short => Boolean])(f.asInstanceOf[(Short, Boolean) => Boolean])
      case _ => foldMapRight1Ref(z)(f)
    }).asInstanceOf[Option[A]]
  }


  def foreach[U](f: Short => U): Unit = {
    var i = 0
    while(i < self.length){
      f(self(i))
      i += 1
    }
  }

  def filter(f: Short => Boolean): ofShort = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        builder += self(i)
      }
      i += 1
    }
    new ofShort(builder.result)
  }

  def filterNot(f: Short => Boolean): ofShort = filter(!f(_))

  def withFilter(f: Short => Boolean): WithFilterShort =
    new WithFilterShort(this, f)

  def find(f: Short => Boolean): Option[Short] = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return Some(self(i))
      }
      i += 1
    }
    None
  }

  def exists(f: Short => Boolean): Boolean = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return true
      }
      i += 1
    }
    false
  }

  def forall(f: Short => Boolean): Boolean = !exists(!f(_))

  def take(n: Int): ofShort = {
    if(n >= self.length){
      this
    }else if(n <= 0){
      ofShort.empty
    }else{
      new ofShort(Arrays.copyOf(self, n ))
    }
  }

  def takeWhile(f: Short => Boolean): ofShort = {
    val len = index(!f(_))
    if(len < 0){
      this
    }else if(len == 0){
      ofShort.empty
    }else{
      new ofShort(Arrays.copyOf(self, len ))
    }
  }

  def takeWhileR(f: Short => Boolean): ofShort = {
    val len = lastIndex(f) + 1
    if(len <= 0){
      this
    }else if(len == self.length){
      ofShort.empty
    }else{
      new ofShort(Arrays.copyOfRange(self, len, self.length ))
    }
  }

  def takeRight(n: Int): ofShort = {
    if(n <= 0){
      ofShort.empty
    }else if(n >= self.length){
      this
    }else{
      val start = self.length - n
      new ofShort(Arrays.copyOfRange(self, start, self.length ))
    }
  }

  def reverse: ofShort = {
    var i = 0
    val len = self.length
    val array = new Array[Short](len)
    while(i < len){
      array(len - i - 1) = self(i)
      i += 1
    }
    new ofShort(array)
  }

  def reverse_:::(prefix: ofShort): ofShort = {
    if(prefix.length == 0){
      this
    }else{
      val array = new Array[Short](self.length + prefix.length)
      var i = 0
      val len = prefix.length
      while(i < len){
        array(i) = prefix.self(len - i - 1)
        i += 1
      }
      System.arraycopy(self, 0, array, prefix.length, self.length)
      new ofShort(array)
    }
  }

  def count(f: Short => Boolean): Int = {
    var i = 0
    var n = 0
    while(i < self.length){
      if(f(self(i))){
        n += 1
      }
      i += 1
    }
    n
  }

  def drop(n: Int): ofShort = {
    if(n <= 0){
      this
    }else if(n >= self.length){
      ofShort.empty
    }else{
      new ofShort(Arrays.copyOfRange(self, n, self.length ))
    }
  }

  def dropWhile(f: Short => Boolean): ofShort = {
    val len = index(!f(_))
    if(len < 0){
      ofShort.empty
    }else if(len == 0){
      this
    }else{
      new ofShort(Arrays.copyOfRange(self, len, self.length ))
    }
  }

  def dropWhileR(f: Short => Boolean): ofShort = {
    val len = lastIndex(f) + 1
    if(len <= 0){
      ofShort.empty
    }else if(len == self.length){
      this
    }else{
      new ofShort(Arrays.copyOf(self, len ))
    }
  }

  def dropRight(n: Int): ofShort = {
    if(n <= 0){
      this
    }else if(n >= self.length){
      ofShort.empty
    }else{
      new ofShort(Arrays.copyOf(self, self.length - n ))
    }
  }

  def contains(elem: Short): Boolean = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        return true
      }
      i += 1
    }
    false
  }

  def splitAt(n: Int): (ofShort, ofShort) = {
    if(n <= 0){
      (ofShort.empty, this)
    }else if(n >= self.length){
      (this, ofShort.empty)
    }else{
      (new ofShort(Arrays.copyOf(self, n )), new ofShort(Arrays.copyOfRange(self, n, self.length )))
    }
  }

  def span(f: Short => Boolean): (ofShort, ofShort) = {
    val n = index(!f(_))
    if(n < 0){
      (this, ofShort.empty)
    }else if(n >= self.length){
      (ofShort.empty, this)
    }else{
      (new ofShort(Arrays.copyOf(self, n )), new ofShort(Arrays.copyOfRange(self, n, self.length )))
    }
  }

  def ++(that: ofShort): ofShort = {
    if(self.length == 0){
      that
    }else if(that.length == 0){
      this
    }else{
      val size1 = self.length
      val size2 = that.length
      val array = new Array[Short](size1 + size2)
      System.arraycopy(self, 0, array, 0, size1)
      System.arraycopy(that.self, 0, array, size1, size2)
      new ofShort(array)
    }
  }

  def partition(f: Short => Boolean): (ofShort, ofShort) = {
    val l, r = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        l += self(i)
      }else{
        r += self(i)
      }
      i += 1
    }
    (new ofShort(l.result), new ofShort(r.result))
  }

  @throws[IndexOutOfBoundsException]
  def updated(index: Int, elem: Short): ofShort = {
    val array = self.clone
    array(index) = elem
    new ofShort(array)
  }

  def slice(from: Int, until: Int): ofShort = {
    if(until <= from || until <= 0 || from >= self.length){
      ofShort.empty
    }else if(from <= 0 && self.length <= until){
      this
    }else{
      new ofShort(Arrays.copyOfRange(self, from max 0, until min self.length ))
    }
  }

  def reduceLeftOption(f: (Short, Short) => Short): Option[Short] = {
    if(self.length == 0) return None

    var i = 1
    var acc = self(0)
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    Some(acc)
  }

  def reduceRightOption(f: (Short, Short) => Short): Option[Short] = {
    if(self.length == 0) return None

    var i = self.length - 2
    var acc = self(self.length - 1)
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    Some(acc)
  }

  def indexOf(elem: Short): Option[Int] = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        return Some(i)
      }
      i += 1
    }
    None
  }

  def lastIndexOf(elem: Short): Option[Int] = {
    var i = self.length - 1
    while(i >= 0){
      if(self(i) == elem){
        return Some(i)
      }
      i -= 1
    }
    None
  }

  def tailOption: Option[ofShort] = {
    if(self.length != 0){
      Some(drop(1))
    }else{
      None
    }
  }

  def tails: Iterator[ofShort] = new Iterator[ofShort]{
    private[this] var i = 0
    var hasNext = true
    def next: ofShort = {
      val r = new ofShort(Arrays.copyOfRange(self, i, self.length ))
      i += 1
      if(i > self.length) hasNext = false
      r
    }
  }

  def inits: Iterator[ofShort] = new Iterator[ofShort]{
    private[this] var i = self.length
    var hasNext = true
    def next: ofShort = {
      val r = new ofShort(Arrays.copyOfRange(self, 0, i ))
      i -= 1
      if(i < 0) hasNext = false
      r
    }
  }

  def initOption: Option[ofShort] = {
    if(self.length != 0){
      Some(dropRight(1))
    }else{
      None
    }
  }

  def length: Int = self.length

  def size: Int = self.length

  @inline private def index(f: Short => Boolean): Int = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return i
      }
      i += 1
    }
    -1
  }

  @inline private def lastIndex(f: Short => Boolean): Int = {
    var i = self.length - 1
    while(0 <= i){
      if(!f(self(i))){
        return i
      }
      i -= 1
    }
    -1
  }

  override def toString = mkString("ofShort(", ", ", ")")

  def mkString(start: String, sep: String, end: String): String =
    addString(new StringBuilder(), start, sep, end).toString

  def mkString(sep: String): String = mkString("", sep, "")

  def mkString: String = mkString("")

  def addString(b: StringBuilder, start: String, sep: String, end: String): StringBuilder = {
    var first = true

    b append start
    var i = 0
    while(i < self.length){
      if (first) {
        b append self(i)
        first = false
      }
      else {
        b append sep
        b append self(i)
      }
      i += 1
    }
    b append end

    b
  }

  def ===(that: ofShort): Boolean = Arrays.equals(self, that.self)

  @throws[IllegalArgumentException]
  def grouped(n: Int): Iterator[ofShort] = sliding(n, n)

  @throws[IllegalArgumentException]
  def sliding(_size: Int, step: Int = 1): Iterator[ofShort] = {
    require(_size > 0, "size must be positive number")
    require(step > 0, "step must be positive number")
    new Iterator[ofShort]{
      private[this] var i = 0
      var hasNext = self.length != 0
      def next = {
        // n is negative, if `i + _size` overflow
        val n = i + _size
        val until = if(n > 0) math.min(n, self.length) else self.length
        val r = new ofShort(Arrays.copyOfRange(self, i, until ))
        i += step
        if(i >= self.length || n > self.length || n < 0) hasNext = false
        r
      }
    }
  }

  def scanLeft1(f: (Short, Short) => Short): ofShort = {
    if(self.length != 0){
      val array = new Array[Short](self.length)
      array(0) = self(0)
      var i = 0
      while(i < self.length - 1){
        array(i + 1) = f(array(i), self(i + 1))
        i += 1
      }
      new ofShort(array)
    }else{
      ofShort.empty
    }
  }

  def scanRight1(f: (Short, Short) => Short): ofShort = {
    if(self.length != 0){
      val array = new Array[Short](self.length)
      array(self.length - 1) = self(self.length - 1)
      var i = self.length - 1
      while(i > 0){
        array(i - 1) = f(self(i - 1), array(i))
        i -= 1
      }
      new ofShort(array)
    }else{
      ofShort.empty
    }
  }

  def startsWith(that: Array[Short], offset: Int = 0): Boolean = {
    require(offset >= 0, "offset = " + offset  + " is invalid. offset must be positive")
    var i = offset
    var j = 0
    val thisLen = self.length
    val thatLen = that.length
    while (i < thisLen && j < thatLen && self(i) == that(j)) {
      i += 1
      j += 1
    }
    j == thatLen
  }

  def endsWith(that: Array[Short]): Boolean = {
    var i = length - 1
    var j = that.length - 1

    (j <= i) && {
      while (j >= 0){
        if(self(i) != that(j)){
          return false
        }
        i -= 1
        j -= 1
      }
      true
    }
  }

  def groupBy[A](f: Short => A): Map[A, ofShort] = {
    val m = collection.mutable.Map.empty[A, ArrayBuilder.ofShort]
    var i = 0
    while(i < self.length){
      val key = f(self(i))
      m.getOrElseUpdate(key, new ArrayBuilder.ofShort) += self(i)
      i += 1
    }

    val b = Map.newBuilder[A, ofShort]
    m.foreach{ case (k, v) =>
      b += ((k, new ofShort(v.result)))
    }

    b.result
  }

  def maxBy[A](f: Short => A)(implicit A: Ordering[A]): Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var maxF = f(self(0))
      var maxElem = self(0)
      var i = 1
      while(i < self.length){
        val fx = f(self(i))
        if (A.gt(fx, maxF)) {
          maxElem = self(i)
          maxF = fx
        }
        i += 1
      }
      Some(maxElem)
    }
  }

  def minBy[A](f: Short => A)(implicit A: Ordering[A]): Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var minF = f(self(0))
      var minElem = self(0)
      var i = 1
      while(i < self.length){
        val fx = f(self(i))
        if (A.lt(fx, minF)) {
          minElem = self(i)
          minF = fx
        }
        i += 1
      }
      Some(minElem)
    }
  }

  def deleteFirst(elem: Short): ofShort = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        val array = new Array[Short](self.length - 1)
        System.arraycopy(self, 0, array, 0, i)
        System.arraycopy(self, i + 1, array, i, self.length - i - 1)
        return new ofShort(array)
      }
      i += 1
    }
    this
  }

  def intersperse(a: Short): ofShort = {
    if(self.length == 0){
      ofShort.empty
    }else{
      val array = new Array[Short]((self.length * 2) - 1)
      var i = 0
      java.util.Arrays.fill(array, a)
      while(i < self.length){
        array(i * 2) = self(i)
        i += 1
      }
      new ofShort(array)
    }
  }
}

object ofShort {

  def apply(elems: Short *): ofShort = elems match{
    case a: collection.mutable.WrappedArray.ofShort => new ofShort(a.array)
    case _ => new ofShort(elems.toArray)
  }

  val empty: ofShort = new ofShort(new Array[Short](0))

  def iterate(start: Short, len: Int)(f: Short => Short): ofShort = {
    if(len == 0){
      empty
    }else{
      val array = new Array[Short](len)
      var i = 1
      array(0) = start
      while (i < len) {
        array(i) = f(array(i - 1))
        i += 1
      }
      new ofShort(array)
    }
  }

  def tabulate(n: Int)(f: Int => Short): ofShort = {
    val array = new Array[Short](n)
    var i = 0
    while (i < n) {
      array(i) = f(i)
      i += 1
    }
    new ofShort(array)
  }

  def flatten(xs: Array[Array[Short]]): ofShort = {
    var i = 0
    var n = 0
    val length = xs.length
    while(i < length){
      n += xs(i).length
      i += 1
    }
    val array = new Array[Short](n)
    i = 0
    n = 0
    while(i < length){
      val elem = xs(i)
      System.arraycopy(elem, 0, array, n, elem.length)
      n += elem.length
      i += 1
    }
    new ofShort(array)
  }

  def fillAll(size: Int)(elem: Short): ofShort = {
    val array = new Array[Short](size)
    Arrays.fill(array, elem)
    new ofShort(array)
  }

  def fill(size: Int)(f: => Short): ofShort = {
    val array = new Array[Short](size)
    var i = 0
    while(i < size){
      array(i) = f
      i += 1
    }
    new ofShort(array)
  }

  def unfold[@specialized B ](z: B)(f: B => Option[(B, Short)]): ofShort = {
    val builder = new ArrayBuilder.ofShort()
    @annotation.tailrec
    def loop(next: Option[(B, Short)]): Unit = next match {
      case Some((b, a)) =>
        builder += a
        loop(f(b))
      case None =>
    }
    loop(f(z))
    new ofShort(builder.result)
  }

}

