package nobox

import java.util.Arrays
import scala.reflect.ClassTag
import scala.collection.mutable.ArrayBuilder

final class WithFilterRef[X <: AnyRef :reflect.ClassTag] private[nobox](self: ofRef[X], f: X => Boolean){
  
  def map[A](g: X => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => mapInt(g.asInstanceOf[X => Int])
      case ClassTag.Long => mapLong(g.asInstanceOf[X => Long])
      case ClassTag.Float => mapFloat(g.asInstanceOf[X => Float])
      case ClassTag.Double => mapDouble(g.asInstanceOf[X => Double])
      case ClassTag.Byte => mapByte(g.asInstanceOf[X => Byte])
      case ClassTag.Char => mapChar(g.asInstanceOf[X => Char])
      case ClassTag.Short => mapShort(g.asInstanceOf[X => Short])
      case ClassTag.Boolean => mapBoolean(g.asInstanceOf[X => Boolean])
      case _ => self.filter(f).map(g) // TODO
    }).asInstanceOf[Array[A]]
  }


  def flatMap[A](g: X => Array[A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => flatMapInt(g.asInstanceOf[X => Array[Int]])
      case ClassTag.Long => flatMapLong(g.asInstanceOf[X => Array[Long]])
      case ClassTag.Float => flatMapFloat(g.asInstanceOf[X => Array[Float]])
      case ClassTag.Double => flatMapDouble(g.asInstanceOf[X => Array[Double]])
      case ClassTag.Byte => flatMapByte(g.asInstanceOf[X => Array[Byte]])
      case ClassTag.Char => flatMapChar(g.asInstanceOf[X => Array[Char]])
      case ClassTag.Short => flatMapShort(g.asInstanceOf[X => Array[Short]])
      case ClassTag.Boolean => flatMapBoolean(g.asInstanceOf[X => Array[Boolean]])
      case _ => self.filter(f).flatMap(g) // TODO
    }).asInstanceOf[Array[A]]
  }


  def foreach[U](g: X => U): Unit = {
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        g(self.self(i))
      }
      i += 1
    }
  }


  def withFilter(g: X => Boolean): WithFilterRef[X] =
    new WithFilterRef[X](self, {a => f(a) && g(a)})


  def mapInt(g: X => Int): Array[Int] = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapLong(g: X => Long): Array[Long] = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapFloat(g: X => Float): Array[Float] = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapDouble(g: X => Double): Array[Double] = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapByte(g: X => Byte): Array[Byte] = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapChar(g: X => Char): Array[Char] = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapShort(g: X => Short): Array[Short] = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapBoolean(g: X => Boolean): Array[Boolean] = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def flatMapInt(g: X => Array[Int]): Array[Int] = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapLong(g: X => Array[Long]): Array[Long] = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapFloat(g: X => Array[Float]): Array[Float] = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapDouble(g: X => Array[Double]): Array[Double] = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapByte(g: X => Array[Byte]): Array[Byte] = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapChar(g: X => Array[Char]): Array[Char] = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapShort(g: X => Array[Short]): Array[Short] = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapBoolean(g: X => Array[Boolean]): Array[Boolean] = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }

}

final class ofRef[X <: AnyRef :reflect.ClassTag] (val self: Array[X]) extends AnyRef {

  
  def sum(implicit X: Numeric[X]): X = {
    var i = 0
    var n = X.zero
    while(i < self.length){
      n = X.plus(n, self(i))
      i += 1
    }
    n
  }











  def sorted(implicit ord: Ordering[X]): ofRef[X] = {
    val array = self.clone
    Arrays.sort(array.asInstanceOf[Array[Object]], ord.asInstanceOf[Ordering[Object]])
    new ofRef[X](array)
  }



  def max[B >: X](implicit O: Ordering[B]): Option[X] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var n = self(0)
      while(i < self.length){
        val x = self(i)
        if(O.gt(x, n)){
          n = x
        }
        i += 1
      }
      Some(n)
    }
  }

  def min[B >: X](implicit O: Ordering[B]): Option[X] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var n = self(0)
      while(i < self.length){
        val x = self(i)
        if(O.lt(x, n)){
          n = x
        }
        i += 1
      }
      Some(n)
    }
  }

  def minmax[B >: X](implicit O: Ordering[B]): Option[(X, X)] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var _min, _max = self(0)
      while(i < self.length){
        val x = self(i)
        if(O.lt(x, _min)){
          _min = x
        }else if(O.gt(x, _max)){
          _max = x
        }
        i += 1
      }
      Some((_min, _max))
    }
  }



  def flatten[E](implicit E: X <:< Array[E]): Array[E] =
    (self.getClass.getComponentType.getComponentType match {
      case Clazz.Int => ofInt.flatten(self.asInstanceOf[Array[Array[Int]]]).self
      case Clazz.Long => ofLong.flatten(self.asInstanceOf[Array[Array[Long]]]).self
      case Clazz.Float => ofFloat.flatten(self.asInstanceOf[Array[Array[Float]]]).self
      case Clazz.Double => ofDouble.flatten(self.asInstanceOf[Array[Array[Double]]]).self
      case Clazz.Byte => ofByte.flatten(self.asInstanceOf[Array[Array[Byte]]]).self
      case Clazz.Char => ofChar.flatten(self.asInstanceOf[Array[Array[Char]]]).self
      case Clazz.Short => ofShort.flatten(self.asInstanceOf[Array[Array[Short]]]).self
      case Clazz.Boolean => ofBoolean.flatten(self.asInstanceOf[Array[Array[Boolean]]]).self
      case c => ofRef.flatten[E with AnyRef](self.asInstanceOf[Array[Array[E with AnyRef]]])(ClassTag(c)).self
    }).asInstanceOf[Array[E]]

  
  def mapInt(f: X => Int): ofInt = {
    val array = new Array[Int](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofInt(array)
  }


  def mapLong(f: X => Long): ofLong = {
    val array = new Array[Long](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofLong(array)
  }


  def mapFloat(f: X => Float): ofFloat = {
    val array = new Array[Float](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def mapDouble(f: X => Double): ofDouble = {
    val array = new Array[Double](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def mapByte(f: X => Byte): ofByte = {
    val array = new Array[Byte](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofByte(array)
  }


  def mapChar(f: X => Char): ofChar = {
    val array = new Array[Char](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofChar(array)
  }


  def mapShort(f: X => Short): ofShort = {
    val array = new Array[Short](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofShort(array)
  }


  def mapBoolean(f: X => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def mapRef[Y <: AnyRef :reflect.ClassTag](f: X => Y): ofRef[Y] = {
    val array = new Array[Y](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def reverseMapInt(f: X => Int): ofInt = {
    val len = self.length
    val array = new Array[Int](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofInt(array)
  }


  def reverseMapLong(f: X => Long): ofLong = {
    val len = self.length
    val array = new Array[Long](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofLong(array)
  }


  def reverseMapFloat(f: X => Float): ofFloat = {
    val len = self.length
    val array = new Array[Float](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def reverseMapDouble(f: X => Double): ofDouble = {
    val len = self.length
    val array = new Array[Double](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def reverseMapByte(f: X => Byte): ofByte = {
    val len = self.length
    val array = new Array[Byte](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofByte(array)
  }


  def reverseMapChar(f: X => Char): ofChar = {
    val len = self.length
    val array = new Array[Char](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofChar(array)
  }


  def reverseMapShort(f: X => Short): ofShort = {
    val len = self.length
    val array = new Array[Short](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofShort(array)
  }


  def reverseMapBoolean(f: X => Boolean): ofBoolean = {
    val len = self.length
    val array = new Array[Boolean](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def reverseMapRef[Y <: AnyRef :reflect.ClassTag](f: X => Y): ofRef[Y] = {
    val len = self.length
    val array = new Array[Y](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def flatMapInt(f: X => Array[Int]): ofInt = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofInt(builder.result)
  }


  def flatMapLong(f: X => Array[Long]): ofLong = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofLong(builder.result)
  }


  def flatMapFloat(f: X => Array[Float]): ofFloat = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofFloat(builder.result)
  }


  def flatMapDouble(f: X => Array[Double]): ofDouble = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofDouble(builder.result)
  }


  def flatMapByte(f: X => Array[Byte]): ofByte = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofByte(builder.result)
  }


  def flatMapChar(f: X => Array[Char]): ofChar = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofChar(builder.result)
  }


  def flatMapShort(f: X => Array[Short]): ofShort = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofShort(builder.result)
  }


  def flatMapBoolean(f: X => Array[Boolean]): ofBoolean = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofBoolean(builder.result)
  }


  def flatMapRef[Y <: AnyRef :reflect.ClassTag](f: X => Array[Y]): ofRef[Y] = {
    val builder = new ArrayBuilder.ofRef[Y]()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofRef[Y](builder.result)
  }



  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectInt(f: PartialFunction[X, Int]): ofInt = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofInt(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectLong(f: PartialFunction[X, Long]): ofLong = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofLong(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectFloat(f: PartialFunction[X, Float]): ofFloat = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofFloat(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectDouble(f: PartialFunction[X, Double]): ofDouble = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofDouble(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectByte(f: PartialFunction[X, Byte]): ofByte = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofByte(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectChar(f: PartialFunction[X, Char]): ofChar = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofChar(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectShort(f: PartialFunction[X, Short]): ofShort = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofShort(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectBoolean(f: PartialFunction[X, Boolean]): ofBoolean = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofBoolean(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectRef[Y <: AnyRef :reflect.ClassTag](f: PartialFunction[X, Y]): ofRef[Y] = {
    val builder = new ArrayBuilder.ofRef[Y]()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofRef[Y](builder.result)
  }



  def collectFirstInt(f: PartialFunction[X, Int]): Option[Int] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstLong(f: PartialFunction[X, Long]): Option[Long] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstFloat(f: PartialFunction[X, Float]): Option[Float] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstDouble(f: PartialFunction[X, Double]): Option[Double] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstByte(f: PartialFunction[X, Byte]): Option[Byte] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstChar(f: PartialFunction[X, Char]): Option[Char] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstShort(f: PartialFunction[X, Short]): Option[Short] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstBoolean(f: PartialFunction[X, Boolean]): Option[Boolean] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstRef[Y <: AnyRef :reflect.ClassTag](f: PartialFunction[X, Y]): Option[Y] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }



  def foldLeftInt(z: Int)(f: (Int, X) => Int): Int = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftLong(z: Long)(f: (Long, X) => Long): Long = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftFloat(z: Float)(f: (Float, X) => Float): Float = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftDouble(z: Double)(f: (Double, X) => Double): Double = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftByte(z: Byte)(f: (Byte, X) => Byte): Byte = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftChar(z: Char)(f: (Char, X) => Char): Char = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftShort(z: Short)(f: (Short, X) => Short): Short = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftBoolean(z: Boolean)(f: (Boolean, X) => Boolean): Boolean = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftRef[Y](z: Y)(f: (Y, X) => Y): Y = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }



  def foldRightInt(z: Int)(f: (X, Int) => Int): Int = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightLong(z: Long)(f: (X, Long) => Long): Long = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightFloat(z: Float)(f: (X, Float) => Float): Float = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightDouble(z: Double)(f: (X, Double) => Double): Double = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightByte(z: Byte)(f: (X, Byte) => Byte): Byte = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightChar(z: Char)(f: (X, Char) => Char): Char = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightShort(z: Short)(f: (X, Short) => Short): Short = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightBoolean(z: Boolean)(f: (X, Boolean) => Boolean): Boolean = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightRef[Y](z: Y)(f: (X, Y) => Y): Y = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }



  def scanLeftInt(z: Int)(f: (Int, X) => Int): ofInt = {
    val array = new Array[Int](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofInt(array)
  }


  def scanLeftLong(z: Long)(f: (Long, X) => Long): ofLong = {
    val array = new Array[Long](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofLong(array)
  }


  def scanLeftFloat(z: Float)(f: (Float, X) => Float): ofFloat = {
    val array = new Array[Float](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def scanLeftDouble(z: Double)(f: (Double, X) => Double): ofDouble = {
    val array = new Array[Double](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def scanLeftByte(z: Byte)(f: (Byte, X) => Byte): ofByte = {
    val array = new Array[Byte](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofByte(array)
  }


  def scanLeftChar(z: Char)(f: (Char, X) => Char): ofChar = {
    val array = new Array[Char](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofChar(array)
  }


  def scanLeftShort(z: Short)(f: (Short, X) => Short): ofShort = {
    val array = new Array[Short](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofShort(array)
  }


  def scanLeftBoolean(z: Boolean)(f: (Boolean, X) => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def scanLeftRef[Y <: AnyRef :reflect.ClassTag](z: Y)(f: (Y, X) => Y): ofRef[Y] = {
    val array = new Array[Y](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def scanRightInt(z: Int)(f: (X, Int) => Int): ofInt = {
    val array = new Array[Int](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofInt(array)
  }


  def scanRightLong(z: Long)(f: (X, Long) => Long): ofLong = {
    val array = new Array[Long](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofLong(array)
  }


  def scanRightFloat(z: Float)(f: (X, Float) => Float): ofFloat = {
    val array = new Array[Float](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofFloat(array)
  }


  def scanRightDouble(z: Double)(f: (X, Double) => Double): ofDouble = {
    val array = new Array[Double](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofDouble(array)
  }


  def scanRightByte(z: Byte)(f: (X, Byte) => Byte): ofByte = {
    val array = new Array[Byte](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofByte(array)
  }


  def scanRightChar(z: Char)(f: (X, Char) => Char): ofChar = {
    val array = new Array[Char](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofChar(array)
  }


  def scanRightShort(z: Short)(f: (X, Short) => Short): ofShort = {
    val array = new Array[Short](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofShort(array)
  }


  def scanRightBoolean(z: Boolean)(f: (X, Boolean) => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofBoolean(array)
  }


  def scanRightRef[Y <: AnyRef :reflect.ClassTag](z: Y)(f: (X, Y) => Y): ofRef[Y] = {
    val array = new Array[Y](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofRef[Y](array)
  }



  def foldMapLeft1Int(z: X => Int)(f: (Int, X) => Int): Option[Int] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Long(z: X => Long)(f: (Long, X) => Long): Option[Long] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Float(z: X => Float)(f: (Float, X) => Float): Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Double(z: X => Double)(f: (Double, X) => Double): Option[Double] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Byte(z: X => Byte)(f: (Byte, X) => Byte): Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Char(z: X => Char)(f: (Char, X) => Char): Option[Char] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Short(z: X => Short)(f: (Short, X) => Short): Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Boolean(z: X => Boolean)(f: (Boolean, X) => Boolean): Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Ref[Y](z: X => Y)(f: (Y, X) => Y): Option[Y] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }



  def foldMapRight1Int(z: X => Int)(f: (X, Int) => Int): Option[Int] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Long(z: X => Long)(f: (X, Long) => Long): Option[Long] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Float(z: X => Float)(f: (X, Float) => Float): Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Double(z: X => Double)(f: (X, Double) => Double): Option[Double] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Byte(z: X => Byte)(f: (X, Byte) => Byte): Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Char(z: X => Char)(f: (X, Char) => Char): Option[Char] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Short(z: X => Short)(f: (X, Short) => Short): Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Boolean(z: X => Boolean)(f: (X, Boolean) => Boolean): Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Ref[Y](z: X => Y)(f: (X, Y) => Y): Option[Y] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }



  def map[A](f: X => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => mapInt(f.asInstanceOf[X => Int]).self
      case ClassTag.Long => mapLong(f.asInstanceOf[X => Long]).self
      case ClassTag.Float => mapFloat(f.asInstanceOf[X => Float]).self
      case ClassTag.Double => mapDouble(f.asInstanceOf[X => Double]).self
      case ClassTag.Byte => mapByte(f.asInstanceOf[X => Byte]).self
      case ClassTag.Char => mapChar(f.asInstanceOf[X => Char]).self
      case ClassTag.Short => mapShort(f.asInstanceOf[X => Short]).self
      case ClassTag.Boolean => mapBoolean(f.asInstanceOf[X => Boolean]).self
      case _ => self.map(f)
    }).asInstanceOf[Array[A]]
  }



  def reverseMap[A](f: X => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => reverseMapInt(f.asInstanceOf[X => Int]).self
      case ClassTag.Long => reverseMapLong(f.asInstanceOf[X => Long]).self
      case ClassTag.Float => reverseMapFloat(f.asInstanceOf[X => Float]).self
      case ClassTag.Double => reverseMapDouble(f.asInstanceOf[X => Double]).self
      case ClassTag.Byte => reverseMapByte(f.asInstanceOf[X => Byte]).self
      case ClassTag.Char => reverseMapChar(f.asInstanceOf[X => Char]).self
      case ClassTag.Short => reverseMapShort(f.asInstanceOf[X => Short]).self
      case ClassTag.Boolean => reverseMapBoolean(f.asInstanceOf[X => Boolean]).self
      case _ => self.reverseMap(f)
    }).asInstanceOf[Array[A]]
  }



  def flatMap[A](f: X => Array[A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => flatMapInt(f.asInstanceOf[X => Array[Int]]).self
      case ClassTag.Long => flatMapLong(f.asInstanceOf[X => Array[Long]]).self
      case ClassTag.Float => flatMapFloat(f.asInstanceOf[X => Array[Float]]).self
      case ClassTag.Double => flatMapDouble(f.asInstanceOf[X => Array[Double]]).self
      case ClassTag.Byte => flatMapByte(f.asInstanceOf[X => Array[Byte]]).self
      case ClassTag.Char => flatMapChar(f.asInstanceOf[X => Array[Char]]).self
      case ClassTag.Short => flatMapShort(f.asInstanceOf[X => Array[Short]]).self
      case ClassTag.Boolean => flatMapBoolean(f.asInstanceOf[X => Array[Boolean]]).self
      case _ => self.flatMap(x => f(x))
    }).asInstanceOf[Array[A]]
  }



  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collect[A](f: PartialFunction[X, A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => collectInt(f.asInstanceOf[PartialFunction[X, Int]]).self
      case ClassTag.Long => collectLong(f.asInstanceOf[PartialFunction[X, Long]]).self
      case ClassTag.Float => collectFloat(f.asInstanceOf[PartialFunction[X, Float]]).self
      case ClassTag.Double => collectDouble(f.asInstanceOf[PartialFunction[X, Double]]).self
      case ClassTag.Byte => collectByte(f.asInstanceOf[PartialFunction[X, Byte]]).self
      case ClassTag.Char => collectChar(f.asInstanceOf[PartialFunction[X, Char]]).self
      case ClassTag.Short => collectShort(f.asInstanceOf[PartialFunction[X, Short]]).self
      case ClassTag.Boolean => collectBoolean(f.asInstanceOf[PartialFunction[X, Boolean]]).self
      case _ => self.collect(f)
    }).asInstanceOf[Array[A]]
  }



  def collectFirst[A](f: PartialFunction[X, A])(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => collectFirstInt(f.asInstanceOf[PartialFunction[X, Int]])
      case ClassTag.Long => collectFirstLong(f.asInstanceOf[PartialFunction[X, Long]])
      case ClassTag.Float => collectFirstFloat(f.asInstanceOf[PartialFunction[X, Float]])
      case ClassTag.Double => collectFirstDouble(f.asInstanceOf[PartialFunction[X, Double]])
      case ClassTag.Byte => collectFirstByte(f.asInstanceOf[PartialFunction[X, Byte]])
      case ClassTag.Char => collectFirstChar(f.asInstanceOf[PartialFunction[X, Char]])
      case ClassTag.Short => collectFirstShort(f.asInstanceOf[PartialFunction[X, Short]])
      case ClassTag.Boolean => collectFirstBoolean(f.asInstanceOf[PartialFunction[X, Boolean]])
      case _ => self.collectFirst(f)
    }).asInstanceOf[Option[A]]
  }



  def foldLeft[A](z: A)(f: (A, X) => A)(implicit A: ClassTag[A]): A = {
    (A match {
      case ClassTag.Int => foldLeftInt(z.asInstanceOf[Int])(f.asInstanceOf[(Int, X) => Int])
      case ClassTag.Long => foldLeftLong(z.asInstanceOf[Long])(f.asInstanceOf[(Long, X) => Long])
      case ClassTag.Float => foldLeftFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Float, X) => Float])
      case ClassTag.Double => foldLeftDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Double, X) => Double])
      case ClassTag.Byte => foldLeftByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Byte, X) => Byte])
      case ClassTag.Char => foldLeftChar(z.asInstanceOf[Char])(f.asInstanceOf[(Char, X) => Char])
      case ClassTag.Short => foldLeftShort(z.asInstanceOf[Short])(f.asInstanceOf[(Short, X) => Short])
      case ClassTag.Boolean => foldLeftBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Boolean, X) => Boolean])
      case _ => self.foldLeft(z)(f)
    }).asInstanceOf[A]
  }



  def foldRight[A](z: A)(f: (X, A) => A)(implicit A: ClassTag[A]): A = {
    (A match {
      case ClassTag.Int => foldRightInt(z.asInstanceOf[Int])(f.asInstanceOf[(X, Int) => Int])
      case ClassTag.Long => foldRightLong(z.asInstanceOf[Long])(f.asInstanceOf[(X, Long) => Long])
      case ClassTag.Float => foldRightFloat(z.asInstanceOf[Float])(f.asInstanceOf[(X, Float) => Float])
      case ClassTag.Double => foldRightDouble(z.asInstanceOf[Double])(f.asInstanceOf[(X, Double) => Double])
      case ClassTag.Byte => foldRightByte(z.asInstanceOf[Byte])(f.asInstanceOf[(X, Byte) => Byte])
      case ClassTag.Char => foldRightChar(z.asInstanceOf[Char])(f.asInstanceOf[(X, Char) => Char])
      case ClassTag.Short => foldRightShort(z.asInstanceOf[Short])(f.asInstanceOf[(X, Short) => Short])
      case ClassTag.Boolean => foldRightBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(X, Boolean) => Boolean])
      case _ => self.foldRight(z)(f)
    }).asInstanceOf[A]
  }



  def scanLeft[A](z: A)(f: (A, X) => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => scanLeftInt(z.asInstanceOf[Int])(f.asInstanceOf[(Int, X) => Int]).self
      case ClassTag.Long => scanLeftLong(z.asInstanceOf[Long])(f.asInstanceOf[(Long, X) => Long]).self
      case ClassTag.Float => scanLeftFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Float, X) => Float]).self
      case ClassTag.Double => scanLeftDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Double, X) => Double]).self
      case ClassTag.Byte => scanLeftByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Byte, X) => Byte]).self
      case ClassTag.Char => scanLeftChar(z.asInstanceOf[Char])(f.asInstanceOf[(Char, X) => Char]).self
      case ClassTag.Short => scanLeftShort(z.asInstanceOf[Short])(f.asInstanceOf[(Short, X) => Short]).self
      case ClassTag.Boolean => scanLeftBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Boolean, X) => Boolean]).self
      case _ => self.scanLeft(z)(f)
    }).asInstanceOf[Array[A]]
  }



  def scanRight[A](z: A)(f: (X, A) => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => scanRightInt(z.asInstanceOf[Int])(f.asInstanceOf[(X, Int) => Int]).self
      case ClassTag.Long => scanRightLong(z.asInstanceOf[Long])(f.asInstanceOf[(X, Long) => Long]).self
      case ClassTag.Float => scanRightFloat(z.asInstanceOf[Float])(f.asInstanceOf[(X, Float) => Float]).self
      case ClassTag.Double => scanRightDouble(z.asInstanceOf[Double])(f.asInstanceOf[(X, Double) => Double]).self
      case ClassTag.Byte => scanRightByte(z.asInstanceOf[Byte])(f.asInstanceOf[(X, Byte) => Byte]).self
      case ClassTag.Char => scanRightChar(z.asInstanceOf[Char])(f.asInstanceOf[(X, Char) => Char]).self
      case ClassTag.Short => scanRightShort(z.asInstanceOf[Short])(f.asInstanceOf[(X, Short) => Short]).self
      case ClassTag.Boolean => scanRightBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(X, Boolean) => Boolean]).self
      case _ => self.scanRight(z)(f)
    }).asInstanceOf[Array[A]]
  }



  def foldMapLeft1[A](z: X => A)(f: (A, X) => A)(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => foldMapLeft1Int(z.asInstanceOf[X => Int])(f.asInstanceOf[(Int, X) => Int])
      case ClassTag.Long => foldMapLeft1Long(z.asInstanceOf[X => Long])(f.asInstanceOf[(Long, X) => Long])
      case ClassTag.Float => foldMapLeft1Float(z.asInstanceOf[X => Float])(f.asInstanceOf[(Float, X) => Float])
      case ClassTag.Double => foldMapLeft1Double(z.asInstanceOf[X => Double])(f.asInstanceOf[(Double, X) => Double])
      case ClassTag.Byte => foldMapLeft1Byte(z.asInstanceOf[X => Byte])(f.asInstanceOf[(Byte, X) => Byte])
      case ClassTag.Char => foldMapLeft1Char(z.asInstanceOf[X => Char])(f.asInstanceOf[(Char, X) => Char])
      case ClassTag.Short => foldMapLeft1Short(z.asInstanceOf[X => Short])(f.asInstanceOf[(Short, X) => Short])
      case ClassTag.Boolean => foldMapLeft1Boolean(z.asInstanceOf[X => Boolean])(f.asInstanceOf[(Boolean, X) => Boolean])
      case _ => foldMapLeft1Ref(z)(f)
    }).asInstanceOf[Option[A]]
  }



  def foldMapRight1[A](z: X => A)(f: (X, A) => A)(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => foldMapRight1Int(z.asInstanceOf[X => Int])(f.asInstanceOf[(X, Int) => Int])
      case ClassTag.Long => foldMapRight1Long(z.asInstanceOf[X => Long])(f.asInstanceOf[(X, Long) => Long])
      case ClassTag.Float => foldMapRight1Float(z.asInstanceOf[X => Float])(f.asInstanceOf[(X, Float) => Float])
      case ClassTag.Double => foldMapRight1Double(z.asInstanceOf[X => Double])(f.asInstanceOf[(X, Double) => Double])
      case ClassTag.Byte => foldMapRight1Byte(z.asInstanceOf[X => Byte])(f.asInstanceOf[(X, Byte) => Byte])
      case ClassTag.Char => foldMapRight1Char(z.asInstanceOf[X => Char])(f.asInstanceOf[(X, Char) => Char])
      case ClassTag.Short => foldMapRight1Short(z.asInstanceOf[X => Short])(f.asInstanceOf[(X, Short) => Short])
      case ClassTag.Boolean => foldMapRight1Boolean(z.asInstanceOf[X => Boolean])(f.asInstanceOf[(X, Boolean) => Boolean])
      case _ => foldMapRight1Ref(z)(f)
    }).asInstanceOf[Option[A]]
  }


  def foreach[U](f: X => U): Unit = {
    var i = 0
    while(i < self.length){
      f(self(i))
      i += 1
    }
  }

  def filter(f: X => Boolean): ofRef[X] = {
    val builder = new ArrayBuilder.ofRef[X]()
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        builder += self(i)
      }
      i += 1
    }
    new ofRef[X](builder.result)
  }

  def filterNot(f: X => Boolean): ofRef[X] = filter(!f(_))

  def withFilter(f: X => Boolean): WithFilterRef[X] =
    new WithFilterRef[X](this, f)

  def find(f: X => Boolean): Option[X] = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return Some(self(i))
      }
      i += 1
    }
    None
  }

  def exists(f: X => Boolean): Boolean = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return true
      }
      i += 1
    }
    false
  }

  def forall(f: X => Boolean): Boolean = !exists(!f(_))

  def take(n: Int): ofRef[X] = {
    if(n >= self.length){
      this
    }else if(n <= 0){
      ofRef.empty[X]
    }else{
      new ofRef[X](Arrays.copyOf[X](self.asInstanceOf[Array[X with AnyRef]], n ).asInstanceOf[Array[X]])
    }
  }

  def takeWhile(f: X => Boolean): ofRef[X] = {
    val len = index(!f(_))
    if(len < 0){
      this
    }else if(len == 0){
      ofRef.empty[X]
    }else{
      new ofRef[X](Arrays.copyOf[X](self.asInstanceOf[Array[X with AnyRef]], len ).asInstanceOf[Array[X]])
    }
  }

  def takeWhileR(f: X => Boolean): ofRef[X] = {
    val len = lastIndex(f) + 1
    if(len <= 0){
      this
    }else if(len == self.length){
      ofRef.empty[X]
    }else{
      new ofRef[X](Arrays.copyOfRange[X](self.asInstanceOf[Array[X with AnyRef]], len, self.length ).asInstanceOf[Array[X]])
    }
  }

  def takeRight(n: Int): ofRef[X] = {
    if(n <= 0){
      ofRef.empty[X]
    }else if(n >= self.length){
      this
    }else{
      val start = self.length - n
      new ofRef[X](Arrays.copyOfRange[X](self.asInstanceOf[Array[X with AnyRef]], start, self.length ).asInstanceOf[Array[X]])
    }
  }

  def reverse: ofRef[X] = {
    var i = 0
    val len = self.length
    val array = new Array[X](len)
    while(i < len){
      array(len - i - 1) = self(i)
      i += 1
    }
    new ofRef[X](array)
  }

  def reverse_:::(prefix: ofRef[X]): ofRef[X] = {
    if(prefix.length == 0){
      this
    }else{
      val array = new Array[X](self.length + prefix.length)
      var i = 0
      val len = prefix.length
      while(i < len){
        array(i) = prefix.self(len - i - 1)
        i += 1
      }
      System.arraycopy(self, 0, array, prefix.length, self.length)
      new ofRef[X](array)
    }
  }

  def count(f: X => Boolean): Int = {
    var i = 0
    var n = 0
    while(i < self.length){
      if(f(self(i))){
        n += 1
      }
      i += 1
    }
    n
  }

  def drop(n: Int): ofRef[X] = {
    if(n <= 0){
      this
    }else if(n >= self.length){
      ofRef.empty[X]
    }else{
      new ofRef[X](Arrays.copyOfRange[X](self.asInstanceOf[Array[X with AnyRef]], n, self.length ).asInstanceOf[Array[X]])
    }
  }

  def dropWhile(f: X => Boolean): ofRef[X] = {
    val len = index(!f(_))
    if(len < 0){
      ofRef.empty[X]
    }else if(len == 0){
      this
    }else{
      new ofRef[X](Arrays.copyOfRange[X](self.asInstanceOf[Array[X with AnyRef]], len, self.length ).asInstanceOf[Array[X]])
    }
  }

  def dropWhileR(f: X => Boolean): ofRef[X] = {
    val len = lastIndex(f) + 1
    if(len <= 0){
      ofRef.empty[X]
    }else if(len == self.length){
      this
    }else{
      new ofRef[X](Arrays.copyOf[X](self.asInstanceOf[Array[X with AnyRef]], len ).asInstanceOf[Array[X]])
    }
  }

  def dropRight(n: Int): ofRef[X] = {
    if(n <= 0){
      this
    }else if(n >= self.length){
      ofRef.empty[X]
    }else{
      new ofRef[X](Arrays.copyOf[X](self.asInstanceOf[Array[X with AnyRef]], self.length - n ).asInstanceOf[Array[X]])
    }
  }

  def contains(elem: X): Boolean = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        return true
      }
      i += 1
    }
    false
  }

  def splitAt(n: Int): (ofRef[X], ofRef[X]) = {
    if(n <= 0){
      (ofRef.empty[X], this)
    }else if(n >= self.length){
      (this, ofRef.empty[X])
    }else{
      (new ofRef[X](Arrays.copyOf[X](self.asInstanceOf[Array[X with AnyRef]], n ).asInstanceOf[Array[X]]), new ofRef[X](Arrays.copyOfRange[X](self.asInstanceOf[Array[X with AnyRef]], n, self.length ).asInstanceOf[Array[X]]))
    }
  }

  def span(f: X => Boolean): (ofRef[X], ofRef[X]) = {
    val n = index(!f(_))
    if(n < 0){
      (this, ofRef.empty[X])
    }else if(n >= self.length){
      (ofRef.empty[X], this)
    }else{
      (new ofRef[X](Arrays.copyOf[X](self.asInstanceOf[Array[X with AnyRef]], n ).asInstanceOf[Array[X]]), new ofRef[X](Arrays.copyOfRange[X](self.asInstanceOf[Array[X with AnyRef]], n, self.length ).asInstanceOf[Array[X]]))
    }
  }

  def ++(that: ofRef[X]): ofRef[X] = {
    if(self.length == 0){
      that
    }else if(that.length == 0){
      this
    }else{
      val size1 = self.length
      val size2 = that.length
      val array = new Array[X](size1 + size2)
      System.arraycopy(self, 0, array, 0, size1)
      System.arraycopy(that.self, 0, array, size1, size2)
      new ofRef[X](array)
    }
  }

  def partition(f: X => Boolean): (ofRef[X], ofRef[X]) = {
    val l, r = new ArrayBuilder.ofRef[X]()
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        l += self(i)
      }else{
        r += self(i)
      }
      i += 1
    }
    (new ofRef[X](l.result), new ofRef[X](r.result))
  }

  @throws[IndexOutOfBoundsException]
  def updated(index: Int, elem: X): ofRef[X] = {
    val array = self.clone
    array(index) = elem
    new ofRef[X](array)
  }

  def slice(from: Int, until: Int): ofRef[X] = {
    if(until <= from || until <= 0 || from >= self.length){
      ofRef.empty[X]
    }else if(from <= 0 && self.length <= until){
      this
    }else{
      new ofRef[X](Arrays.copyOfRange[X](self.asInstanceOf[Array[X with AnyRef]], from max 0, until min self.length ).asInstanceOf[Array[X]])
    }
  }

  def reduceLeftOption(f: (X, X) => X): Option[X] = {
    if(self.length == 0) return None

    var i = 1
    var acc = self(0)
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    Some(acc)
  }

  def reduceRightOption(f: (X, X) => X): Option[X] = {
    if(self.length == 0) return None

    var i = self.length - 2
    var acc = self(self.length - 1)
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    Some(acc)
  }

  def indexOf(elem: X): Option[Int] = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        return Some(i)
      }
      i += 1
    }
    None
  }

  def lastIndexOf(elem: X): Option[Int] = {
    var i = self.length - 1
    while(i >= 0){
      if(self(i) == elem){
        return Some(i)
      }
      i -= 1
    }
    None
  }

  def tailOption: Option[ofRef[X]] = {
    if(self.length != 0){
      Some(drop(1))
    }else{
      None
    }
  }

  def tails: Iterator[ofRef[X]] = new Iterator[ofRef[X]]{
    private[this] var i = 0
    var hasNext = true
    def next: ofRef[X] = {
      val r = new ofRef[X](Arrays.copyOfRange[X](self.asInstanceOf[Array[X with AnyRef]], i, self.length ).asInstanceOf[Array[X]])
      i += 1
      if(i > self.length) hasNext = false
      r
    }
  }

  def inits: Iterator[ofRef[X]] = new Iterator[ofRef[X]]{
    private[this] var i = self.length
    var hasNext = true
    def next: ofRef[X] = {
      val r = new ofRef[X](Arrays.copyOfRange[X](self.asInstanceOf[Array[X with AnyRef]], 0, i ).asInstanceOf[Array[X]])
      i -= 1
      if(i < 0) hasNext = false
      r
    }
  }

  def initOption: Option[ofRef[X]] = {
    if(self.length != 0){
      Some(dropRight(1))
    }else{
      None
    }
  }

  def length: Int = self.length

  def size: Int = self.length

  @inline private def index(f: X => Boolean): Int = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return i
      }
      i += 1
    }
    -1
  }

  @inline private def lastIndex(f: X => Boolean): Int = {
    var i = self.length - 1
    while(0 <= i){
      if(!f(self(i))){
        return i
      }
      i -= 1
    }
    -1
  }

  override def toString = mkString("ofRef(", ", ", ")")

  def mkString(start: String, sep: String, end: String): String =
    addString(new StringBuilder(), start, sep, end).toString

  def mkString(sep: String): String = mkString("", sep, "")

  def mkString: String = mkString("")

  def addString(b: StringBuilder, start: String, sep: String, end: String): StringBuilder = {
    var first = true

    b append start
    var i = 0
    while(i < self.length){
      if (first) {
        b append self(i)
        first = false
      }
      else {
        b append sep
        b append self(i)
      }
      i += 1
    }
    b append end

    b
  }

  def ===(that: ofRef[X]): Boolean = Arrays.equals(self.asInstanceOf[Array[AnyRef]], that.self.asInstanceOf[Array[AnyRef]])

  @throws[IllegalArgumentException]
  def grouped(n: Int): Iterator[ofRef[X]] = sliding(n, n)

  @throws[IllegalArgumentException]
  def sliding(_size: Int, step: Int = 1): Iterator[ofRef[X]] = {
    require(_size > 0, "size must be positive number")
    require(step > 0, "step must be positive number")
    new Iterator[ofRef[X]]{
      private[this] var i = 0
      var hasNext = self.length != 0
      def next = {
        // n is negative, if `i + _size` overflow
        val n = i + _size
        val until = if(n > 0) math.min(n, self.length) else self.length
        val r = new ofRef[X](Arrays.copyOfRange[X](self.asInstanceOf[Array[X with AnyRef]], i, until ).asInstanceOf[Array[X]])
        i += step
        if(i >= self.length || n > self.length || n < 0) hasNext = false
        r
      }
    }
  }

  def scanLeft1(f: (X, X) => X): ofRef[X] = {
    if(self.length != 0){
      val array = new Array[X](self.length)
      array(0) = self(0)
      var i = 0
      while(i < self.length - 1){
        array(i + 1) = f(array(i), self(i + 1))
        i += 1
      }
      new ofRef[X](array)
    }else{
      ofRef.empty[X]
    }
  }

  def scanRight1(f: (X, X) => X): ofRef[X] = {
    if(self.length != 0){
      val array = new Array[X](self.length)
      array(self.length - 1) = self(self.length - 1)
      var i = self.length - 1
      while(i > 0){
        array(i - 1) = f(self(i - 1), array(i))
        i -= 1
      }
      new ofRef[X](array)
    }else{
      ofRef.empty[X]
    }
  }

  def startsWith(that: Array[X], offset: Int = 0): Boolean = {
    require(offset >= 0, "offset = " + offset  + " is invalid. offset must be positive")
    var i = offset
    var j = 0
    val thisLen = self.length
    val thatLen = that.length
    while (i < thisLen && j < thatLen && self(i) == that(j)) {
      i += 1
      j += 1
    }
    j == thatLen
  }

  def endsWith(that: Array[X]): Boolean = {
    var i = length - 1
    var j = that.length - 1

    (j <= i) && {
      while (j >= 0){
        if(self(i) != that(j)){
          return false
        }
        i -= 1
        j -= 1
      }
      true
    }
  }

  def groupBy[A](f: X => A): Map[A, ofRef[X]] = {
    val m = collection.mutable.Map.empty[A, ArrayBuilder.ofRef[X]]
    var i = 0
    while(i < self.length){
      val key = f(self(i))
      m.getOrElseUpdate(key, new ArrayBuilder.ofRef[X]) += self(i)
      i += 1
    }

    val b = Map.newBuilder[A, ofRef[X]]
    m.foreach{ case (k, v) =>
      b += ((k, new ofRef[X](v.result)))
    }

    b.result
  }

  def maxBy[A](f: X => A)(implicit A: Ordering[A]): Option[X] = {
    if(self.length == 0){
      None
    }else{
      var maxF = f(self(0))
      var maxElem = self(0)
      var i = 1
      while(i < self.length){
        val fx = f(self(i))
        if (A.gt(fx, maxF)) {
          maxElem = self(i)
          maxF = fx
        }
        i += 1
      }
      Some(maxElem)
    }
  }

  def minBy[A](f: X => A)(implicit A: Ordering[A]): Option[X] = {
    if(self.length == 0){
      None
    }else{
      var minF = f(self(0))
      var minElem = self(0)
      var i = 1
      while(i < self.length){
        val fx = f(self(i))
        if (A.lt(fx, minF)) {
          minElem = self(i)
          minF = fx
        }
        i += 1
      }
      Some(minElem)
    }
  }

  def deleteFirst(elem: X): ofRef[X] = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        val array = new Array[X](self.length - 1)
        System.arraycopy(self, 0, array, 0, i)
        System.arraycopy(self, i + 1, array, i, self.length - i - 1)
        return new ofRef[X](array)
      }
      i += 1
    }
    this
  }

  def intersperse(a: X): ofRef[X] = {
    if(self.length == 0){
      ofRef.empty[X]
    }else{
      val array = new Array[X]((self.length * 2) - 1)
      var i = 0
      java.util.Arrays.fill(array.asInstanceOf[Array[AnyRef]], a)
      while(i < self.length){
        array(i * 2) = self(i)
        i += 1
      }
      new ofRef[X](array)
    }
  }
}

object ofRef {

  def apply[X <: AnyRef :reflect.ClassTag](elems: X *): ofRef[X] = elems match{
    case a: collection.mutable.WrappedArray.ofRef[X] => new ofRef[X](a.array)
    case _ => new ofRef[X](elems.toArray)
  }

  def empty[X <: AnyRef :reflect.ClassTag]: ofRef[X] = new ofRef[X](new Array[X](0))

  def iterate[X <: AnyRef :reflect.ClassTag](start: X, len: Int)(f: X => X): ofRef[X] = {
    if(len == 0){
      empty
    }else{
      val array = new Array[X](len)
      var i = 1
      array(0) = start
      while (i < len) {
        array(i) = f(array(i - 1))
        i += 1
      }
      new ofRef[X](array)
    }
  }

  def tabulate[X <: AnyRef :reflect.ClassTag](n: Int)(f: Int => X): ofRef[X] = {
    val array = new Array[X](n)
    var i = 0
    while (i < n) {
      array(i) = f(i)
      i += 1
    }
    new ofRef[X](array)
  }

  def flatten[X <: AnyRef :reflect.ClassTag](xs: Array[Array[X]]): ofRef[X] = {
    var i = 0
    var n = 0
    val length = xs.length
    while(i < length){
      n += xs(i).length
      i += 1
    }
    val array = new Array[X](n)
    i = 0
    n = 0
    while(i < length){
      val elem = xs(i)
      System.arraycopy(elem, 0, array, n, elem.length)
      n += elem.length
      i += 1
    }
    new ofRef[X](array)
  }

  def fillAll[X <: AnyRef :reflect.ClassTag](size: Int)(elem: X): ofRef[X] = {
    val array = new Array[X](size)
    Arrays.fill(array.asInstanceOf[Array[AnyRef]], elem)
    new ofRef[X](array)
  }

  def fill[X <: AnyRef :reflect.ClassTag](size: Int)(f: => X): ofRef[X] = {
    val array = new Array[X](size)
    var i = 0
    while(i < size){
      array(i) = f
      i += 1
    }
    new ofRef[X](array)
  }

  def unfold[@specialized B ,X <: AnyRef: reflect.ClassTag](z: B)(f: B => Option[(B, X)]): ofRef[X] = {
    val builder = new ArrayBuilder.ofRef[X]()
    @annotation.tailrec
    def loop(next: Option[(B, X)]): Unit = next match {
      case Some((b, a)) =>
        builder += a
        loop(f(b))
      case None =>
    }
    loop(f(z))
    new ofRef[X](builder.result)
  }

}

