package nobox

import java.util.Arrays
import scala.reflect.ClassTag
import scala.collection.mutable.ArrayBuilder

final class WithFilterFloat private[nobox](self: ofFloat, f: Float => Boolean){
  
  def map[A](g: Float => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => mapInt(g.asInstanceOf[Float => Int])
      case ClassTag.Long => mapLong(g.asInstanceOf[Float => Long])
      case ClassTag.Float => mapFloat(g.asInstanceOf[Float => Float])
      case ClassTag.Double => mapDouble(g.asInstanceOf[Float => Double])
      case ClassTag.Byte => mapByte(g.asInstanceOf[Float => Byte])
      case ClassTag.Char => mapChar(g.asInstanceOf[Float => Char])
      case ClassTag.Short => mapShort(g.asInstanceOf[Float => Short])
      case ClassTag.Boolean => mapBoolean(g.asInstanceOf[Float => Boolean])
      case _ => self.filter(f).map(g) // TODO
    }).asInstanceOf[Array[A]]
  }


  def flatMap[A](g: Float => Array[A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => flatMapInt(g.asInstanceOf[Float => Array[Int]])
      case ClassTag.Long => flatMapLong(g.asInstanceOf[Float => Array[Long]])
      case ClassTag.Float => flatMapFloat(g.asInstanceOf[Float => Array[Float]])
      case ClassTag.Double => flatMapDouble(g.asInstanceOf[Float => Array[Double]])
      case ClassTag.Byte => flatMapByte(g.asInstanceOf[Float => Array[Byte]])
      case ClassTag.Char => flatMapChar(g.asInstanceOf[Float => Array[Char]])
      case ClassTag.Short => flatMapShort(g.asInstanceOf[Float => Array[Short]])
      case ClassTag.Boolean => flatMapBoolean(g.asInstanceOf[Float => Array[Boolean]])
      case _ => self.filter(f).flatMap(g) // TODO
    }).asInstanceOf[Array[A]]
  }


  def foreach[U](g: Float => U): Unit = {
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        g(self.self(i))
      }
      i += 1
    }
  }


  def withFilter(g: Float => Boolean): WithFilterFloat =
    new WithFilterFloat(self, {a => f(a) && g(a)})


  def mapInt(g: Float => Int): Array[Int] = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapLong(g: Float => Long): Array[Long] = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapFloat(g: Float => Float): Array[Float] = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapDouble(g: Float => Double): Array[Double] = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapByte(g: Float => Byte): Array[Byte] = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapChar(g: Float => Char): Array[Char] = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapShort(g: Float => Short): Array[Short] = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapBoolean(g: Float => Boolean): Array[Boolean] = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def flatMapInt(g: Float => Array[Int]): Array[Int] = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapLong(g: Float => Array[Long]): Array[Long] = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapFloat(g: Float => Array[Float]): Array[Float] = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapDouble(g: Float => Array[Double]): Array[Double] = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapByte(g: Float => Array[Byte]): Array[Byte] = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapChar(g: Float => Array[Char]): Array[Char] = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapShort(g: Float => Array[Short]): Array[Short] = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapBoolean(g: Float => Array[Boolean]): Array[Boolean] = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }

}

final class ofFloat (val self: Array[Float]) extends AnyVal {

  
  def sum: Float = {
    var i = 0
    var n: Float = 0
    while(i < self.length){
      n += self(i)
      i += 1
    }
    n
  }





  def product: Float = {
    var i = 0
    var n: Float = 1
    while(i < self.length){
      n *= self(i)
      i += 1
    }
    n
  }





  def productDouble: Double = {
    var i = 0
    var n: Double = 1.0
    while(i < self.length){
      n *= self(i)
      i += 1
    }
    n
  }



  def sorted: ofFloat = {
    val array = self.clone
    Arrays.sort(array)
    new ofFloat(array)
  }



  def max: Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var n = self(0)
      while(i < self.length){
        val x = self(i)
        if(n < x){
          n = x
        }
        i += 1
      }
      Some(n)
    }
  }

  def min: Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var n = self(0)
      while(i < self.length){
        val x = self(i)
        if(n > x){
          n = x
        }
        i += 1
      }
      Some(n)
    }
  }

  def minmax: Option[(Float, Float)] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var _min, _max = self(0)
      while(i < self.length){
        val x = self(i)
        if(_min > x){
          _min = x
        }else if(_max < x){
          _max = x
        }
        i += 1
      }
      Some((_min, _max))
    }
  }



  
  def mapInt(f: Float => Int): ofInt = {
    val array = new Array[Int](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofInt(array)
  }


  def mapLong(f: Float => Long): ofLong = {
    val array = new Array[Long](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofLong(array)
  }


  def mapFloat(f: Float => Float): ofFloat = {
    val array = new Array[Float](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def mapDouble(f: Float => Double): ofDouble = {
    val array = new Array[Double](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def mapByte(f: Float => Byte): ofByte = {
    val array = new Array[Byte](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofByte(array)
  }


  def mapChar(f: Float => Char): ofChar = {
    val array = new Array[Char](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofChar(array)
  }


  def mapShort(f: Float => Short): ofShort = {
    val array = new Array[Short](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofShort(array)
  }


  def mapBoolean(f: Float => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def mapRef[Y <: AnyRef :reflect.ClassTag](f: Float => Y): ofRef[Y] = {
    val array = new Array[Y](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def reverseMapInt(f: Float => Int): ofInt = {
    val len = self.length
    val array = new Array[Int](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofInt(array)
  }


  def reverseMapLong(f: Float => Long): ofLong = {
    val len = self.length
    val array = new Array[Long](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofLong(array)
  }


  def reverseMapFloat(f: Float => Float): ofFloat = {
    val len = self.length
    val array = new Array[Float](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def reverseMapDouble(f: Float => Double): ofDouble = {
    val len = self.length
    val array = new Array[Double](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def reverseMapByte(f: Float => Byte): ofByte = {
    val len = self.length
    val array = new Array[Byte](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofByte(array)
  }


  def reverseMapChar(f: Float => Char): ofChar = {
    val len = self.length
    val array = new Array[Char](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofChar(array)
  }


  def reverseMapShort(f: Float => Short): ofShort = {
    val len = self.length
    val array = new Array[Short](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofShort(array)
  }


  def reverseMapBoolean(f: Float => Boolean): ofBoolean = {
    val len = self.length
    val array = new Array[Boolean](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def reverseMapRef[Y <: AnyRef :reflect.ClassTag](f: Float => Y): ofRef[Y] = {
    val len = self.length
    val array = new Array[Y](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def flatMapInt(f: Float => Array[Int]): ofInt = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofInt(builder.result)
  }


  def flatMapLong(f: Float => Array[Long]): ofLong = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofLong(builder.result)
  }


  def flatMapFloat(f: Float => Array[Float]): ofFloat = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofFloat(builder.result)
  }


  def flatMapDouble(f: Float => Array[Double]): ofDouble = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofDouble(builder.result)
  }


  def flatMapByte(f: Float => Array[Byte]): ofByte = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofByte(builder.result)
  }


  def flatMapChar(f: Float => Array[Char]): ofChar = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofChar(builder.result)
  }


  def flatMapShort(f: Float => Array[Short]): ofShort = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofShort(builder.result)
  }


  def flatMapBoolean(f: Float => Array[Boolean]): ofBoolean = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofBoolean(builder.result)
  }


  def flatMapRef[Y <: AnyRef :reflect.ClassTag](f: Float => Array[Y]): ofRef[Y] = {
    val builder = new ArrayBuilder.ofRef[Y]()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofRef[Y](builder.result)
  }



  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectInt(f: PartialFunction[Float, Int]): ofInt = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofInt(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectLong(f: PartialFunction[Float, Long]): ofLong = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofLong(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectFloat(f: PartialFunction[Float, Float]): ofFloat = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofFloat(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectDouble(f: PartialFunction[Float, Double]): ofDouble = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofDouble(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectByte(f: PartialFunction[Float, Byte]): ofByte = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofByte(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectChar(f: PartialFunction[Float, Char]): ofChar = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofChar(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectShort(f: PartialFunction[Float, Short]): ofShort = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofShort(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectBoolean(f: PartialFunction[Float, Boolean]): ofBoolean = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofBoolean(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectRef[Y <: AnyRef :reflect.ClassTag](f: PartialFunction[Float, Y]): ofRef[Y] = {
    val builder = new ArrayBuilder.ofRef[Y]()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofRef[Y](builder.result)
  }



  def collectFirstInt(f: PartialFunction[Float, Int]): Option[Int] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstLong(f: PartialFunction[Float, Long]): Option[Long] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstFloat(f: PartialFunction[Float, Float]): Option[Float] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstDouble(f: PartialFunction[Float, Double]): Option[Double] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstByte(f: PartialFunction[Float, Byte]): Option[Byte] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstChar(f: PartialFunction[Float, Char]): Option[Char] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstShort(f: PartialFunction[Float, Short]): Option[Short] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstBoolean(f: PartialFunction[Float, Boolean]): Option[Boolean] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstRef[Y <: AnyRef :reflect.ClassTag](f: PartialFunction[Float, Y]): Option[Y] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }



  def foldLeftInt(z: Int)(f: (Int, Float) => Int): Int = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftLong(z: Long)(f: (Long, Float) => Long): Long = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftFloat(z: Float)(f: (Float, Float) => Float): Float = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftDouble(z: Double)(f: (Double, Float) => Double): Double = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftByte(z: Byte)(f: (Byte, Float) => Byte): Byte = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftChar(z: Char)(f: (Char, Float) => Char): Char = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftShort(z: Short)(f: (Short, Float) => Short): Short = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftBoolean(z: Boolean)(f: (Boolean, Float) => Boolean): Boolean = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftRef[Y](z: Y)(f: (Y, Float) => Y): Y = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }



  def foldRightInt(z: Int)(f: (Float, Int) => Int): Int = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightLong(z: Long)(f: (Float, Long) => Long): Long = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightFloat(z: Float)(f: (Float, Float) => Float): Float = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightDouble(z: Double)(f: (Float, Double) => Double): Double = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightByte(z: Byte)(f: (Float, Byte) => Byte): Byte = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightChar(z: Char)(f: (Float, Char) => Char): Char = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightShort(z: Short)(f: (Float, Short) => Short): Short = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightBoolean(z: Boolean)(f: (Float, Boolean) => Boolean): Boolean = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightRef[Y](z: Y)(f: (Float, Y) => Y): Y = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }



  def scanLeftInt(z: Int)(f: (Int, Float) => Int): ofInt = {
    val array = new Array[Int](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofInt(array)
  }


  def scanLeftLong(z: Long)(f: (Long, Float) => Long): ofLong = {
    val array = new Array[Long](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofLong(array)
  }


  def scanLeftFloat(z: Float)(f: (Float, Float) => Float): ofFloat = {
    val array = new Array[Float](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def scanLeftDouble(z: Double)(f: (Double, Float) => Double): ofDouble = {
    val array = new Array[Double](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def scanLeftByte(z: Byte)(f: (Byte, Float) => Byte): ofByte = {
    val array = new Array[Byte](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofByte(array)
  }


  def scanLeftChar(z: Char)(f: (Char, Float) => Char): ofChar = {
    val array = new Array[Char](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofChar(array)
  }


  def scanLeftShort(z: Short)(f: (Short, Float) => Short): ofShort = {
    val array = new Array[Short](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofShort(array)
  }


  def scanLeftBoolean(z: Boolean)(f: (Boolean, Float) => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def scanLeftRef[Y <: AnyRef :reflect.ClassTag](z: Y)(f: (Y, Float) => Y): ofRef[Y] = {
    val array = new Array[Y](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def scanRightInt(z: Int)(f: (Float, Int) => Int): ofInt = {
    val array = new Array[Int](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofInt(array)
  }


  def scanRightLong(z: Long)(f: (Float, Long) => Long): ofLong = {
    val array = new Array[Long](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofLong(array)
  }


  def scanRightFloat(z: Float)(f: (Float, Float) => Float): ofFloat = {
    val array = new Array[Float](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofFloat(array)
  }


  def scanRightDouble(z: Double)(f: (Float, Double) => Double): ofDouble = {
    val array = new Array[Double](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofDouble(array)
  }


  def scanRightByte(z: Byte)(f: (Float, Byte) => Byte): ofByte = {
    val array = new Array[Byte](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofByte(array)
  }


  def scanRightChar(z: Char)(f: (Float, Char) => Char): ofChar = {
    val array = new Array[Char](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofChar(array)
  }


  def scanRightShort(z: Short)(f: (Float, Short) => Short): ofShort = {
    val array = new Array[Short](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofShort(array)
  }


  def scanRightBoolean(z: Boolean)(f: (Float, Boolean) => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofBoolean(array)
  }


  def scanRightRef[Y <: AnyRef :reflect.ClassTag](z: Y)(f: (Float, Y) => Y): ofRef[Y] = {
    val array = new Array[Y](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofRef[Y](array)
  }



  def foldMapLeft1Int(z: Float => Int)(f: (Int, Float) => Int): Option[Int] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Long(z: Float => Long)(f: (Long, Float) => Long): Option[Long] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Float(z: Float => Float)(f: (Float, Float) => Float): Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Double(z: Float => Double)(f: (Double, Float) => Double): Option[Double] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Byte(z: Float => Byte)(f: (Byte, Float) => Byte): Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Char(z: Float => Char)(f: (Char, Float) => Char): Option[Char] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Short(z: Float => Short)(f: (Short, Float) => Short): Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Boolean(z: Float => Boolean)(f: (Boolean, Float) => Boolean): Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Ref[Y](z: Float => Y)(f: (Y, Float) => Y): Option[Y] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }



  def foldMapRight1Int(z: Float => Int)(f: (Float, Int) => Int): Option[Int] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Long(z: Float => Long)(f: (Float, Long) => Long): Option[Long] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Float(z: Float => Float)(f: (Float, Float) => Float): Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Double(z: Float => Double)(f: (Float, Double) => Double): Option[Double] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Byte(z: Float => Byte)(f: (Float, Byte) => Byte): Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Char(z: Float => Char)(f: (Float, Char) => Char): Option[Char] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Short(z: Float => Short)(f: (Float, Short) => Short): Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Boolean(z: Float => Boolean)(f: (Float, Boolean) => Boolean): Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Ref[Y](z: Float => Y)(f: (Float, Y) => Y): Option[Y] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }



  def map[A](f: Float => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => mapInt(f.asInstanceOf[Float => Int]).self
      case ClassTag.Long => mapLong(f.asInstanceOf[Float => Long]).self
      case ClassTag.Float => mapFloat(f.asInstanceOf[Float => Float]).self
      case ClassTag.Double => mapDouble(f.asInstanceOf[Float => Double]).self
      case ClassTag.Byte => mapByte(f.asInstanceOf[Float => Byte]).self
      case ClassTag.Char => mapChar(f.asInstanceOf[Float => Char]).self
      case ClassTag.Short => mapShort(f.asInstanceOf[Float => Short]).self
      case ClassTag.Boolean => mapBoolean(f.asInstanceOf[Float => Boolean]).self
      case _ => self.map(f)
    }).asInstanceOf[Array[A]]
  }



  def reverseMap[A](f: Float => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => reverseMapInt(f.asInstanceOf[Float => Int]).self
      case ClassTag.Long => reverseMapLong(f.asInstanceOf[Float => Long]).self
      case ClassTag.Float => reverseMapFloat(f.asInstanceOf[Float => Float]).self
      case ClassTag.Double => reverseMapDouble(f.asInstanceOf[Float => Double]).self
      case ClassTag.Byte => reverseMapByte(f.asInstanceOf[Float => Byte]).self
      case ClassTag.Char => reverseMapChar(f.asInstanceOf[Float => Char]).self
      case ClassTag.Short => reverseMapShort(f.asInstanceOf[Float => Short]).self
      case ClassTag.Boolean => reverseMapBoolean(f.asInstanceOf[Float => Boolean]).self
      case _ => self.reverseMap(f)
    }).asInstanceOf[Array[A]]
  }



  def flatMap[A](f: Float => Array[A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => flatMapInt(f.asInstanceOf[Float => Array[Int]]).self
      case ClassTag.Long => flatMapLong(f.asInstanceOf[Float => Array[Long]]).self
      case ClassTag.Float => flatMapFloat(f.asInstanceOf[Float => Array[Float]]).self
      case ClassTag.Double => flatMapDouble(f.asInstanceOf[Float => Array[Double]]).self
      case ClassTag.Byte => flatMapByte(f.asInstanceOf[Float => Array[Byte]]).self
      case ClassTag.Char => flatMapChar(f.asInstanceOf[Float => Array[Char]]).self
      case ClassTag.Short => flatMapShort(f.asInstanceOf[Float => Array[Short]]).self
      case ClassTag.Boolean => flatMapBoolean(f.asInstanceOf[Float => Array[Boolean]]).self
      case _ => self.flatMap(x => f(x))
    }).asInstanceOf[Array[A]]
  }



  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collect[A](f: PartialFunction[Float, A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => collectInt(f.asInstanceOf[PartialFunction[Float, Int]]).self
      case ClassTag.Long => collectLong(f.asInstanceOf[PartialFunction[Float, Long]]).self
      case ClassTag.Float => collectFloat(f.asInstanceOf[PartialFunction[Float, Float]]).self
      case ClassTag.Double => collectDouble(f.asInstanceOf[PartialFunction[Float, Double]]).self
      case ClassTag.Byte => collectByte(f.asInstanceOf[PartialFunction[Float, Byte]]).self
      case ClassTag.Char => collectChar(f.asInstanceOf[PartialFunction[Float, Char]]).self
      case ClassTag.Short => collectShort(f.asInstanceOf[PartialFunction[Float, Short]]).self
      case ClassTag.Boolean => collectBoolean(f.asInstanceOf[PartialFunction[Float, Boolean]]).self
      case _ => self.collect(f)
    }).asInstanceOf[Array[A]]
  }



  def collectFirst[A](f: PartialFunction[Float, A])(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => collectFirstInt(f.asInstanceOf[PartialFunction[Float, Int]])
      case ClassTag.Long => collectFirstLong(f.asInstanceOf[PartialFunction[Float, Long]])
      case ClassTag.Float => collectFirstFloat(f.asInstanceOf[PartialFunction[Float, Float]])
      case ClassTag.Double => collectFirstDouble(f.asInstanceOf[PartialFunction[Float, Double]])
      case ClassTag.Byte => collectFirstByte(f.asInstanceOf[PartialFunction[Float, Byte]])
      case ClassTag.Char => collectFirstChar(f.asInstanceOf[PartialFunction[Float, Char]])
      case ClassTag.Short => collectFirstShort(f.asInstanceOf[PartialFunction[Float, Short]])
      case ClassTag.Boolean => collectFirstBoolean(f.asInstanceOf[PartialFunction[Float, Boolean]])
      case _ => self.collectFirst(f)
    }).asInstanceOf[Option[A]]
  }



  def foldLeft[A](z: A)(f: (A, Float) => A)(implicit A: ClassTag[A]): A = {
    (A match {
      case ClassTag.Int => foldLeftInt(z.asInstanceOf[Int])(f.asInstanceOf[(Int, Float) => Int])
      case ClassTag.Long => foldLeftLong(z.asInstanceOf[Long])(f.asInstanceOf[(Long, Float) => Long])
      case ClassTag.Float => foldLeftFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Float, Float) => Float])
      case ClassTag.Double => foldLeftDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Double, Float) => Double])
      case ClassTag.Byte => foldLeftByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Byte, Float) => Byte])
      case ClassTag.Char => foldLeftChar(z.asInstanceOf[Char])(f.asInstanceOf[(Char, Float) => Char])
      case ClassTag.Short => foldLeftShort(z.asInstanceOf[Short])(f.asInstanceOf[(Short, Float) => Short])
      case ClassTag.Boolean => foldLeftBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Boolean, Float) => Boolean])
      case _ => self.foldLeft(z)(f)
    }).asInstanceOf[A]
  }



  def foldRight[A](z: A)(f: (Float, A) => A)(implicit A: ClassTag[A]): A = {
    (A match {
      case ClassTag.Int => foldRightInt(z.asInstanceOf[Int])(f.asInstanceOf[(Float, Int) => Int])
      case ClassTag.Long => foldRightLong(z.asInstanceOf[Long])(f.asInstanceOf[(Float, Long) => Long])
      case ClassTag.Float => foldRightFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Float, Float) => Float])
      case ClassTag.Double => foldRightDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Float, Double) => Double])
      case ClassTag.Byte => foldRightByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Float, Byte) => Byte])
      case ClassTag.Char => foldRightChar(z.asInstanceOf[Char])(f.asInstanceOf[(Float, Char) => Char])
      case ClassTag.Short => foldRightShort(z.asInstanceOf[Short])(f.asInstanceOf[(Float, Short) => Short])
      case ClassTag.Boolean => foldRightBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Float, Boolean) => Boolean])
      case _ => self.foldRight(z)(f)
    }).asInstanceOf[A]
  }



  def scanLeft[A](z: A)(f: (A, Float) => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => scanLeftInt(z.asInstanceOf[Int])(f.asInstanceOf[(Int, Float) => Int]).self
      case ClassTag.Long => scanLeftLong(z.asInstanceOf[Long])(f.asInstanceOf[(Long, Float) => Long]).self
      case ClassTag.Float => scanLeftFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Float, Float) => Float]).self
      case ClassTag.Double => scanLeftDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Double, Float) => Double]).self
      case ClassTag.Byte => scanLeftByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Byte, Float) => Byte]).self
      case ClassTag.Char => scanLeftChar(z.asInstanceOf[Char])(f.asInstanceOf[(Char, Float) => Char]).self
      case ClassTag.Short => scanLeftShort(z.asInstanceOf[Short])(f.asInstanceOf[(Short, Float) => Short]).self
      case ClassTag.Boolean => scanLeftBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Boolean, Float) => Boolean]).self
      case _ => self.scanLeft(z)(f)
    }).asInstanceOf[Array[A]]
  }



  def scanRight[A](z: A)(f: (Float, A) => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => scanRightInt(z.asInstanceOf[Int])(f.asInstanceOf[(Float, Int) => Int]).self
      case ClassTag.Long => scanRightLong(z.asInstanceOf[Long])(f.asInstanceOf[(Float, Long) => Long]).self
      case ClassTag.Float => scanRightFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Float, Float) => Float]).self
      case ClassTag.Double => scanRightDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Float, Double) => Double]).self
      case ClassTag.Byte => scanRightByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Float, Byte) => Byte]).self
      case ClassTag.Char => scanRightChar(z.asInstanceOf[Char])(f.asInstanceOf[(Float, Char) => Char]).self
      case ClassTag.Short => scanRightShort(z.asInstanceOf[Short])(f.asInstanceOf[(Float, Short) => Short]).self
      case ClassTag.Boolean => scanRightBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Float, Boolean) => Boolean]).self
      case _ => self.scanRight(z)(f)
    }).asInstanceOf[Array[A]]
  }



  def foldMapLeft1[A](z: Float => A)(f: (A, Float) => A)(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => foldMapLeft1Int(z.asInstanceOf[Float => Int])(f.asInstanceOf[(Int, Float) => Int])
      case ClassTag.Long => foldMapLeft1Long(z.asInstanceOf[Float => Long])(f.asInstanceOf[(Long, Float) => Long])
      case ClassTag.Float => foldMapLeft1Float(z.asInstanceOf[Float => Float])(f.asInstanceOf[(Float, Float) => Float])
      case ClassTag.Double => foldMapLeft1Double(z.asInstanceOf[Float => Double])(f.asInstanceOf[(Double, Float) => Double])
      case ClassTag.Byte => foldMapLeft1Byte(z.asInstanceOf[Float => Byte])(f.asInstanceOf[(Byte, Float) => Byte])
      case ClassTag.Char => foldMapLeft1Char(z.asInstanceOf[Float => Char])(f.asInstanceOf[(Char, Float) => Char])
      case ClassTag.Short => foldMapLeft1Short(z.asInstanceOf[Float => Short])(f.asInstanceOf[(Short, Float) => Short])
      case ClassTag.Boolean => foldMapLeft1Boolean(z.asInstanceOf[Float => Boolean])(f.asInstanceOf[(Boolean, Float) => Boolean])
      case _ => foldMapLeft1Ref(z)(f)
    }).asInstanceOf[Option[A]]
  }



  def foldMapRight1[A](z: Float => A)(f: (Float, A) => A)(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => foldMapRight1Int(z.asInstanceOf[Float => Int])(f.asInstanceOf[(Float, Int) => Int])
      case ClassTag.Long => foldMapRight1Long(z.asInstanceOf[Float => Long])(f.asInstanceOf[(Float, Long) => Long])
      case ClassTag.Float => foldMapRight1Float(z.asInstanceOf[Float => Float])(f.asInstanceOf[(Float, Float) => Float])
      case ClassTag.Double => foldMapRight1Double(z.asInstanceOf[Float => Double])(f.asInstanceOf[(Float, Double) => Double])
      case ClassTag.Byte => foldMapRight1Byte(z.asInstanceOf[Float => Byte])(f.asInstanceOf[(Float, Byte) => Byte])
      case ClassTag.Char => foldMapRight1Char(z.asInstanceOf[Float => Char])(f.asInstanceOf[(Float, Char) => Char])
      case ClassTag.Short => foldMapRight1Short(z.asInstanceOf[Float => Short])(f.asInstanceOf[(Float, Short) => Short])
      case ClassTag.Boolean => foldMapRight1Boolean(z.asInstanceOf[Float => Boolean])(f.asInstanceOf[(Float, Boolean) => Boolean])
      case _ => foldMapRight1Ref(z)(f)
    }).asInstanceOf[Option[A]]
  }


  def foreach[U](f: Float => U): Unit = {
    var i = 0
    while(i < self.length){
      f(self(i))
      i += 1
    }
  }

  def filter(f: Float => Boolean): ofFloat = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        builder += self(i)
      }
      i += 1
    }
    new ofFloat(builder.result)
  }

  def filterNot(f: Float => Boolean): ofFloat = filter(!f(_))

  def withFilter(f: Float => Boolean): WithFilterFloat =
    new WithFilterFloat(this, f)

  def find(f: Float => Boolean): Option[Float] = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return Some(self(i))
      }
      i += 1
    }
    None
  }

  def exists(f: Float => Boolean): Boolean = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return true
      }
      i += 1
    }
    false
  }

  def forall(f: Float => Boolean): Boolean = !exists(!f(_))

  def take(n: Int): ofFloat = {
    if(n >= self.length){
      this
    }else if(n <= 0){
      ofFloat.empty
    }else{
      new ofFloat(Arrays.copyOf(self, n ))
    }
  }

  def takeWhile(f: Float => Boolean): ofFloat = {
    val len = index(!f(_))
    if(len < 0){
      this
    }else if(len == 0){
      ofFloat.empty
    }else{
      new ofFloat(Arrays.copyOf(self, len ))
    }
  }

  def takeWhileR(f: Float => Boolean): ofFloat = {
    val len = lastIndex(f) + 1
    if(len <= 0){
      this
    }else if(len == self.length){
      ofFloat.empty
    }else{
      new ofFloat(Arrays.copyOfRange(self, len, self.length ))
    }
  }

  def takeRight(n: Int): ofFloat = {
    if(n <= 0){
      ofFloat.empty
    }else if(n >= self.length){
      this
    }else{
      val start = self.length - n
      new ofFloat(Arrays.copyOfRange(self, start, self.length ))
    }
  }

  def reverse: ofFloat = {
    var i = 0
    val len = self.length
    val array = new Array[Float](len)
    while(i < len){
      array(len - i - 1) = self(i)
      i += 1
    }
    new ofFloat(array)
  }

  def reverse_:::(prefix: ofFloat): ofFloat = {
    if(prefix.length == 0){
      this
    }else{
      val array = new Array[Float](self.length + prefix.length)
      var i = 0
      val len = prefix.length
      while(i < len){
        array(i) = prefix.self(len - i - 1)
        i += 1
      }
      System.arraycopy(self, 0, array, prefix.length, self.length)
      new ofFloat(array)
    }
  }

  def count(f: Float => Boolean): Int = {
    var i = 0
    var n = 0
    while(i < self.length){
      if(f(self(i))){
        n += 1
      }
      i += 1
    }
    n
  }

  def drop(n: Int): ofFloat = {
    if(n <= 0){
      this
    }else if(n >= self.length){
      ofFloat.empty
    }else{
      new ofFloat(Arrays.copyOfRange(self, n, self.length ))
    }
  }

  def dropWhile(f: Float => Boolean): ofFloat = {
    val len = index(!f(_))
    if(len < 0){
      ofFloat.empty
    }else if(len == 0){
      this
    }else{
      new ofFloat(Arrays.copyOfRange(self, len, self.length ))
    }
  }

  def dropWhileR(f: Float => Boolean): ofFloat = {
    val len = lastIndex(f) + 1
    if(len <= 0){
      ofFloat.empty
    }else if(len == self.length){
      this
    }else{
      new ofFloat(Arrays.copyOf(self, len ))
    }
  }

  def dropRight(n: Int): ofFloat = {
    if(n <= 0){
      this
    }else if(n >= self.length){
      ofFloat.empty
    }else{
      new ofFloat(Arrays.copyOf(self, self.length - n ))
    }
  }

  def contains(elem: Float): Boolean = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        return true
      }
      i += 1
    }
    false
  }

  def splitAt(n: Int): (ofFloat, ofFloat) = {
    if(n <= 0){
      (ofFloat.empty, this)
    }else if(n >= self.length){
      (this, ofFloat.empty)
    }else{
      (new ofFloat(Arrays.copyOf(self, n )), new ofFloat(Arrays.copyOfRange(self, n, self.length )))
    }
  }

  def span(f: Float => Boolean): (ofFloat, ofFloat) = {
    val n = index(!f(_))
    if(n < 0){
      (this, ofFloat.empty)
    }else if(n >= self.length){
      (ofFloat.empty, this)
    }else{
      (new ofFloat(Arrays.copyOf(self, n )), new ofFloat(Arrays.copyOfRange(self, n, self.length )))
    }
  }

  def ++(that: ofFloat): ofFloat = {
    if(self.length == 0){
      that
    }else if(that.length == 0){
      this
    }else{
      val size1 = self.length
      val size2 = that.length
      val array = new Array[Float](size1 + size2)
      System.arraycopy(self, 0, array, 0, size1)
      System.arraycopy(that.self, 0, array, size1, size2)
      new ofFloat(array)
    }
  }

  def partition(f: Float => Boolean): (ofFloat, ofFloat) = {
    val l, r = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        l += self(i)
      }else{
        r += self(i)
      }
      i += 1
    }
    (new ofFloat(l.result), new ofFloat(r.result))
  }

  @throws[IndexOutOfBoundsException]
  def updated(index: Int, elem: Float): ofFloat = {
    val array = self.clone
    array(index) = elem
    new ofFloat(array)
  }

  def slice(from: Int, until: Int): ofFloat = {
    if(until <= from || until <= 0 || from >= self.length){
      ofFloat.empty
    }else if(from <= 0 && self.length <= until){
      this
    }else{
      new ofFloat(Arrays.copyOfRange(self, from max 0, until min self.length ))
    }
  }

  def reduceLeftOption(f: (Float, Float) => Float): Option[Float] = {
    if(self.length == 0) return None

    var i = 1
    var acc = self(0)
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    Some(acc)
  }

  def reduceRightOption(f: (Float, Float) => Float): Option[Float] = {
    if(self.length == 0) return None

    var i = self.length - 2
    var acc = self(self.length - 1)
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    Some(acc)
  }

  def indexOf(elem: Float): Option[Int] = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        return Some(i)
      }
      i += 1
    }
    None
  }

  def lastIndexOf(elem: Float): Option[Int] = {
    var i = self.length - 1
    while(i >= 0){
      if(self(i) == elem){
        return Some(i)
      }
      i -= 1
    }
    None
  }

  def tailOption: Option[ofFloat] = {
    if(self.length != 0){
      Some(drop(1))
    }else{
      None
    }
  }

  def tails: Iterator[ofFloat] = new Iterator[ofFloat]{
    private[this] var i = 0
    var hasNext = true
    def next: ofFloat = {
      val r = new ofFloat(Arrays.copyOfRange(self, i, self.length ))
      i += 1
      if(i > self.length) hasNext = false
      r
    }
  }

  def inits: Iterator[ofFloat] = new Iterator[ofFloat]{
    private[this] var i = self.length
    var hasNext = true
    def next: ofFloat = {
      val r = new ofFloat(Arrays.copyOfRange(self, 0, i ))
      i -= 1
      if(i < 0) hasNext = false
      r
    }
  }

  def initOption: Option[ofFloat] = {
    if(self.length != 0){
      Some(dropRight(1))
    }else{
      None
    }
  }

  def length: Int = self.length

  def size: Int = self.length

  @inline private def index(f: Float => Boolean): Int = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return i
      }
      i += 1
    }
    -1
  }

  @inline private def lastIndex(f: Float => Boolean): Int = {
    var i = self.length - 1
    while(0 <= i){
      if(!f(self(i))){
        return i
      }
      i -= 1
    }
    -1
  }

  override def toString = mkString("ofFloat(", ", ", ")")

  def mkString(start: String, sep: String, end: String): String =
    addString(new StringBuilder(), start, sep, end).toString

  def mkString(sep: String): String = mkString("", sep, "")

  def mkString: String = mkString("")

  def addString(b: StringBuilder, start: String, sep: String, end: String): StringBuilder = {
    var first = true

    b append start
    var i = 0
    while(i < self.length){
      if (first) {
        b append self(i)
        first = false
      }
      else {
        b append sep
        b append self(i)
      }
      i += 1
    }
    b append end

    b
  }

  def ===(that: ofFloat): Boolean = Arrays.equals(self, that.self)

  @throws[IllegalArgumentException]
  def grouped(n: Int): Iterator[ofFloat] = sliding(n, n)

  @throws[IllegalArgumentException]
  def sliding(_size: Int, step: Int = 1): Iterator[ofFloat] = {
    require(_size > 0, "size must be positive number")
    require(step > 0, "step must be positive number")
    new Iterator[ofFloat]{
      private[this] var i = 0
      var hasNext = self.length != 0
      def next = {
        // n is negative, if `i + _size` overflow
        val n = i + _size
        val until = if(n > 0) math.min(n, self.length) else self.length
        val r = new ofFloat(Arrays.copyOfRange(self, i, until ))
        i += step
        if(i >= self.length || n > self.length || n < 0) hasNext = false
        r
      }
    }
  }

  def scanLeft1(f: (Float, Float) => Float): ofFloat = {
    if(self.length != 0){
      val array = new Array[Float](self.length)
      array(0) = self(0)
      var i = 0
      while(i < self.length - 1){
        array(i + 1) = f(array(i), self(i + 1))
        i += 1
      }
      new ofFloat(array)
    }else{
      ofFloat.empty
    }
  }

  def scanRight1(f: (Float, Float) => Float): ofFloat = {
    if(self.length != 0){
      val array = new Array[Float](self.length)
      array(self.length - 1) = self(self.length - 1)
      var i = self.length - 1
      while(i > 0){
        array(i - 1) = f(self(i - 1), array(i))
        i -= 1
      }
      new ofFloat(array)
    }else{
      ofFloat.empty
    }
  }

  def startsWith(that: Array[Float], offset: Int = 0): Boolean = {
    require(offset >= 0, "offset = " + offset  + " is invalid. offset must be positive")
    var i = offset
    var j = 0
    val thisLen = self.length
    val thatLen = that.length
    while (i < thisLen && j < thatLen && self(i) == that(j)) {
      i += 1
      j += 1
    }
    j == thatLen
  }

  def endsWith(that: Array[Float]): Boolean = {
    var i = length - 1
    var j = that.length - 1

    (j <= i) && {
      while (j >= 0){
        if(self(i) != that(j)){
          return false
        }
        i -= 1
        j -= 1
      }
      true
    }
  }

  def groupBy[A](f: Float => A): Map[A, ofFloat] = {
    val m = collection.mutable.Map.empty[A, ArrayBuilder.ofFloat]
    var i = 0
    while(i < self.length){
      val key = f(self(i))
      m.getOrElseUpdate(key, new ArrayBuilder.ofFloat) += self(i)
      i += 1
    }

    val b = Map.newBuilder[A, ofFloat]
    m.foreach{ case (k, v) =>
      b += ((k, new ofFloat(v.result)))
    }

    b.result
  }

  def maxBy[A](f: Float => A)(implicit A: Ordering[A]): Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var maxF = f(self(0))
      var maxElem = self(0)
      var i = 1
      while(i < self.length){
        val fx = f(self(i))
        if (A.gt(fx, maxF)) {
          maxElem = self(i)
          maxF = fx
        }
        i += 1
      }
      Some(maxElem)
    }
  }

  def minBy[A](f: Float => A)(implicit A: Ordering[A]): Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var minF = f(self(0))
      var minElem = self(0)
      var i = 1
      while(i < self.length){
        val fx = f(self(i))
        if (A.lt(fx, minF)) {
          minElem = self(i)
          minF = fx
        }
        i += 1
      }
      Some(minElem)
    }
  }

  def deleteFirst(elem: Float): ofFloat = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        val array = new Array[Float](self.length - 1)
        System.arraycopy(self, 0, array, 0, i)
        System.arraycopy(self, i + 1, array, i, self.length - i - 1)
        return new ofFloat(array)
      }
      i += 1
    }
    this
  }

  def intersperse(a: Float): ofFloat = {
    if(self.length == 0){
      ofFloat.empty
    }else{
      val array = new Array[Float]((self.length * 2) - 1)
      var i = 0
      java.util.Arrays.fill(array, a)
      while(i < self.length){
        array(i * 2) = self(i)
        i += 1
      }
      new ofFloat(array)
    }
  }
}

object ofFloat {

  def apply(elems: Float *): ofFloat = elems match{
    case a: collection.mutable.WrappedArray.ofFloat => new ofFloat(a.array)
    case _ => new ofFloat(elems.toArray)
  }

  val empty: ofFloat = new ofFloat(new Array[Float](0))

  def iterate(start: Float, len: Int)(f: Float => Float): ofFloat = {
    if(len == 0){
      empty
    }else{
      val array = new Array[Float](len)
      var i = 1
      array(0) = start
      while (i < len) {
        array(i) = f(array(i - 1))
        i += 1
      }
      new ofFloat(array)
    }
  }

  def tabulate(n: Int)(f: Int => Float): ofFloat = {
    val array = new Array[Float](n)
    var i = 0
    while (i < n) {
      array(i) = f(i)
      i += 1
    }
    new ofFloat(array)
  }

  def flatten(xs: Array[Array[Float]]): ofFloat = {
    var i = 0
    var n = 0
    val length = xs.length
    while(i < length){
      n += xs(i).length
      i += 1
    }
    val array = new Array[Float](n)
    i = 0
    n = 0
    while(i < length){
      val elem = xs(i)
      System.arraycopy(elem, 0, array, n, elem.length)
      n += elem.length
      i += 1
    }
    new ofFloat(array)
  }

  def fillAll(size: Int)(elem: Float): ofFloat = {
    val array = new Array[Float](size)
    Arrays.fill(array, elem)
    new ofFloat(array)
  }

  def fill(size: Int)(f: => Float): ofFloat = {
    val array = new Array[Float](size)
    var i = 0
    while(i < size){
      array(i) = f
      i += 1
    }
    new ofFloat(array)
  }

  def unfold[@specialized B ](z: B)(f: B => Option[(B, Float)]): ofFloat = {
    val builder = new ArrayBuilder.ofFloat()
    @annotation.tailrec
    def loop(next: Option[(B, Float)]): Unit = next match {
      case Some((b, a)) =>
        builder += a
        loop(f(b))
      case None =>
    }
    loop(f(z))
    new ofFloat(builder.result)
  }

}

