package nobox

import java.util.Arrays
import scala.reflect.ClassTag
import scala.collection.mutable.ArrayBuilder

final class WithFilterByte private[nobox](self: ofByte, f: Byte => Boolean){
  
  def map[A](g: Byte => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => mapInt(g.asInstanceOf[Byte => Int])
      case ClassTag.Long => mapLong(g.asInstanceOf[Byte => Long])
      case ClassTag.Float => mapFloat(g.asInstanceOf[Byte => Float])
      case ClassTag.Double => mapDouble(g.asInstanceOf[Byte => Double])
      case ClassTag.Byte => mapByte(g.asInstanceOf[Byte => Byte])
      case ClassTag.Char => mapChar(g.asInstanceOf[Byte => Char])
      case ClassTag.Short => mapShort(g.asInstanceOf[Byte => Short])
      case ClassTag.Boolean => mapBoolean(g.asInstanceOf[Byte => Boolean])
      case _ => self.filter(f).map(g) // TODO
    }).asInstanceOf[Array[A]]
  }


  def flatMap[A](g: Byte => Array[A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => flatMapInt(g.asInstanceOf[Byte => Array[Int]])
      case ClassTag.Long => flatMapLong(g.asInstanceOf[Byte => Array[Long]])
      case ClassTag.Float => flatMapFloat(g.asInstanceOf[Byte => Array[Float]])
      case ClassTag.Double => flatMapDouble(g.asInstanceOf[Byte => Array[Double]])
      case ClassTag.Byte => flatMapByte(g.asInstanceOf[Byte => Array[Byte]])
      case ClassTag.Char => flatMapChar(g.asInstanceOf[Byte => Array[Char]])
      case ClassTag.Short => flatMapShort(g.asInstanceOf[Byte => Array[Short]])
      case ClassTag.Boolean => flatMapBoolean(g.asInstanceOf[Byte => Array[Boolean]])
      case _ => self.filter(f).flatMap(g) // TODO
    }).asInstanceOf[Array[A]]
  }


  def foreach[U](g: Byte => U): Unit = {
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        g(self.self(i))
      }
      i += 1
    }
  }


  def withFilter(g: Byte => Boolean): WithFilterByte =
    new WithFilterByte(self, {a => f(a) && g(a)})


  def mapInt(g: Byte => Int): Array[Int] = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapLong(g: Byte => Long): Array[Long] = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapFloat(g: Byte => Float): Array[Float] = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapDouble(g: Byte => Double): Array[Double] = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapByte(g: Byte => Byte): Array[Byte] = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapChar(g: Byte => Char): Array[Char] = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapShort(g: Byte => Short): Array[Short] = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapBoolean(g: Byte => Boolean): Array[Boolean] = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def flatMapInt(g: Byte => Array[Int]): Array[Int] = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapLong(g: Byte => Array[Long]): Array[Long] = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapFloat(g: Byte => Array[Float]): Array[Float] = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapDouble(g: Byte => Array[Double]): Array[Double] = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapByte(g: Byte => Array[Byte]): Array[Byte] = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapChar(g: Byte => Array[Char]): Array[Char] = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapShort(g: Byte => Array[Short]): Array[Short] = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapBoolean(g: Byte => Array[Boolean]): Array[Boolean] = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }

}

final class ofByte (val self: Array[Byte]) extends AnyVal {

  
  def sum: Int = {
    var i, n = 0
    while(i < self.length){
      n += self(i)
      i += 1
    }
    n
  }





  def product: Int = {
    var i = 0
    var n = 1
    while(i < self.length){
      n *= self(i)
      i += 1
    }
    n
  }



  def productLong: Long = {
    var i = 0
    var n: Long = 1L
    while(i < self.length){
      n *= self(i)
      i += 1
    }
    n
  }



  def productDouble: Double = {
    var i = 0
    var n: Double = 1.0
    while(i < self.length){
      n *= self(i)
      i += 1
    }
    n
  }



  def sorted: ofByte = {
    val array = self.clone
    Arrays.sort(array)
    new ofByte(array)
  }



  def max: Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var n = self(0)
      while(i < self.length){
        val x = self(i)
        if(n < x){
          n = x
        }
        i += 1
      }
      Some(n)
    }
  }

  def min: Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var n = self(0)
      while(i < self.length){
        val x = self(i)
        if(n > x){
          n = x
        }
        i += 1
      }
      Some(n)
    }
  }

  def minmax: Option[(Byte, Byte)] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var _min, _max = self(0)
      while(i < self.length){
        val x = self(i)
        if(_min > x){
          _min = x
        }else if(_max < x){
          _max = x
        }
        i += 1
      }
      Some((_min, _max))
    }
  }



  
  def mapInt(f: Byte => Int): ofInt = {
    val array = new Array[Int](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofInt(array)
  }


  def mapLong(f: Byte => Long): ofLong = {
    val array = new Array[Long](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofLong(array)
  }


  def mapFloat(f: Byte => Float): ofFloat = {
    val array = new Array[Float](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def mapDouble(f: Byte => Double): ofDouble = {
    val array = new Array[Double](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def mapByte(f: Byte => Byte): ofByte = {
    val array = new Array[Byte](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofByte(array)
  }


  def mapChar(f: Byte => Char): ofChar = {
    val array = new Array[Char](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofChar(array)
  }


  def mapShort(f: Byte => Short): ofShort = {
    val array = new Array[Short](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofShort(array)
  }


  def mapBoolean(f: Byte => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def mapRef[Y <: AnyRef :reflect.ClassTag](f: Byte => Y): ofRef[Y] = {
    val array = new Array[Y](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def reverseMapInt(f: Byte => Int): ofInt = {
    val len = self.length
    val array = new Array[Int](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofInt(array)
  }


  def reverseMapLong(f: Byte => Long): ofLong = {
    val len = self.length
    val array = new Array[Long](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofLong(array)
  }


  def reverseMapFloat(f: Byte => Float): ofFloat = {
    val len = self.length
    val array = new Array[Float](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def reverseMapDouble(f: Byte => Double): ofDouble = {
    val len = self.length
    val array = new Array[Double](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def reverseMapByte(f: Byte => Byte): ofByte = {
    val len = self.length
    val array = new Array[Byte](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofByte(array)
  }


  def reverseMapChar(f: Byte => Char): ofChar = {
    val len = self.length
    val array = new Array[Char](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofChar(array)
  }


  def reverseMapShort(f: Byte => Short): ofShort = {
    val len = self.length
    val array = new Array[Short](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofShort(array)
  }


  def reverseMapBoolean(f: Byte => Boolean): ofBoolean = {
    val len = self.length
    val array = new Array[Boolean](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def reverseMapRef[Y <: AnyRef :reflect.ClassTag](f: Byte => Y): ofRef[Y] = {
    val len = self.length
    val array = new Array[Y](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def flatMapInt(f: Byte => Array[Int]): ofInt = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofInt(builder.result)
  }


  def flatMapLong(f: Byte => Array[Long]): ofLong = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofLong(builder.result)
  }


  def flatMapFloat(f: Byte => Array[Float]): ofFloat = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofFloat(builder.result)
  }


  def flatMapDouble(f: Byte => Array[Double]): ofDouble = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofDouble(builder.result)
  }


  def flatMapByte(f: Byte => Array[Byte]): ofByte = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofByte(builder.result)
  }


  def flatMapChar(f: Byte => Array[Char]): ofChar = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofChar(builder.result)
  }


  def flatMapShort(f: Byte => Array[Short]): ofShort = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofShort(builder.result)
  }


  def flatMapBoolean(f: Byte => Array[Boolean]): ofBoolean = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofBoolean(builder.result)
  }


  def flatMapRef[Y <: AnyRef :reflect.ClassTag](f: Byte => Array[Y]): ofRef[Y] = {
    val builder = new ArrayBuilder.ofRef[Y]()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofRef[Y](builder.result)
  }



  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectInt(f: PartialFunction[Byte, Int]): ofInt = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofInt(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectLong(f: PartialFunction[Byte, Long]): ofLong = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofLong(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectFloat(f: PartialFunction[Byte, Float]): ofFloat = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofFloat(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectDouble(f: PartialFunction[Byte, Double]): ofDouble = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofDouble(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectByte(f: PartialFunction[Byte, Byte]): ofByte = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofByte(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectChar(f: PartialFunction[Byte, Char]): ofChar = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofChar(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectShort(f: PartialFunction[Byte, Short]): ofShort = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofShort(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectBoolean(f: PartialFunction[Byte, Boolean]): ofBoolean = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofBoolean(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectRef[Y <: AnyRef :reflect.ClassTag](f: PartialFunction[Byte, Y]): ofRef[Y] = {
    val builder = new ArrayBuilder.ofRef[Y]()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofRef[Y](builder.result)
  }



  def collectFirstInt(f: PartialFunction[Byte, Int]): Option[Int] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstLong(f: PartialFunction[Byte, Long]): Option[Long] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstFloat(f: PartialFunction[Byte, Float]): Option[Float] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstDouble(f: PartialFunction[Byte, Double]): Option[Double] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstByte(f: PartialFunction[Byte, Byte]): Option[Byte] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstChar(f: PartialFunction[Byte, Char]): Option[Char] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstShort(f: PartialFunction[Byte, Short]): Option[Short] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstBoolean(f: PartialFunction[Byte, Boolean]): Option[Boolean] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstRef[Y <: AnyRef :reflect.ClassTag](f: PartialFunction[Byte, Y]): Option[Y] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }



  def foldLeftInt(z: Int)(f: (Int, Byte) => Int): Int = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftLong(z: Long)(f: (Long, Byte) => Long): Long = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftFloat(z: Float)(f: (Float, Byte) => Float): Float = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftDouble(z: Double)(f: (Double, Byte) => Double): Double = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftByte(z: Byte)(f: (Byte, Byte) => Byte): Byte = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftChar(z: Char)(f: (Char, Byte) => Char): Char = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftShort(z: Short)(f: (Short, Byte) => Short): Short = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftBoolean(z: Boolean)(f: (Boolean, Byte) => Boolean): Boolean = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftRef[Y](z: Y)(f: (Y, Byte) => Y): Y = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }



  def foldRightInt(z: Int)(f: (Byte, Int) => Int): Int = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightLong(z: Long)(f: (Byte, Long) => Long): Long = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightFloat(z: Float)(f: (Byte, Float) => Float): Float = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightDouble(z: Double)(f: (Byte, Double) => Double): Double = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightByte(z: Byte)(f: (Byte, Byte) => Byte): Byte = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightChar(z: Char)(f: (Byte, Char) => Char): Char = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightShort(z: Short)(f: (Byte, Short) => Short): Short = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightBoolean(z: Boolean)(f: (Byte, Boolean) => Boolean): Boolean = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightRef[Y](z: Y)(f: (Byte, Y) => Y): Y = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }



  def scanLeftInt(z: Int)(f: (Int, Byte) => Int): ofInt = {
    val array = new Array[Int](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofInt(array)
  }


  def scanLeftLong(z: Long)(f: (Long, Byte) => Long): ofLong = {
    val array = new Array[Long](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofLong(array)
  }


  def scanLeftFloat(z: Float)(f: (Float, Byte) => Float): ofFloat = {
    val array = new Array[Float](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def scanLeftDouble(z: Double)(f: (Double, Byte) => Double): ofDouble = {
    val array = new Array[Double](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def scanLeftByte(z: Byte)(f: (Byte, Byte) => Byte): ofByte = {
    val array = new Array[Byte](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofByte(array)
  }


  def scanLeftChar(z: Char)(f: (Char, Byte) => Char): ofChar = {
    val array = new Array[Char](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofChar(array)
  }


  def scanLeftShort(z: Short)(f: (Short, Byte) => Short): ofShort = {
    val array = new Array[Short](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofShort(array)
  }


  def scanLeftBoolean(z: Boolean)(f: (Boolean, Byte) => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def scanLeftRef[Y <: AnyRef :reflect.ClassTag](z: Y)(f: (Y, Byte) => Y): ofRef[Y] = {
    val array = new Array[Y](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def scanRightInt(z: Int)(f: (Byte, Int) => Int): ofInt = {
    val array = new Array[Int](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofInt(array)
  }


  def scanRightLong(z: Long)(f: (Byte, Long) => Long): ofLong = {
    val array = new Array[Long](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofLong(array)
  }


  def scanRightFloat(z: Float)(f: (Byte, Float) => Float): ofFloat = {
    val array = new Array[Float](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofFloat(array)
  }


  def scanRightDouble(z: Double)(f: (Byte, Double) => Double): ofDouble = {
    val array = new Array[Double](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofDouble(array)
  }


  def scanRightByte(z: Byte)(f: (Byte, Byte) => Byte): ofByte = {
    val array = new Array[Byte](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofByte(array)
  }


  def scanRightChar(z: Char)(f: (Byte, Char) => Char): ofChar = {
    val array = new Array[Char](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofChar(array)
  }


  def scanRightShort(z: Short)(f: (Byte, Short) => Short): ofShort = {
    val array = new Array[Short](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofShort(array)
  }


  def scanRightBoolean(z: Boolean)(f: (Byte, Boolean) => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofBoolean(array)
  }


  def scanRightRef[Y <: AnyRef :reflect.ClassTag](z: Y)(f: (Byte, Y) => Y): ofRef[Y] = {
    val array = new Array[Y](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofRef[Y](array)
  }



  def foldMapLeft1Int(z: Byte => Int)(f: (Int, Byte) => Int): Option[Int] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Long(z: Byte => Long)(f: (Long, Byte) => Long): Option[Long] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Float(z: Byte => Float)(f: (Float, Byte) => Float): Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Double(z: Byte => Double)(f: (Double, Byte) => Double): Option[Double] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Byte(z: Byte => Byte)(f: (Byte, Byte) => Byte): Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Char(z: Byte => Char)(f: (Char, Byte) => Char): Option[Char] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Short(z: Byte => Short)(f: (Short, Byte) => Short): Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Boolean(z: Byte => Boolean)(f: (Boolean, Byte) => Boolean): Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Ref[Y](z: Byte => Y)(f: (Y, Byte) => Y): Option[Y] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }



  def foldMapRight1Int(z: Byte => Int)(f: (Byte, Int) => Int): Option[Int] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Long(z: Byte => Long)(f: (Byte, Long) => Long): Option[Long] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Float(z: Byte => Float)(f: (Byte, Float) => Float): Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Double(z: Byte => Double)(f: (Byte, Double) => Double): Option[Double] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Byte(z: Byte => Byte)(f: (Byte, Byte) => Byte): Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Char(z: Byte => Char)(f: (Byte, Char) => Char): Option[Char] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Short(z: Byte => Short)(f: (Byte, Short) => Short): Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Boolean(z: Byte => Boolean)(f: (Byte, Boolean) => Boolean): Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Ref[Y](z: Byte => Y)(f: (Byte, Y) => Y): Option[Y] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }



  def map[A](f: Byte => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => mapInt(f.asInstanceOf[Byte => Int]).self
      case ClassTag.Long => mapLong(f.asInstanceOf[Byte => Long]).self
      case ClassTag.Float => mapFloat(f.asInstanceOf[Byte => Float]).self
      case ClassTag.Double => mapDouble(f.asInstanceOf[Byte => Double]).self
      case ClassTag.Byte => mapByte(f.asInstanceOf[Byte => Byte]).self
      case ClassTag.Char => mapChar(f.asInstanceOf[Byte => Char]).self
      case ClassTag.Short => mapShort(f.asInstanceOf[Byte => Short]).self
      case ClassTag.Boolean => mapBoolean(f.asInstanceOf[Byte => Boolean]).self
      case _ => self.map(f)
    }).asInstanceOf[Array[A]]
  }



  def reverseMap[A](f: Byte => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => reverseMapInt(f.asInstanceOf[Byte => Int]).self
      case ClassTag.Long => reverseMapLong(f.asInstanceOf[Byte => Long]).self
      case ClassTag.Float => reverseMapFloat(f.asInstanceOf[Byte => Float]).self
      case ClassTag.Double => reverseMapDouble(f.asInstanceOf[Byte => Double]).self
      case ClassTag.Byte => reverseMapByte(f.asInstanceOf[Byte => Byte]).self
      case ClassTag.Char => reverseMapChar(f.asInstanceOf[Byte => Char]).self
      case ClassTag.Short => reverseMapShort(f.asInstanceOf[Byte => Short]).self
      case ClassTag.Boolean => reverseMapBoolean(f.asInstanceOf[Byte => Boolean]).self
      case _ => self.reverseMap(f)
    }).asInstanceOf[Array[A]]
  }



  def flatMap[A](f: Byte => Array[A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => flatMapInt(f.asInstanceOf[Byte => Array[Int]]).self
      case ClassTag.Long => flatMapLong(f.asInstanceOf[Byte => Array[Long]]).self
      case ClassTag.Float => flatMapFloat(f.asInstanceOf[Byte => Array[Float]]).self
      case ClassTag.Double => flatMapDouble(f.asInstanceOf[Byte => Array[Double]]).self
      case ClassTag.Byte => flatMapByte(f.asInstanceOf[Byte => Array[Byte]]).self
      case ClassTag.Char => flatMapChar(f.asInstanceOf[Byte => Array[Char]]).self
      case ClassTag.Short => flatMapShort(f.asInstanceOf[Byte => Array[Short]]).self
      case ClassTag.Boolean => flatMapBoolean(f.asInstanceOf[Byte => Array[Boolean]]).self
      case _ => self.flatMap(x => f(x))
    }).asInstanceOf[Array[A]]
  }



  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collect[A](f: PartialFunction[Byte, A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => collectInt(f.asInstanceOf[PartialFunction[Byte, Int]]).self
      case ClassTag.Long => collectLong(f.asInstanceOf[PartialFunction[Byte, Long]]).self
      case ClassTag.Float => collectFloat(f.asInstanceOf[PartialFunction[Byte, Float]]).self
      case ClassTag.Double => collectDouble(f.asInstanceOf[PartialFunction[Byte, Double]]).self
      case ClassTag.Byte => collectByte(f.asInstanceOf[PartialFunction[Byte, Byte]]).self
      case ClassTag.Char => collectChar(f.asInstanceOf[PartialFunction[Byte, Char]]).self
      case ClassTag.Short => collectShort(f.asInstanceOf[PartialFunction[Byte, Short]]).self
      case ClassTag.Boolean => collectBoolean(f.asInstanceOf[PartialFunction[Byte, Boolean]]).self
      case _ => self.collect(f)
    }).asInstanceOf[Array[A]]
  }



  def collectFirst[A](f: PartialFunction[Byte, A])(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => collectFirstInt(f.asInstanceOf[PartialFunction[Byte, Int]])
      case ClassTag.Long => collectFirstLong(f.asInstanceOf[PartialFunction[Byte, Long]])
      case ClassTag.Float => collectFirstFloat(f.asInstanceOf[PartialFunction[Byte, Float]])
      case ClassTag.Double => collectFirstDouble(f.asInstanceOf[PartialFunction[Byte, Double]])
      case ClassTag.Byte => collectFirstByte(f.asInstanceOf[PartialFunction[Byte, Byte]])
      case ClassTag.Char => collectFirstChar(f.asInstanceOf[PartialFunction[Byte, Char]])
      case ClassTag.Short => collectFirstShort(f.asInstanceOf[PartialFunction[Byte, Short]])
      case ClassTag.Boolean => collectFirstBoolean(f.asInstanceOf[PartialFunction[Byte, Boolean]])
      case _ => self.collectFirst(f)
    }).asInstanceOf[Option[A]]
  }



  def foldLeft[A](z: A)(f: (A, Byte) => A)(implicit A: ClassTag[A]): A = {
    (A match {
      case ClassTag.Int => foldLeftInt(z.asInstanceOf[Int])(f.asInstanceOf[(Int, Byte) => Int])
      case ClassTag.Long => foldLeftLong(z.asInstanceOf[Long])(f.asInstanceOf[(Long, Byte) => Long])
      case ClassTag.Float => foldLeftFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Float, Byte) => Float])
      case ClassTag.Double => foldLeftDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Double, Byte) => Double])
      case ClassTag.Byte => foldLeftByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Byte, Byte) => Byte])
      case ClassTag.Char => foldLeftChar(z.asInstanceOf[Char])(f.asInstanceOf[(Char, Byte) => Char])
      case ClassTag.Short => foldLeftShort(z.asInstanceOf[Short])(f.asInstanceOf[(Short, Byte) => Short])
      case ClassTag.Boolean => foldLeftBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Boolean, Byte) => Boolean])
      case _ => self.foldLeft(z)(f)
    }).asInstanceOf[A]
  }



  def foldRight[A](z: A)(f: (Byte, A) => A)(implicit A: ClassTag[A]): A = {
    (A match {
      case ClassTag.Int => foldRightInt(z.asInstanceOf[Int])(f.asInstanceOf[(Byte, Int) => Int])
      case ClassTag.Long => foldRightLong(z.asInstanceOf[Long])(f.asInstanceOf[(Byte, Long) => Long])
      case ClassTag.Float => foldRightFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Byte, Float) => Float])
      case ClassTag.Double => foldRightDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Byte, Double) => Double])
      case ClassTag.Byte => foldRightByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Byte, Byte) => Byte])
      case ClassTag.Char => foldRightChar(z.asInstanceOf[Char])(f.asInstanceOf[(Byte, Char) => Char])
      case ClassTag.Short => foldRightShort(z.asInstanceOf[Short])(f.asInstanceOf[(Byte, Short) => Short])
      case ClassTag.Boolean => foldRightBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Byte, Boolean) => Boolean])
      case _ => self.foldRight(z)(f)
    }).asInstanceOf[A]
  }



  def scanLeft[A](z: A)(f: (A, Byte) => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => scanLeftInt(z.asInstanceOf[Int])(f.asInstanceOf[(Int, Byte) => Int]).self
      case ClassTag.Long => scanLeftLong(z.asInstanceOf[Long])(f.asInstanceOf[(Long, Byte) => Long]).self
      case ClassTag.Float => scanLeftFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Float, Byte) => Float]).self
      case ClassTag.Double => scanLeftDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Double, Byte) => Double]).self
      case ClassTag.Byte => scanLeftByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Byte, Byte) => Byte]).self
      case ClassTag.Char => scanLeftChar(z.asInstanceOf[Char])(f.asInstanceOf[(Char, Byte) => Char]).self
      case ClassTag.Short => scanLeftShort(z.asInstanceOf[Short])(f.asInstanceOf[(Short, Byte) => Short]).self
      case ClassTag.Boolean => scanLeftBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Boolean, Byte) => Boolean]).self
      case _ => self.scanLeft(z)(f)
    }).asInstanceOf[Array[A]]
  }



  def scanRight[A](z: A)(f: (Byte, A) => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => scanRightInt(z.asInstanceOf[Int])(f.asInstanceOf[(Byte, Int) => Int]).self
      case ClassTag.Long => scanRightLong(z.asInstanceOf[Long])(f.asInstanceOf[(Byte, Long) => Long]).self
      case ClassTag.Float => scanRightFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Byte, Float) => Float]).self
      case ClassTag.Double => scanRightDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Byte, Double) => Double]).self
      case ClassTag.Byte => scanRightByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Byte, Byte) => Byte]).self
      case ClassTag.Char => scanRightChar(z.asInstanceOf[Char])(f.asInstanceOf[(Byte, Char) => Char]).self
      case ClassTag.Short => scanRightShort(z.asInstanceOf[Short])(f.asInstanceOf[(Byte, Short) => Short]).self
      case ClassTag.Boolean => scanRightBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Byte, Boolean) => Boolean]).self
      case _ => self.scanRight(z)(f)
    }).asInstanceOf[Array[A]]
  }



  def foldMapLeft1[A](z: Byte => A)(f: (A, Byte) => A)(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => foldMapLeft1Int(z.asInstanceOf[Byte => Int])(f.asInstanceOf[(Int, Byte) => Int])
      case ClassTag.Long => foldMapLeft1Long(z.asInstanceOf[Byte => Long])(f.asInstanceOf[(Long, Byte) => Long])
      case ClassTag.Float => foldMapLeft1Float(z.asInstanceOf[Byte => Float])(f.asInstanceOf[(Float, Byte) => Float])
      case ClassTag.Double => foldMapLeft1Double(z.asInstanceOf[Byte => Double])(f.asInstanceOf[(Double, Byte) => Double])
      case ClassTag.Byte => foldMapLeft1Byte(z.asInstanceOf[Byte => Byte])(f.asInstanceOf[(Byte, Byte) => Byte])
      case ClassTag.Char => foldMapLeft1Char(z.asInstanceOf[Byte => Char])(f.asInstanceOf[(Char, Byte) => Char])
      case ClassTag.Short => foldMapLeft1Short(z.asInstanceOf[Byte => Short])(f.asInstanceOf[(Short, Byte) => Short])
      case ClassTag.Boolean => foldMapLeft1Boolean(z.asInstanceOf[Byte => Boolean])(f.asInstanceOf[(Boolean, Byte) => Boolean])
      case _ => foldMapLeft1Ref(z)(f)
    }).asInstanceOf[Option[A]]
  }



  def foldMapRight1[A](z: Byte => A)(f: (Byte, A) => A)(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => foldMapRight1Int(z.asInstanceOf[Byte => Int])(f.asInstanceOf[(Byte, Int) => Int])
      case ClassTag.Long => foldMapRight1Long(z.asInstanceOf[Byte => Long])(f.asInstanceOf[(Byte, Long) => Long])
      case ClassTag.Float => foldMapRight1Float(z.asInstanceOf[Byte => Float])(f.asInstanceOf[(Byte, Float) => Float])
      case ClassTag.Double => foldMapRight1Double(z.asInstanceOf[Byte => Double])(f.asInstanceOf[(Byte, Double) => Double])
      case ClassTag.Byte => foldMapRight1Byte(z.asInstanceOf[Byte => Byte])(f.asInstanceOf[(Byte, Byte) => Byte])
      case ClassTag.Char => foldMapRight1Char(z.asInstanceOf[Byte => Char])(f.asInstanceOf[(Byte, Char) => Char])
      case ClassTag.Short => foldMapRight1Short(z.asInstanceOf[Byte => Short])(f.asInstanceOf[(Byte, Short) => Short])
      case ClassTag.Boolean => foldMapRight1Boolean(z.asInstanceOf[Byte => Boolean])(f.asInstanceOf[(Byte, Boolean) => Boolean])
      case _ => foldMapRight1Ref(z)(f)
    }).asInstanceOf[Option[A]]
  }


  def foreach[U](f: Byte => U): Unit = {
    var i = 0
    while(i < self.length){
      f(self(i))
      i += 1
    }
  }

  def filter(f: Byte => Boolean): ofByte = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        builder += self(i)
      }
      i += 1
    }
    new ofByte(builder.result)
  }

  def filterNot(f: Byte => Boolean): ofByte = filter(!f(_))

  def withFilter(f: Byte => Boolean): WithFilterByte =
    new WithFilterByte(this, f)

  def find(f: Byte => Boolean): Option[Byte] = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return Some(self(i))
      }
      i += 1
    }
    None
  }

  def exists(f: Byte => Boolean): Boolean = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return true
      }
      i += 1
    }
    false
  }

  def forall(f: Byte => Boolean): Boolean = !exists(!f(_))

  def take(n: Int): ofByte = {
    if(n >= self.length){
      this
    }else if(n <= 0){
      ofByte.empty
    }else{
      new ofByte(Arrays.copyOf(self, n ))
    }
  }

  def takeWhile(f: Byte => Boolean): ofByte = {
    val len = index(!f(_))
    if(len < 0){
      this
    }else if(len == 0){
      ofByte.empty
    }else{
      new ofByte(Arrays.copyOf(self, len ))
    }
  }

  def takeWhileR(f: Byte => Boolean): ofByte = {
    val len = lastIndex(f) + 1
    if(len <= 0){
      this
    }else if(len == self.length){
      ofByte.empty
    }else{
      new ofByte(Arrays.copyOfRange(self, len, self.length ))
    }
  }

  def takeRight(n: Int): ofByte = {
    if(n <= 0){
      ofByte.empty
    }else if(n >= self.length){
      this
    }else{
      val start = self.length - n
      new ofByte(Arrays.copyOfRange(self, start, self.length ))
    }
  }

  def reverse: ofByte = {
    var i = 0
    val len = self.length
    val array = new Array[Byte](len)
    while(i < len){
      array(len - i - 1) = self(i)
      i += 1
    }
    new ofByte(array)
  }

  def reverse_:::(prefix: ofByte): ofByte = {
    if(prefix.length == 0){
      this
    }else{
      val array = new Array[Byte](self.length + prefix.length)
      var i = 0
      val len = prefix.length
      while(i < len){
        array(i) = prefix.self(len - i - 1)
        i += 1
      }
      System.arraycopy(self, 0, array, prefix.length, self.length)
      new ofByte(array)
    }
  }

  def count(f: Byte => Boolean): Int = {
    var i = 0
    var n = 0
    while(i < self.length){
      if(f(self(i))){
        n += 1
      }
      i += 1
    }
    n
  }

  def drop(n: Int): ofByte = {
    if(n <= 0){
      this
    }else if(n >= self.length){
      ofByte.empty
    }else{
      new ofByte(Arrays.copyOfRange(self, n, self.length ))
    }
  }

  def dropWhile(f: Byte => Boolean): ofByte = {
    val len = index(!f(_))
    if(len < 0){
      ofByte.empty
    }else if(len == 0){
      this
    }else{
      new ofByte(Arrays.copyOfRange(self, len, self.length ))
    }
  }

  def dropWhileR(f: Byte => Boolean): ofByte = {
    val len = lastIndex(f) + 1
    if(len <= 0){
      ofByte.empty
    }else if(len == self.length){
      this
    }else{
      new ofByte(Arrays.copyOf(self, len ))
    }
  }

  def dropRight(n: Int): ofByte = {
    if(n <= 0){
      this
    }else if(n >= self.length){
      ofByte.empty
    }else{
      new ofByte(Arrays.copyOf(self, self.length - n ))
    }
  }

  def contains(elem: Byte): Boolean = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        return true
      }
      i += 1
    }
    false
  }

  def splitAt(n: Int): (ofByte, ofByte) = {
    if(n <= 0){
      (ofByte.empty, this)
    }else if(n >= self.length){
      (this, ofByte.empty)
    }else{
      (new ofByte(Arrays.copyOf(self, n )), new ofByte(Arrays.copyOfRange(self, n, self.length )))
    }
  }

  def span(f: Byte => Boolean): (ofByte, ofByte) = {
    val n = index(!f(_))
    if(n < 0){
      (this, ofByte.empty)
    }else if(n >= self.length){
      (ofByte.empty, this)
    }else{
      (new ofByte(Arrays.copyOf(self, n )), new ofByte(Arrays.copyOfRange(self, n, self.length )))
    }
  }

  def ++(that: ofByte): ofByte = {
    if(self.length == 0){
      that
    }else if(that.length == 0){
      this
    }else{
      val size1 = self.length
      val size2 = that.length
      val array = new Array[Byte](size1 + size2)
      System.arraycopy(self, 0, array, 0, size1)
      System.arraycopy(that.self, 0, array, size1, size2)
      new ofByte(array)
    }
  }

  def partition(f: Byte => Boolean): (ofByte, ofByte) = {
    val l, r = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        l += self(i)
      }else{
        r += self(i)
      }
      i += 1
    }
    (new ofByte(l.result), new ofByte(r.result))
  }

  @throws[IndexOutOfBoundsException]
  def updated(index: Int, elem: Byte): ofByte = {
    val array = self.clone
    array(index) = elem
    new ofByte(array)
  }

  def slice(from: Int, until: Int): ofByte = {
    if(until <= from || until <= 0 || from >= self.length){
      ofByte.empty
    }else if(from <= 0 && self.length <= until){
      this
    }else{
      new ofByte(Arrays.copyOfRange(self, from max 0, until min self.length ))
    }
  }

  def reduceLeftOption(f: (Byte, Byte) => Byte): Option[Byte] = {
    if(self.length == 0) return None

    var i = 1
    var acc = self(0)
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    Some(acc)
  }

  def reduceRightOption(f: (Byte, Byte) => Byte): Option[Byte] = {
    if(self.length == 0) return None

    var i = self.length - 2
    var acc = self(self.length - 1)
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    Some(acc)
  }

  def indexOf(elem: Byte): Option[Int] = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        return Some(i)
      }
      i += 1
    }
    None
  }

  def lastIndexOf(elem: Byte): Option[Int] = {
    var i = self.length - 1
    while(i >= 0){
      if(self(i) == elem){
        return Some(i)
      }
      i -= 1
    }
    None
  }

  def tailOption: Option[ofByte] = {
    if(self.length != 0){
      Some(drop(1))
    }else{
      None
    }
  }

  def tails: Iterator[ofByte] = new Iterator[ofByte]{
    private[this] var i = 0
    var hasNext = true
    def next: ofByte = {
      val r = new ofByte(Arrays.copyOfRange(self, i, self.length ))
      i += 1
      if(i > self.length) hasNext = false
      r
    }
  }

  def inits: Iterator[ofByte] = new Iterator[ofByte]{
    private[this] var i = self.length
    var hasNext = true
    def next: ofByte = {
      val r = new ofByte(Arrays.copyOfRange(self, 0, i ))
      i -= 1
      if(i < 0) hasNext = false
      r
    }
  }

  def initOption: Option[ofByte] = {
    if(self.length != 0){
      Some(dropRight(1))
    }else{
      None
    }
  }

  def length: Int = self.length

  def size: Int = self.length

  @inline private def index(f: Byte => Boolean): Int = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return i
      }
      i += 1
    }
    -1
  }

  @inline private def lastIndex(f: Byte => Boolean): Int = {
    var i = self.length - 1
    while(0 <= i){
      if(!f(self(i))){
        return i
      }
      i -= 1
    }
    -1
  }

  override def toString = mkString("ofByte(", ", ", ")")

  def mkString(start: String, sep: String, end: String): String =
    addString(new StringBuilder(), start, sep, end).toString

  def mkString(sep: String): String = mkString("", sep, "")

  def mkString: String = mkString("")

  def addString(b: StringBuilder, start: String, sep: String, end: String): StringBuilder = {
    var first = true

    b append start
    var i = 0
    while(i < self.length){
      if (first) {
        b append self(i)
        first = false
      }
      else {
        b append sep
        b append self(i)
      }
      i += 1
    }
    b append end

    b
  }

  def ===(that: ofByte): Boolean = Arrays.equals(self, that.self)

  @throws[IllegalArgumentException]
  def grouped(n: Int): Iterator[ofByte] = sliding(n, n)

  @throws[IllegalArgumentException]
  def sliding(_size: Int, step: Int = 1): Iterator[ofByte] = {
    require(_size > 0, "size must be positive number")
    require(step > 0, "step must be positive number")
    new Iterator[ofByte]{
      private[this] var i = 0
      var hasNext = self.length != 0
      def next = {
        // n is negative, if `i + _size` overflow
        val n = i + _size
        val until = if(n > 0) math.min(n, self.length) else self.length
        val r = new ofByte(Arrays.copyOfRange(self, i, until ))
        i += step
        if(i >= self.length || n > self.length || n < 0) hasNext = false
        r
      }
    }
  }

  def scanLeft1(f: (Byte, Byte) => Byte): ofByte = {
    if(self.length != 0){
      val array = new Array[Byte](self.length)
      array(0) = self(0)
      var i = 0
      while(i < self.length - 1){
        array(i + 1) = f(array(i), self(i + 1))
        i += 1
      }
      new ofByte(array)
    }else{
      ofByte.empty
    }
  }

  def scanRight1(f: (Byte, Byte) => Byte): ofByte = {
    if(self.length != 0){
      val array = new Array[Byte](self.length)
      array(self.length - 1) = self(self.length - 1)
      var i = self.length - 1
      while(i > 0){
        array(i - 1) = f(self(i - 1), array(i))
        i -= 1
      }
      new ofByte(array)
    }else{
      ofByte.empty
    }
  }

  def startsWith(that: Array[Byte], offset: Int = 0): Boolean = {
    require(offset >= 0, "offset = " + offset  + " is invalid. offset must be positive")
    var i = offset
    var j = 0
    val thisLen = self.length
    val thatLen = that.length
    while (i < thisLen && j < thatLen && self(i) == that(j)) {
      i += 1
      j += 1
    }
    j == thatLen
  }

  def endsWith(that: Array[Byte]): Boolean = {
    var i = length - 1
    var j = that.length - 1

    (j <= i) && {
      while (j >= 0){
        if(self(i) != that(j)){
          return false
        }
        i -= 1
        j -= 1
      }
      true
    }
  }

  def groupBy[A](f: Byte => A): Map[A, ofByte] = {
    val m = collection.mutable.Map.empty[A, ArrayBuilder.ofByte]
    var i = 0
    while(i < self.length){
      val key = f(self(i))
      m.getOrElseUpdate(key, new ArrayBuilder.ofByte) += self(i)
      i += 1
    }

    val b = Map.newBuilder[A, ofByte]
    m.foreach{ case (k, v) =>
      b += ((k, new ofByte(v.result)))
    }

    b.result
  }

  def maxBy[A](f: Byte => A)(implicit A: Ordering[A]): Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var maxF = f(self(0))
      var maxElem = self(0)
      var i = 1
      while(i < self.length){
        val fx = f(self(i))
        if (A.gt(fx, maxF)) {
          maxElem = self(i)
          maxF = fx
        }
        i += 1
      }
      Some(maxElem)
    }
  }

  def minBy[A](f: Byte => A)(implicit A: Ordering[A]): Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var minF = f(self(0))
      var minElem = self(0)
      var i = 1
      while(i < self.length){
        val fx = f(self(i))
        if (A.lt(fx, minF)) {
          minElem = self(i)
          minF = fx
        }
        i += 1
      }
      Some(minElem)
    }
  }

  def deleteFirst(elem: Byte): ofByte = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        val array = new Array[Byte](self.length - 1)
        System.arraycopy(self, 0, array, 0, i)
        System.arraycopy(self, i + 1, array, i, self.length - i - 1)
        return new ofByte(array)
      }
      i += 1
    }
    this
  }

  def intersperse(a: Byte): ofByte = {
    if(self.length == 0){
      ofByte.empty
    }else{
      val array = new Array[Byte]((self.length * 2) - 1)
      var i = 0
      java.util.Arrays.fill(array, a)
      while(i < self.length){
        array(i * 2) = self(i)
        i += 1
      }
      new ofByte(array)
    }
  }
}

object ofByte {

  def apply(elems: Byte *): ofByte = elems match{
    case a: collection.mutable.WrappedArray.ofByte => new ofByte(a.array)
    case _ => new ofByte(elems.toArray)
  }

  val empty: ofByte = new ofByte(new Array[Byte](0))

  def iterate(start: Byte, len: Int)(f: Byte => Byte): ofByte = {
    if(len == 0){
      empty
    }else{
      val array = new Array[Byte](len)
      var i = 1
      array(0) = start
      while (i < len) {
        array(i) = f(array(i - 1))
        i += 1
      }
      new ofByte(array)
    }
  }

  def tabulate(n: Int)(f: Int => Byte): ofByte = {
    val array = new Array[Byte](n)
    var i = 0
    while (i < n) {
      array(i) = f(i)
      i += 1
    }
    new ofByte(array)
  }

  def flatten(xs: Array[Array[Byte]]): ofByte = {
    var i = 0
    var n = 0
    val length = xs.length
    while(i < length){
      n += xs(i).length
      i += 1
    }
    val array = new Array[Byte](n)
    i = 0
    n = 0
    while(i < length){
      val elem = xs(i)
      System.arraycopy(elem, 0, array, n, elem.length)
      n += elem.length
      i += 1
    }
    new ofByte(array)
  }

  def fillAll(size: Int)(elem: Byte): ofByte = {
    val array = new Array[Byte](size)
    Arrays.fill(array, elem)
    new ofByte(array)
  }

  def fill(size: Int)(f: => Byte): ofByte = {
    val array = new Array[Byte](size)
    var i = 0
    while(i < size){
      array(i) = f
      i += 1
    }
    new ofByte(array)
  }

  def unfold[@specialized B ](z: B)(f: B => Option[(B, Byte)]): ofByte = {
    val builder = new ArrayBuilder.ofByte()
    @annotation.tailrec
    def loop(next: Option[(B, Byte)]): Unit = next match {
      case Some((b, a)) =>
        builder += a
        loop(f(b))
      case None =>
    }
    loop(f(z))
    new ofByte(builder.result)
  }

}

