package nobox

import java.util.Arrays
import scala.reflect.ClassTag
import scala.collection.mutable.ArrayBuilder

final class WithFilterBoolean private[nobox](self: ofBoolean, f: Boolean => Boolean){
  
  def map[A](g: Boolean => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => mapInt(g.asInstanceOf[Boolean => Int])
      case ClassTag.Long => mapLong(g.asInstanceOf[Boolean => Long])
      case ClassTag.Float => mapFloat(g.asInstanceOf[Boolean => Float])
      case ClassTag.Double => mapDouble(g.asInstanceOf[Boolean => Double])
      case ClassTag.Byte => mapByte(g.asInstanceOf[Boolean => Byte])
      case ClassTag.Char => mapChar(g.asInstanceOf[Boolean => Char])
      case ClassTag.Short => mapShort(g.asInstanceOf[Boolean => Short])
      case ClassTag.Boolean => mapBoolean(g.asInstanceOf[Boolean => Boolean])
      case _ => self.filter(f).map(g) // TODO
    }).asInstanceOf[Array[A]]
  }


  def flatMap[A](g: Boolean => Array[A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => flatMapInt(g.asInstanceOf[Boolean => Array[Int]])
      case ClassTag.Long => flatMapLong(g.asInstanceOf[Boolean => Array[Long]])
      case ClassTag.Float => flatMapFloat(g.asInstanceOf[Boolean => Array[Float]])
      case ClassTag.Double => flatMapDouble(g.asInstanceOf[Boolean => Array[Double]])
      case ClassTag.Byte => flatMapByte(g.asInstanceOf[Boolean => Array[Byte]])
      case ClassTag.Char => flatMapChar(g.asInstanceOf[Boolean => Array[Char]])
      case ClassTag.Short => flatMapShort(g.asInstanceOf[Boolean => Array[Short]])
      case ClassTag.Boolean => flatMapBoolean(g.asInstanceOf[Boolean => Array[Boolean]])
      case _ => self.filter(f).flatMap(g) // TODO
    }).asInstanceOf[Array[A]]
  }


  def foreach[U](g: Boolean => U): Unit = {
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        g(self.self(i))
      }
      i += 1
    }
  }


  def withFilter(g: Boolean => Boolean): WithFilterBoolean =
    new WithFilterBoolean(self, {a => f(a) && g(a)})


  def mapInt(g: Boolean => Int): Array[Int] = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapLong(g: Boolean => Long): Array[Long] = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapFloat(g: Boolean => Float): Array[Float] = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapDouble(g: Boolean => Double): Array[Double] = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapByte(g: Boolean => Byte): Array[Byte] = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapChar(g: Boolean => Char): Array[Char] = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapShort(g: Boolean => Short): Array[Short] = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def mapBoolean(g: Boolean => Boolean): Array[Boolean] = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        builder += g(self.self(i))
      }
      i += 1
    }
    builder.result
  }


  def flatMapInt(g: Boolean => Array[Int]): Array[Int] = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapLong(g: Boolean => Array[Long]): Array[Long] = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapFloat(g: Boolean => Array[Float]): Array[Float] = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapDouble(g: Boolean => Array[Double]): Array[Double] = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapByte(g: Boolean => Array[Byte]): Array[Byte] = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapChar(g: Boolean => Array[Char]): Array[Char] = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapShort(g: Boolean => Array[Short]): Array[Short] = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }


  def flatMapBoolean(g: Boolean => Array[Boolean]): Array[Boolean] = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      if(f(self.self(i))){
        val x = g(self.self(i))
        var j = 0
        while(j < x.length){
          builder += x(j)
          j += 1
        }
      }
      i += 1
    }
    builder.result
  }

}

final class ofBoolean (val self: Array[Boolean]) extends AnyVal {

  












  def max: Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var n = self(0)
      while(i < self.length){
        val x = self(i)
        if(n < x){
          n = x
        }
        i += 1
      }
      Some(n)
    }
  }

  def min: Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var n = self(0)
      while(i < self.length){
        val x = self(i)
        if(n > x){
          n = x
        }
        i += 1
      }
      Some(n)
    }
  }

  def minmax: Option[(Boolean, Boolean)] = {
    if(self.length == 0){
      None
    }else{
      var i = 1
      var _min, _max = self(0)
      while(i < self.length){
        val x = self(i)
        if(_min > x){
          _min = x
        }else if(_max < x){
          _max = x
        }
        i += 1
      }
      Some((_min, _max))
    }
  }



  
  def mapInt(f: Boolean => Int): ofInt = {
    val array = new Array[Int](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofInt(array)
  }


  def mapLong(f: Boolean => Long): ofLong = {
    val array = new Array[Long](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofLong(array)
  }


  def mapFloat(f: Boolean => Float): ofFloat = {
    val array = new Array[Float](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def mapDouble(f: Boolean => Double): ofDouble = {
    val array = new Array[Double](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def mapByte(f: Boolean => Byte): ofByte = {
    val array = new Array[Byte](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofByte(array)
  }


  def mapChar(f: Boolean => Char): ofChar = {
    val array = new Array[Char](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofChar(array)
  }


  def mapShort(f: Boolean => Short): ofShort = {
    val array = new Array[Short](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofShort(array)
  }


  def mapBoolean(f: Boolean => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def mapRef[Y <: AnyRef :reflect.ClassTag](f: Boolean => Y): ofRef[Y] = {
    val array = new Array[Y](self.length)
    var i = 0
    while(i < self.length){
      array(i) = f(self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def reverseMapInt(f: Boolean => Int): ofInt = {
    val len = self.length
    val array = new Array[Int](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofInt(array)
  }


  def reverseMapLong(f: Boolean => Long): ofLong = {
    val len = self.length
    val array = new Array[Long](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofLong(array)
  }


  def reverseMapFloat(f: Boolean => Float): ofFloat = {
    val len = self.length
    val array = new Array[Float](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def reverseMapDouble(f: Boolean => Double): ofDouble = {
    val len = self.length
    val array = new Array[Double](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def reverseMapByte(f: Boolean => Byte): ofByte = {
    val len = self.length
    val array = new Array[Byte](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofByte(array)
  }


  def reverseMapChar(f: Boolean => Char): ofChar = {
    val len = self.length
    val array = new Array[Char](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofChar(array)
  }


  def reverseMapShort(f: Boolean => Short): ofShort = {
    val len = self.length
    val array = new Array[Short](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofShort(array)
  }


  def reverseMapBoolean(f: Boolean => Boolean): ofBoolean = {
    val len = self.length
    val array = new Array[Boolean](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def reverseMapRef[Y <: AnyRef :reflect.ClassTag](f: Boolean => Y): ofRef[Y] = {
    val len = self.length
    val array = new Array[Y](len)
    var i = 0
    while(i < len){
      array(len - i - 1) = f(self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def flatMapInt(f: Boolean => Array[Int]): ofInt = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofInt(builder.result)
  }


  def flatMapLong(f: Boolean => Array[Long]): ofLong = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofLong(builder.result)
  }


  def flatMapFloat(f: Boolean => Array[Float]): ofFloat = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofFloat(builder.result)
  }


  def flatMapDouble(f: Boolean => Array[Double]): ofDouble = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofDouble(builder.result)
  }


  def flatMapByte(f: Boolean => Array[Byte]): ofByte = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofByte(builder.result)
  }


  def flatMapChar(f: Boolean => Array[Char]): ofChar = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofChar(builder.result)
  }


  def flatMapShort(f: Boolean => Array[Short]): ofShort = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofShort(builder.result)
  }


  def flatMapBoolean(f: Boolean => Array[Boolean]): ofBoolean = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofBoolean(builder.result)
  }


  def flatMapRef[Y <: AnyRef :reflect.ClassTag](f: Boolean => Array[Y]): ofRef[Y] = {
    val builder = new ArrayBuilder.ofRef[Y]()
    var i = 0
    while(i < self.length){
      val x = f(self(i))
      var j = 0
      while(j < x.length){
        builder += x(j)
        j += 1
      }
      i += 1
    }
    new ofRef[Y](builder.result)
  }



  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectInt(f: PartialFunction[Boolean, Int]): ofInt = {
    val builder = new ArrayBuilder.ofInt()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofInt(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectLong(f: PartialFunction[Boolean, Long]): ofLong = {
    val builder = new ArrayBuilder.ofLong()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofLong(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectFloat(f: PartialFunction[Boolean, Float]): ofFloat = {
    val builder = new ArrayBuilder.ofFloat()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofFloat(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectDouble(f: PartialFunction[Boolean, Double]): ofDouble = {
    val builder = new ArrayBuilder.ofDouble()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofDouble(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectByte(f: PartialFunction[Boolean, Byte]): ofByte = {
    val builder = new ArrayBuilder.ofByte()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofByte(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectChar(f: PartialFunction[Boolean, Char]): ofChar = {
    val builder = new ArrayBuilder.ofChar()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofChar(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectShort(f: PartialFunction[Boolean, Short]): ofShort = {
    val builder = new ArrayBuilder.ofShort()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofShort(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectBoolean(f: PartialFunction[Boolean, Boolean]): ofBoolean = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofBoolean(builder.result)
  }


  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collectRef[Y <: AnyRef :reflect.ClassTag](f: PartialFunction[Boolean, Y]): ofRef[Y] = {
    val builder = new ArrayBuilder.ofRef[Y]()
    var i = 0
    val appendFunc = f.runWith(builder += _)
    while(i < self.length){
      appendFunc(self(i))
      i += 1
    }
    new ofRef[Y](builder.result)
  }



  def collectFirstInt(f: PartialFunction[Boolean, Int]): Option[Int] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstLong(f: PartialFunction[Boolean, Long]): Option[Long] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstFloat(f: PartialFunction[Boolean, Float]): Option[Float] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstDouble(f: PartialFunction[Boolean, Double]): Option[Double] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstByte(f: PartialFunction[Boolean, Byte]): Option[Byte] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstChar(f: PartialFunction[Boolean, Char]): Option[Char] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstShort(f: PartialFunction[Boolean, Short]): Option[Short] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstBoolean(f: PartialFunction[Boolean, Boolean]): Option[Boolean] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }


  def collectFirstRef[Y <: AnyRef :reflect.ClassTag](f: PartialFunction[Boolean, Y]): Option[Y] = {
    var i = 0
    while(i < self.length){
      if(f isDefinedAt self(i)){
        return Some(f(self(i)))
      }
      i += 1
    }
    None
  }



  def foldLeftInt(z: Int)(f: (Int, Boolean) => Int): Int = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftLong(z: Long)(f: (Long, Boolean) => Long): Long = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftFloat(z: Float)(f: (Float, Boolean) => Float): Float = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftDouble(z: Double)(f: (Double, Boolean) => Double): Double = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftByte(z: Byte)(f: (Byte, Boolean) => Byte): Byte = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftChar(z: Char)(f: (Char, Boolean) => Char): Char = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftShort(z: Short)(f: (Short, Boolean) => Short): Short = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftBoolean(z: Boolean)(f: (Boolean, Boolean) => Boolean): Boolean = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }


  def foldLeftRef[Y](z: Y)(f: (Y, Boolean) => Y): Y = {
    var i = 0
    var acc = z
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    acc
  }



  def foldRightInt(z: Int)(f: (Boolean, Int) => Int): Int = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightLong(z: Long)(f: (Boolean, Long) => Long): Long = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightFloat(z: Float)(f: (Boolean, Float) => Float): Float = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightDouble(z: Double)(f: (Boolean, Double) => Double): Double = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightByte(z: Byte)(f: (Boolean, Byte) => Byte): Byte = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightChar(z: Char)(f: (Boolean, Char) => Char): Char = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightShort(z: Short)(f: (Boolean, Short) => Short): Short = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightBoolean(z: Boolean)(f: (Boolean, Boolean) => Boolean): Boolean = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }


  def foldRightRef[Y](z: Y)(f: (Boolean, Y) => Y): Y = {
    var i = self.length - 1
    var acc = z
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    acc
  }



  def scanLeftInt(z: Int)(f: (Int, Boolean) => Int): ofInt = {
    val array = new Array[Int](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofInt(array)
  }


  def scanLeftLong(z: Long)(f: (Long, Boolean) => Long): ofLong = {
    val array = new Array[Long](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofLong(array)
  }


  def scanLeftFloat(z: Float)(f: (Float, Boolean) => Float): ofFloat = {
    val array = new Array[Float](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofFloat(array)
  }


  def scanLeftDouble(z: Double)(f: (Double, Boolean) => Double): ofDouble = {
    val array = new Array[Double](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofDouble(array)
  }


  def scanLeftByte(z: Byte)(f: (Byte, Boolean) => Byte): ofByte = {
    val array = new Array[Byte](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofByte(array)
  }


  def scanLeftChar(z: Char)(f: (Char, Boolean) => Char): ofChar = {
    val array = new Array[Char](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofChar(array)
  }


  def scanLeftShort(z: Short)(f: (Short, Boolean) => Short): ofShort = {
    val array = new Array[Short](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofShort(array)
  }


  def scanLeftBoolean(z: Boolean)(f: (Boolean, Boolean) => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofBoolean(array)
  }


  def scanLeftRef[Y <: AnyRef :reflect.ClassTag](z: Y)(f: (Y, Boolean) => Y): ofRef[Y] = {
    val array = new Array[Y](self.length + 1)
    array(0) = z
    var i = 0
    while(i < self.length){
      array(i + 1) = f(array(i), self(i))
      i += 1
    }
    new ofRef[Y](array)
  }



  def scanRightInt(z: Int)(f: (Boolean, Int) => Int): ofInt = {
    val array = new Array[Int](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofInt(array)
  }


  def scanRightLong(z: Long)(f: (Boolean, Long) => Long): ofLong = {
    val array = new Array[Long](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofLong(array)
  }


  def scanRightFloat(z: Float)(f: (Boolean, Float) => Float): ofFloat = {
    val array = new Array[Float](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofFloat(array)
  }


  def scanRightDouble(z: Double)(f: (Boolean, Double) => Double): ofDouble = {
    val array = new Array[Double](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofDouble(array)
  }


  def scanRightByte(z: Byte)(f: (Boolean, Byte) => Byte): ofByte = {
    val array = new Array[Byte](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofByte(array)
  }


  def scanRightChar(z: Char)(f: (Boolean, Char) => Char): ofChar = {
    val array = new Array[Char](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofChar(array)
  }


  def scanRightShort(z: Short)(f: (Boolean, Short) => Short): ofShort = {
    val array = new Array[Short](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofShort(array)
  }


  def scanRightBoolean(z: Boolean)(f: (Boolean, Boolean) => Boolean): ofBoolean = {
    val array = new Array[Boolean](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofBoolean(array)
  }


  def scanRightRef[Y <: AnyRef :reflect.ClassTag](z: Y)(f: (Boolean, Y) => Y): ofRef[Y] = {
    val array = new Array[Y](self.length + 1)
    array(self.length) = z
    var i = self.length
    while(i > 0){
      array(i - 1) = f(self(i - 1), array(i))
      i -= 1
    }
    new ofRef[Y](array)
  }



  def foldMapLeft1Int(z: Boolean => Int)(f: (Int, Boolean) => Int): Option[Int] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Long(z: Boolean => Long)(f: (Long, Boolean) => Long): Option[Long] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Float(z: Boolean => Float)(f: (Float, Boolean) => Float): Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Double(z: Boolean => Double)(f: (Double, Boolean) => Double): Option[Double] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Byte(z: Boolean => Byte)(f: (Byte, Boolean) => Byte): Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Char(z: Boolean => Char)(f: (Char, Boolean) => Char): Option[Char] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Short(z: Boolean => Short)(f: (Short, Boolean) => Short): Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Boolean(z: Boolean => Boolean)(f: (Boolean, Boolean) => Boolean): Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }


  def foldMapLeft1Ref[Y](z: Boolean => Y)(f: (Y, Boolean) => Y): Option[Y] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(0))
      var i = 1
      while(i < self.length){
        acc = f(acc, self(i))
        i += 1
      }
      Some(acc)
    }
  }



  def foldMapRight1Int(z: Boolean => Int)(f: (Boolean, Int) => Int): Option[Int] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Long(z: Boolean => Long)(f: (Boolean, Long) => Long): Option[Long] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Float(z: Boolean => Float)(f: (Boolean, Float) => Float): Option[Float] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Double(z: Boolean => Double)(f: (Boolean, Double) => Double): Option[Double] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Byte(z: Boolean => Byte)(f: (Boolean, Byte) => Byte): Option[Byte] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Char(z: Boolean => Char)(f: (Boolean, Char) => Char): Option[Char] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Short(z: Boolean => Short)(f: (Boolean, Short) => Short): Option[Short] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Boolean(z: Boolean => Boolean)(f: (Boolean, Boolean) => Boolean): Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }


  def foldMapRight1Ref[Y](z: Boolean => Y)(f: (Boolean, Y) => Y): Option[Y] = {
    if(self.length == 0){
      None
    }else{
      var acc = z(self(self.length - 1))
      var i = self.length - 2
      while(i >= 0){
        acc = f(self(i), acc)
        i -= 1
      }
      Some(acc)
    }
  }



  def map[A](f: Boolean => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => mapInt(f.asInstanceOf[Boolean => Int]).self
      case ClassTag.Long => mapLong(f.asInstanceOf[Boolean => Long]).self
      case ClassTag.Float => mapFloat(f.asInstanceOf[Boolean => Float]).self
      case ClassTag.Double => mapDouble(f.asInstanceOf[Boolean => Double]).self
      case ClassTag.Byte => mapByte(f.asInstanceOf[Boolean => Byte]).self
      case ClassTag.Char => mapChar(f.asInstanceOf[Boolean => Char]).self
      case ClassTag.Short => mapShort(f.asInstanceOf[Boolean => Short]).self
      case ClassTag.Boolean => mapBoolean(f.asInstanceOf[Boolean => Boolean]).self
      case _ => self.map(f)
    }).asInstanceOf[Array[A]]
  }



  def reverseMap[A](f: Boolean => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => reverseMapInt(f.asInstanceOf[Boolean => Int]).self
      case ClassTag.Long => reverseMapLong(f.asInstanceOf[Boolean => Long]).self
      case ClassTag.Float => reverseMapFloat(f.asInstanceOf[Boolean => Float]).self
      case ClassTag.Double => reverseMapDouble(f.asInstanceOf[Boolean => Double]).self
      case ClassTag.Byte => reverseMapByte(f.asInstanceOf[Boolean => Byte]).self
      case ClassTag.Char => reverseMapChar(f.asInstanceOf[Boolean => Char]).self
      case ClassTag.Short => reverseMapShort(f.asInstanceOf[Boolean => Short]).self
      case ClassTag.Boolean => reverseMapBoolean(f.asInstanceOf[Boolean => Boolean]).self
      case _ => self.reverseMap(f)
    }).asInstanceOf[Array[A]]
  }



  def flatMap[A](f: Boolean => Array[A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => flatMapInt(f.asInstanceOf[Boolean => Array[Int]]).self
      case ClassTag.Long => flatMapLong(f.asInstanceOf[Boolean => Array[Long]]).self
      case ClassTag.Float => flatMapFloat(f.asInstanceOf[Boolean => Array[Float]]).self
      case ClassTag.Double => flatMapDouble(f.asInstanceOf[Boolean => Array[Double]]).self
      case ClassTag.Byte => flatMapByte(f.asInstanceOf[Boolean => Array[Byte]]).self
      case ClassTag.Char => flatMapChar(f.asInstanceOf[Boolean => Array[Char]]).self
      case ClassTag.Short => flatMapShort(f.asInstanceOf[Boolean => Array[Short]]).self
      case ClassTag.Boolean => flatMapBoolean(f.asInstanceOf[Boolean => Array[Boolean]]).self
      case _ => self.flatMap(x => f(x))
    }).asInstanceOf[Array[A]]
  }



  
  /**
   * can not avoid boxing `PartialFunction#applyOrElse`
   * use `.withFilter(predicate).map(f)` instead
   */
  def collect[A](f: PartialFunction[Boolean, A])(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => collectInt(f.asInstanceOf[PartialFunction[Boolean, Int]]).self
      case ClassTag.Long => collectLong(f.asInstanceOf[PartialFunction[Boolean, Long]]).self
      case ClassTag.Float => collectFloat(f.asInstanceOf[PartialFunction[Boolean, Float]]).self
      case ClassTag.Double => collectDouble(f.asInstanceOf[PartialFunction[Boolean, Double]]).self
      case ClassTag.Byte => collectByte(f.asInstanceOf[PartialFunction[Boolean, Byte]]).self
      case ClassTag.Char => collectChar(f.asInstanceOf[PartialFunction[Boolean, Char]]).self
      case ClassTag.Short => collectShort(f.asInstanceOf[PartialFunction[Boolean, Short]]).self
      case ClassTag.Boolean => collectBoolean(f.asInstanceOf[PartialFunction[Boolean, Boolean]]).self
      case _ => self.collect(f)
    }).asInstanceOf[Array[A]]
  }



  def collectFirst[A](f: PartialFunction[Boolean, A])(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => collectFirstInt(f.asInstanceOf[PartialFunction[Boolean, Int]])
      case ClassTag.Long => collectFirstLong(f.asInstanceOf[PartialFunction[Boolean, Long]])
      case ClassTag.Float => collectFirstFloat(f.asInstanceOf[PartialFunction[Boolean, Float]])
      case ClassTag.Double => collectFirstDouble(f.asInstanceOf[PartialFunction[Boolean, Double]])
      case ClassTag.Byte => collectFirstByte(f.asInstanceOf[PartialFunction[Boolean, Byte]])
      case ClassTag.Char => collectFirstChar(f.asInstanceOf[PartialFunction[Boolean, Char]])
      case ClassTag.Short => collectFirstShort(f.asInstanceOf[PartialFunction[Boolean, Short]])
      case ClassTag.Boolean => collectFirstBoolean(f.asInstanceOf[PartialFunction[Boolean, Boolean]])
      case _ => self.collectFirst(f)
    }).asInstanceOf[Option[A]]
  }



  def foldLeft[A](z: A)(f: (A, Boolean) => A)(implicit A: ClassTag[A]): A = {
    (A match {
      case ClassTag.Int => foldLeftInt(z.asInstanceOf[Int])(f.asInstanceOf[(Int, Boolean) => Int])
      case ClassTag.Long => foldLeftLong(z.asInstanceOf[Long])(f.asInstanceOf[(Long, Boolean) => Long])
      case ClassTag.Float => foldLeftFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Float, Boolean) => Float])
      case ClassTag.Double => foldLeftDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Double, Boolean) => Double])
      case ClassTag.Byte => foldLeftByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Byte, Boolean) => Byte])
      case ClassTag.Char => foldLeftChar(z.asInstanceOf[Char])(f.asInstanceOf[(Char, Boolean) => Char])
      case ClassTag.Short => foldLeftShort(z.asInstanceOf[Short])(f.asInstanceOf[(Short, Boolean) => Short])
      case ClassTag.Boolean => foldLeftBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Boolean, Boolean) => Boolean])
      case _ => self.foldLeft(z)(f)
    }).asInstanceOf[A]
  }



  def foldRight[A](z: A)(f: (Boolean, A) => A)(implicit A: ClassTag[A]): A = {
    (A match {
      case ClassTag.Int => foldRightInt(z.asInstanceOf[Int])(f.asInstanceOf[(Boolean, Int) => Int])
      case ClassTag.Long => foldRightLong(z.asInstanceOf[Long])(f.asInstanceOf[(Boolean, Long) => Long])
      case ClassTag.Float => foldRightFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Boolean, Float) => Float])
      case ClassTag.Double => foldRightDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Boolean, Double) => Double])
      case ClassTag.Byte => foldRightByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Boolean, Byte) => Byte])
      case ClassTag.Char => foldRightChar(z.asInstanceOf[Char])(f.asInstanceOf[(Boolean, Char) => Char])
      case ClassTag.Short => foldRightShort(z.asInstanceOf[Short])(f.asInstanceOf[(Boolean, Short) => Short])
      case ClassTag.Boolean => foldRightBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Boolean, Boolean) => Boolean])
      case _ => self.foldRight(z)(f)
    }).asInstanceOf[A]
  }



  def scanLeft[A](z: A)(f: (A, Boolean) => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => scanLeftInt(z.asInstanceOf[Int])(f.asInstanceOf[(Int, Boolean) => Int]).self
      case ClassTag.Long => scanLeftLong(z.asInstanceOf[Long])(f.asInstanceOf[(Long, Boolean) => Long]).self
      case ClassTag.Float => scanLeftFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Float, Boolean) => Float]).self
      case ClassTag.Double => scanLeftDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Double, Boolean) => Double]).self
      case ClassTag.Byte => scanLeftByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Byte, Boolean) => Byte]).self
      case ClassTag.Char => scanLeftChar(z.asInstanceOf[Char])(f.asInstanceOf[(Char, Boolean) => Char]).self
      case ClassTag.Short => scanLeftShort(z.asInstanceOf[Short])(f.asInstanceOf[(Short, Boolean) => Short]).self
      case ClassTag.Boolean => scanLeftBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Boolean, Boolean) => Boolean]).self
      case _ => self.scanLeft(z)(f)
    }).asInstanceOf[Array[A]]
  }



  def scanRight[A](z: A)(f: (Boolean, A) => A)(implicit A: ClassTag[A]): Array[A] = {
    (A match {
      case ClassTag.Int => scanRightInt(z.asInstanceOf[Int])(f.asInstanceOf[(Boolean, Int) => Int]).self
      case ClassTag.Long => scanRightLong(z.asInstanceOf[Long])(f.asInstanceOf[(Boolean, Long) => Long]).self
      case ClassTag.Float => scanRightFloat(z.asInstanceOf[Float])(f.asInstanceOf[(Boolean, Float) => Float]).self
      case ClassTag.Double => scanRightDouble(z.asInstanceOf[Double])(f.asInstanceOf[(Boolean, Double) => Double]).self
      case ClassTag.Byte => scanRightByte(z.asInstanceOf[Byte])(f.asInstanceOf[(Boolean, Byte) => Byte]).self
      case ClassTag.Char => scanRightChar(z.asInstanceOf[Char])(f.asInstanceOf[(Boolean, Char) => Char]).self
      case ClassTag.Short => scanRightShort(z.asInstanceOf[Short])(f.asInstanceOf[(Boolean, Short) => Short]).self
      case ClassTag.Boolean => scanRightBoolean(z.asInstanceOf[Boolean])(f.asInstanceOf[(Boolean, Boolean) => Boolean]).self
      case _ => self.scanRight(z)(f)
    }).asInstanceOf[Array[A]]
  }



  def foldMapLeft1[A](z: Boolean => A)(f: (A, Boolean) => A)(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => foldMapLeft1Int(z.asInstanceOf[Boolean => Int])(f.asInstanceOf[(Int, Boolean) => Int])
      case ClassTag.Long => foldMapLeft1Long(z.asInstanceOf[Boolean => Long])(f.asInstanceOf[(Long, Boolean) => Long])
      case ClassTag.Float => foldMapLeft1Float(z.asInstanceOf[Boolean => Float])(f.asInstanceOf[(Float, Boolean) => Float])
      case ClassTag.Double => foldMapLeft1Double(z.asInstanceOf[Boolean => Double])(f.asInstanceOf[(Double, Boolean) => Double])
      case ClassTag.Byte => foldMapLeft1Byte(z.asInstanceOf[Boolean => Byte])(f.asInstanceOf[(Byte, Boolean) => Byte])
      case ClassTag.Char => foldMapLeft1Char(z.asInstanceOf[Boolean => Char])(f.asInstanceOf[(Char, Boolean) => Char])
      case ClassTag.Short => foldMapLeft1Short(z.asInstanceOf[Boolean => Short])(f.asInstanceOf[(Short, Boolean) => Short])
      case ClassTag.Boolean => foldMapLeft1Boolean(z.asInstanceOf[Boolean => Boolean])(f.asInstanceOf[(Boolean, Boolean) => Boolean])
      case _ => foldMapLeft1Ref(z)(f)
    }).asInstanceOf[Option[A]]
  }



  def foldMapRight1[A](z: Boolean => A)(f: (Boolean, A) => A)(implicit A: ClassTag[A]): Option[A] = {
    (A match {
      case ClassTag.Int => foldMapRight1Int(z.asInstanceOf[Boolean => Int])(f.asInstanceOf[(Boolean, Int) => Int])
      case ClassTag.Long => foldMapRight1Long(z.asInstanceOf[Boolean => Long])(f.asInstanceOf[(Boolean, Long) => Long])
      case ClassTag.Float => foldMapRight1Float(z.asInstanceOf[Boolean => Float])(f.asInstanceOf[(Boolean, Float) => Float])
      case ClassTag.Double => foldMapRight1Double(z.asInstanceOf[Boolean => Double])(f.asInstanceOf[(Boolean, Double) => Double])
      case ClassTag.Byte => foldMapRight1Byte(z.asInstanceOf[Boolean => Byte])(f.asInstanceOf[(Boolean, Byte) => Byte])
      case ClassTag.Char => foldMapRight1Char(z.asInstanceOf[Boolean => Char])(f.asInstanceOf[(Boolean, Char) => Char])
      case ClassTag.Short => foldMapRight1Short(z.asInstanceOf[Boolean => Short])(f.asInstanceOf[(Boolean, Short) => Short])
      case ClassTag.Boolean => foldMapRight1Boolean(z.asInstanceOf[Boolean => Boolean])(f.asInstanceOf[(Boolean, Boolean) => Boolean])
      case _ => foldMapRight1Ref(z)(f)
    }).asInstanceOf[Option[A]]
  }


  def foreach[U](f: Boolean => U): Unit = {
    var i = 0
    while(i < self.length){
      f(self(i))
      i += 1
    }
  }

  def filter(f: Boolean => Boolean): ofBoolean = {
    val builder = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        builder += self(i)
      }
      i += 1
    }
    new ofBoolean(builder.result)
  }

  def filterNot(f: Boolean => Boolean): ofBoolean = filter(!f(_))

  def withFilter(f: Boolean => Boolean): WithFilterBoolean =
    new WithFilterBoolean(this, f)

  def find(f: Boolean => Boolean): Option[Boolean] = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return Some(self(i))
      }
      i += 1
    }
    None
  }

  def exists(f: Boolean => Boolean): Boolean = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return true
      }
      i += 1
    }
    false
  }

  def forall(f: Boolean => Boolean): Boolean = !exists(!f(_))

  def take(n: Int): ofBoolean = {
    if(n >= self.length){
      this
    }else if(n <= 0){
      ofBoolean.empty
    }else{
      new ofBoolean(Arrays.copyOf(self, n ))
    }
  }

  def takeWhile(f: Boolean => Boolean): ofBoolean = {
    val len = index(!f(_))
    if(len < 0){
      this
    }else if(len == 0){
      ofBoolean.empty
    }else{
      new ofBoolean(Arrays.copyOf(self, len ))
    }
  }

  def takeWhileR(f: Boolean => Boolean): ofBoolean = {
    val len = lastIndex(f) + 1
    if(len <= 0){
      this
    }else if(len == self.length){
      ofBoolean.empty
    }else{
      new ofBoolean(Arrays.copyOfRange(self, len, self.length ))
    }
  }

  def takeRight(n: Int): ofBoolean = {
    if(n <= 0){
      ofBoolean.empty
    }else if(n >= self.length){
      this
    }else{
      val start = self.length - n
      new ofBoolean(Arrays.copyOfRange(self, start, self.length ))
    }
  }

  def reverse: ofBoolean = {
    var i = 0
    val len = self.length
    val array = new Array[Boolean](len)
    while(i < len){
      array(len - i - 1) = self(i)
      i += 1
    }
    new ofBoolean(array)
  }

  def reverse_:::(prefix: ofBoolean): ofBoolean = {
    if(prefix.length == 0){
      this
    }else{
      val array = new Array[Boolean](self.length + prefix.length)
      var i = 0
      val len = prefix.length
      while(i < len){
        array(i) = prefix.self(len - i - 1)
        i += 1
      }
      System.arraycopy(self, 0, array, prefix.length, self.length)
      new ofBoolean(array)
    }
  }

  def count(f: Boolean => Boolean): Int = {
    var i = 0
    var n = 0
    while(i < self.length){
      if(f(self(i))){
        n += 1
      }
      i += 1
    }
    n
  }

  def drop(n: Int): ofBoolean = {
    if(n <= 0){
      this
    }else if(n >= self.length){
      ofBoolean.empty
    }else{
      new ofBoolean(Arrays.copyOfRange(self, n, self.length ))
    }
  }

  def dropWhile(f: Boolean => Boolean): ofBoolean = {
    val len = index(!f(_))
    if(len < 0){
      ofBoolean.empty
    }else if(len == 0){
      this
    }else{
      new ofBoolean(Arrays.copyOfRange(self, len, self.length ))
    }
  }

  def dropWhileR(f: Boolean => Boolean): ofBoolean = {
    val len = lastIndex(f) + 1
    if(len <= 0){
      ofBoolean.empty
    }else if(len == self.length){
      this
    }else{
      new ofBoolean(Arrays.copyOf(self, len ))
    }
  }

  def dropRight(n: Int): ofBoolean = {
    if(n <= 0){
      this
    }else if(n >= self.length){
      ofBoolean.empty
    }else{
      new ofBoolean(Arrays.copyOf(self, self.length - n ))
    }
  }

  def contains(elem: Boolean): Boolean = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        return true
      }
      i += 1
    }
    false
  }

  def splitAt(n: Int): (ofBoolean, ofBoolean) = {
    if(n <= 0){
      (ofBoolean.empty, this)
    }else if(n >= self.length){
      (this, ofBoolean.empty)
    }else{
      (new ofBoolean(Arrays.copyOf(self, n )), new ofBoolean(Arrays.copyOfRange(self, n, self.length )))
    }
  }

  def span(f: Boolean => Boolean): (ofBoolean, ofBoolean) = {
    val n = index(!f(_))
    if(n < 0){
      (this, ofBoolean.empty)
    }else if(n >= self.length){
      (ofBoolean.empty, this)
    }else{
      (new ofBoolean(Arrays.copyOf(self, n )), new ofBoolean(Arrays.copyOfRange(self, n, self.length )))
    }
  }

  def ++(that: ofBoolean): ofBoolean = {
    if(self.length == 0){
      that
    }else if(that.length == 0){
      this
    }else{
      val size1 = self.length
      val size2 = that.length
      val array = new Array[Boolean](size1 + size2)
      System.arraycopy(self, 0, array, 0, size1)
      System.arraycopy(that.self, 0, array, size1, size2)
      new ofBoolean(array)
    }
  }

  def partition(f: Boolean => Boolean): (ofBoolean, ofBoolean) = {
    val l, r = new ArrayBuilder.ofBoolean()
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        l += self(i)
      }else{
        r += self(i)
      }
      i += 1
    }
    (new ofBoolean(l.result), new ofBoolean(r.result))
  }

  @throws[IndexOutOfBoundsException]
  def updated(index: Int, elem: Boolean): ofBoolean = {
    val array = self.clone
    array(index) = elem
    new ofBoolean(array)
  }

  def slice(from: Int, until: Int): ofBoolean = {
    if(until <= from || until <= 0 || from >= self.length){
      ofBoolean.empty
    }else if(from <= 0 && self.length <= until){
      this
    }else{
      new ofBoolean(Arrays.copyOfRange(self, from max 0, until min self.length ))
    }
  }

  def reduceLeftOption(f: (Boolean, Boolean) => Boolean): Option[Boolean] = {
    if(self.length == 0) return None

    var i = 1
    var acc = self(0)
    while(i < self.length){
      acc = f(acc, self(i))
      i += 1
    }
    Some(acc)
  }

  def reduceRightOption(f: (Boolean, Boolean) => Boolean): Option[Boolean] = {
    if(self.length == 0) return None

    var i = self.length - 2
    var acc = self(self.length - 1)
    while(i >= 0){
      acc = f(self(i), acc)
      i -= 1
    }
    Some(acc)
  }

  def indexOf(elem: Boolean): Option[Int] = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        return Some(i)
      }
      i += 1
    }
    None
  }

  def lastIndexOf(elem: Boolean): Option[Int] = {
    var i = self.length - 1
    while(i >= 0){
      if(self(i) == elem){
        return Some(i)
      }
      i -= 1
    }
    None
  }

  def tailOption: Option[ofBoolean] = {
    if(self.length != 0){
      Some(drop(1))
    }else{
      None
    }
  }

  def tails: Iterator[ofBoolean] = new Iterator[ofBoolean]{
    private[this] var i = 0
    var hasNext = true
    def next: ofBoolean = {
      val r = new ofBoolean(Arrays.copyOfRange(self, i, self.length ))
      i += 1
      if(i > self.length) hasNext = false
      r
    }
  }

  def inits: Iterator[ofBoolean] = new Iterator[ofBoolean]{
    private[this] var i = self.length
    var hasNext = true
    def next: ofBoolean = {
      val r = new ofBoolean(Arrays.copyOfRange(self, 0, i ))
      i -= 1
      if(i < 0) hasNext = false
      r
    }
  }

  def initOption: Option[ofBoolean] = {
    if(self.length != 0){
      Some(dropRight(1))
    }else{
      None
    }
  }

  def length: Int = self.length

  def size: Int = self.length

  @inline private def index(f: Boolean => Boolean): Int = {
    var i = 0
    while(i < self.length){
      if(f(self(i))){
        return i
      }
      i += 1
    }
    -1
  }

  @inline private def lastIndex(f: Boolean => Boolean): Int = {
    var i = self.length - 1
    while(0 <= i){
      if(!f(self(i))){
        return i
      }
      i -= 1
    }
    -1
  }

  override def toString = mkString("ofBoolean(", ", ", ")")

  def mkString(start: String, sep: String, end: String): String =
    addString(new StringBuilder(), start, sep, end).toString

  def mkString(sep: String): String = mkString("", sep, "")

  def mkString: String = mkString("")

  def addString(b: StringBuilder, start: String, sep: String, end: String): StringBuilder = {
    var first = true

    b append start
    var i = 0
    while(i < self.length){
      if (first) {
        b append self(i)
        first = false
      }
      else {
        b append sep
        b append self(i)
      }
      i += 1
    }
    b append end

    b
  }

  def ===(that: ofBoolean): Boolean = Arrays.equals(self, that.self)

  @throws[IllegalArgumentException]
  def grouped(n: Int): Iterator[ofBoolean] = sliding(n, n)

  @throws[IllegalArgumentException]
  def sliding(_size: Int, step: Int = 1): Iterator[ofBoolean] = {
    require(_size > 0, "size must be positive number")
    require(step > 0, "step must be positive number")
    new Iterator[ofBoolean]{
      private[this] var i = 0
      var hasNext = self.length != 0
      def next = {
        // n is negative, if `i + _size` overflow
        val n = i + _size
        val until = if(n > 0) math.min(n, self.length) else self.length
        val r = new ofBoolean(Arrays.copyOfRange(self, i, until ))
        i += step
        if(i >= self.length || n > self.length || n < 0) hasNext = false
        r
      }
    }
  }

  def scanLeft1(f: (Boolean, Boolean) => Boolean): ofBoolean = {
    if(self.length != 0){
      val array = new Array[Boolean](self.length)
      array(0) = self(0)
      var i = 0
      while(i < self.length - 1){
        array(i + 1) = f(array(i), self(i + 1))
        i += 1
      }
      new ofBoolean(array)
    }else{
      ofBoolean.empty
    }
  }

  def scanRight1(f: (Boolean, Boolean) => Boolean): ofBoolean = {
    if(self.length != 0){
      val array = new Array[Boolean](self.length)
      array(self.length - 1) = self(self.length - 1)
      var i = self.length - 1
      while(i > 0){
        array(i - 1) = f(self(i - 1), array(i))
        i -= 1
      }
      new ofBoolean(array)
    }else{
      ofBoolean.empty
    }
  }

  def startsWith(that: Array[Boolean], offset: Int = 0): Boolean = {
    require(offset >= 0, "offset = " + offset  + " is invalid. offset must be positive")
    var i = offset
    var j = 0
    val thisLen = self.length
    val thatLen = that.length
    while (i < thisLen && j < thatLen && self(i) == that(j)) {
      i += 1
      j += 1
    }
    j == thatLen
  }

  def endsWith(that: Array[Boolean]): Boolean = {
    var i = length - 1
    var j = that.length - 1

    (j <= i) && {
      while (j >= 0){
        if(self(i) != that(j)){
          return false
        }
        i -= 1
        j -= 1
      }
      true
    }
  }

  def groupBy[A](f: Boolean => A): Map[A, ofBoolean] = {
    val m = collection.mutable.Map.empty[A, ArrayBuilder.ofBoolean]
    var i = 0
    while(i < self.length){
      val key = f(self(i))
      m.getOrElseUpdate(key, new ArrayBuilder.ofBoolean) += self(i)
      i += 1
    }

    val b = Map.newBuilder[A, ofBoolean]
    m.foreach{ case (k, v) =>
      b += ((k, new ofBoolean(v.result)))
    }

    b.result
  }

  def maxBy[A](f: Boolean => A)(implicit A: Ordering[A]): Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var maxF = f(self(0))
      var maxElem = self(0)
      var i = 1
      while(i < self.length){
        val fx = f(self(i))
        if (A.gt(fx, maxF)) {
          maxElem = self(i)
          maxF = fx
        }
        i += 1
      }
      Some(maxElem)
    }
  }

  def minBy[A](f: Boolean => A)(implicit A: Ordering[A]): Option[Boolean] = {
    if(self.length == 0){
      None
    }else{
      var minF = f(self(0))
      var minElem = self(0)
      var i = 1
      while(i < self.length){
        val fx = f(self(i))
        if (A.lt(fx, minF)) {
          minElem = self(i)
          minF = fx
        }
        i += 1
      }
      Some(minElem)
    }
  }

  def deleteFirst(elem: Boolean): ofBoolean = {
    var i = 0
    while(i < self.length){
      if(self(i) == elem){
        val array = new Array[Boolean](self.length - 1)
        System.arraycopy(self, 0, array, 0, i)
        System.arraycopy(self, i + 1, array, i, self.length - i - 1)
        return new ofBoolean(array)
      }
      i += 1
    }
    this
  }

  def intersperse(a: Boolean): ofBoolean = {
    if(self.length == 0){
      ofBoolean.empty
    }else{
      val array = new Array[Boolean]((self.length * 2) - 1)
      var i = 0
      java.util.Arrays.fill(array, a)
      while(i < self.length){
        array(i * 2) = self(i)
        i += 1
      }
      new ofBoolean(array)
    }
  }
}

object ofBoolean {

  def apply(elems: Boolean *): ofBoolean = elems match{
    case a: collection.mutable.WrappedArray.ofBoolean => new ofBoolean(a.array)
    case _ => new ofBoolean(elems.toArray)
  }

  val empty: ofBoolean = new ofBoolean(new Array[Boolean](0))

  def iterate(start: Boolean, len: Int)(f: Boolean => Boolean): ofBoolean = {
    if(len == 0){
      empty
    }else{
      val array = new Array[Boolean](len)
      var i = 1
      array(0) = start
      while (i < len) {
        array(i) = f(array(i - 1))
        i += 1
      }
      new ofBoolean(array)
    }
  }

  def tabulate(n: Int)(f: Int => Boolean): ofBoolean = {
    val array = new Array[Boolean](n)
    var i = 0
    while (i < n) {
      array(i) = f(i)
      i += 1
    }
    new ofBoolean(array)
  }

  def flatten(xs: Array[Array[Boolean]]): ofBoolean = {
    var i = 0
    var n = 0
    val length = xs.length
    while(i < length){
      n += xs(i).length
      i += 1
    }
    val array = new Array[Boolean](n)
    i = 0
    n = 0
    while(i < length){
      val elem = xs(i)
      System.arraycopy(elem, 0, array, n, elem.length)
      n += elem.length
      i += 1
    }
    new ofBoolean(array)
  }

  def fillAll(size: Int)(elem: Boolean): ofBoolean = {
    val array = new Array[Boolean](size)
    Arrays.fill(array, elem)
    new ofBoolean(array)
  }

  def fill(size: Int)(f: => Boolean): ofBoolean = {
    val array = new Array[Boolean](size)
    var i = 0
    while(i < size){
      array(i) = f
      i += 1
    }
    new ofBoolean(array)
  }

  def unfold[@specialized B ](z: B)(f: B => Option[(B, Boolean)]): ofBoolean = {
    val builder = new ArrayBuilder.ofBoolean()
    @annotation.tailrec
    def loop(next: Option[(B, Boolean)]): Unit = next match {
      case Some((b, a)) =>
        builder += a
        loop(f(b))
      case None =>
    }
    loop(f(z))
    new ofBoolean(builder.result)
  }

}

