/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.ImageSpan;

public class AlignMiddleImageSpan
extends ImageSpan {
    public static final int ALIGN_MIDDLE = -100;
    private float mFontWidthMultiple = -1.0f;
    private boolean mAvoidSuperChangeFontMetrics = false;
    private int mWidth;

    public AlignMiddleImageSpan(Drawable d, int verticalAlignment) {
        super(d, verticalAlignment);
    }

    public AlignMiddleImageSpan(Drawable d, int verticalAlignment, float fontWidthMultiple) {
        this(d, verticalAlignment);
        if (fontWidthMultiple >= 0.0f) {
            this.mFontWidthMultiple = fontWidthMultiple;
        }
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        if (this.mAvoidSuperChangeFontMetrics) {
            Drawable d = this.getDrawable();
            Rect rect = d.getBounds();
            this.mWidth = rect.right;
        } else {
            this.mWidth = super.getSize(paint, text, start, end, fm);
        }
        if (this.mFontWidthMultiple > 0.0f) {
            this.mWidth = (int)(paint.measureText("\u5b50") * this.mFontWidthMultiple);
        }
        return this.mWidth;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        if (this.mVerticalAlignment == -100) {
            Drawable d = this.getDrawable();
            canvas.save();
            Paint.FontMetricsInt fontMetricsInt = paint.getFontMetricsInt();
            int fontTop = y + fontMetricsInt.top;
            int fontMetricsHeight = fontMetricsInt.bottom - fontMetricsInt.top;
            int iconHeight = d.getBounds().bottom - d.getBounds().top;
            int iconTop = fontTop + (fontMetricsHeight - iconHeight) / 2;
            canvas.translate(x, (float)iconTop);
            d.draw(canvas);
            canvas.restore();
        } else {
            super.draw(canvas, text, start, end, x, top, y, bottom, paint);
        }
    }

    public void setAvoidSuperChangeFontMetrics(boolean avoidSuperChangeFontMetrics) {
        this.mAvoidSuperChangeFontMetrics = avoidSuperChangeFontMetrics;
    }
}

