/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.marqueen;

import android.content.Context;
import android.view.View;
import com.xuexiang.xui.widget.textview.marqueen.MarqueeView;
import java.util.ArrayList;
import java.util.List;

public abstract class MarqueeFactory<T extends View, E> {
    protected Context mContext;
    protected OnItemClickListener<T, E> mOnItemClickListener;
    protected List<T> mViews;
    protected List<E> mDatas;
    private boolean isOnItemClickRegistered;
    private MarqueeView mMarqueeView;

    public MarqueeFactory(Context context) {
        this.mContext = context;
    }

    public abstract T generateMarqueeItemView(E var1);

    public void setData(List<E> datas) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.mDatas = datas;
        this.mViews = new ArrayList<T>();
        for (int i = 0; i < datas.size(); ++i) {
            E data = datas.get(i);
            T mView = this.generateMarqueeItemView(data);
            this.mViews.add(mView);
        }
        this.registerOnItemClick();
        if (this.mMarqueeView != null) {
            this.mMarqueeView.setMarqueeFactory(this);
        }
    }

    public void setOnItemClickListener(OnItemClickListener<T, E> onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
        this.registerOnItemClick();
    }

    public List<T> getMarqueeViews() {
        return this.mViews;
    }

    private void registerOnItemClick() {
        if (!this.isOnItemClickRegistered && this.mOnItemClickListener != null && this.mDatas != null) {
            for (int i = 0; i < this.mDatas.size(); ++i) {
                View mView = (View)this.mViews.get(i);
                E data = this.mDatas.get(i);
                mView.setTag(new ViewHolder<View, E>(mView, data, i));
                mView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        MarqueeFactory.this.mOnItemClickListener.onItemClickListener((ViewHolder)view.getTag());
                    }
                });
            }
            this.isOnItemClickRegistered = true;
        }
    }

    public void setAttachedToMarqueeView(MarqueeView marqueeView) {
        this.mMarqueeView = marqueeView;
    }

    public static class ViewHolder<V extends View, P> {
        public V mView;
        public P mData;
        public int mPosition;

        public ViewHolder(V view, P data, int position) {
            this.mView = view;
            this.mData = data;
            this.mPosition = position;
        }

        public V getView() {
            return this.mView;
        }

        public ViewHolder setView(V view) {
            this.mView = view;
            return this;
        }

        public P getData() {
            return this.mData;
        }

        public ViewHolder setData(P data) {
            this.mData = data;
            return this;
        }

        public int getPosition() {
            return this.mPosition;
        }

        public ViewHolder setPosition(int position) {
            this.mPosition = position;
            return this;
        }
    }

    public static interface OnItemClickListener<V extends View, E> {
        public void onItemClickListener(ViewHolder<V, E> var1);
    }
}

