/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.label;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Typeface;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import java.util.concurrent.atomic.AtomicInteger;

public class LabelView
extends AppCompatTextView {
    private float _offsetx;
    private float _offsety;
    private float _anchorx;
    private float _anchory;
    private float _angel;
    private int _labelViewContainerID;
    private Animation _animation = new Animation(){

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            Matrix tran = t.getMatrix();
            tran.postTranslate(LabelView.this._offsetx, LabelView.this._offsety);
            tran.postRotate(LabelView.this._angel, LabelView.this._anchorx, LabelView.this._anchory);
        }
    };
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);

    public LabelView(Context context) {
        this(context, null);
    }

    public LabelView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public LabelView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
        this._animation.setFillBefore(true);
        this._animation.setFillAfter(true);
        this._animation.setFillEnabled(true);
    }

    private void init() {
        if (!(this.getLayoutParams() instanceof ViewGroup.LayoutParams)) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this._labelViewContainerID = -1;
        this.setGravity(17);
        this.setTextColor(-1);
        this.setTypeface(Typeface.DEFAULT_BOLD);
        this.setTextSize(2, 12.0f);
        this.setBackgroundColor(-16776961);
    }

    public void setTargetView(View target, int distance, Gravity gravity) {
        if (!this.replaceLayout(target)) {
            return;
        }
        final int d = this.dip2Px(distance);
        final Gravity g = gravity;
        final View v = target;
        ViewTreeObserver vto = this.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                LabelView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                LabelView.this.calcOffset(LabelView.this.getMeasuredWidth(), d, g, v.getMeasuredWidth(), false);
            }
        });
    }

    public void setTargetViewInBaseAdapter(View target, int targetWidth, int distance, Gravity gravity) {
        if (!this.replaceLayout(target)) {
            return;
        }
        this.calcOffset(this.dip2Px(targetWidth), distance, gravity, targetWidth, true);
    }

    public void remove() {
        if (this.getParent() == null || this._labelViewContainerID == -1) {
            return;
        }
        ViewGroup frameContainer = (ViewGroup)this.getParent();
        assert (frameContainer.getChildCount() == 2);
        View target = frameContainer.getChildAt(0);
        ViewGroup parentContainer = (ViewGroup)frameContainer.getParent();
        int groupIndex = parentContainer.indexOfChild((View)frameContainer);
        if (frameContainer.getParent() instanceof RelativeLayout) {
            for (int i = 0; i < parentContainer.getChildCount(); ++i) {
                if (i == groupIndex) continue;
                View view = parentContainer.getChildAt(i);
                RelativeLayout.LayoutParams para = (RelativeLayout.LayoutParams)view.getLayoutParams();
                for (int j = 0; j < para.getRules().length; ++j) {
                    if (para.getRules()[j] != this._labelViewContainerID) continue;
                    para.getRules()[j] = target.getId();
                }
                view.setLayoutParams((ViewGroup.LayoutParams)para);
            }
        }
        ViewGroup.LayoutParams frameLayoutParam = frameContainer.getLayoutParams();
        target.setLayoutParams(frameLayoutParam);
        parentContainer.removeViewAt(groupIndex);
        frameContainer.removeView(target);
        frameContainer.removeView((View)this);
        parentContainer.addView(target, groupIndex);
        this._labelViewContainerID = -1;
    }

    private boolean replaceLayout(View target) {
        if (this.getParent() != null || target == null || target.getParent() == null || this._labelViewContainerID != -1) {
            return false;
        }
        ViewGroup parentContainer = (ViewGroup)target.getParent();
        if (target.getParent() instanceof FrameLayout) {
            ((FrameLayout)target.getParent()).addView((View)this);
        } else if (target.getParent() instanceof ViewGroup) {
            int groupIndex = parentContainer.indexOfChild(target);
            this._labelViewContainerID = LabelView.generateViewId();
            if (target.getParent() instanceof RelativeLayout) {
                for (int i = 0; i < parentContainer.getChildCount(); ++i) {
                    if (i == groupIndex) continue;
                    View view = parentContainer.getChildAt(i);
                    RelativeLayout.LayoutParams para = (RelativeLayout.LayoutParams)view.getLayoutParams();
                    for (int j = 0; j < para.getRules().length; ++j) {
                        if (para.getRules()[j] != target.getId()) continue;
                        para.getRules()[j] = this._labelViewContainerID;
                    }
                    view.setLayoutParams((ViewGroup.LayoutParams)para);
                }
            }
            parentContainer.removeView(target);
            FrameLayout labelViewContainer = new FrameLayout(this.getContext());
            ViewGroup.LayoutParams targetLayoutParam = target.getLayoutParams();
            labelViewContainer.setLayoutParams(targetLayoutParam);
            target.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            labelViewContainer.addView(target);
            labelViewContainer.addView((View)this);
            labelViewContainer.setId(this._labelViewContainerID);
            parentContainer.addView((View)labelViewContainer, groupIndex, targetLayoutParam);
        }
        return true;
    }

    private void calcOffset(int labelWidth, int distance, Gravity gravity, int targetWidth, boolean isDP) {
        int d = this.dip2Px(distance);
        int tw = isDP ? this.dip2Px(targetWidth) : targetWidth;
        float edge = (float)((double)(labelWidth - 2 * d) / 2.828);
        if (gravity == Gravity.LEFT_TOP) {
            this._offsetx = this._anchorx = -edge;
            this._angel = -45.0f;
        } else if (gravity == Gravity.RIGHT_TOP) {
            this._offsetx = (float)tw + edge - (float)labelWidth;
            this._anchorx = (float)tw + edge;
            this._angel = 45.0f;
        }
        this._offsety = this._anchory = (float)(1.414 * (double)d + (double)edge);
        this.clearAnimation();
        this.startAnimation(this._animation);
    }

    private int dip2Px(float dip) {
        return (int)(dip * this.getContext().getResources().getDisplayMetrics().density + 0.5f);
    }

    public static int generateViewId() {
        int newValue;
        int result;
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    public static enum Gravity {
        LEFT_TOP,
        RIGHT_TOP;

    }
}

