/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.textview.badge;

import android.graphics.PointF;
import java.util.List;

public class MathUtils {
    public static final double CIRCLE_RADIAN = Math.PI * 2;

    private MathUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static double getTanRadian(double atan, int quadrant) {
        if (atan < 0.0) {
            atan += 1.5707963267948966;
        }
        return atan += 1.5707963267948966 * (double)(quadrant - 1);
    }

    public static double radianToAngle(double radian) {
        return 360.0 * (radian / (Math.PI * 2));
    }

    public static int getQuadrant(PointF p, PointF center) {
        if (p.x > center.x) {
            if (p.y > center.y) {
                return 4;
            }
            if (p.y < center.y) {
                return 1;
            }
        } else if (p.x < center.x) {
            if (p.y > center.y) {
                return 3;
            }
            if (p.y < center.y) {
                return 2;
            }
        }
        return -1;
    }

    public static float getPointDistance(PointF p1, PointF p2) {
        return (float)Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0));
    }

    public static void getInnerTangentPoints(PointF circleCenter, float radius, Double slopeLine, List<PointF> points) {
        float yOffset;
        float xOffset;
        if (slopeLine != null) {
            float radian = (float)Math.atan(slopeLine);
            xOffset = (float)(Math.cos(radian) * (double)radius);
            yOffset = (float)(Math.sin(radian) * (double)radius);
        } else {
            xOffset = radius;
            yOffset = 0.0f;
        }
        points.add(new PointF(circleCenter.x + xOffset, circleCenter.y + yOffset));
        points.add(new PointF(circleCenter.x - xOffset, circleCenter.y - yOffset));
    }
}

