/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.tabbar;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.support.v7.widget.LinearLayoutCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import uk.co.chrisjenx.calligraphy.HasTypeface;

public class EasyIndicator
extends LinearLayout
implements View.OnClickListener,
ViewPager.OnPageChangeListener,
HasTypeface {
    private View mIndicator;
    private int mPosition;
    private ViewPager mViewPager;
    public onTabClickListener mOnTabClickListener;
    private LinearLayout tab_content;
    private TextView[] tvs;
    public int screenWidth;
    public int screenHeight;
    private int mCurrIndex;
    private int indicatorHeight = 45;
    private int indicator_width = -1;
    private boolean indicator_line_show = true;
    private int indicator_line_height = 3;
    private int indicator_line_color;
    private int indicator_bottom_line_height = 0;
    private int indicator_bottom_line_color;
    private int indicator_vertical_line_w = 0;
    private int indicator_vertical_line_h = 0;
    private int indicator_vertical_line_color;
    private int indicator_selected_color;
    private int indicator_normal_color;
    private float indicator_textSize;
    private float indicator_select_textSize = this.indicator_textSize = 14.0f;

    public EasyIndicator(Context context) {
        this(context, null);
    }

    public EasyIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.EasyIndicatorStyle);
    }

    public EasyIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        this.initScreenWidth();
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.EasyIndicator, defStyleAttr, 0);
        if (a != null) {
            this.indicatorHeight = (int)this.getDimensionPixelSize(a, R.styleable.EasyIndicator_indicator_height, this.indicatorHeight);
            this.indicator_line_height = (int)this.getDimensionPixelSize(a, R.styleable.EasyIndicator_indicator_line_height, this.indicator_line_height);
            this.indicator_bottom_line_height = (int)this.getDimensionPixelSize(a, R.styleable.EasyIndicator_indicator_bottom_line_height, this.indicator_bottom_line_height);
            this.indicator_bottom_line_color = a.getColor(R.styleable.EasyIndicator_indicator_bottom_line_color, ThemeUtils.resolveColor(this.getContext(), R.attr.xui_config_color_separator_dark));
            this.indicator_selected_color = a.getColor(R.styleable.EasyIndicator_indicator_selected_color, ThemeUtils.resolveColor(this.getContext(), R.attr.colorAccent));
            this.indicator_normal_color = a.getColor(R.styleable.EasyIndicator_indicator_normal_color, ResUtils.getColor(R.color.xui_config_color_black));
            this.indicator_line_color = a.getColor(R.styleable.EasyIndicator_indicator_line_color, ThemeUtils.resolveColor(this.getContext(), R.attr.colorAccent));
            this.indicator_textSize = this.getDimensionPixelSize(a, R.styleable.EasyIndicator_indicator_textSize, (int)this.indicator_textSize);
            this.indicator_line_show = a.getBoolean(R.styleable.EasyIndicator_indicator_line_show, this.indicator_line_show);
            this.indicator_vertical_line_w = (int)this.getDimensionPixelSize(a, R.styleable.EasyIndicator_indicator_vertical_line_w, this.indicator_vertical_line_w);
            this.indicator_vertical_line_color = a.getColor(R.styleable.EasyIndicator_indicator_vertical_line_color, ThemeUtils.resolveColor(this.getContext(), R.attr.xui_config_color_separator_dark));
            this.indicator_vertical_line_h = (int)this.getDimensionPixelSize(a, R.styleable.EasyIndicator_indicator_vertical_line_h, this.indicator_vertical_line_h);
            this.indicator_width = (int)this.getDimensionPixelSize(a, R.styleable.EasyIndicator_indicator_width, this.indicator_width);
            this.indicator_select_textSize = this.getDimensionPixelSize(a, R.styleable.EasyIndicator_indicator_select_textSize, 14);
            if (this.indicator_width == 0) {
                this.indicator_width = -1;
            }
            a.recycle();
        }
        this.tab_content = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.indicator_width, -2);
        this.tab_content.setBackgroundColor(-1);
        params.gravity = 17;
        this.tab_content.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void setTabTitles(String[] tabTitles) {
        this.tvs = new TextView[tabTitles.length];
        this.tab_content.removeAllViews();
        for (int i = 0; i < tabTitles.length; ++i) {
            TextView view = new TextView(this.getContext());
            view.setTag((Object)i);
            view.setText((CharSequence)tabTitles[i]);
            view.setTypeface(XUI.getDefaultTypeface());
            view.setGravity(17);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, this.indicatorHeight, 1.0f);
            view.setLayoutParams((ViewGroup.LayoutParams)lp);
            switch (i) {
                case 0: {
                    view.setTextColor(this.indicator_selected_color);
                    view.setTextSize(0, this.indicator_select_textSize);
                    break;
                }
                default: {
                    view.setTextColor(this.indicator_normal_color);
                    view.setTextSize(0, this.indicator_textSize);
                }
            }
            view.setOnClickListener((View.OnClickListener)this);
            this.tvs[i] = view;
            this.tab_content.addView((View)view);
            if (i == tabTitles.length - 1) continue;
            View line = new View(this.getContext());
            line.setBackgroundColor(this.indicator_vertical_line_color);
            LinearLayoutCompat.LayoutParams compat = new LinearLayoutCompat.LayoutParams(this.indicator_vertical_line_w, this.indicator_vertical_line_h);
            line.setLayoutParams((ViewGroup.LayoutParams)compat);
            this.tab_content.addView(line);
        }
        this.removeAllViews();
        this.addView((View)this.tab_content);
        if (this.indicator_line_show) {
            this.mIndicator = new View(this.getContext());
            int iw = 0;
            if (this.indicator_width == 0 || this.indicator_width == -1) {
                iw = this.screenWidth / this.tvs.length;
            }
            this.mIndicator.setLayoutParams((ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(iw, this.indicator_line_height));
            this.mIndicator.setBackgroundColor(this.indicator_line_color);
            this.addView(this.mIndicator);
        }
        View line = new View(this.getContext());
        LinearLayoutCompat.LayoutParams params = new LinearLayoutCompat.LayoutParams(-1, this.indicator_bottom_line_height);
        line.setLayoutParams((ViewGroup.LayoutParams)params);
        line.setBackgroundColor(this.indicator_bottom_line_color);
        this.addView(line);
    }

    public void setViewPager(PagerAdapter adapter) {
        this.mViewPager = new ViewPager(this.getContext());
        this.mViewPager.setId(R.id.view_pager);
        this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(-1, -1));
        this.mViewPager.setAdapter(adapter);
        this.mViewPager.setCurrentItem(0);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.addView((View)this.mViewPager);
    }

    public void setViewPager(ViewPager viewPage, PagerAdapter adapter) {
        this.mViewPager = viewPage;
        this.mViewPager.setAdapter(adapter);
        this.mViewPager.setCurrentItem(0);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
    }

    private AnimatorSet buildIndicatorAnimatorTowards(TextView tv) {
        float x = this.tab_content.getX();
        ObjectAnimator xAnimator = ObjectAnimator.ofFloat((Object)this.mIndicator, (String)"X", (float[])new float[]{this.mIndicator.getX(), tv.getX() + x});
        final ViewGroup.LayoutParams params = this.mIndicator.getLayoutParams();
        ValueAnimator widthAnimator = ValueAnimator.ofInt((int[])new int[]{params.width, tv.getMeasuredWidth()});
        widthAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                params.width = (Integer)animation.getAnimatedValue();
                EasyIndicator.this.mIndicator.setLayoutParams(params);
            }
        });
        AnimatorSet set = new AnimatorSet();
        set.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        set.playTogether(new Animator[]{xAnimator, widthAnimator});
        return set;
    }

    public void onClick(View v) {
        TextView tv = (TextView)v;
        this.mPosition = (Integer)v.getTag();
        if (this.mViewPager != null) {
            this.mViewPager.setCurrentItem(this.mPosition);
        } else {
            this.setSelectorColor(tv);
            if (this.indicator_line_show) {
                this.buildIndicatorAnimatorTowards(tv).start();
            }
        }
        if (this.mOnTabClickListener != null) {
            this.mOnTabClickListener.onTabClick(((TextView)v).getText().toString(), this.mPosition);
        }
    }

    private void setSelectorColor(TextView tv) {
        for (int i = 0; i < this.tvs.length; ++i) {
            this.tvs[i].setTextColor(this.indicator_normal_color);
            this.tvs[i].setTextSize(0, this.indicator_textSize);
        }
        tv.setTextColor(this.indicator_selected_color);
        tv.setTextSize(0, this.indicator_select_textSize);
    }

    public void setOnTabClickListener(onTabClickListener onTabClickListener2) {
        this.mOnTabClickListener = onTabClickListener2;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        LinearLayout.LayoutParams ll = (LinearLayout.LayoutParams)this.mIndicator.getLayoutParams();
        if (this.mCurrIndex == position) {
            ll.leftMargin = (int)((float)(this.mCurrIndex * this.mIndicator.getMeasuredWidth()) + positionOffset * (float)this.mIndicator.getMeasuredWidth());
        } else if (this.mCurrIndex > position) {
            ll.leftMargin = (int)((float)(this.mCurrIndex * this.mIndicator.getMeasuredWidth()) - (1.0f - positionOffset) * (float)this.mIndicator.getMeasuredWidth());
        }
        this.mIndicator.setLayoutParams((ViewGroup.LayoutParams)ll);
    }

    public void onPageSelected(int position) {
        this.mCurrIndex = position;
        this.setSelectorColor(this.tvs[position]);
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void setTypeface(Typeface typeface) {
        if (this.tvs != null) {
            for (TextView tv : this.tvs) {
                tv.setTypeface(typeface);
            }
        }
    }

    private float getDimensionPixelSize(TypedArray typeArray, int styleable2, int defaultSize) {
        int sizeStyleable = typeArray.getResourceId(styleable2, 0);
        return sizeStyleable > 0 ? (float)typeArray.getResources().getDimensionPixelSize(sizeStyleable) : (float)typeArray.getDimensionPixelSize(styleable2, (int)this.getPixelSizeBySp(defaultSize));
    }

    private float getPixelSizeBySp(int sp) {
        Resources res = this.getResources();
        float scale = res.getDisplayMetrics().scaledDensity;
        return (float)sp * scale;
    }

    private void initScreenWidth() {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.screenHeight = dm.heightPixels;
        this.screenWidth = dm.widthPixels;
    }

    public static interface onTabClickListener {
        public void onTabClick(String var1, int var2);
    }
}

