/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.spinner.materialspinner;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import com.xuexiang.xui.R;
import com.xuexiang.xui.logs.UILog;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.utils.Utils;
import com.xuexiang.xui.widget.spinner.materialspinner.MaterialSpinnerAdapter;
import com.xuexiang.xui.widget.spinner.materialspinner.MaterialSpinnerAdapterWrapper;
import com.xuexiang.xui.widget.spinner.materialspinner.MaterialSpinnerBaseAdapter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class MaterialSpinner
extends AppCompatTextView {
    private OnNothingSelectedListener mOnNothingSelectedListener;
    private OnItemSelectedListener mOnItemSelectedListener;
    private OnNoMoreChoiceListener mOnNoMoreChoiceListener;
    private MaterialSpinnerBaseAdapter mAdapter;
    private PopupWindow mPopupWindow;
    private ListView mListView;
    private Drawable mArrowDrawable;
    private boolean mHideArrow;
    private boolean mNothingSelected;
    private int mPopupWindowMaxHeight;
    private int mPopupWindowHeight;
    private int mSelectedIndex;
    private int mBackgroundColor;
    private int mBackgroundSelector;
    private int mArrowColor;
    private int mArrowColorDisabled;
    private int mTextColor;
    private int mEntriesID;
    private Drawable mDropDownBg;
    private boolean mIsInDialog;
    private int dropDownOffset;

    public MaterialSpinner(Context context) {
        this(context, null);
    }

    public MaterialSpinner(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.MaterialSpinnerStyle);
    }

    public MaterialSpinner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        int top;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaterialSpinner, defStyleAttr, 0);
        int defaultColor = this.getTextColors().getDefaultColor();
        boolean rtl = ResUtils.isRtl();
        try {
            this.mBackgroundColor = typedArray.getColor(R.styleable.MaterialSpinner_ms_background_color, -1);
            this.mBackgroundSelector = typedArray.getResourceId(R.styleable.MaterialSpinner_ms_background_selector, 0);
            this.mTextColor = typedArray.getColor(R.styleable.MaterialSpinner_ms_text_color, defaultColor);
            this.mArrowDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.MaterialSpinner_ms_arrow_image);
            this.mArrowColor = typedArray.getColor(R.styleable.MaterialSpinner_ms_arrow_tint, this.mTextColor);
            this.mHideArrow = typedArray.getBoolean(R.styleable.MaterialSpinner_ms_hide_arrow, false);
            this.mPopupWindowMaxHeight = typedArray.getDimensionPixelSize(R.styleable.MaterialSpinner_ms_dropdown_max_height, 0);
            this.mPopupWindowHeight = typedArray.getLayoutDimension(R.styleable.MaterialSpinner_ms_dropdown_height, -2);
            this.mArrowColorDisabled = ResUtils.lighter(this.mArrowColor, 0.8f);
            this.mEntriesID = typedArray.getResourceId(R.styleable.MaterialSpinner_ms_entries, 0);
            this.mDropDownBg = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.MaterialSpinner_ms_dropdown_bg);
            this.mIsInDialog = typedArray.getBoolean(R.styleable.MaterialSpinner_ms_in_dialog, false);
        }
        finally {
            typedArray.recycle();
        }
        int bottom = top = ThemeUtils.resolveDimension(this.getContext(), R.attr.ms_padding_top_size);
        int right = top;
        int left = top;
        if (rtl) {
            right = ThemeUtils.resolveDimension(this.getContext(), R.attr.ms_padding_left_size);
        } else {
            left = ThemeUtils.resolveDimension(this.getContext(), R.attr.ms_padding_left_size);
        }
        this.dropDownOffset = ThemeUtils.resolveDimension(this.getContext(), R.attr.ms_dropdown_offset);
        this.setGravity(8388627);
        this.setClickable(true);
        this.setPadding(left, top, right, bottom);
        this.setBackgroundResource(R.drawable.ms_background_selector);
        if (Build.VERSION.SDK_INT >= 17 && rtl) {
            this.setLayoutDirection(1);
            this.setTextDirection(4);
        }
        if (!this.mHideArrow) {
            if (this.mArrowDrawable == null) {
                this.mArrowDrawable = ResUtils.getVectorDrawable(this.getContext(), R.drawable.ms_ic_arrow_up).mutate();
            }
            this.mArrowDrawable.setColorFilter(this.mArrowColor, PorterDuff.Mode.SRC_IN);
            int arrowSize = ThemeUtils.resolveDimension(this.getContext(), R.attr.ms_arrow_size);
            this.mArrowDrawable.setBounds(0, 0, arrowSize, arrowSize);
            if (rtl) {
                this.setCompoundDrawablesWithIntrinsicBounds(this.mArrowDrawable, null, null, null);
            } else {
                this.setCompoundDrawablesWithIntrinsicBounds(null, null, this.mArrowDrawable, null);
            }
        }
        this.mListView = new ListView(context);
        this.mListView.setId(this.getId());
        this.mListView.setDivider(null);
        this.mListView.setItemsCanFocus(true);
        int padding = ThemeUtils.resolveDimension(this.getContext(), R.attr.ms_dropdown_offset);
        this.mListView.setPadding(padding, padding, padding, padding);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (position >= MaterialSpinner.this.mSelectedIndex && position < MaterialSpinner.this.mAdapter.getCount()) {
                    ++position;
                }
                MaterialSpinner.this.mSelectedIndex = position;
                MaterialSpinner.this.mNothingSelected = false;
                Object item = MaterialSpinner.this.mAdapter.get(position);
                MaterialSpinner.this.mAdapter.notifyItemSelected(position);
                MaterialSpinner.this.setText(item.toString());
                MaterialSpinner.this.collapse();
                if (MaterialSpinner.this.mOnItemSelectedListener != null) {
                    MaterialSpinner.this.mOnItemSelectedListener.onItemSelected(MaterialSpinner.this, position, id2, item);
                }
            }
        });
        if (this.mEntriesID != 0) {
            this.setItems(ResUtils.getStringArray(this.mEntriesID));
        }
        this.mPopupWindow = new PopupWindow(context);
        this.mPopupWindow.setContentView((View)this.mListView);
        this.mPopupWindow.setOutsideTouchable(true);
        this.mPopupWindow.setFocusable(true);
        this.mPopupWindow.setInputMethodMode(2);
        this.mPopupWindow.setSoftInputMode(48);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mPopupWindow.setElevation(16.0f);
        }
        if (this.mDropDownBg != null) {
            this.mPopupWindow.setBackgroundDrawable(this.mDropDownBg);
        } else {
            this.mPopupWindow.setBackgroundDrawable(ResUtils.getDrawable(this.getContext(), R.drawable.ms_drop_down_bg));
        }
        if (this.mBackgroundColor != -1) {
            this.setBackgroundColor(this.mBackgroundColor);
        } else if (this.mBackgroundSelector != 0) {
            this.setBackgroundResource(this.mBackgroundSelector);
        }
        if (this.mTextColor != defaultColor) {
            this.setTextColor(this.mTextColor);
        }
        this.mPopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (MaterialSpinner.this.mNothingSelected && MaterialSpinner.this.mOnNothingSelectedListener != null) {
                    MaterialSpinner.this.mOnNothingSelectedListener.onNothingSelected(MaterialSpinner.this);
                }
                if (!MaterialSpinner.this.mHideArrow) {
                    MaterialSpinner.this.animateArrow(false);
                }
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mPopupWindow.setHeight(this.calculatePopupWindowHeight());
        if (this.mAdapter != null) {
            CharSequence currentText = this.getText();
            String longestItem = currentText.toString();
            for (int i = 0; i < this.mAdapter.getCount(); ++i) {
                String itemText = this.mAdapter.getItemText(i);
                if (itemText.length() <= longestItem.length()) continue;
                longestItem = itemText;
            }
            this.setText(longestItem);
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.setText(currentText);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
        this.mPopupWindow.setWidth(this.getMeasuredWidth());
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (event.getAction() == 1 && this.isEnabled() && this.isClickable()) {
            if (!this.mPopupWindow.isShowing()) {
                this.expand();
            } else {
                this.collapse();
            }
        }
        return super.onTouchEvent(event);
    }

    public void setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
        Drawable background = this.getBackground();
        if (background instanceof StateListDrawable) {
            try {
                Method getStateDrawable = StateListDrawable.class.getDeclaredMethod("getStateDrawable", Integer.TYPE);
                if (!getStateDrawable.isAccessible()) {
                    getStateDrawable.setAccessible(true);
                }
                int[] colors = new int[]{ResUtils.darker(color2, 0.85f), color2};
                for (int i = 0; i < colors.length; ++i) {
                    ColorDrawable drawable2 = (ColorDrawable)getStateDrawable.invoke((Object)background, i);
                    drawable2.setColor(colors[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                UILog.e(e);
            }
        } else if (background != null) {
            background.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        }
        this.mPopupWindow.getBackground().setColorFilter(color2, PorterDuff.Mode.SRC_IN);
    }

    public void setTextColor(int color2) {
        this.mTextColor = color2;
        super.setTextColor(color2);
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("state", super.onSaveInstanceState());
        bundle.putInt("selected_index", this.mSelectedIndex);
        if (this.mPopupWindow != null) {
            bundle.putBoolean("is_popup_showing", this.mPopupWindow.isShowing());
            this.collapse();
        } else {
            bundle.putBoolean("is_popup_showing", false);
        }
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable savedState) {
        if (savedState instanceof Bundle) {
            Bundle bundle = (Bundle)savedState;
            this.mSelectedIndex = bundle.getInt("selected_index");
            if (this.mAdapter != null) {
                this.setText(this.mAdapter.get(this.mSelectedIndex).toString());
                this.mAdapter.notifyItemSelected(this.mSelectedIndex);
            }
            if (bundle.getBoolean("is_popup_showing") && this.mPopupWindow != null) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        MaterialSpinner.this.expand();
                    }
                });
            }
            savedState = bundle.getParcelable("state");
        }
        super.onRestoreInstanceState(savedState);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.mArrowDrawable != null) {
            this.mArrowDrawable.setColorFilter(enabled ? this.mArrowColor : this.mArrowColorDisabled, PorterDuff.Mode.SRC_IN);
        }
    }

    public int getSelectedIndex() {
        return this.mSelectedIndex;
    }

    public MaterialSpinner setSelectedIndex(int position) {
        if (this.mAdapter != null) {
            if (position >= 0 && position <= this.mAdapter.getCount()) {
                this.mAdapter.notifyItemSelected(position);
                this.mSelectedIndex = position;
                this.setText(this.mAdapter.get(position).toString());
            } else {
                throw new IllegalArgumentException("Position must be lower than adapter count!");
            }
        }
        return this;
    }

    public <T> MaterialSpinner setSelectedItem(@NonNull T item) {
        if (this.mAdapter != null && item != null) {
            this.setSelectedIndex(this.getSpinnerPosition(item, this.mAdapter.getItems()));
        }
        return this;
    }

    public <T> int getSpinnerPosition(T item, List<T> items) {
        if (item != null && items != null && items.size() > 0) {
            for (int i = 0; i < items.size(); ++i) {
                if (!item.equals(items.get(i))) continue;
                return i;
            }
        }
        return 0;
    }

    public MaterialSpinner setOnItemSelectedListener(@Nullable OnItemSelectedListener onItemSelectedListener) {
        this.mOnItemSelectedListener = onItemSelectedListener;
        return this;
    }

    public MaterialSpinner setOnNothingSelectedListener(@Nullable OnNothingSelectedListener onNothingSelectedListener) {
        this.mOnNothingSelectedListener = onNothingSelectedListener;
        return this;
    }

    public MaterialSpinner setOnNoMoreChoiceListener(OnNoMoreChoiceListener onNoMoreChoiceListener) {
        this.mOnNoMoreChoiceListener = onNoMoreChoiceListener;
        return this;
    }

    public <T> MaterialSpinner setItems(T ... items) {
        this.setItems(Arrays.asList(items));
        return this;
    }

    public <T> MaterialSpinner setItems(@NonNull List<T> items) {
        this.mAdapter = new MaterialSpinnerAdapter<T>(this.getContext(), items).setTextColor(this.mTextColor).setTextSize(this.getTextSize());
        this.setAdapterInternal(this.mAdapter);
        return this;
    }

    public <T> List<T> getItems() {
        if (this.mAdapter == null) {
            return null;
        }
        return this.mAdapter.getItems();
    }

    public <T> T getSelectedItem() {
        return this.mAdapter != null ? (T)this.mAdapter.get(this.mSelectedIndex) : null;
    }

    public MaterialSpinner setAdapter(@NonNull ListAdapter adapter) {
        this.mAdapter = new MaterialSpinnerAdapterWrapper(this.getContext(), adapter).setTextColor(this.mTextColor).setTextSize(this.getTextSize());
        this.setAdapterInternal(this.mAdapter);
        return this;
    }

    public <T> MaterialSpinner setAdapter(MaterialSpinnerAdapter<T> adapter) {
        this.mAdapter = adapter;
        this.mAdapter.setTextColor(this.mTextColor);
        this.mAdapter.setTextSize(this.getTextSize());
        this.setAdapterInternal(adapter);
        return this;
    }

    public MaterialSpinnerBaseAdapter getAdapter() {
        return this.mAdapter;
    }

    public MaterialSpinner setDropDownBackgroundSelector(@DrawableRes int backgroundSelector) {
        if (this.mAdapter != null) {
            this.mAdapter.setBackgroundSelector(backgroundSelector);
        }
        return this;
    }

    private void setAdapterInternal(@NonNull MaterialSpinnerBaseAdapter adapter) {
        this.mListView.setAdapter((ListAdapter)adapter);
        if (this.mSelectedIndex >= adapter.getCount()) {
            this.mSelectedIndex = 0;
        }
        if (adapter.getCount() >= 0) {
            this.setText(adapter.get(this.mSelectedIndex).toString());
        } else {
            this.setText("");
        }
    }

    private boolean hasMoreChoice() {
        return this.mAdapter != null && this.mAdapter.getCount() > 0;
    }

    public void expand() {
        if (!this.hasMoreChoice()) {
            if (this.mOnNoMoreChoiceListener != null) {
                this.mOnNoMoreChoiceListener.OnNoMoreChoice(this);
            }
            return;
        }
        if (!this.mHideArrow) {
            this.animateArrow(true);
        }
        this.mNothingSelected = true;
        this.showPopupWindow();
    }

    public void collapse() {
        if (!this.mHideArrow) {
            this.animateArrow(false);
        }
        this.mPopupWindow.dismiss();
    }

    private void showPopupWindow() {
        if (this.mIsInDialog) {
            this.mPopupWindow.showAsDropDown((View)this);
        } else {
            this.mPopupWindow.showAsDropDown((View)this, 0, this.calculatePopWindowYOffset((View)this));
        }
    }

    private int[] calculatePopWindowPos(View anchorView) {
        boolean isNeedShowUp;
        int[] windowPos = new int[2];
        int[] anchorLoc = new int[2];
        anchorView.getLocationOnScreen(anchorLoc);
        int anchorHeight = anchorView.getHeight();
        int screenHeight = Utils.getScreenHeight(this.getContext());
        int listViewHeight = Utils.getListViewHeightBasedOnChildren(this.mListView);
        if (this.mPopupWindowMaxHeight > 0 && listViewHeight > this.mPopupWindowMaxHeight) {
            listViewHeight = this.mPopupWindowMaxHeight;
        }
        boolean bl = isNeedShowUp = screenHeight - anchorLoc[1] - anchorHeight < listViewHeight;
        if (isNeedShowUp) {
            windowPos[0] = anchorLoc[0];
            windowPos[1] = anchorLoc[1] - listViewHeight - this.dropDownOffset;
        } else {
            windowPos[0] = anchorLoc[0];
            windowPos[1] = anchorLoc[1] + anchorHeight;
        }
        return windowPos;
    }

    private int calculatePopWindowYOffset(View anchorView) {
        int[] anchorLoc = new int[2];
        anchorView.getLocationOnScreen(anchorLoc);
        int anchorHeight = anchorView.getHeight();
        int screenHeight = Utils.getScreenHeight(this.getContext());
        int listViewHeight = Utils.getListViewHeightBasedOnChildren(this.mListView);
        if (this.mPopupWindowMaxHeight > 0 && listViewHeight > this.mPopupWindowMaxHeight) {
            listViewHeight = this.mPopupWindowMaxHeight;
        }
        boolean isNeedShowUp = screenHeight - anchorLoc[1] < listViewHeight + anchorHeight;
        int windowYOffset = isNeedShowUp ? -(listViewHeight + this.dropDownOffset + anchorHeight) : 0;
        return windowYOffset;
    }

    public void setArrowColor(@ColorInt int color2) {
        this.mArrowColor = color2;
        this.mArrowColorDisabled = ResUtils.lighter(this.mArrowColor, 0.8f);
        if (this.mArrowDrawable != null) {
            this.mArrowDrawable.setColorFilter(this.mArrowColor, PorterDuff.Mode.SRC_IN);
        }
    }

    private void animateArrow(boolean shouldRotateUp) {
        int start = shouldRotateUp ? 0 : 10000;
        int end = shouldRotateUp ? 10000 : 0;
        ObjectAnimator animator = ObjectAnimator.ofInt((Object)this.mArrowDrawable, (String)"level", (int[])new int[]{start, end});
        animator.start();
    }

    public void setDropdownMaxHeight(int height) {
        this.mPopupWindowMaxHeight = height;
        this.mPopupWindow.setHeight(this.calculatePopupWindowHeight());
    }

    public void setDropdownHeight(int height) {
        this.mPopupWindowHeight = height;
        this.mPopupWindow.setHeight(this.calculatePopupWindowHeight());
    }

    private int calculatePopupWindowHeight() {
        if (this.mAdapter == null) {
            return -2;
        }
        float listViewHeight = this.mAdapter.getCount() * ThemeUtils.resolveDimension(this.getContext(), R.attr.ms_item_height_size);
        if (this.mPopupWindowMaxHeight > 0 && listViewHeight > (float)this.mPopupWindowMaxHeight) {
            return this.mPopupWindowMaxHeight;
        }
        if (this.mPopupWindowHeight != -1 && this.mPopupWindowHeight != -2 && (float)this.mPopupWindowHeight <= listViewHeight) {
            return this.mPopupWindowHeight;
        }
        return -2;
    }

    public PopupWindow getPopupWindow() {
        return this.mPopupWindow;
    }

    public ListView getListView() {
        return this.mListView;
    }

    public static interface OnNoMoreChoiceListener {
        public void OnNoMoreChoice(MaterialSpinner var1);
    }

    public static interface OnNothingSelectedListener {
        public void onNothingSelected(MaterialSpinner var1);
    }

    public static interface OnItemSelectedListener<T> {
        public void onItemSelected(MaterialSpinner var1, int var2, long var3, T var5);
    }
}

