/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.spinner.editspinner;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.spinner.editspinner.BaseEditSpinnerAdapter;
import com.xuexiang.xui.widget.spinner.editspinner.EditSpinnerFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EditSpinnerAdapter
extends BaseEditSpinnerAdapter
implements EditSpinnerFilter {
    private Context mContext;
    private final List<String> mSpinnerData;
    private final List<String> mDisplayData;
    private final int[] mIndexs;
    private int textColor;
    private float textSize;
    private int backgroundSelector;
    private boolean mIsFilterKey = false;

    public EditSpinnerAdapter(Context context, List<String> data) {
        this.mContext = context;
        this.mSpinnerData = data;
        this.mDisplayData = new ArrayList<String>(data);
        this.mIndexs = new int[this.mSpinnerData.size()];
    }

    public EditSpinnerAdapter(Context context, String[] data) {
        this.mContext = context;
        this.mSpinnerData = new ArrayList<String>();
        this.mSpinnerData.addAll(Arrays.asList(data));
        this.mDisplayData = new ArrayList<String>(this.mSpinnerData);
        this.mIndexs = new int[this.mSpinnerData.size()];
    }

    @Override
    public EditSpinnerFilter getEditSpinnerFilter() {
        return this;
    }

    @Override
    public String getItemString(int position) {
        return this.mSpinnerData.get(this.mIndexs[position]);
    }

    public int getCount() {
        return this.mDisplayData == null ? 0 : this.mDisplayData.size();
    }

    public String getItem(int position) {
        return this.mDisplayData == null ? "" : (this.mDisplayData.get(position) == null ? "" : this.mDisplayData.get(position));
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        TextView textView;
        if (convertView == null) {
            Configuration config;
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            convertView = inflater.inflate(R.layout.ms_list_item, parent, false);
            textView = (TextView)convertView.findViewById(R.id.tv_tinted_spinner);
            textView.setTextColor(this.textColor);
            textView.setTextSize(0, this.textSize);
            if (this.backgroundSelector != 0) {
                textView.setBackgroundResource(this.backgroundSelector);
            }
            if (Build.VERSION.SDK_INT >= 17 && (config = this.mContext.getResources().getConfiguration()).getLayoutDirection() == 1) {
                textView.setTextDirection(4);
            }
            convertView.setTag((Object)new ViewHolder(textView));
        } else {
            textView = ((ViewHolder)convertView.getTag()).textView;
        }
        textView.setText((CharSequence)Html.fromHtml((String)this.getItem(position)));
        return textView;
    }

    @Override
    public boolean onFilter(String keyword) {
        this.mDisplayData.clear();
        if (TextUtils.isEmpty((CharSequence)keyword)) {
            this.mDisplayData.addAll(this.mSpinnerData);
            for (int i = 0; i < this.mIndexs.length; ++i) {
                this.mIndexs[i] = i;
            }
        } else {
            try {
                StringBuilder builder = new StringBuilder();
                builder.append("[^\\s]*").append(keyword).append("[^\\s]*");
                for (int i = 0; i < this.mSpinnerData.size(); ++i) {
                    if (!this.mSpinnerData.get(i).replaceAll("\\s+", "|").matches(builder.toString())) continue;
                    this.mIndexs[this.mDisplayData.size()] = i;
                    if (this.mIsFilterKey) {
                        this.mDisplayData.add(this.mSpinnerData.get(i).replaceFirst(keyword, "<font color=\"#F15C58\">" + keyword + "</font>"));
                        continue;
                    }
                    this.mDisplayData.add(this.mSpinnerData.get(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.notifyDataSetChanged();
        return this.mDisplayData.size() <= 0;
    }

    public EditSpinnerAdapter setTextColor(@ColorInt int textColor) {
        this.textColor = textColor;
        return this;
    }

    public EditSpinnerAdapter setTextSize(float textSize) {
        this.textSize = textSize;
        return this;
    }

    public EditSpinnerAdapter setBackgroundSelector(@DrawableRes int backgroundSelector) {
        this.backgroundSelector = backgroundSelector;
        return this;
    }

    public EditSpinnerAdapter setIsFilterKey(boolean isFilterKey) {
        this.mIsFilterKey = isFilterKey;
        return this;
    }

    private static class ViewHolder {
        private TextView textView;

        private ViewHolder(TextView textView) {
            this.textView = textView;
        }
    }
}

